/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl.connector;

import com.neeve.event.IEventHandler;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.connector.ConnectorBusChannel;
import com.neeve.sma.spi.connector.Connector;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.util.Properties;

public final class ConnectorBusBinding
extends MessageBusBindingBase
implements Connector.BindingCallback {
    private final int sender = this.hashCode();
    private final NoOpOutboundAcknowledger bestEffortAcknowledger = new NoOpOutboundAcknowledger();
    private String inboundDriverCPUAffinityMask;
    private String inboundChannelName;
    private MessageChannel inboundChannel;
    private UtlPool<OutboundAcknowledger> outboundAcknowledgerPool;
    private Connector connector;
    private InboundDriver inboundDriver;

    ConnectorBusBinding(String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(null, userName, descriptor, eventHandler);
    }

    private final Connector.OutboundAcknowledger createAcknowledger(ConnectorBusChannel channel, MessageView view) {
        if (this.outboundAcknowledgerPool == null) {
            throw new IllegalStateException("Cannot create acknowledger prior to bus open");
        }
        if (channel.getQos() == MessageChannel.Qos.Guaranteed) {
            return ((OutboundAcknowledger)this.outboundAcknowledgerPool.get(null)).init(channel, view);
        }
        return this.bestEffortAcknowledger;
    }

    final void processOutboundMessage(ConnectorBusChannel channel, MessageView view) throws SmaException {
        view.acquire();
        try {
            Connector.OutboundAcknowledger acknowledger = this.createAcknowledger(channel, view);
            if (MessageLatencyManager.recordMsgLegWaypoints) {
                view.setPreWireTs(UtlTime.now());
            }
            if (this.tracer.debug) {
                this.tracer.log("Processing connector bus message: " + view.toString(), Tracer.Level.DEBUG);
            }
            this.connector.processOutbound(view, acknowledger, 0);
            if (MessageLatencyManager.recordMsgLegWaypoints) {
                view.setPostWireSendTs(UtlTime.now());
            }
            if (MessageLatencyManager.captureMsgLatencyStats) {
                this.latencyManager.update(view, MessageLatencyManager.MessagingDirection.Outbound);
            }
        }
        catch (Exception e) {
            throw new SmaException(this.tracePrefix + "Execution failure for '" + view.getClass().getSimpleName() + "' [" + e.getMessage() + "]", e);
        }
        finally {
            view.dispose();
        }
    }

    @Override
    protected final void doOpen() throws SmaException {
        Properties providerConfig = this.descriptor.getProviderConfig();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Opening binding (props=" + providerConfig + ")...", Tracer.Level.DEBUG);
        }
        String className = UtlProps.getValue((Properties)providerConfig, (String)"classname", null);
        this.inboundDriverCPUAffinityMask = this.descriptor.getProviderConfig().getProperty("inbound_driver_affinitymask", null);
        if (this.inboundDriverCPUAffinityMask != null && this.inboundDriverCPUAffinityMask.equalsIgnoreCase("null")) {
            this.inboundDriverCPUAffinityMask = null;
        }
        this.inboundChannelName = UtlProps.getValue((Properties)providerConfig, (String)"inbound_channel", null);
        if (this.inboundChannelName == null) {
            throw new SmaPermanentException(this.tracePrefix + "'" + "inbound_channel" + "' must be set as a connector bus property!");
        }
        if (className == null) {
            throw new SmaPermanentException(this.tracePrefix + "'" + "classname" + "' must be set as a connector bus property!");
        }
        try {
            this.connector = (Connector)Class.forName(className).newInstance();
        }
        catch (Throwable t) {
            throw new SmaPermanentException(this.tracePrefix + "' unable to load specified connector class '" + className + "'", t);
        }
        try {
            this.connector.open(providerConfig);
        }
        catch (SmaException smae) {
            throw smae;
        }
        catch (SmaPermanentException smae) {
            throw smae;
        }
        catch (Exception e) {
            throw new SmaException(this.tracePrefix + "Error in opening connector [" + e.getMessage() + "]", e);
        }
        this.inboundDriver = new InboundDriver();
        this.outboundAcknowledgerPool = UtlPool.create((String)"connector-outbound-acknowledger", (String)(this.getUserName() + "." + this.getName()), (UtlPool.Factory)new OutboundAcknowledgerFactory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
    }

    @Override
    protected final void doStart() throws SmaException {
        this.inboundChannel = (ConnectorBusChannel)this.getMessageChannel(this.inboundChannelName);
        if (this.inboundChannel == null) {
            throw new SmaPermanentException(this.tracePrefix + "' unable to find inbound channel '" + this.inboundChannelName + "'");
        }
        this.inboundDriver.start();
    }

    @Override
    protected final MessageChannel doGetMessageChannel(MessageChannelDescriptor descriptor) throws SmaException {
        return new ConnectorBusChannel(descriptor, this);
    }

    @Override
    protected final void doFlush() throws SmaException {
    }

    @Override
    protected final boolean doCanFail() {
        return true;
    }

    @Override
    protected final boolean doAcksRequireFlush() {
        return false;
    }

    @Override
    protected final void doClose() throws SmaException {
        try {
            this.connector.close();
        }
        catch (SmaPermanentException smae) {
            throw smae;
        }
        catch (Exception e) {
            throw new SmaException(this.tracePrefix + "Error in closing connector [" + e.getMessage() + "]", e);
        }
        this.outboundAcknowledgerPool.close();
    }

    @Override
    public final void processInbound(MessageView message, long sno, long originTs, long preWireTs, long postWireTs, long preDeserializeTs, Connector.InboundAcknowledger acknowledger) {
        this.onMessage(this.inboundChannel, this.setInboundMetadata(message, this.sender, 0, sno, 0L, null, null, null, originTs, preWireTs, postWireTs, preDeserializeTs), acknowledger);
    }

    @Override
    public final void processInbound(MessageView message, long sno, long postWireTs, long preDeserializeTs, Connector.InboundAcknowledger acknowleger) {
        this.processInbound(message, sno, 0L, 0L, postWireTs, preDeserializeTs, acknowleger);
    }

    @Override
    public final void processInbound(Object messagePayload, short vfid, short vtype, int encodingType, long sno, long originTs, long preWireTs, long postWireTs, Connector.InboundAcknowledger acknowledger) {
        this.onMessage(this.inboundChannel, this.wrap(messagePayload, vfid, vtype, encodingType, this.sender, 0, sno, 0L, null, null, null, originTs, preWireTs, postWireTs, UtlTime.now()), acknowledger);
    }

    @Override
    public final void processInbound(Object messagePayload, short vfid, short vtype, int encodingType, long sno, long postWireTs, Connector.InboundAcknowledger acknowleger) {
        this.processInbound(messagePayload, vfid, vtype, encodingType, sno, 0L, 0L, postWireTs, acknowleger);
    }

    @Override
    public final void fail(Throwable cause) {
        this.tracer.log("Connector has failed. Stack trace:\n" + UtlThrowable.prepareStackTrace((Throwable)cause), Tracer.Level.SEVERE);
        try {
            this.fail(cause instanceof Exception ? (Exception)cause : new Exception(cause), true);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Throwable e2) {
            this.tracer.log("FATAL ERROR: Failed to fail binding on connector binding exception. The stack trace for the failed fail attempt is as follows:\n" + UtlThrowable.prepareStackTrace((Throwable)e2), Tracer.Level.SEVERE);
        }
    }

    private final class NoOpOutboundAcknowledger
    implements Connector.OutboundAcknowledger {
        private NoOpOutboundAcknowledger() {
        }

        @Override
        public void acknowledge() {
            this.acknowledge(null);
        }

        @Override
        public void acknowledge(Exception status) {
        }
    }

    private final class OutboundAcknowledgerFactory
    implements UtlPool.Factory<OutboundAcknowledger> {
        private OutboundAcknowledgerFactory() {
        }

        public final OutboundAcknowledger createItem(Object object) {
            return new OutboundAcknowledger();
        }

        public final OutboundAcknowledger[] createItemArray(int size) {
            return new OutboundAcknowledger[size];
        }
    }

    private final class OutboundAcknowledger
    implements Connector.OutboundAcknowledger,
    UtlPool.Item<OutboundAcknowledger> {
        private UtlPool<OutboundAcknowledger> pool;
        private ConnectorBusChannel channel;
        private MessageView view;

        protected OutboundAcknowledger() {
        }

        public OutboundAcknowledger init(ConnectorBusChannel channel, MessageView view) {
            this.channel = channel;
            this.view = view;
            return this;
        }

        @Override
        public final void acknowledge() {
            this.acknowledge(null);
        }

        @Override
        public final void acknowledge(Exception status) {
            if (this.view == null || this.channel == null) {
                throw new IllegalStateException("Acknowledge called on unititialized outbound acknowledger ... duplicate call to acknowledge?");
            }
            if (((ConnectorBusBinding)ConnectorBusBinding.this).tracer.debug) {
                ConnectorBusBinding.this.tracer.log("Acknowleding processing of " + this.view.toString(), Tracer.Level.DEBUG);
            }
            try {
                this.channel.ack(this.view, status);
            }
            finally {
                this.dispose();
            }
        }

        public final void dispose() {
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }

        public final OutboundAcknowledger init() {
            this.view = null;
            this.channel = null;
            return this;
        }

        public final OutboundAcknowledger setPool(UtlPool<OutboundAcknowledger> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<OutboundAcknowledger> getPool() {
            return this.pool;
        }
    }

    private final class InboundDriver
    extends Thread {
        InboundDriver() {
            this.setName("X-SMA-Connector-" + ConnectorBusBinding.this.getName() + "-InboundDriver");
            this.setDaemon(true);
        }

        @Override
        public final void run() {
            if (ConnectorBusBinding.this.inboundDriverCPUAffinityMask != null) {
                UtlThread.setCPUAffinityMask((String)ConnectorBusBinding.this.inboundDriverCPUAffinityMask);
            }
            try {
                ConnectorBusBinding.this.connector.run(ConnectorBusBinding.this);
            }
            catch (Throwable e) {
                ConnectorBusBinding.this.tracer.log(UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                ConnectorBusBinding.this.fail(e);
            }
        }
    }
}

