/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.config.Config;
import com.neeve.lang.IXStringFactory;
import com.neeve.lang.XString;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlReferenceTracker;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class XAbstractPooledString<T extends XAbstractPooledString<T>>
extends XString
implements UtlPool.Item<T> {
    protected final AtomicInteger ownershipCount = new AtomicInteger(1);
    protected final UtlReferenceTracker refTracker;
    private UtlPool<T> pool;

    protected XAbstractPooledString(boolean mutable, short initialCapacity) {
        super(mutable, initialCapacity);
        if (UtlReferenceTracker.enabled(this.getClass())) {
            this.refTracker = new UtlReferenceTracker(this);
            this.refTracker.onInit(1);
        } else {
            this.refTracker = null;
        }
    }

    @Override
    public final T init() {
        this.clear(false);
        return (T)this;
    }

    @Override
    public final T setPool(UtlPool<T> pool) {
        this.pool = pool;
        return (T)this;
    }

    @Override
    public final UtlPool<T> getPool() {
        return this.pool;
    }

    public final T acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1) {
            throw new IllegalStateException("attempt to acquire an already disposed " + this.getClass().getCanonicalName());
        }
        return (T)this;
    }

    public final void dispose() {
        int val = this.ownershipCount.decrementAndGet();
        if (this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed " + this.getClass().getCanonicalName());
        }
        if (val == 0 && this.pool != null) {
            this.pool.put(this);
        }
    }

    public final int getOwnershipCount() {
        return this.ownershipCount.get();
    }

    protected static abstract class PooledStringFactory<T extends XAbstractPooledString<T>>
    implements IXStringFactory<T> {
        private final short initialCapacity;
        private final UtlPool<T> pool;

        protected PooledStringFactory() {
            Class<T> clazz = this.getType();
            String typeName = clazz.getName();
            String poolName = "default";
            this.initialCapacity = (short)Config.getValue((String)(typeName + "." + "initialCapacity"), (int)this.getDefaultInitialCapacity());
            boolean pooled = Config.getValue((String)(typeName + "." + "pool.enabled"), (boolean)Config.getValue((String)"nv.pool.shouldpool", (boolean)true));
            boolean threaded = Config.getValue((String)(typeName + "." + "pool.enabled"), (boolean)true);
            int preallocationCount = Config.getValue((String)(typeName + "." + "pool.enabled"), (int)0);
            if (pooled) {
                UtlPool.Params params = UtlPool.Params.create().setThreaded(threaded);
                if (preallocationCount > 0) {
                    params.setInitialCapacity(preallocationCount);
                    params.setPreallocate(true);
                }
                this.pool = UtlPool.create(this.getTypeName(), poolName, new PoolFactory(), params);
            } else {
                this.pool = null;
            }
        }

        protected PooledStringFactory(String name, Map<String, Object> props) {
            boolean pooled;
            this.initialCapacity = (short)(props != null ? UtlProps.getValue(props, (String)"initialCapacity", (int)this.getDefaultInitialCapacity()) : this.getDefaultInitialCapacity());
            boolean bl = pooled = props != null ? UtlProps.getValue(props, (String)"pool.enabled", (boolean)Config.getValue((String)"nv.pool.shouldpool", (boolean)true)) : Config.getValue((String)"nv.pool.shouldpool", (boolean)true);
            if (pooled) {
                boolean threaded = props != null ? UtlProps.getValue(props, (String)"pool.threaded", (boolean)true) : true;
                int preallocationCount = props != null ? UtlProps.getValue(props, (String)"pool.preallocateCount", (int)0) : 0;
                UtlPool.Params params = UtlPool.Params.create().setThreaded(threaded);
                if (preallocationCount > 0) {
                    params.setInitialCapacity(preallocationCount);
                    params.setPreallocate(true);
                }
                this.pool = UtlPool.create(this.getTypeName(), name, new PoolFactory(), params);
            } else {
                this.pool = null;
            }
        }

        protected PooledStringFactory(String name, short initialCapacity, boolean pooled, int preallocationCount, boolean threaded) {
            this.initialCapacity = initialCapacity;
            if (pooled) {
                UtlPool.Params params = UtlPool.Params.create().setThreaded(threaded);
                if (preallocationCount > 0) {
                    params.setInitialCapacity(preallocationCount);
                    params.setPreallocate(true);
                }
                this.pool = UtlPool.create(this.getTypeName(), name, new PoolFactory(), params);
            } else {
                this.pool = null;
            }
        }

        protected String getTypeName() {
            return this.getType().getCanonicalName();
        }

        protected abstract Class<T> getType();

        protected abstract T create(boolean var1, short var2);

        protected abstract T[] newArray(int var1);

        protected int getDefaultInitialCapacity() {
            return 0;
        }

        public final int getInitialCapacity() {
            return this.initialCapacity;
        }

        public final UtlPool<T> getPool() {
            return this.pool;
        }

        @Override
        public final T[] createArray(int size) {
            return this.newArray(size);
        }

        @Override
        public final T create() {
            return (T)this.create(true);
        }

        @Override
        public final T create(String initialValue) {
            XString rc = this.create(initialValue, false);
            return (T)rc;
        }

        @Override
        public final T create(boolean mutable) {
            if (this.pool != null) {
                XAbstractPooledString rc = (XAbstractPooledString)this.pool.get(null);
                rc.setMutable(mutable);
                rc.ownershipCount.set(1);
                if (rc.refTracker != null) {
                    rc.refTracker.onInit(1);
                }
                return (T)rc;
            }
            return this.create(mutable, this.initialCapacity);
        }

        @Override
        public final T create(String initialValue, boolean mutable) {
            XString rc = this.create(mutable);
            rc.initialize(initialValue);
            return (T)rc;
        }

        @Override
        public final T create(XString initialValue, boolean mutable) {
            XString rc = this.create(mutable);
            rc.initializeFrom(initialValue);
            return (T)rc;
        }

        private final class PoolFactory
        implements UtlPool.Factory<T> {
            @Override
            public T createItem(Object object) {
                return PooledStringFactory.this.create(true, PooledStringFactory.this.initialCapacity);
            }

            @Override
            public T[] createItemArray(int size) {
                return PooledStringFactory.this.newArray(size);
            }
        }
    }
}

