/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.quark.adm;

import com.neeve.adm.AdmCollection;
import com.neeve.adm.AdmEntity;
import com.neeve.adm.AdmEnumeration;
import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.adm.AdmSourceCodeBuilder;
import com.neeve.adm.EAdmException;
import com.neeve.adm.IAdmGenerator;
import com.neeve.quark.adm.QuarkAdmFactoryGenerator;
import com.neeve.quark.adm.QuarkAdmNodeGenerator;
import com.neeve.trace.Tracer;
import java.io.File;
import java.util.Iterator;

public final class QuarkAdmGenerator
implements IAdmGenerator {
    private final String name;
    private final Tracer tracer;
    private final QuarkAdmFactoryGenerator factoryGenerator;
    private final QuarkAdmNodeGenerator nodeGenerator;
    public static final String NAME = "quark";

    private QuarkAdmGenerator(String name) {
        this.name = name;
        this.tracer = Tracer.get((String)"nv.adm");
        this.factoryGenerator = new QuarkAdmFactoryGenerator();
        this.nodeGenerator = new QuarkAdmNodeGenerator();
    }

    public static final IAdmGenerator create(String name) throws EAdmException {
        return new QuarkAdmGenerator(name);
    }

    public final String getName() {
        return this.name;
    }

    public final short getMaxFieldId() {
        return 8192;
    }

    public final void generateClasses(AdmModel model, File outdir, boolean absolute, boolean generateArrayGetterEmptyIfNull) throws Exception {
        String encodingType = model.getStringDirective("encodingType");
        this.tracer.log("Generating class files (" + this.getName() + ") to '" + outdir.getAbsolutePath() + "' (absolute=" + absolute + ")...", Tracer.Level.INFO);
        for (AdmFactory factory : model.getFactories()) {
            AdmSourceCodeBuilder codeBuilder = factory.startClassGeneration(encodingType, false);
            this.factoryGenerator.generateClass(factory, codeBuilder);
            factory.completeClassGeneration(codeBuilder, outdir, absolute);
        }
        Iterator enumIterator = model.getEnumerations().iterator();
        while (enumIterator.hasNext()) {
            ((AdmEnumeration)enumIterator.next()).generateClass(outdir, absolute);
        }
        for (AdmCollection collection : model.getCollections()) {
            AdmSourceCodeBuilder codeBuilder = collection.startClassGeneration();
            this.nodeGenerator.generateClass(collection, encodingType, codeBuilder);
            collection.completeClassGeneration(codeBuilder, outdir, absolute);
        }
        for (AdmMessage message : model.getMessages()) {
            AdmSourceCodeBuilder codeBuilder = message.startClassGeneration();
            this.nodeGenerator.generateClass((AdmEntity)message, encodingType, generateArrayGetterEmptyIfNull, codeBuilder);
            message.completeClassGeneration(codeBuilder, outdir, absolute);
        }
        for (AdmEntity entity : model.getEntities()) {
            AdmSourceCodeBuilder codeBuilder = entity.startClassGeneration();
            this.nodeGenerator.generateClass(entity, encodingType, generateArrayGetterEmptyIfNull, codeBuilder);
            entity.completeClassGeneration(codeBuilder, outdir, absolute);
        }
    }
}

