/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.trace;

import cern.colt.function.ObjectProcedure;
import cern.colt.list.ObjectArrayList;
import com.neeve.env.Env;
import com.neeve.trace.TraceFormatter;
import com.neeve.trace.Tracer;
import com.neeve.trace.TracerDescriptor;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import java.util.logging.SocketHandler;
import java.util.logging.StreamHandler;

public final class TraceLoggerFactory {
    private static final ObjectProcedure TRACE_HANDLER_CLOSER = new ObjectProcedure(){

        public final boolean apply(Object element) {
            ((Handler)element).close();
            return true;
        }
    };
    private final Map<String, Logger> loggers = new HashMap<String, Logger>();
    private final Map<String, Handler> handlers = new HashMap<String, Handler>();
    private final ObjectArrayList watchers = new ObjectArrayList();
    private final ReentrantReadWriteLock watchersLock = new ReentrantReadWriteLock(true);
    private final Tracer tracer = Tracer.create(Tracer.Level.INFO);
    private static TraceLoggerFactory instance;
    private static Handler defaultHandler;
    private static Formatter formatter;
    public static final String DEFAULT_HANDLER_NAME = "default";

    private TraceLoggerFactory() {
        if (defaultHandler == null) {
            String propname = "nv.logger.defaulthandler";
            String defaultDefaultHandlerDescriptorStr = "stdout://level=finest";
            String defaultHandlerDescriptorStr = Env.getValue("nv.logger.defaulthandler", "stdout://level=finest");
            if (this.createHandler(DEFAULT_HANDLER_NAME, defaultHandlerDescriptorStr) == null) {
                this.createHandler(DEFAULT_HANDLER_NAME, "stdout://level=finest");
            }
        } else {
            this.setHandler(DEFAULT_HANDLER_NAME, defaultHandler);
        }
        this.tracer.bind(this.getLogger("nv.loggerfactory", true));
        String level = Env.getValue("nv.loggerfactory.trace", null, (Env.PropertyChangeCallback)new TraceLevelPropertyChangeCallback());
        if (level != null) {
            try {
                this.tracer.setLevel(level);
            }
            catch (IllegalArgumentException e) {
                System.err.println(UtlThrowable.prepareStackTrace(e));
            }
        }
    }

    public static TraceLoggerFactory getInstance() {
        if (instance == null) {
            instance = new TraceLoggerFactory();
        }
        return instance;
    }

    public static void setDefaultHandler(Handler handler) {
        defaultHandler = handler;
    }

    public static void setFormatter(Formatter formatter) {
        TraceLoggerFactory.formatter = formatter;
    }

    private final Handler createStdoutHandler(String handlerName, TracerDescriptor descriptor) {
        this.tracer.log("Creating and configuring stdout handler [" + handlerName + "]...", Tracer.Level.VERBOSE);
        return new StdoutHandler();
    }

    private final Handler createStderrHandler(String handlerName, TracerDescriptor descriptor) {
        this.tracer.log("Creating and configuring stderr handler [" + handlerName + "]...", Tracer.Level.VERBOSE);
        return new StderrHandler();
    }

    private final Handler createMemoryHandler(String handlerName, TracerDescriptor descriptor) {
        Level level;
        String levelStr;
        int size;
        this.tracer.log("Creating and configuring memory handler [" + handlerName + "]...", Tracer.Level.VERBOSE);
        String targetStr = UtlProps.getValue(descriptor.props, "target", null);
        if (targetStr == null) {
            this.tracer.log("Target is not specified in memory handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "].", Tracer.Level.FINEST);
            throw new IllegalArgumentException("target not specified in memory handler descriptor");
        }
        Handler target = this.getHandler(targetStr);
        if (target == null) {
            this.tracer.log("Target ['" + targetStr + "'] specified in memory handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "] is invalid.", Tracer.Level.FINEST);
            throw new IllegalArgumentException("target specified in memory handler descriptor is invalid");
        }
        String sizeStr = UtlProps.getValue(descriptor.props, "size", null);
        if (sizeStr == null || (size = Integer.parseInt(sizeStr)) <= 0) {
            this.tracer.log("Size is not specified or is invalid in memory handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "]. Using default=1000", Tracer.Level.FINEST);
            size = 1000;
        }
        if ((levelStr = UtlProps.getValue(descriptor.props, "pushLevel", null)) == null) {
            this.tracer.log("Push level is not specified in memory handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "]. Using default=WARNING", Tracer.Level.FINEST);
            levelStr = Level.WARNING.toString();
        }
        try {
            level = Level.parse(levelStr);
        }
        catch (IllegalArgumentException e) {
            this.tracer.log("Push level [" + levelStr + "] specified in memory handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "] is invalid. Using default=WARNING", Tracer.Level.FINEST);
            level = Level.WARNING;
        }
        this.tracer.log("Creating memory handler with params [target=" + targetStr + ", size=" + size + ", pushlevel=" + level.toString() + "]", Tracer.Level.VERBOSE);
        return new MemoryHandler(target, size, level);
    }

    private final Handler createFileHandler(String handlerName, TracerDescriptor descriptor) {
        int count;
        String countStr;
        int limit;
        String limitStr;
        this.tracer.log("Creating and configuring file handler [" + handlerName + "]...", Tracer.Level.VERBOSE);
        String filename = UtlProps.getValue(descriptor.props, "filename", null);
        if (filename == null) {
            throw new IllegalArgumentException("File name must be specified in file handler descriptors");
        }
        String errTrace = null;
        try {
            File filedir = new File(filename).getCanonicalFile().getParentFile();
            if (!filedir.exists() && !filedir.mkdirs()) {
                errTrace = "Failed to create the directory for the trace log file '" + new File(filename).getCanonicalPath() + "'";
            }
        }
        catch (IOException e) {
            errTrace = "Failed to create the directory for the trace log file '" + filename + "' [" + e.toString() + "]";
        }
        if (errTrace != null) {
            if (this.tracer != null) {
                this.tracer.log(errTrace, Tracer.Level.SEVERE);
            } else {
                System.err.println(errTrace);
            }
        }
        if ((limitStr = UtlProps.getValue(descriptor.props, "limit", null)) == null || (limit = Integer.parseInt(limitStr)) < 0) {
            this.tracer.log("Limit is not specified or is invalid in file handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "]. Using default=100M", Tracer.Level.FINEST);
            limit = 0x6400000;
        }
        if ((countStr = UtlProps.getValue(descriptor.props, "count", null)) == null || (count = Integer.parseInt(countStr)) < 1) {
            this.tracer.log("Count is not specified or is invalid in file handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "]. Using default=10", Tracer.Level.FINEST);
            count = 10;
        }
        boolean append = UtlProps.getValue(descriptor.props, "append", true);
        this.tracer.log("Creating file handler with params [filename=" + filename + ", limit=" + limit + ", count=" + count + ", append=" + append + "]", Tracer.Level.VERBOSE);
        try {
            return new FileHandler(filename, limit, count, append);
        }
        catch (Exception e) {
            this.tracer.log("Failed to create file handler [" + handlerName + "] [error=" + e.toString() + "]", Tracer.Level.WARNING);
            throw new IllegalArgumentException("Failure in creating file handler");
        }
    }

    private final Handler createNetworkHandler(String handlerName, TracerDescriptor descriptor) {
        int port;
        String portStr;
        this.tracer.log("Creating and configuring network handler [" + handlerName + "]...", Tracer.Level.VERBOSE);
        String host = UtlProps.getValue(descriptor.props, "host", null);
        if (host == null) {
            this.tracer.log("Host is not specified in network handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "]. Using default='localhost'", Tracer.Level.FINEST);
            host = "localhost";
        }
        if ((portStr = UtlProps.getValue(descriptor.props, "port", null)) == null || (port = Integer.parseInt(portStr)) <= 0) {
            this.tracer.log("Port is not specified or is invalid in network handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "].", Tracer.Level.FINEST);
            throw new IllegalArgumentException("port specified in network handler descriptor is invalid");
        }
        this.tracer.log("Creating network handler with params [host=" + host + ", port=" + port + "]", Tracer.Level.VERBOSE);
        try {
            return new SocketHandler(host, port);
        }
        catch (Exception e) {
            this.tracer.log("Failed to create network handler [" + handlerName + "] [error=" + e.toString() + "]", Tracer.Level.WARNING);
            throw new IllegalArgumentException("Failure in creating network handler");
        }
    }

    private final Handler createHandler(String handlerName, TracerDescriptor descriptor) {
        Level level;
        Handler handler;
        if (descriptor.type.compareToIgnoreCase("stdout") == 0) {
            handler = this.createStdoutHandler(handlerName, descriptor);
        } else if (descriptor.type.compareToIgnoreCase("stderr") == 0) {
            handler = this.createStderrHandler(handlerName, descriptor);
        } else if (descriptor.type.compareToIgnoreCase("memory") == 0) {
            handler = this.createMemoryHandler(handlerName, descriptor);
        } else if (descriptor.type.compareToIgnoreCase("file") == 0) {
            handler = this.createFileHandler(handlerName, descriptor);
        } else if (descriptor.type.compareToIgnoreCase("network") == 0) {
            handler = this.createNetworkHandler(handlerName, descriptor);
        } else if (descriptor.type.compareToIgnoreCase("null") == 0) {
            handler = new NullHandler();
        } else {
            this.tracer.log("Configured descriptor ['" + descriptor.toString() + "'] for handler [" + handlerName + "] specifies an invalid handler type.", Tracer.Level.FINEST);
            throw new IllegalArgumentException("invalid handler type [" + descriptor.type + "]");
        }
        try {
            level = Level.parse(UtlProps.getValue(descriptor.props, "level", Level.FINEST.toString()).toUpperCase());
        }
        catch (IllegalArgumentException e) {
            level = Level.FINEST;
            this.tracer.log("Level in handler descriptor [" + descriptor.toString() + "] for handler [" + handlerName + "] is invalid. Using default=" + level.toString() + ".", Tracer.Level.FINEST);
        }
        handler.setLevel(level);
        handler.setFormatter(formatter == null ? TraceFormatter.create() : formatter);
        return handler;
    }

    private final Level strToLoggerLevel(String loggerName, String levelStr) {
        this.tracer.log("Logger [" + loggerName + "] level is configured as ['" + levelStr + "']...", Tracer.Level.VERBOSE);
        Level level = null;
        String propname = loggerName + ".logger.level";
        String propLevelStr = Env.getValue(propname, (String)null);
        if (propLevelStr != null) {
            try {
                level = Level.parse(propLevelStr.toUpperCase());
                this.tracer.log("Set logger [" + loggerName + "] level=['" + level.toString() + "'] (from property '" + propname + "')...", Tracer.Level.VERBOSE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (level == null && levelStr != null) {
            try {
                level = Level.parse(levelStr.toUpperCase());
                this.tracer.log("Set logger [" + loggerName + "] level=['" + level.toString() + "'] (as configured)...", Tracer.Level.VERBOSE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (level == null) {
            level = Level.FINEST;
            this.tracer.log("Setting logger [" + loggerName + "] level=['" + level.toString() + "'] (direct)...", Tracer.Level.VERBOSE);
        }
        return level;
    }

    private final ObjectArrayList strToLoggerHandlers(String loggerName, String handlersStr) {
        ObjectArrayList loggerHandlers = new ObjectArrayList();
        String resolvedHandlersStr = null;
        String propName = loggerName + ".logger.handlers";
        resolvedHandlersStr = Env.getValue(propName, (String)null);
        if (resolvedHandlersStr != null) {
            this.tracer.log("Binding logger [" + loggerName + "] to handlers=['" + resolvedHandlersStr + "'] (from property '" + propName + "')...", Tracer.Level.VERBOSE);
        } else {
            resolvedHandlersStr = handlersStr;
            if (resolvedHandlersStr != null) {
                this.tracer.log("Binding logger [" + loggerName + "] to handlers=['" + resolvedHandlersStr + "'] (as configured)...", Tracer.Level.VERBOSE);
            } else {
                resolvedHandlersStr = DEFAULT_HANDLER_NAME;
                this.tracer.log("Binding logger [" + loggerName + "] to handlers=['" + resolvedHandlersStr + "'] (direct)...", Tracer.Level.VERBOSE);
            }
        }
        String str = resolvedHandlersStr;
        StringTokenizer tokenizer = new StringTokenizer(str, ",", false);
        if (tokenizer.countTokens() > 0) {
            do {
                String handlerName;
                Handler handler;
                if ((handler = this.getHandler(handlerName = tokenizer.nextToken())) != null) {
                    loggerHandlers.add((Object)handler);
                    continue;
                }
                this.tracer.log("Handler [" + handlerName + "] configured for logger [" + loggerName + "] is invalid.", Tracer.Level.WARNING);
            } while (tokenizer.hasMoreTokens());
        }
        if (loggerHandlers.size() == 0) {
            this.tracer.log("No valid handlers configured for logger [" + loggerName + "].", Tracer.Level.VERBOSE);
        }
        return loggerHandlers;
    }

    private final Logger createLogger(String loggerName, String levelStr, String handlersStr, boolean fromFile) {
        boolean update;
        boolean bl = update = this.loggers.get(loggerName) != null;
        if (fromFile) {
            this.tracer.log((update ? "Updating" : "Creating") + " logger [" + loggerName + "] (from file)...", Tracer.Level.VERBOSE);
        } else {
            this.tracer.log((update ? "Updating" : "Creating") + " logger [" + loggerName + "] (dynamic)...", Tracer.Level.VERBOSE);
        }
        final Logger logger = Logger.getLogger(loggerName);
        Handler[] oldHandlers = logger.getHandlers();
        for (int i = 0; i < oldHandlers.length; ++i) {
            logger.removeHandler(oldHandlers[i]);
        }
        Level level = this.strToLoggerLevel(loggerName, levelStr);
        logger.setLevel(level);
        ObjectArrayList handlers = this.strToLoggerHandlers(loggerName, handlersStr);
        if (handlers.size() > 0) {
            handlers.forEach(new ObjectProcedure(){

                public final boolean apply(Object element) {
                    Handler handler = (Handler)element;
                    logger.addHandler(new InterceptorHandler(handler));
                    return true;
                }
            });
        }
        logger.setUseParentHandlers(false);
        this.loggers.put(loggerName, logger);
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Handler createHandler(String handlerName, String descriptorStr) {
        if (handlerName == null) {
            throw new IllegalArgumentException("handler name cannot be null;");
        }
        TraceLoggerFactory traceLoggerFactory = this;
        synchronized (traceLoggerFactory) {
            if (this.handlers.containsKey(handlerName)) {
                this.tracer.log("Updating handler [" + handlerName + "] using descriptor ['" + descriptorStr + "']", Tracer.Level.VERBOSE);
            } else {
                this.tracer.log("Creating handler [" + handlerName + "] using descriptor ['" + descriptorStr + "']", Tracer.Level.VERBOSE);
            }
            Handler handler = null;
            if (descriptorStr != null) {
                TracerDescriptor descriptor = null;
                try {
                    descriptor = TracerDescriptor.parse(descriptorStr, null);
                }
                catch (IllegalArgumentException e) {
                    this.tracer.log("Configured descriptor ['" + descriptorStr + "'] for handler [" + handlerName + "] is invalid. Cannot create/update handler.", Tracer.Level.FINEST);
                }
                if (descriptor != null) {
                    try {
                        handler = this.createHandler(handlerName, descriptor);
                        this.handlers.put(handlerName, handler);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else {
                this.tracer.log("Configured descriptor ['" + descriptorStr + "'] for handler [" + handlerName + "] is null. Cannot create/update handler.", Tracer.Level.FINEST);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setHandler(String handlerName, Handler handler) {
        if (handlerName == null) {
            throw new IllegalArgumentException("handler name cannot be null;");
        }
        TraceLoggerFactory traceLoggerFactory = this;
        synchronized (traceLoggerFactory) {
            this.handlers.put(handlerName, handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Handler getHandler(String handlerName) {
        TraceLoggerFactory traceLoggerFactory = this;
        synchronized (traceLoggerFactory) {
            String handlerDescriptorStr;
            Handler handler = this.handlers.get(handlerName);
            if (handler == null && (handlerDescriptorStr = Env.getValue("nv.logger.handler." + handlerName, (String)null)) != null) {
                handler = this.createHandler(handlerName, handlerDescriptorStr);
            }
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Logger createLogger(String loggerName, String levelStr, String handlersStr) {
        TraceLoggerFactory traceLoggerFactory = this;
        synchronized (traceLoggerFactory) {
            return this.createLogger(loggerName, levelStr, handlersStr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Logger getLogger(String loggerName, boolean create) {
        TraceLoggerFactory traceLoggerFactory = this;
        synchronized (traceLoggerFactory) {
            Logger logger = this.loggers.get(loggerName);
            if (logger == null && create) {
                logger = this.createLogger(loggerName, null, null);
            }
            return logger;
        }
    }

    public final void registerWatcher(Handler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("installed watcher cannot be null");
        }
        this.watchersLock.writeLock().lock();
        try {
            this.watchers.add((Object)handler);
        }
        finally {
            this.watchersLock.writeLock().unlock();
        }
    }

    public static final class ForkHandler
    extends Handler {
        private final Handler handler1;
        private final Handler handler2;

        public ForkHandler(Handler handler1, Handler handler2) {
            this.handler1 = handler1;
            this.handler2 = handler2;
        }

        @Override
        public final void setFormatter(Formatter formatter) {
            if (this.handler1 != null) {
                this.handler1.setFormatter(formatter);
            }
            if (this.handler2 != null) {
                this.handler2.setFormatter(formatter);
            }
        }

        @Override
        public final void publish(LogRecord record) {
            if (this.isLoggable(record)) {
                if (this.handler1 != null) {
                    this.handler1.publish(record);
                }
                if (this.handler2 != null) {
                    this.handler2.publish(record);
                }
            }
        }

        @Override
        public final void flush() {
            if (this.handler1 != null) {
                this.handler1.flush();
            }
            if (this.handler2 != null) {
                this.handler2.flush();
            }
        }

        @Override
        public final void close() {
            if (this.handler1 != null) {
                this.handler1.close();
            }
            if (this.handler2 != null) {
                this.handler2.close();
            }
        }
    }

    public static final class NullHandler
    extends Handler {
        @Override
        public final void publish(LogRecord record) {
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }
    }

    public static final class StderrHandler
    extends StreamHandler {
        StderrHandler() {
            this.setOutputStream(System.err);
        }
    }

    public static final class StdoutHandler
    extends StreamHandler {
        public StdoutHandler() {
            this.setOutputStream(System.out);
        }
    }

    private final class InterceptorHandler
    extends Handler {
        private final Handler handler;

        public InterceptorHandler(Handler handler) {
            this.handler = handler;
            this.setLevel(Level.FINEST);
        }

        @Override
        public final void setFormatter(Formatter formatter) {
            if (this.handler != null) {
                this.handler.setFormatter(formatter);
            }
            super.setFormatter(formatter);
        }

        @Override
        public final void publish(final LogRecord record) {
            if (this.isLoggable(record)) {
                if (this.handler != null) {
                    this.handler.publish(record);
                }
                TraceLoggerFactory.this.watchersLock.readLock().lock();
                try {
                    TraceLoggerFactory.this.watchers.forEach(new ObjectProcedure(){

                        public final boolean apply(Object element) {
                            ((Handler)element).publish(record);
                            return true;
                        }
                    });
                }
                finally {
                    TraceLoggerFactory.this.watchersLock.readLock().unlock();
                }
            }
        }

        @Override
        public final void flush() {
            if (this.handler != null) {
                this.handler.flush();
            }
            TraceLoggerFactory.this.watchersLock.readLock().lock();
            try {
                TraceLoggerFactory.this.watchers.forEach(new ObjectProcedure(){

                    public final boolean apply(Object element) {
                        ((Handler)element).flush();
                        return true;
                    }
                });
            }
            finally {
                TraceLoggerFactory.this.watchersLock.readLock().unlock();
            }
        }

        @Override
        public final void close() {
            if (this.handler != null) {
                this.handler.close();
            }
            TraceLoggerFactory.this.watchersLock.readLock().lock();
            try {
                TraceLoggerFactory.this.watchers.forEach(TRACE_HANDLER_CLOSER);
            }
            finally {
                TraceLoggerFactory.this.watchersLock.readLock().unlock();
            }
        }
    }

    private final class TraceLevelPropertyChangeCallback
    implements Env.PropertyChangeCallback {
        private TraceLevelPropertyChangeCallback() {
        }

        @Override
        public final void onPropertyChange(String name, Object oldValue, Object newValue) {
            if (newValue == null) {
                TraceLoggerFactory.this.tracer.setLevel(Tracer.defaultLevel);
            } else if (newValue instanceof String) {
                try {
                    TraceLoggerFactory.this.tracer.setLevel((String)newValue);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Invalid trace level configured for the '" + name + "' tracer.\nStack Trace:" + UtlThrowable.prepareStackTrace(e));
                }
            }
        }
    }
}

