/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitor;
import com.neeve.trace.Tracer;

final class ProgressMonitorHelper {
    private final Controller _controller;
    private final ProgressMonitor _progressMonitor;
    private static final ProgressMonitor NULL_PROGRESS_MONITOR = new ProgressMonitor(){

        @Override
        public void onTrace(String msg, Tracer.Level level) {
        }

        @Override
        public void onError(String msg, Throwable cause) {
        }
    };

    ProgressMonitorHelper(Controller controller, ProgressMonitor progressMonitor) {
        this._controller = controller;
        this._progressMonitor = progressMonitor != null ? progressMonitor : NULL_PROGRESS_MONITOR;
    }

    ProgressMonitorHelper(Controller controller) {
        this(controller, null);
    }

    final void error(String str) {
        this._progressMonitor.onError(str, null);
        this._controller.traceForTroubleshooting("ERROR: " + str, Tracer.Level.SEVERE);
        this._controller.error(str);
    }

    final void error(String str, Throwable thrown) {
        this._progressMonitor.onError(str, thrown);
        this._controller.traceForTroubleshooting("ERROR: " + str, Tracer.Level.SEVERE);
        this._controller.error(str, thrown);
    }

    final void troubleshootingInfo(String str) {
        this._controller.traceForTroubleshooting(str, Tracer.Level.INFO);
    }

    final void troubleshootingSevere(String str) {
        this._controller.traceForTroubleshooting(str, Tracer.Level.SEVERE);
    }

    final void info(String str) {
        this._progressMonitor.onTrace(str, Tracer.Level.INFO);
        this._controller.trace(str, Tracer.Level.INFO);
    }

    final void warning(String str) {
        this._progressMonitor.onTrace(str, Tracer.Level.WARNING);
        this._controller.trace(str, Tracer.Level.WARNING);
    }

    final Object remoteCommand(String xvmName, String appName, String command, boolean sync, boolean waitForXVMToLaunch, int numAppPingAttempts) throws Exception {
        return this._controller.remoteCommand(xvmName, appName, command, sync, waitForXVMToLaunch, numAppPingAttempts, this._progressMonitor);
    }

    final Object remoteCommand(String xvmName, String appName, String command, boolean sync, int numAppPingAttempts) throws Exception {
        return this._controller.remoteCommand(xvmName, appName, command, sync, numAppPingAttempts, this._progressMonitor);
    }
}

