/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.util.ProcessHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;

final class Configure
extends Command {
    private String _sshUser;
    private String _sshKeyFile;
    private XVM _xvm;

    Configure(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final boolean distributeXcs() {
        return this.getDistributionMajorVersion() <= 3 && this.getDistributionMinorVersion() < 14;
    }

    private final ProcessBuilder createConfigurer(XVM xvm) throws Exception {
        if (!(xvm.host().equals(".") || this._sshUser != null && this._sshKeyFile != null)) {
            this.error("ssh user and key file needs to be provided for remote execution");
        }
        File configFile = this.distributeXcs() ? xvm.getXcsFile() : xvm.getConfigFile();
        File envFile = xvm.getEnvironmentFile();
        File jvmParamsFile = xvm.getJVMParamsFile();
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.resolveScript(this.distributeXcs() ? "rucconfig1" : "rucconfig2"));
        command.add(xvm.host().equals(".") ? "sh" : "ssh");
        command.add(xvm.runDir());
        command.add(configFile.getParent());
        command.add(configFile.getName());
        command.add(envFile.getAbsolutePath());
        command.add(jvmParamsFile != null ? jvmParamsFile.getAbsolutePath() : "default");
        if (!xvm.host().equals(".")) {
            command.add(this._sshUser + "@" + xvm.host());
            command.add(this._sshKeyFile);
            command.add(String.valueOf(xvm.sshPort()));
        }
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        ProcessHelper.cleanEnvironment(pb.environment());
        return pb;
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: configure all xvms | the <xvmName> xvm");
    }

    @Override
    final String name() {
        return "configure";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        String token;
        this._sshUser = this.getSshUser();
        this._sshKeyFile = this.getSshKeyFile();
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        if ((token = tokenizer.nextToken()).equals("the")) {
            if (!tokenizer.hasMoreTokens()) {
                this.syntaxError(this.lineNum());
            }
            token = tokenizer.nextToken();
            this._xvm = this.system().getXVM(token);
            if (this._xvm == null) {
                this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
            }
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
                this.syntaxError(this.lineNum());
            }
        } else if (token.equals("all")) {
            if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvms")) {
                this.syntaxError(this.lineNum());
            }
        } else {
            this.syntaxError(this.lineNum());
        }
        return true;
    }

    @Override
    final void execute() {
        try {
            if (this._xvm == null) {
                Iterator<XVM> iterator = this.system().getXVMs().iterator();
                while (iterator.hasNext()) {
                    XVM xvm;
                    this._xvm = xvm = iterator.next();
                    this.execute();
                }
                return;
            }
            if (!this.mock()) {
                String line;
                this.info("......configuring '" + this._xvm.name() + "'...");
                ProcessBuilder pb = this.createConfigurer(this._xvm);
                Process process = pb.start();
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    this.troubleshootingInfo(line);
                    sb.append(line).append("\n");
                }
                while (true) {
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                if (process.exitValue() != 0) {
                    this.error("Configure failed [exit code '" + process.exitValue() + "']:\n" + sb);
                }
            }
        }
        catch (Exception e) {
            this.error("Configure failed [" + e.toString() + "]", e);
        }
    }

    @Override
    final void cleanup() {
    }
}

