/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Controller;
import com.neeve.controller.Script;
import com.neeve.controller.XVM;
import com.neeve.ddl.DdlXMLParser;
import com.neeve.ddl.jaxb.Model;
import com.neeve.ddl.jaxb.XvmConfigList;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlTailoring;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public final class System {
    private final String _name;
    private final File _home;
    private final File _modelFile;
    private final Controller _controller;
    private final SystemConfigPropertySource _controllerPropertySource;
    private final File _systemConfigFolder;
    private final File _localizedSystemDdlFile;
    private final Map<String, XVM> _xvms;
    private long _lastControllerConfigModification = -1L;
    private HashMap<File, Long> configSourceFileModifications = new HashMap();
    private Model _model;
    private String _systemName;
    private String _systemDisplayName;
    private String _systemVersion;

    public System(String name, File home, Controller controller) throws Exception {
        this(name, home, controller, false);
    }

    public System(String name, File home, Controller controller, boolean enableTroubleshooting) throws Exception {
        String[] configFileNames;
        this._name = name;
        this._home = home;
        this._controller = controller;
        this._controllerPropertySource = new SystemConfigPropertySource(controller);
        File modelFile = null;
        for (String configFileName : configFileNames = new String[]{"config.xml", "descriptor.xml"}) {
            File configFile = new File(this._home + File.separator + configFileName);
            this.configSourceFileModifications.put(configFile, -1L);
            if (!configFile.exists()) continue;
            modelFile = configFile;
            break;
        }
        if (modelFile == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            for (int i = 0; i < configFileNames.length; ++i) {
                sb.append(configFileNames[i]);
                if (i >= configFileNames.length - 1) continue;
                sb.append(", ");
            }
            sb.append(']');
            throw new RuntimeException("system configuration file could not be found (looked in '" + this._home + "' for any of " + sb.toString() + ")");
        }
        this._modelFile = modelFile;
        this._xvms = new LinkedHashMap<String, XVM>();
        this._systemConfigFolder = new File(this._modelFile.getParentFile(), "/.rumi/provisioning/" + this._name);
        if (!this._systemConfigFolder.exists() && !this._systemConfigFolder.mkdirs()) {
            throw new RuntimeException("Error creating system config folder " + this._systemConfigFolder);
        }
        this._localizedSystemDdlFile = new File(this._systemConfigFolder, "localized.config.xml");
        this.configure(enableTroubleshooting);
    }

    static final void deleteAndRecreateFile(File file) throws IOException {
        for (int deleteAttempts = 5; file.exists() && deleteAttempts > 0 && !file.delete(); --deleteAttempts) {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (file.exists()) {
            throw new RuntimeException("Error deleting " + file.getAbsolutePath());
        }
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.createNewFile()) {
            throw new RuntimeException("Error creating " + file.getAbsolutePath());
        }
    }

    public boolean isConfigStale() {
        if (this._lastControllerConfigModification != this._controller.lastConfigModificationTime()) {
            return true;
        }
        for (Map.Entry<File, Long> fileEntry : this.configSourceFileModifications.entrySet()) {
            if (fileEntry.getValue() <= 0L) {
                if (!fileEntry.getKey().exists()) continue;
                return true;
            }
            if (!fileEntry.getKey().exists()) {
                return true;
            }
            if (fileEntry.getValue().longValue() == fileEntry.getKey().lastModified()) continue;
            return true;
        }
        for (XVM xvm : this._xvms.values()) {
            if (!xvm.isConfigStale()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void configure(boolean enableTroubleshooting) throws Exception {
        if (!this.isConfigStale()) {
            return;
        }
        this._controllerPropertySource.refresh();
        this._lastControllerConfigModification = this._controllerPropertySource.getConfigModificationTime();
        this._model = DdlXMLParser.parse((File)this._modelFile, (UtlTailoring.PropertySource)this._controllerPropertySource);
        Model.SystemDetails systemDetails = this._model.getSystemDetails();
        if (systemDetails != null) {
            this._systemName = systemDetails.getName();
            this._systemDisplayName = systemDetails.getDisplayName();
            this._systemVersion = systemDetails.getVersion();
        } else {
            this._systemDisplayName = this._systemName = this._name;
            this._systemVersion = null;
        }
        HashSet<String> xvmsConfigured = new HashSet<String>();
        Properties mergedModelProperies = new Properties();
        for (XvmConfigList.Xvm xvmConfig : this._model.getXvms().getXvm()) {
            XVM xvm = this._xvms.get(xvmConfig.getName());
            if (!this._xvms.containsKey(xvmConfig.getName())) {
                xvm = new XVM(xvmConfig.getName(), this._controller, this, this._modelFile, this._controllerPropertySource);
                this._xvms.put(xvmConfig.getName(), xvm);
            } else {
                xvm.configure();
            }
            xvmsConfigured.add(xvmConfig.getName());
            mergedModelProperies.putAll((Map<?, ?>)DdlXMLParser.toDdlProperties((Model)xvm.getXvmLocalizedModel()));
        }
        this._xvms.keySet().retainAll(xvmsConfigured);
        this._model = DdlXMLParser.fromDdlProperties((Properties)mergedModelProperies, null, (boolean)true);
        System.deleteAndRecreateFile(this._localizedSystemDdlFile);
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this._localizedSystemDdlFile));){
            DdlXMLParser.toXml((Model)this._model, (Appendable)writer);
        }
        this.configSourceFileModifications.put(this._modelFile, this._modelFile.lastModified());
    }

    public final Model getModel() {
        return this._model;
    }

    public final String getName() {
        return this._name;
    }

    public final String getSystemName() {
        return this._systemName == null ? this.getName() : this._systemName;
    }

    public final String getSystemDisplayName() {
        return this._systemDisplayName == null ? this.getSystemName() : this._systemDisplayName;
    }

    public final String getSystemVersion() {
        return this._systemVersion;
    }

    public final File getHome() {
        return this._home;
    }

    public final File getJarsDir() {
        return new File(this._home + File.separator + "jars");
    }

    public final File getResourcesDir() {
        return new File(this._home + File.separator + "resources");
    }

    final File getResultsDir(Script script, String token) {
        return new File(this._home + File.separator + "results" + File.separator + script.getRunId() + File.separator + token);
    }

    final File getScriptFile(String scriptName) {
        return new File(this.getScriptsDir() + File.separator + scriptName);
    }

    public final File getScriptsDir() {
        return new File(this._home + File.separator + "scripts");
    }

    public final List<String> getScriptNames() {
        ArrayList<String> scripts = new ArrayList<String>();
        File file = this.getScriptsDir();
        if (file.exists() && file.isDirectory()) {
            for (File child : file.listFiles()) {
                if (!child.isFile()) continue;
                scripts.add(child.getName());
            }
        }
        return scripts;
    }

    public final Script loadScript(String scriptName) throws Exception {
        if (this.isConfigStale()) {
            try {
                this.configure(true);
            }
            catch (Exception e) {
                this._controller.error("Error (re) configuring '" + this.getName() + "'.", e);
            }
        }
        Script script = this._controller.createScript(this);
        File scriptFile = this.getScriptFile(scriptName);
        script.parse(scriptFile, null, true);
        return script;
    }

    public final Collection<XVM> getXVMs() {
        return this._xvms.values();
    }

    public final XVM getXVM(String name) {
        return this._xvms.get(name);
    }

    public final int hashCode() {
        return this.getHome().hashCode();
    }

    public final boolean equals(Object o) {
        return o instanceof System && ((System)o).getHome().getAbsolutePath().equals(this.getHome().getAbsolutePath());
    }

    public final String toString() {
        return this.getSystemDisplayName() + (this.getSystemVersion() == null ? "" : this.getSystemVersion()) + "[" + this.getHome().getAbsolutePath() + "]";
    }

    final class SystemConfigPropertySource
    implements UtlTailoring.PropertySource {
        private Properties controllerConfig = new Properties();
        private long configTimestamp = -1L;
        private Controller controller;
        private boolean configureXvmDiscovery = true;
        private boolean configureXvmAdmin = true;

        SystemConfigPropertySource(Controller controller) throws IOException {
            this.controller = controller;
            this.refresh();
        }

        public String getValue(String key, String defaultValue) {
            if (key != null) {
                if (!this.configureXvmDiscovery && "nv.discovery.descriptor".equals(key)) {
                    return defaultValue;
                }
                if (!this.configureXvmAdmin && key.startsWith("nv.server.admin")) {
                    return defaultValue;
                }
            }
            return this.controllerConfig.getProperty(key, defaultValue);
        }

        public void refresh() throws IOException {
            this.controllerConfig = this.controller.getConfig();
            long newTimestamp = this.controller.lastConfigModificationTime();
            if (newTimestamp != this.configTimestamp) {
                this.configureXvmDiscovery = UtlProps.getValue((Properties)this.controllerConfig, (String)"nv.controller.configurexvmdiscovery", (boolean)true);
                this.configureXvmAdmin = UtlProps.getValue((Properties)this.controllerConfig, (String)"nv.controller.configurexvmadminconnectivity", (boolean)true);
            }
            this.configTimestamp = newTimestamp;
        }

        public Properties getCurrentControllerConfig() {
            return this.controllerConfig;
        }

        public long getConfigModificationTime() {
            return this.configTimestamp;
        }
    }
}

