/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.config.Config;
import com.neeve.lang.XBooleanIterator;
import com.neeve.lang.XBooleanLinkedHashMap;
import com.neeve.lang.XBooleanMap;
import com.neeve.lang.XBooleanSet;
import com.neeve.lang.XIterator;
import com.neeve.ods.IStoreObject;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogBooleanMap;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RogXBooleanMap<V extends IRogCollectionNodeElement>
extends RogCollectionNode<V>
implements IRogBooleanMap<V> {
    private final int initialCapacity = Config.getValue((String)("nv.rog.map." + this.getClass().getName() + ".initialCapacity"), (int)0);
    private final XBooleanLinkedHashMap<V> map = this.initialCapacity > 0 ? new XBooleanLinkedHashMap(this.initialCapacity) : new XBooleanLinkedHashMap();
    private Set<Map.Entry<Boolean, V>> boxedEntrySet;
    private Set<Boolean> boxedKeySet;

    protected RogXBooleanMap(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.map.setSupportsIteratorModifications(false);
    }

    private final V add(V element) {
        return (V)((IRogCollectionNodeElement)this.map.put(this.getMapElementKey(element), element));
    }

    protected abstract boolean getMapElementKey(V var1);

    protected abstract void setMapElementKey(V var1, boolean var2);

    @Override
    protected final XIterator<V> reusableChildIterator() {
        return this.reuseableValueIterator();
    }

    @Override
    protected final PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        XIterator iterator = this.map.reuseableEntryIterator();
        while (iterator.hasNext()) {
            XBooleanMap.Entry entry = (XBooleanMap.Entry)iterator.next();
            this.visitField(visitor, "Key " + i, entry.getKey());
            this.visitField(visitor, "Value " + i, (RogNode)entry.getValue());
            ++i;
        }
    }

    @Override
    public final void addChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.put(this.getMapElementKey(mapElement), (V)mapElement);
    }

    @Override
    public final void removeChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.remove(this.getMapElementKey(mapElement));
        element.dispose();
    }

    @Override
    public final int getNumChildren() {
        return this.map.size();
    }

    @Override
    public final int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.map.clear();
        }
        return count;
    }

    @Override
    public final IStoreObject setFieldValue(long fid, Object val) {
        return this;
    }

    @Override
    public final V put(boolean key, V value) {
        V rc;
        boolean currentKey = this.getMapElementKey(value);
        if (value.getParent() == this && key == currentKey) {
            return value;
        }
        if (currentKey != key) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove(key);
                this.map.put(key, rc);
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final V put(Boolean key, V value) {
        if (key == null) {
            throw new NullPointerException("Null values not supported");
        }
        return this.put((boolean)key, value);
    }

    @Override
    public final void putAll(Map<? extends Boolean, ? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V get(boolean key) {
        return (V)((IRogCollectionNodeElement)this.map.get(key));
    }

    @Override
    public final V get(Boolean key) {
        if (key == null) {
            return null;
        }
        return this.get((boolean)key);
    }

    @Override
    public final V get(Object key) {
        if (key instanceof Boolean) {
            return this.get((Boolean)key);
        }
        return null;
    }

    @Override
    public final boolean containsKey(boolean key) {
        return this.map.containsKey(key);
    }

    @Override
    public final boolean containsKey(Boolean key) {
        if (key == null) {
            return false;
        }
        return this.containsKey((boolean)key);
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey((Boolean)key);
    }

    @Override
    public final boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public final Set<Boolean> keySet() {
        if (this.boxedKeySet == null) {
            this.boxedKeySet = new KeySet();
        }
        return this.boxedKeySet;
    }

    @Override
    public final XBooleanSet keyBooleanSet() {
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final Set<Map.Entry<Boolean, V>> entrySet() {
        if (this.boxedEntrySet == null) {
            this.boxedEntrySet = new EntrySet();
        }
        return this.boxedEntrySet;
    }

    @Override
    public final XBooleanIterator reuseableKeyIterator() {
        return this.map.reuseableKeyIterator();
    }

    @Override
    public final XIterator<V> reuseableValueIterator() {
        return this.map.reuseableValueIterator();
    }

    @Override
    public final XIterator<XBooleanMap.Entry<V>> reuseableEntryIterator() {
        return this.map.reuseableEntryIterator();
    }

    @Override
    public final V remove(boolean key) {
        IRogCollectionNodeElement element = (IRogCollectionNodeElement)this.map.remove(key);
        if (element != null) {
            this.removeChild(element);
        }
        return (V)element;
    }

    @Override
    public final V remove(Boolean key) {
        if (key == null) {
            return null;
        }
        return this.remove((boolean)key);
    }

    @Override
    public final V remove(Object key) {
        if (key instanceof Boolean) {
            return this.remove((Boolean)key);
        }
        return null;
    }

    @Override
    public final void clear() {
        XBooleanIterator iterator = this.map.reuseableKeyIterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
            this.map.reuseableKeyIterator();
        }
        this.map.clear();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Boolean, V>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return RogXBooleanMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXBooleanMap.this.isEmpty();
        }

        @Override
        public final Iterator<Map.Entry<Boolean, V>> iterator() {
            final Iterator it = RogXBooleanMap.this.map.entrySet().iterator();
            return new Iterator<Map.Entry<Boolean, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<Boolean, V> next() {
                    final XBooleanMap.Entry e = (XBooleanMap.Entry)it.next();
                    return new Map.Entry<Boolean, V>(){

                        @Override
                        public Boolean getKey() {
                            return e.getKey();
                        }

                        @Override
                        public V getValue() {
                            return (IRogCollectionNodeElement)e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<Boolean, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Boolean, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<Boolean> {
        KeySet() {
        }

        @Override
        public int size() {
            return RogXBooleanMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXBooleanMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RogXBooleanMap.this.containsKey(o);
        }

        @Override
        public Iterator<Boolean> iterator() {
            final XBooleanIterator it = RogXBooleanMap.this.map.keySet().iterator();
            return new Iterator<Boolean>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Boolean next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        }

        @Override
        public boolean add(Boolean e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Boolean> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

