/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.databind.util.StdConverter;
import com.neeve.sma.MessageTransportHeaders;
import java.util.Date;
import java.util.Map;

public class RogUtil {

    public static class DateToTimestampConverter
    extends StdConverter<Date, Long> {
        public Long convert(Date value) {
            return value == null ? 0L : value.getTime();
        }
    }

    public static class TimestampToDateConverter
    extends StdConverter<Long, Date> {
        public Date convert(Long value) {
            return value == null || value == 0L ? null : new Date(value);
        }
    }

    public static class UUIDToStringConverter
    extends StdConverter<UUID, String> {
        public String convert(UUID value) {
            return value == null ? null : value.toString();
        }
    }

    public static class StringToUUIDConverter
    extends StdConverter<String, UUID> {
        public UUID convert(String value) {
            return value == null ? null : new UUID((CharSequence)value);
        }
    }

    public static class MapToMessageTransportHeadersConverter
    extends StdConverter<Map<String, Object>, MessageTransportHeaders> {
        public MessageTransportHeaders convert(Map<String, Object> value) {
            if (value == null) {
                return null;
            }
            MessageTransportHeaders headers = MessageTransportHeaders.create();
            for (Map.Entry<String, Object> h : value.entrySet()) {
                headers.addHeader((CharSequence)h.getKey(), h.getValue());
            }
            return headers;
        }
    }

    public static class MessageTransportHeadersToMapConverter
    extends StdConverter<MessageTransportHeaders, Map<String, Object>> {
        public Map<String, Object> convert(MessageTransportHeaders value) {
            if (value == null) {
                return null;
            }
            return value.toMap();
        }
    }
}

