/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XString;

final class RogDirectMetadataV2Deserializer {
    static final byte VERSION = 2;
    private static final int FLAG_IN_MSGS_IN_TRANSACTION = 1;
    private static final int FLAG_OUT_MSGS_IN_TRANSACTION = 2;
    private static final int FLAG_POSDUP = 4;
    private static final int FLAG_IS_MESSAGE = 8;
    private static final int FLAG_IS_MESSAGE_OUTBOUND = 16;
    private static final int FLAG_IS_MESSAGE_REPLAYED = 32;
    private static final int FLAG_LAST_TRANSACTION = 64;
    private static final int FLAG_INTERNAL = 128;
    private static final int FLAG_IS_MESSAGE_INBOUND = 256;
    private static final int HAS_TRANSACTION_IN_SEQ_NO = 1;
    private static final int HAS_TRANSACTION_OUT_SEQ_NO = 2;
    private static final int HAS_GRAPH_ID = 4;
    private static final int HAS_PARENT_ID = 8;
    private static final int HAS_PREPROCESSING_TS = 16;
    private static final int HAS_OUT_TS = 32;
    private static final int HAS_MESSAGE_SENDER = 64;
    private static final int HAS_MESSAGE_FLOW = 128;
    private static final int HAS_MESSAGE_SEQ_NUMBER = 256;
    private static final int HAS_MESSAGE_BUS = 512;
    private static final int HAS_MESSAGE_CHANNEL = 1024;
    private static final int HAS_MESSAGE_KEY = 2048;
    private static final int POS_VERSION = 0;
    private static final int POS_FLAGS = 1;
    private static final int POS_HASFIELD_FLAGS = 5;
    private static final int POS_TRANSACTION_IN_SEQ_NO = 9;
    private static final int POS_TRANSACTION_OUT_SEQ_NO = 13;
    private static final int POS_GRAPH_ID = 17;
    private static final int POS_PARENT_UUID_TIME = 21;
    private static final int POS_PARENT_UUID_CLOCK_SEQ = 29;
    private static final int POS_PREPROCESSING_TS = 37;
    private static final int POS_OUT_TS = 45;
    private static final int POS_MESSAGE_SENDER = 53;
    private static final int POS_MESSAGE_FLOW = 57;
    private static final int POS_MESSAGE_SEQ_NUMBER = 61;
    private static final int POS_MESSAGE_BUS_LENGTH = 69;
    private static final int POS_MESSAGE_BUS_OFFSET = 71;
    private static final int POS_MESSAGE_CHANNEL_LENGTH = 73;
    private static final int POS_MESSAGE_CHANNEL_OFFSET = 75;
    private static final int POS_MESSAGE_KEY_LENGTH = 77;
    private static final int POS_MESSAGE_KEY_OFFSET = 79;

    RogDirectMetadataV2Deserializer() {
    }

    private static final boolean hasField(IOElasticBuffer buffer, int flag) {
        return (buffer.getInt(5) & flag) > 0;
    }

    private static final boolean getFlag(IOElasticBuffer buffer, int flag) {
        return (buffer.getInt(1) & flag) == flag;
    }

    static final byte getVersion(IOElasticBuffer buffer) {
        return buffer.get(0);
    }

    static final boolean getInMsgsInTransaction(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 1);
    }

    static final boolean getOutMsgsInTransaction(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 2);
    }

    static final boolean getIsMessage(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 8);
    }

    static final boolean getIsInboundMessage(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 256);
    }

    static final boolean getIsOutboundMessage(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 16);
    }

    static final boolean getIsReplayedMessage(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 32);
    }

    static final boolean getIsLastTransaction(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 64);
    }

    static final boolean getIsInternal(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 128);
    }

    static final boolean isPossibleDuplicate(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.getFlag(buffer, 4);
    }

    static final int getTransactionInSequenceNumber(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 1)) {
            return buffer.getInt(9);
        }
        return 0;
    }

    static final int getTransactionOutSequenceNumber(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 2)) {
            return buffer.getInt(13);
        }
        return 0;
    }

    static final int getGraphId(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 4)) {
            return buffer.getInt(17);
        }
        return 0;
    }

    static final UUID getParentId(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 8)) {
            long time = buffer.getLong(21);
            long cas = buffer.getLong(29);
            return new UUID(time, cas);
        }
        return null;
    }

    static final long getPreProcessingTs(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 16)) {
            return buffer.getLong(37);
        }
        return 0L;
    }

    static final long getOutTs(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 32)) {
            return buffer.getLong(45);
        }
        return 0L;
    }

    static final int getMessageSender(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 64)) {
            return buffer.getInt(53);
        }
        return 0;
    }

    static final int getMessageFlow(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 128)) {
            return buffer.getInt(57);
        }
        return 0;
    }

    static final long getMessageSequenceNumber(IOElasticBuffer buffer) {
        if (RogDirectMetadataV2Deserializer.hasField(buffer, 256)) {
            return buffer.getLong(61);
        }
        return 0L;
    }

    static final boolean hasMessageBus(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.hasField(buffer, 512);
    }

    static final short getMessageBusLength(IOElasticBuffer buffer) {
        return buffer.getShort(69);
    }

    static final void getMessageBus(IOElasticBuffer buffer, XString messageBus) {
        if (!RogDirectMetadataV2Deserializer.hasField(buffer, 512)) {
            messageBus.setValue((String)null);
        } else {
            short offset = buffer.getShort(71);
            short length = buffer.getShort(69);
            messageBus.setValue(buffer, (int)offset, (int)length);
        }
    }

    static final boolean hasMessageChannel(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.hasField(buffer, 1024);
    }

    static final short getMessageChannelLength(IOElasticBuffer buffer) {
        return buffer.getShort(73);
    }

    static final void getMessageChannel(IOElasticBuffer buffer, XString messageChannel) {
        if (!RogDirectMetadataV2Deserializer.hasField(buffer, 1024)) {
            messageChannel.setValue((String)null);
        } else {
            short offset = buffer.getShort(75);
            short length = buffer.getShort(73);
            messageChannel.setValue(buffer, (int)offset, (int)length);
        }
    }

    static final boolean hasMessageKey(IOElasticBuffer buffer) {
        return RogDirectMetadataV2Deserializer.hasField(buffer, 2048);
    }

    static final short getMessageKeyLength(IOElasticBuffer buffer) {
        return buffer.getShort(77);
    }

    static final void getMessageKey(IOElasticBuffer buffer, XString messageKey) {
        if (!RogDirectMetadataV2Deserializer.hasField(buffer, 2048)) {
            messageKey.setValue((String)null);
        } else {
            short offset = buffer.getShort(79);
            short length = buffer.getShort(77);
            messageKey.setValue(buffer, (int)offset, (int)length);
        }
    }
}

