/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreBinding;
import com.neeve.rog.ERogIllegalParentReferenceException;
import com.neeve.rog.IRogContainerNode;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogNode;

public abstract class RogContainerNode
extends RogNode
implements IRogContainerNode {
    protected RogContainerNode(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
    }

    protected final void assertSingleParent(IRogNode node) throws IllegalStateException {
        if (node != null && node.getParent() != null && node.getParent() != this) {
            throw new ERogIllegalParentReferenceException("Cannot set '" + node.getClass().getSimpleName() + "' as a child of '" + this.getClass().getSimpleName() + "', it is already a child of '" + node.getParent().getClass().getSimpleName() + "'. An entity can only be used as a single field in the object graph.");
        }
    }

    protected final void addNodeToStore(long fid, RogNode node) {
        if (this.binding != null && this.binding.getState() == IStoreBinding.State.Open && this.binding.getRole() == IStoreBinding.Role.Primary) {
            if (this.transactional) {
                this.recordFieldUpdate(fid, null);
            }
            node.acquire();
            this.binding.put(node);
        }
    }

    protected final void removeNodeFromStore(long fid, RogNode node) {
        if (this.binding != null && this.binding.getState() == IStoreBinding.State.Open && this.binding.getRole() == IStoreBinding.Role.Primary) {
            if (this.transactional) {
                this.recordFieldUpdate(fid, node);
            }
            this.binding.remove(node);
        }
    }

    protected final void addChild(long fid, RogNode node) {
        node.acquire();
        this.addNodeToStore(fid, node);
        node.setGraphId(this.getGraphId());
        node.setParent(this);
        if (node instanceof RogContainerNode) {
            ((RogContainerNode)node).addChildrenToStore();
        }
    }

    protected final void removeChild(long fid, RogNode node) {
        if (node instanceof RogContainerNode) {
            ((RogContainerNode)node).removeChildrenFromStore();
        }
        node.setParent(null);
        node.setGraphId(0);
        this.removeNodeFromStore(fid, node);
        node.dispose();
    }

    protected abstract void addChildrenToStore();

    protected abstract void removeChildrenFromStore();
}

