/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.neeve.ods.IStoreCommitCompletionEvent;
import com.neeve.ods.IStoreCommitCompletionStatus;
import com.neeve.ods.IStoreMember;
import com.neeve.ods.IStoreMemberReplicationStatus;
import com.neeve.ods.impl.StoreCommitCompletionEvent;
import com.neeve.ods.impl.StoreMemberReplicationStatus;
import com.neeve.util.UtlLinkedHashMap;
import com.neeve.util.UtlListElement;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class StoreCommitCompletionStatus
extends UtlListElement
implements IStoreCommitCompletionStatus {
    private final StoreCommitCompletionEvent completionEvent;
    private final UtlLinkedHashMap<IStoreMember, IStoreMemberReplicationStatus> replicationStatus;
    private int successCount;
    private int failedCount;
    private final AtomicBoolean memberAdditionClosed;
    private long commitSequenceNumber;

    StoreCommitCompletionStatus(StoreCommitCompletionEvent completionEvent) {
        this.completionEvent = completionEvent;
        this.replicationStatus = new UtlLinkedHashMap();
        this.memberAdditionClosed = new AtomicBoolean(false);
        this.reset();
    }

    private final void clearReplicationStatuses() {
        UtlLinkedHashMap.FastIterator iterator = this.replicationStatus.fastIterator().toFirst();
        while (iterator.hasNext()) {
            StoreMemberReplicationStatus status = (StoreMemberReplicationStatus)((Map.Entry)iterator.next()).getValue();
            try {
                status.dispose();
            }
            catch (IllegalArgumentException iae) {
                if (status.getStatus() != null || status.getPool() != null && status.getPool().isClosed()) continue;
                throw iae;
            }
        }
        this.replicationStatus.clear();
    }

    final void reset() {
        this.successCount = 0;
        this.failedCount = 0;
        this.commitSequenceNumber = -1L;
        this.memberAdditionClosed.set(false);
        this.clearReplicationStatuses();
    }

    public final IStoreCommitCompletionEvent getCompletionEvent() {
        return this.completionEvent;
    }

    public final void addMember(IStoreMember member) {
        if (member == null) {
            throw new IllegalArgumentException("member cannot be null");
        }
        if (this.memberAdditionClosed.get()) {
            throw new IllegalStateException("member addition has been closed");
        }
        if (this.replicationStatus.put((Object)member, (Object)member.createReplicationStatus()) != null) {
            throw new IllegalStateException("member already exists!");
        }
    }

    public final boolean isMemberAdded(IStoreMember member) {
        return this.replicationStatus.get((Object)member) != null;
    }

    public final void closeMemberAddition() {
        this.memberAdditionClosed.set(true);
    }

    public final void setReplicationStatus(IStoreMember member, Exception status) {
        StoreMemberReplicationStatus memberStatus = (StoreMemberReplicationStatus)this.replicationStatus.get((Object)member);
        if (memberStatus != null) {
            memberStatus.setStatus(status);
            if (status == null) {
                ++this.successCount;
            } else {
                ++this.failedCount;
            }
        } else {
            throw new IllegalArgumentException("member not registered a part of commit");
        }
    }

    public final StoreCommitCompletionStatus complete(Exception status) {
        UtlLinkedHashMap.FastIterator iterator = this.replicationStatus.fastIterator().toFirst();
        while (iterator.hasNext()) {
            StoreMemberReplicationStatus memberStatus = (StoreMemberReplicationStatus)((Map.Entry)iterator.next()).getValue();
            if (memberStatus.isStatusSet()) continue;
            memberStatus.setStatus(status);
            if (status == null) {
                ++this.successCount;
                continue;
            }
            ++this.failedCount;
        }
        return this;
    }

    public final boolean isComplete() {
        while (!this.memberAdditionClosed.get()) {
        }
        return this.successCount + this.failedCount == this.replicationStatus.size();
    }

    public long getCommitSequenceNumber() {
        return this.commitSequenceNumber;
    }

    public StoreCommitCompletionStatus setCommitSequenceNumber(long commitSequenceNumber) {
        this.commitSequenceNumber = commitSequenceNumber;
        return this;
    }

    @Override
    public final int getSuccessCount() {
        return this.successCount;
    }

    @Override
    public final int getFailedCount() {
        return this.failedCount;
    }

    @Override
    public final Map<IStoreMember, IStoreMemberReplicationStatus> getReplicationStatus() {
        return this.replicationStatus;
    }
}

