/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigComplexEntity;
import com.neeve.config.IConfigComplexEntityContainer;
import com.neeve.config.IConfigRepository;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.OdsException;
import com.neeve.ods.OdsObject;
import com.neeve.ods.StoreInterClusterReplicatorDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.ods.StoreReplicatorDescriptor;
import com.neeve.stats.Stats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;

public final class StoreDescriptor
extends OdsObject {
    private final String name;
    private Properties providerConfig;
    private String replicatorName;
    private String persisterName;
    private int persistenceQuorum;
    private int maxPersistSyncBacklog;
    private String icrName;
    private int icrQuorum;
    private int maxIcrSyncBacklog;
    private IStoreCheckpointingController.Type checkpointingType;
    private int checkpointThreshold;
    private long checkpointMaxInterval;
    private boolean queryable;
    private boolean detachedMemberInitialization;
    private String detachedMemberInitializerCpuAffinityMask;
    private String discoveryDescriptor;
    private boolean recordLegLatencies;
    private boolean recordLegLatenciesExplcitlySet;
    public static final String PROPNAME_DISCOVERY_DESCRIPTOR = "DiscoveryDescriptor";

    private StoreDescriptor(String name) {
        super(null);
        this.name = name;
        this.replicatorName = null;
        this.persisterName = null;
        this.persistenceQuorum = 2;
        this.maxPersistSyncBacklog = 0;
        this.icrName = null;
        this.icrQuorum = 2;
        this.maxIcrSyncBacklog = 0;
        this.checkpointingType = null;
        this.checkpointThreshold = 10000000;
        this.checkpointMaxInterval = 0L;
        this.queryable = false;
        this.detachedMemberInitialization = false;
        this.detachedMemberInitializerCpuAffinityMask = "0";
        this.discoveryDescriptor = null;
        this.recordLegLatencies = false;
        this.providerConfig = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final StoreDescriptor setReplicator(String replicatorName) {
        this.replicatorName = replicatorName;
        return this;
    }

    public final String getReplicator() {
        return this.replicatorName;
    }

    public final StoreDescriptor setPersister(String persisterName) {
        this.persisterName = persisterName;
        return this;
    }

    public final String getPersister() {
        return this.persisterName;
    }

    public final StoreDescriptor setPersistenceQuorum(int quorum) {
        if (quorum <= 0) {
            throw new IllegalArgumentException("quorum must be >= 1");
        }
        this.persistenceQuorum = quorum;
        return this;
    }

    public final int getPersistenceQuorum() {
        return this.persistenceQuorum;
    }

    public final StoreDescriptor setMaxPersistSyncBacklog(int backlog) {
        this.maxPersistSyncBacklog = backlog;
        return this;
    }

    public final int getMaxPersistSyncBacklog() {
        return this.maxPersistSyncBacklog;
    }

    public final StoreDescriptor setInterClusterReplicator(String icrName) {
        this.icrName = icrName;
        return this;
    }

    public final String getInterClusterReplicator() {
        return this.icrName;
    }

    public final StoreDescriptor setInterClusterReplicationQuorum(int quorum) {
        if (quorum <= 0) {
            throw new IllegalArgumentException("quorum must be >= 1");
        }
        this.icrQuorum = quorum;
        return this;
    }

    public final int getInterClusterReplicationQuorum() {
        return this.icrQuorum;
    }

    public final StoreDescriptor setIcrQuorum(int quorum) {
        return this.setInterClusterReplicationQuorum(quorum);
    }

    public final int getIcrQuorum() {
        return this.getInterClusterReplicationQuorum();
    }

    public final StoreDescriptor setMaxInterClusterReplicationSyncBacklog(int backlog) {
        this.maxIcrSyncBacklog = backlog;
        return this;
    }

    public final int getMaxInterClusterReplicationSyncBacklog() {
        return this.maxIcrSyncBacklog;
    }

    public final StoreDescriptor setMaxIcrSyncBacklog(int backlog) {
        return this.setMaxInterClusterReplicationSyncBacklog(backlog);
    }

    public final int getMaxIcrSyncBacklog() {
        return this.getMaxInterClusterReplicationSyncBacklog();
    }

    public final void setCheckpointingType(IStoreCheckpointingController.Type val) {
        this.checkpointingType = val;
    }

    public final IStoreCheckpointingController.Type getCheckpointingType() {
        return this.checkpointingType;
    }

    public int getCheckpointThreshold() {
        return this.checkpointThreshold;
    }

    public void setCheckpointThreshold(int checkpointThreshold) {
        this.checkpointThreshold = checkpointThreshold;
    }

    public long getCheckpointMaxInterval() {
        return this.checkpointMaxInterval;
    }

    public void setCheckpointMaxInterval(long checkpointMaxInterval) {
        this.checkpointMaxInterval = checkpointMaxInterval;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    @Deprecated
    public String getDiscoveryDescriptor() {
        return this.discoveryDescriptor;
    }

    @Deprecated
    public void setDiscoveryDescriptor(String discoveryDescriptor) {
        this.discoveryDescriptor = discoveryDescriptor;
    }

    public void setDetachedMemberInitialization(boolean enabled) {
        this.detachedMemberInitialization = enabled;
    }

    public boolean isDetachedMemberInitialization() {
        return this.detachedMemberInitialization;
    }

    public void setDetachedMemberInitializerCpuAffinityMask(String mask) {
        if (mask == null) {
            throw new IllegalArgumentException("mask cannot be null");
        }
        this.detachedMemberInitializerCpuAffinityMask = mask;
    }

    public String getDetachedMemberInitializerCpuAffinityMask() {
        return this.detachedMemberInitializerCpuAffinityMask;
    }

    public final void setRecordLegLatencies(boolean val) {
        this.recordLegLatencies = val;
        this.recordLegLatenciesExplcitlySet = true;
    }

    public final boolean getRecordLegLatencies() {
        if (!this.recordLegLatenciesExplcitlySet) {
            this.setRecordLegLatencies(Config.getValue((String)"nv.stats.latency.leg.store.enabled", (boolean)Config.getValue((String)"nv.ods.latency.stats", (boolean)Stats.LatencyManager.recordLegLatencies)));
        }
        return this.recordLegLatencies;
    }

    @Deprecated
    public final void setCaptureLatencyStats(boolean val) {
        this.setRecordLegLatencies(val);
    }

    @Deprecated
    public final boolean getCaptureLatencyStats() {
        return this.getRecordLegLatencies();
    }

    public final Properties save(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        if (this.replicatorName != null) {
            props.setProperty("Replicator", this.replicatorName);
        }
        if (this.persisterName != null) {
            props.setProperty("Persister", this.persisterName);
        }
        props.setProperty("PersistenceQuorum", String.valueOf(this.persistenceQuorum));
        props.setProperty("MaxPersistSyncBacklog", String.valueOf(this.maxPersistSyncBacklog));
        if (this.icrName != null) {
            props.setProperty("InterClusterReplicator", this.icrName.toString());
        }
        props.setProperty("InterClusterReplicationQuorum", String.valueOf(this.icrQuorum));
        props.setProperty("MaxInterClusterReplicationSyncBacklog", String.valueOf(this.maxIcrSyncBacklog));
        if (this.checkpointingType != null) {
            props.setProperty("CheckpointingType", String.valueOf((Object)this.checkpointingType));
        }
        props.setProperty("CheckpointingThreshold", String.valueOf(this.checkpointThreshold));
        props.setProperty("CheckpointingMaxInterval", String.valueOf(this.checkpointMaxInterval));
        props.setProperty("Queryable", String.valueOf(this.queryable));
        props.setProperty("DetachedMemberInitialization", String.valueOf(this.detachedMemberInitialization));
        props.setProperty("DetachedMemberInitializerCpuAffinityMask", this.detachedMemberInitializerCpuAffinityMask);
        if (this.recordLegLatenciesExplcitlySet) {
            props.setProperty("RecordLegLatencies", String.valueOf(this.recordLegLatencies));
        }
        if (this.discoveryDescriptor != null) {
            props.setProperty(PROPNAME_DISCOVERY_DESCRIPTOR, this.discoveryDescriptor);
        }
        return props;
    }

    public final Properties load(Properties props) {
        if (props == null) {
            throw new IllegalArgumentException("props cannot be null");
        }
        this.setReplicator(props.getProperty("Replicator"));
        this.setPersister(props.getProperty("Persister"));
        this.setPersistenceQuorum(Integer.parseInt(props.getProperty("PersistenceQuorum", "2")));
        this.setMaxPersistSyncBacklog(Integer.parseInt(props.getProperty("MaxPersistSyncBacklog", "0")));
        this.setInterClusterReplicator(props.getProperty("InterClusterReplicator"));
        this.setInterClusterReplicationQuorum(Integer.parseInt(props.getProperty("InterClusterReplicationQuorum", "2")));
        this.setMaxInterClusterReplicationSyncBacklog(Integer.parseInt(props.getProperty("MaxInterClusterReplicationSyncBacklog", "0")));
        String checkpointingType = props.getProperty("CheckpointingType");
        if (checkpointingType != null) {
            this.setCheckpointingType(IStoreCheckpointingController.Type.valueOf(checkpointingType));
        }
        this.setCheckpointThreshold(Integer.parseInt(props.getProperty("CheckpointingThreshold", new Long(10000000L).toString())));
        this.setCheckpointMaxInterval(Long.parseLong(props.getProperty("CheckpointingMaxInterval", new Long(this.checkpointMaxInterval).toString())));
        this.setQueryable(Boolean.parseBoolean(props.getProperty("Queryable", new Boolean(this.queryable).toString())));
        this.setDetachedMemberInitialization(Boolean.parseBoolean(props.getProperty("DetachedMemberInitialization", new Boolean(this.detachedMemberInitialization).toString())));
        this.setDetachedMemberInitializerCpuAffinityMask(props.getProperty("DetachedMemberInitializerCpuAffinityMask", this.detachedMemberInitializerCpuAffinityMask));
        if (props.getProperty("RecordLegLatencies") != null) {
            this.setRecordLegLatencies(Boolean.parseBoolean(props.getProperty("RecordLegLatencies")));
        }
        this.setDiscoveryDescriptor(props.getProperty(PROPNAME_DISCOVERY_DESCRIPTOR));
        return props;
    }

    public final void save(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigComplexEntity entity;
            String storeContainerAddr = "/ods/stores";
            IConfigComplexEntityContainer storeContainer = repo.getComplexEntityContainer("/ods/stores");
            if (storeContainer == null) {
                storeContainer = repo.createComplexEntityContainer("/ods/stores");
            }
            if ((entity = (IConfigComplexEntity)storeContainer.getEntity(this.name)) == null) {
                entity = (IConfigComplexEntity)storeContainer.createEntity(this.name);
            }
            entity.setProperties("store.properties", null).setProperties("store.properties", this.save(new Properties()));
        }
        catch (EConfigException e) {
            throw new OdsException(e);
        }
    }

    public final void save() throws OdsException {
        this.save(Config.getRepository());
    }

    public final void delete(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigComplexEntityContainer storeContainer = repo.getComplexEntityContainer("/ods/stores");
        if (storeContainer != null) {
            storeContainer.removeEntity(this.name);
        }
    }

    public final void delete() throws OdsException {
        this.delete(Config.getRepository());
    }

    public static StoreDescriptor create(String name) {
        if (name == null) {
            throw new IllegalArgumentException("store name cannot be null");
        }
        return new StoreDescriptor(name);
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("store name cannot be null");
        }
        return repo.getComplexEntity("/ods/stores/" + name) != null;
    }

    public static boolean exists(String name) {
        return StoreDescriptor.exists(Config.getRepository(), name);
    }

    public static StoreDescriptor load(IConfigRepository repo, String name) throws OdsException {
        Properties storeProps;
        IConfigComplexEntity entity;
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        StoreDescriptor storeDescriptor = StoreDescriptor.create(name);
        Tracer tracer = storeDescriptor.getTracer();
        if (tracer.debug) {
            tracer.log("[StoreDescriptor," + name + "] Loading store descriptor for store '" + name + "' from repository...", Tracer.Level.DEBUG);
        }
        if ((entity = repo.getComplexEntity("/ods/stores/" + name)) != null) {
            storeProps = entity.getProperties("store.properties");
            if (storeProps == null) {
                storeProps = new Properties();
            }
            if (tracer.debug) {
                tracer.log("[StoreDescriptor," + name + "] Store properties=" + storeProps.toString(), Tracer.Level.DEBUG);
            }
        } else {
            throw new OdsException("Store '" + name + "' not found in repository");
        }
        storeDescriptor.load(storeProps);
        return storeDescriptor;
    }

    public static StoreDescriptor load(String name) throws OdsException {
        return StoreDescriptor.load(Config.getRepository(), name);
    }

    public static Set<StoreDescriptor> loadAll(IConfigRepository repo) throws OdsException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<StoreDescriptor> stores = new LinkedHashSet<StoreDescriptor>();
        IConfigComplexEntityContainer container = repo.getComplexEntityContainer("/ods/stores");
        if (container != null) {
            for (IConfigComplexEntity entity : container) {
                try {
                    stores.add(StoreDescriptor.load(repo, entity.getName()));
                }
                catch (OdsException e) {
                    throw new OdsException("Failure in loading descriptor for store '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return stores;
    }

    public static Set<StoreDescriptor> loadAll() throws OdsException {
        return StoreDescriptor.loadAll(Config.getRepository());
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nStore '" + this.getName() + "' Configuration {").append("\n");
        sb.append("...checkpointingType").append("=").append((Object)this.getCheckpointingType()).append("\n");
        sb.append("...checkpointingThreshold").append("=").append(this.getCheckpointThreshold()).append("\n");
        sb.append("...checkpointingMaxInterval").append("=").append(this.getCheckpointMaxInterval()).append("\n");
        if (this.discoveryDescriptor != null) {
            sb.append("...discovery=" + UtlAddressDescriptor.parse((String)this.getDiscoveryDescriptor(), null).toPasswordSanitizedFullString());
        }
        sb.append("...detachedMemberInitialization=" + this.detachedMemberInitialization).append("\n");
        sb.append("...detachedMemberInitializerCpuAffinityMask=" + this.detachedMemberInitializerCpuAffinityMask).append("\n");
        if (this.getPersister() != null) {
            sb.append("...persistenceQuorum=" + this.getPersistenceQuorum()).append("\n");
            sb.append("...maxPersistSyncBacklog=" + this.getMaxPersistSyncBacklog()).append("\n");
        }
        sb.append("...queryable=" + this.queryable).append("\n");
        sb.append("...replicator='" + this.getReplicator()).append("'\n");
        sb.append("...interClusterReplicator='" + this.getInterClusterReplicator()).append("'\n");
        if (this.getInterClusterReplicator() != null) {
            sb.append("...interClusterReplicationQuorum=" + this.getInterClusterReplicationQuorum()).append("\n");
            sb.append("...maxInterClusterReplicationSyncBacklog=" + this.getMaxInterClusterReplicationSyncBacklog()).append("\n");
        }
        sb.append("}").append("\n");
        if (this.getReplicator() != null) {
            try {
                sb.append(StoreReplicatorDescriptor.load(this.getReplicator()).toString());
            }
            catch (Exception e) {
                sb.append("...<failed to get store replicator configuration [" + e.toString() + "]>");
            }
        }
        if (this.getPersister() != null) {
            try {
                sb.append(StorePersisterDescriptor.load(this.getPersister()).toString());
            }
            catch (Exception e) {
                sb.append("...<failed to get store persister configuration [" + e.toString() + "]>");
            }
        }
        if (this.getInterClusterReplicator() != null) {
            try {
                sb.append(StoreInterClusterReplicatorDescriptor.load(this.getInterClusterReplicator()).toString());
            }
            catch (Exception e) {
                sb.append("...<failed to get store ICR configuration [" + e.toString() + "]>");
            }
        }
        return sb.toString();
    }
}

