/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.StoreBinding;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderODS;

public final class StoreCommitEntry {
    private final PktPacket masterSerializedObject = PktFactory.getInstance().createPacket(264);
    public IStoreObject object;
    public PktPacket serializedObject;
    public IStoreBinding.Operation operation;
    public UUID oid;
    public short ofid;
    public short otype;
    public long transactionId;
    public long stableTransactionId;
    public long checkpointVersion;
    public IStoreObject.EncodingType contentEncodingType;
    public IOElasticBuffer serializedMetadata;
    public int serializedMetadataOffset;
    public final IOElasticBuffer serializedPersisterMetadata = IOElasticBuffer.create((int)1);
    public boolean commitStart;
    public boolean commitEnd;

    private StoreCommitEntry() {
    }

    public static final StoreCommitEntry create() {
        return new StoreCommitEntry();
    }

    private final IStoreBinding.Operation toStoreOperation(PktSubheaderODS subheaderODS) {
        switch (subheaderODS.getCommitEntryType()) {
            case 1: {
                return IStoreBinding.Operation.Put;
            }
            case 2: {
                return IStoreBinding.Operation.Update;
            }
            case 3: {
                return IStoreBinding.Operation.Remove;
            }
            case 4: {
                return IStoreBinding.Operation.Send;
            }
        }
        throw new RuntimeException("unknown packet entry type");
    }

    public final StoreCommitEntry init(IStoreBinding.Operation operation, UUID oid, short ofid, short otype, long transactionId, long stableTransactionId, long checkpointVersion, IStoreObject object, IStoreObject.EncodingType contentEncodingType, boolean commitStart, boolean commitEnd) {
        this.object = object;
        this.masterSerializedObject.getBody().reset(false);
        this.serializedObject = this.masterSerializedObject;
        object.serializeTo(this.serializedObject);
        StoreBinding.prepareStorePacketHeader(object, this.serializedObject, operation, oid, ofid, otype, transactionId, stableTransactionId, checkpointVersion, contentEncodingType, commitStart, commitEnd, this.serializedPersisterMetadata);
        this.serializedObject.sync();
        this.operation = operation;
        this.oid = oid;
        this.ofid = ofid;
        this.otype = otype;
        this.transactionId = transactionId;
        this.stableTransactionId = stableTransactionId;
        this.checkpointVersion = checkpointVersion;
        this.contentEncodingType = contentEncodingType;
        this.commitStart = commitStart;
        this.commitEnd = commitEnd;
        return this;
    }

    public final StoreCommitEntry init(PktPacket serializedObject) {
        this.object = null;
        this.serializedObject = serializedObject;
        PktSubheaderODS subheaderODS = serializedObject.getHeader().getODSSubheader();
        this.operation = this.toStoreOperation(subheaderODS);
        this.oid = subheaderODS.getObjectId();
        this.ofid = subheaderODS.getObjectFactoryId();
        this.otype = subheaderODS.getObjectType();
        this.transactionId = subheaderODS.getTransactionId();
        this.stableTransactionId = subheaderODS.getStableTransactionId();
        this.checkpointVersion = subheaderODS.getCheckpointVersion();
        this.contentEncodingType = IStoreObject.EncodingType.fromMessageViewEncoding(subheaderODS.getContentEncodingType());
        this.commitStart = subheaderODS.getFlagCommitStart();
        this.commitEnd = subheaderODS.getFlagCommitEnd();
        this.serializedMetadata = subheaderODS.getBuffer();
        this.serializedMetadataOffset = subheaderODS.getObjectMetadataOffset();
        subheaderODS.copyPersisterMetadataTo(this.serializedPersisterMetadata, 0);
        return this;
    }

    public final StoreCommitEntry init(StoreCommitEntry commitEntry) {
        this.masterSerializedObject.getBody().reset(false);
        this.serializedObject = this.masterSerializedObject;
        this.serializedObject.putFrom(commitEntry.serializedObject);
        PktSubheaderODS subheaderODS = this.serializedObject.getHeader().getODSSubheader();
        this.operation = commitEntry.operation;
        this.oid = subheaderODS.getObjectId();
        this.ofid = commitEntry.ofid;
        this.otype = commitEntry.otype;
        this.transactionId = commitEntry.transactionId;
        this.stableTransactionId = commitEntry.stableTransactionId;
        this.checkpointVersion = commitEntry.checkpointVersion;
        this.contentEncodingType = commitEntry.contentEncodingType;
        this.commitStart = commitEntry.commitStart;
        this.commitEnd = commitEntry.commitEnd;
        this.serializedMetadata = subheaderODS.getBuffer();
        this.serializedMetadataOffset = subheaderODS.getObjectMetadataOffset();
        if (commitEntry.serializedPersisterMetadata.getLength() > 0) {
            this.serializedPersisterMetadata.putFrom(0, commitEntry.serializedPersisterMetadata, 0, commitEntry.serializedPersisterMetadata.getLength());
        }
        return this;
    }

    public final StoreCommitEntry commitEnd() {
        this.commitEnd = true;
        this.serializedObject.getHeader().getODSSubheader().setFlagCommitEnd(true);
        return this;
    }

    public final void fin() {
        this.object = null;
        this.serializedObject = null;
        this.serializedMetadata = null;
        this.serializedPersisterMetadata.setLength(0);
    }
}

