/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.admin.impl.direct;

import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryEntity;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.server.admin.AdminObject;
import com.neeve.server.admin.AdminSession;
import com.neeve.server.admin.AdminSessionProvider;
import com.neeve.server.admin.EAdminException;
import com.neeve.server.admin.impl.direct.AdminClientSession;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlNet;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;

public class AdminClientSessionProvider
extends AdminObject
implements AdminSessionProvider {
    final String name;

    public static final AdminSessionProvider create(String name, Properties props) throws EDiscoveryException {
        return new AdminClientSessionProvider(name, props);
    }

    private AdminClientSessionProvider(String name, Properties props) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final AdminSession create(String adminClientId, String xvmName, IDiscoveryEntity discoveredXvm, AdminSession.EventHandler eventHandler, Properties sessionProperties, Tracer tracer) throws EAdminException {
        UtlAddressDescriptor descriptor = this.getSuitableDescriptorForAdminConnect(discoveredXvm, tracer);
        if (descriptor == null) {
            throw new EAdminException("No suitable address found to connect to xvm '" + xvmName + "' on host '" + discoveredXvm.getHost() + " in discovered address: '" + discoveredXvm.getAddressDescriptors() + "]");
        }
        try {
            return AdminClientSession.create(adminClientId, xvmName, descriptor, eventHandler, sessionProperties, tracer);
        }
        catch (Throwable thrown) {
            throw new EAdminException("Error creating admin session [" + thrown.getMessage() + "]", thrown);
        }
    }

    private final boolean thisHost(IDiscoveryEntity discoveredXvm, Tracer tracer) {
        try {
            return InetAddress.getByName(discoveredXvm.getHost()).equals(UtlNet.getLocalHostInetAddress());
        }
        catch (UnknownHostException e) {
            if (tracer != null) {
                tracer.log("Failed to get IP address of XVM's host [" + e.toString() + ". Will not use loopback addresses to connect to XVM.", Tracer.Level.WARNING);
            }
            return false;
        }
    }

    private final UtlAddressDescriptor getSuitableDescriptorForAdminConnect(IDiscoveryEntity discoveredXvm, Tracer tracer) {
        List connectionDescriptors = discoveredXvm.getAddressDescriptors();
        for (UtlAddressDescriptor descriptor : connectionDescriptors) {
            String name = EmxNwLnkInetAddr.parse((String)descriptor.address).host;
            try {
                InetAddress address = InetAddress.getByName(name);
                if (!this.thisHost(discoveredXvm, tracer) && address.isLoopbackAddress()) continue;
                return descriptor;
            }
            catch (UnknownHostException e) {
                if (tracer == null) continue;
                tracer.log("Failed to get IP address for host portion of XVM listener [" + e.toString() + ". Will not use descriptor to connect to XVM.", Tracer.Level.WARNING);
            }
        }
        return null;
    }
}

