/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link.network;

import com.neeve.stats.Stats;
import java.text.NumberFormat;

final class LnkNwPeerEndpointStats
extends Stats {
    private NumberFormat format;
    private long startTime;
    private long deltaStartTime;
    private long numNetworkReadsLast;
    private long numReadsLast;
    private long numBytesReadLast;
    private long numPacketsReadLast;
    private long numPacketBatchesReadLast;
    private long numInputBufBytesAllocatedLast;
    private long numInputBufBytesCompactedLast;
    private long numInputBufAllocsLast;
    private long numInputBufGrowthsLast;
    private long numInputBufShrinksLast;
    private long numBytesEnqueuedLast;
    private long numPacketsEnqueuedLast;
    private long numOutputBufBytesAllocatedLast;
    private long numFlushesLast;
    private long numBytesFlushedLast;
    private long numFlushesSyncLast;
    private long numBytesFlushedSyncLast;
    volatile long numNetworkReads;
    volatile long numReads;
    volatile long numBytesRead;
    volatile long numPacketsRead;
    volatile long numPacketBatchesRead;
    volatile int minBatchSize;
    volatile int maxBatchSize;
    volatile int meanReadSize;
    volatile int meanPacketSize;
    volatile int inputBufSize;
    volatile long numInputBufBytesAllocated;
    volatile long numInputBufBytesCompacted;
    volatile long numInputBufAllocs;
    volatile long numInputBufGrowths;
    volatile long numInputBufShrinks;
    volatile long numBytesEnqueued;
    volatile long numPacketsEnqueued;
    volatile long numOutputBufBytesAllocated;
    volatile long numFlushes;
    volatile long numBytesFlushed;
    volatile long numFlushesSync;
    volatile int meanFlushSize;
    volatile int meanBufferSize;
    final Stats.LatencyManager r = new Stats.LatencyManager("r");
    final Stats.LatencyManager w = new Stats.LatencyManager("w");

    LnkNwPeerEndpointStats(String name, int statsInterval) {
        super("nv.link.network", name, "nv.link.network.stats", statsInterval);
        this.format = NumberFormat.getInstance();
        this.format.setMaximumFractionDigits(2);
        this.startPeriodicOutputIfConfigured();
    }

    private void stamp() {
        this.deltaStartTime = System.currentTimeMillis();
        this.numNetworkReadsLast = this.numNetworkReads;
        this.numReadsLast = this.numReads;
        this.numBytesReadLast = this.numBytesRead;
        this.numPacketsReadLast = this.numPacketsRead;
        this.numPacketBatchesReadLast = this.numPacketBatchesRead;
        this.numInputBufBytesAllocatedLast = this.numInputBufBytesAllocated;
        this.numInputBufBytesCompactedLast = this.numInputBufBytesCompacted;
        this.numInputBufAllocsLast = this.numInputBufAllocs;
        this.numInputBufGrowthsLast = this.numInputBufGrowths;
        this.numInputBufShrinksLast = this.numInputBufShrinks;
        this.numBytesEnqueuedLast = this.numBytesEnqueued;
        this.numPacketsEnqueuedLast = this.numPacketsEnqueued;
        this.numOutputBufBytesAllocatedLast = this.numOutputBufBytesAllocated;
        this.numFlushesLast = this.numFlushes;
        this.numBytesFlushedLast = this.numBytesFlushed;
        this.numFlushesSyncLast = this.numFlushesSync;
    }

    protected final void init() {
        this.startTime = System.currentTimeMillis();
        this.stamp();
    }

    public final synchronized void get(StringBuilder sb) {
        long currentTime = System.currentTimeMillis();
        long deltaTime = currentTime - this.deltaStartTime;
        long deltaTotalTime = currentTime - this.startTime;
        long numNetworkReadsCurrent = this.numNetworkReads;
        long numReadsCurrent = this.numReads;
        long numBytesReadCurrent = this.numBytesRead;
        long numPacketsReadCurrent = this.numPacketsRead;
        long numPacketBatchesReadCurrent = this.numPacketBatchesRead;
        int minBatchSizeCurrent = this.minBatchSize;
        int maxBatchSizeCurrent = this.maxBatchSize;
        int meanReadSizeCurrent = this.meanReadSize;
        int meanPacketSizeCurrent = this.meanPacketSize;
        int inputBufSizeCurrent = this.inputBufSize;
        long numInputBufBytesAllocatedCurrent = this.numInputBufBytesAllocated;
        long numInputBufBytesCompactedCurrent = this.numInputBufBytesCompacted;
        long numInputBufAllocsCurrent = this.numInputBufAllocs;
        long numInputBufGrowthsCurrent = this.numInputBufGrowths;
        long numInputBufShrinksCurrent = this.numInputBufShrinks;
        long numBytesEnqueuedCurrent = this.numBytesEnqueued;
        long numPacketsEnqueuedCurrent = this.numPacketsEnqueued;
        long numOutputBufBytesAllocatedCurrent = this.numOutputBufBytesAllocated;
        long numFlushesCurrent = this.numFlushes;
        long numBytesFlushedCurrent = this.numBytesFlushed;
        long numFlushesSyncCurrent = this.numFlushesSync;
        this.r.compute();
        this.w.compute();
        String networkReadsStr = this.format.format(numNetworkReadsCurrent);
        String deltaNetworkReadsStr = this.format.format(numNetworkReadsCurrent - this.numNetworkReadsLast);
        String networkReadRateStr = this.format.format(numNetworkReadsCurrent * 1000L / deltaTotalTime);
        String deltaNetworkReadRateStr = this.format.format((numNetworkReadsCurrent - this.numNetworkReadsLast) * 1000L / deltaTime);
        String readsStr = this.format.format(numReadsCurrent);
        String deltaReadsStr = this.format.format(numReadsCurrent - this.numReadsLast);
        String readRateStr = this.format.format(numReadsCurrent * 1000L / deltaTotalTime);
        String deltaReadRateStr = this.format.format((numReadsCurrent - this.numReadsLast) * 1000L / deltaTime);
        String bytesReadStr = this.format.format(numBytesReadCurrent);
        String deltaBytesReadStr = this.format.format(numBytesReadCurrent - this.numBytesReadLast);
        String byteReadRateStr = this.format.format(numBytesReadCurrent * 1000L / deltaTotalTime);
        String deltaByteReadRateStr = this.format.format((numBytesReadCurrent - this.numBytesReadLast) * 1000L / deltaTime);
        String packetsReadStr = this.format.format(numPacketsReadCurrent);
        String deltaPacketsReadStr = this.format.format(numPacketsReadCurrent - this.numPacketsReadLast);
        String packetReadRateStr = this.format.format(numPacketsReadCurrent * 1000L / deltaTotalTime);
        String deltaPacketReadRateStr = this.format.format((numPacketsReadCurrent - this.numPacketsReadLast) * 1000L / deltaTime);
        String packetBatchesReadStr = this.format.format(numPacketBatchesReadCurrent);
        String deltaPacketBatchesReadStr = this.format.format(numPacketBatchesReadCurrent - this.numPacketBatchesReadLast);
        String packetBatchReadRateStr = this.format.format(numPacketBatchesReadCurrent * 1000L / deltaTotalTime);
        String deltaPacketBatchReadRateStr = this.format.format((numPacketBatchesReadCurrent - this.numPacketBatchesReadLast) * 1000L / deltaTime);
        String inputBufBytesAllocatedStr = this.format.format(numInputBufBytesAllocatedCurrent);
        String deltaInputBufBytesAllocatedStr = this.format.format(numInputBufBytesAllocatedCurrent - this.numInputBufBytesAllocatedLast);
        String inputBufBytesAllocRateStr = this.format.format(numInputBufBytesAllocatedCurrent * 1000L / deltaTotalTime);
        String deltaInputBufBytesAllocRateStr = this.format.format((numInputBufBytesAllocatedCurrent - this.numInputBufBytesAllocatedLast) * 1000L / deltaTime);
        String inputBufBytesCompactedStr = this.format.format(numInputBufBytesCompactedCurrent);
        String deltaInputBufBytesCompactedStr = this.format.format(numInputBufBytesCompactedCurrent - this.numInputBufBytesCompactedLast);
        String inputBufBytesCompactRateStr = this.format.format(numInputBufBytesCompactedCurrent * 1000L / deltaTotalTime);
        String deltaInputBufBytesCompactRateStr = this.format.format((numInputBufBytesCompactedCurrent - this.numInputBufBytesCompactedLast) * 1000L / deltaTime);
        String inputBufAllocsStr = this.format.format(numInputBufAllocsCurrent);
        String deltaInputBufAllocsStr = this.format.format(numInputBufAllocsCurrent - this.numInputBufAllocsLast);
        String inputBufAllocRateStr = this.format.format(numInputBufAllocsCurrent * 1000L / deltaTotalTime);
        String deltaInputBufAllocRateStr = this.format.format((numInputBufAllocsCurrent - this.numInputBufAllocsLast) * 1000L / deltaTime);
        String inputBufGrowthsStr = this.format.format(numInputBufGrowthsCurrent);
        String deltaInputBufGrowthsStr = this.format.format(numInputBufGrowthsCurrent - this.numInputBufGrowthsLast);
        String inputBufGrowthRateStr = this.format.format(numInputBufGrowthsCurrent * 1000L / deltaTotalTime);
        String deltaInputBufGrowthRateStr = this.format.format((numInputBufGrowthsCurrent - this.numInputBufGrowthsLast) * 1000L / deltaTime);
        String inputBufShrinksStr = this.format.format(numInputBufShrinksCurrent);
        String deltaInputBufShrinksStr = this.format.format(numInputBufShrinksCurrent - this.numInputBufShrinksLast);
        String inputBufShrinkRateStr = this.format.format(numInputBufShrinksCurrent * 1000L / deltaTotalTime);
        String deltaInputBufShrinkRateStr = this.format.format((numInputBufShrinksCurrent - this.numInputBufShrinksLast) * 1000L / deltaTime);
        String bytesReadPerNetworkReadStr = numNetworkReadsCurrent > 0L ? this.format.format(numBytesReadCurrent / numNetworkReadsCurrent) : "0";
        String deltaBytesReadPerNetworkReadStr = numNetworkReadsCurrent - this.numNetworkReadsLast > 0L ? this.format.format((numBytesReadCurrent - this.numBytesReadLast) / (numNetworkReadsCurrent - this.numNetworkReadsLast)) : "0";
        String packetsReadPerNetworkReadStr = numNetworkReadsCurrent > 0L ? this.format.format(numPacketsReadCurrent / numNetworkReadsCurrent) : "0";
        String deltaPacketsReadPerNetworkReadStr = numNetworkReadsCurrent - this.numNetworkReadsLast > 0L ? this.format.format((numPacketsReadCurrent - this.numPacketsReadLast) / (numNetworkReadsCurrent - this.numNetworkReadsLast)) : "0";
        String bytesReadPerReadStr = numReadsCurrent > 0L ? this.format.format(numBytesReadCurrent / numReadsCurrent) : "0";
        String deltaBytesReadPerReadStr = numReadsCurrent - this.numReadsLast > 0L ? this.format.format((numBytesReadCurrent - this.numBytesReadLast) / (numReadsCurrent - this.numReadsLast)) : "0";
        String packetsReadPerReadStr = numReadsCurrent > 0L ? this.format.format(numPacketsReadCurrent / numReadsCurrent) : "0";
        String deltaPacketsReadPerReadStr = numReadsCurrent - this.numReadsLast > 0L ? this.format.format((numPacketsReadCurrent - this.numPacketsReadLast) / (numReadsCurrent - this.numReadsLast)) : "0";
        String packetsReadPerBatchStr = numPacketBatchesReadCurrent > 0L ? this.format.format(numPacketsReadCurrent / numPacketBatchesReadCurrent) : "0";
        String deltaPacketsReadPerBatchStr = numPacketBatchesReadCurrent - this.numPacketBatchesReadLast > 0L ? this.format.format((numPacketsReadCurrent - this.numPacketsReadLast) / (numPacketBatchesReadCurrent - this.numPacketBatchesReadLast)) : "0";
        String bytesEnqueuedStr = this.format.format(numBytesEnqueuedCurrent);
        String deltaBytesEnqueuedStr = this.format.format(numBytesEnqueuedCurrent - this.numBytesEnqueuedLast);
        String byteEnqueRateStr = this.format.format(numBytesEnqueuedCurrent * 1000L / deltaTotalTime);
        String deltaByteEnqueRateStr = this.format.format((numBytesEnqueuedCurrent - this.numBytesEnqueuedLast) * 1000L / deltaTime);
        String packetsEnqueuedStr = this.format.format(numPacketsEnqueuedCurrent);
        String deltaPacketsEnqueuedStr = this.format.format(numPacketsEnqueuedCurrent - this.numPacketsEnqueuedLast);
        String packetEnqueRateStr = this.format.format(numPacketsEnqueuedCurrent * 1000L / deltaTotalTime);
        String deltaPacketEnqueRateStr = this.format.format((numPacketsEnqueuedCurrent - this.numPacketsEnqueuedLast) * 1000L / deltaTime);
        String outputBufBytesAllocatedStr = this.format.format(numOutputBufBytesAllocatedCurrent);
        String deltaOutputBufBytesAllocatedStr = this.format.format(numOutputBufBytesAllocatedCurrent - this.numOutputBufBytesAllocatedLast);
        String outputBufBytesAllocRateStr = this.format.format(numOutputBufBytesAllocatedCurrent * 1000L / deltaTotalTime);
        String deltaOutputBufBytesAllocRateStr = this.format.format((numOutputBufBytesAllocatedCurrent - this.numOutputBufBytesAllocatedLast) * 1000L / deltaTime);
        String flushesStr = this.format.format(numFlushesCurrent);
        String deltaFlushesStr = this.format.format(numFlushesCurrent - this.numFlushesLast);
        String flushRateStr = this.format.format(numFlushesCurrent * 1000L / deltaTotalTime);
        String deltaFlushRateStr = this.format.format((numFlushesCurrent - this.numFlushesLast) * 1000L / deltaTime);
        String bytesFlushedStr = this.format.format(numBytesFlushedCurrent);
        String deltaBytesFlushedStr = this.format.format(numBytesFlushedCurrent - this.numBytesFlushedLast);
        String byteFlushRateStr = this.format.format(numBytesFlushedCurrent * 1000L / deltaTotalTime);
        String deltaByteFlushRateStr = this.format.format((numBytesFlushedCurrent - this.numBytesFlushedLast) * 1000L / deltaTime);
        String flushesSyncStr = this.format.format(numFlushesSyncCurrent);
        String deltaFlushesSyncStr = this.format.format(numFlushesSyncCurrent - this.numFlushesSyncLast);
        String flushSyncRateStr = this.format.format(numFlushesSyncCurrent * 1000L / deltaTotalTime);
        String deltaFlushSyncRateStr = this.format.format((numFlushesSyncCurrent - this.numFlushesSyncLast) * 1000L / deltaTime);
        String bytesFlushedPerFlushStr = numFlushesCurrent > 0L ? this.format.format(numBytesFlushedCurrent / numFlushesCurrent) : "0";
        String deltaBytesFlushPerFlushStr = numFlushesCurrent - this.numFlushesLast > 0L ? this.format.format((numBytesFlushedCurrent - this.numBytesFlushedLast) / (numFlushesCurrent - this.numFlushesLast)) : "0";
        String flushSyncPctStr = this.format.format(numFlushesCurrent > 0L ? numFlushesSyncCurrent * 100L / numFlushesCurrent : 0L);
        String deltaFlushSyncPctStr = this.format.format(numFlushesCurrent - this.numFlushesLast > 0L ? (numFlushesSyncCurrent - this.numFlushesSyncLast) * 100L / (numFlushesCurrent - this.numFlushesLast) : 0L);
        sb.append(" Read{");
        sb.append(networkReadsStr + "(" + networkReadRateStr + " " + deltaNetworkReadRateStr + ") ");
        sb.append(readsStr + "(" + readRateStr + " " + deltaReadRateStr + ") ");
        sb.append(bytesReadStr + "(" + byteReadRateStr + " " + deltaByteReadRateStr + ") ");
        sb.append(packetsReadStr + "(" + packetReadRateStr + " " + deltaPacketReadRateStr + ") ");
        sb.append(packetBatchesReadStr + "(" + packetBatchReadRateStr + " " + deltaPacketBatchReadRateStr + ") ");
        sb.append("(" + meanReadSizeCurrent + "," + meanPacketSizeCurrent + "," + inputBufSizeCurrent + ") ");
        sb.append(inputBufBytesAllocatedStr + "(" + inputBufBytesAllocRateStr + " " + deltaInputBufBytesAllocRateStr + ") ");
        sb.append(inputBufBytesCompactedStr + "(" + inputBufBytesCompactRateStr + " " + deltaInputBufBytesCompactRateStr + ") ");
        sb.append(inputBufAllocsStr + "(" + inputBufAllocRateStr + " " + deltaInputBufAllocRateStr + ") ");
        sb.append(inputBufGrowthsStr + "(" + inputBufGrowthRateStr + " " + deltaInputBufGrowthRateStr + ") ");
        sb.append(inputBufShrinksStr + "(" + inputBufShrinkRateStr + " " + deltaInputBufShrinkRateStr + ") ");
        sb.append(bytesReadPerNetworkReadStr + "(" + deltaBytesReadPerNetworkReadStr + ") ");
        sb.append(packetsReadPerNetworkReadStr + "(" + deltaPacketsReadPerNetworkReadStr + ") ");
        sb.append(bytesReadPerReadStr + "(" + deltaBytesReadPerReadStr + ") ");
        sb.append(packetsReadPerReadStr + "(" + deltaPacketsReadPerReadStr + ") ");
        sb.append(packetsReadPerBatchStr + "(" + deltaPacketsReadPerBatchStr + ") (" + minBatchSizeCurrent + " " + maxBatchSizeCurrent + ")");
        sb.append("}");
        sb.append(" Write{");
        sb.append(bytesEnqueuedStr + "(" + byteEnqueRateStr + " " + deltaByteEnqueRateStr + ") ");
        sb.append(packetsEnqueuedStr + "(" + packetEnqueRateStr + " " + deltaPacketEnqueRateStr + ") ");
        sb.append(outputBufBytesAllocatedStr + "(" + outputBufBytesAllocRateStr + " " + deltaOutputBufBytesAllocRateStr + ")");
        sb.append("}");
        sb.append(" Flush{");
        sb.append(flushesStr + "(" + flushRateStr + " " + deltaFlushRateStr + ") ");
        sb.append(bytesFlushedStr + "(" + byteFlushRateStr + " " + deltaByteFlushRateStr + ") ");
        sb.append(bytesFlushedPerFlushStr + "(" + deltaBytesFlushPerFlushStr + ") ");
        sb.append(flushSyncPctStr + "%(" + deltaFlushSyncPctStr + "%) ");
        sb.append(this.meanFlushSize + "(" + this.meanBufferSize + ")");
        sb.append("}");
        sb.append("\n");
        sb.append("\n[IO Latencies] {\n");
        this.r.get(sb);
        this.w.get(sb);
        sb.append("}\n");
        this.stamp();
    }
}

