/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.nio.tcp;

import com.neeve.command.Command;
import com.neeve.command.ECommandException;
import com.neeve.command.ECommandInvalidDataTypeException;
import com.neeve.command.ECommandNotSupportedException;
import com.neeve.command.ICommandHandler;
import com.neeve.config.Config;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkInetAddrFormatException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxNwLnkInetAddr;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.EmxNwLnkProps;
import com.neeve.emx.IEmxNwAcceptReadyEvent;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.nio.EmxNioNwAcceptReadyEvent;
import com.neeve.emx.nio.EmxNioNwLnkEndpoint;
import com.neeve.emx.nio.tcp.EmxNioTcpNwLnkPeerEndpoint;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlNet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.HashMap;

public final class EmxNioTcpNwLnkServerEndpoint
extends EmxNioNwLnkEndpoint
implements IEmxNwLnkServerEndpoint,
ICommandHandler {
    private final EmxNioNwLnkEndpoint.StringProperty localIfAddr = new EmxNioNwLnkEndpoint.StringProperty(EmxNwLnkProps.Socket.localifaddr.toString(), "0.0.0.0");
    private final EmxNioNwLnkEndpoint.IntProperty localPort = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.localport.toString(), 0);
    private final EmxNioNwLnkEndpoint.IntProperty recvBufferSize = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.recvbuffersize.toString(), Short.MAX_VALUE);
    private final EmxNioNwLnkEndpoint.IntProperty backlog = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.backlog.toString(), 0);
    private final UtlAddressDescriptor descriptor;
    private ServerSocketChannel ssc;
    private EmxNioNwAcceptReadyEvent arevent;
    private boolean closed;

    private EmxNioTcpNwLnkServerEndpoint(UtlAddressDescriptor descriptor) throws EEmxException {
        EmxNwLnkInetAddr inetAddr;
        Config.setTraceLevel((Tracer)this.tracer, (String)"nv.emx.nio.tcp.trace");
        this.descriptor = descriptor;
        try {
            inetAddr = EmxNwLnkInetAddr.parse(this.descriptor.address);
        }
        catch (IllegalArgumentException e) {
            throw new EEmxNwLnkInetAddrFormatException(this.descriptor.address);
        }
        this.descriptor.props.put(EmxNwLnkProps.Socket.localifaddr.toString(), inetAddr.host);
        this.descriptor.props.put(EmxNwLnkProps.Socket.localport.toString(), String.valueOf(inetAddr.port));
        this.localIfAddr.init(this.descriptor.props).save(this.descriptor.props);
        this.localPort.init(this.descriptor.props).save(this.descriptor.props);
        this.recvBufferSize.init(this.descriptor.props).save(this.descriptor.props);
        this.backlog.init(this.descriptor.props).save(this.descriptor.props);
        this.init(descriptor);
    }

    public static IEmxNwLnkServerEndpoint create(UtlAddressDescriptor descriptor) throws EEmxException {
        return new EmxNioTcpNwLnkServerEndpoint(descriptor);
    }

    private final void init(UtlAddressDescriptor descriptor) throws EEmxException {
        try {
            this.ssc = ServerSocketChannel.open();
        }
        catch (Exception e) {
            this.tracer.log("Failure in creating the TCP network link server endpoint socket channel [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        try {
            this.ssc.socket().bind(new InetSocketAddress(this.localIfAddr.value(), this.localPort.value()), this.backlog.value());
        }
        catch (Exception e) {
            try {
                this.ssc.socket().close();
            }
            catch (Exception e2) {
                this.tracer.log("Failure to close server socket after bind failure: " + e2.getMessage(), Tracer.Level.WARNING);
            }
            this.tracer.log("Failure in binding the TCP network link server endpoint socket to " + this.localIfAddr.value() + ":" + this.localPort.value() + " [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        EmxNioNwLnkEndpoint.StringProperty localIfAddrBound = new EmxNioNwLnkEndpoint.StringProperty(EmxNwLnkProps.Socket.localifaddrbound.toString(), this.ssc.socket().getInetAddress().getHostAddress());
        EmxNioNwLnkEndpoint.IntProperty localPortBound = new EmxNioNwLnkEndpoint.IntProperty(EmxNwLnkProps.Socket.localportbound.toString(), this.ssc.socket().getLocalPort());
        localIfAddrBound.init(null).save(this.descriptor.props);
        localPortBound.init(null).save(this.descriptor.props);
        try {
            this.ssc.configureBlocking(false);
        }
        catch (Exception e) {
            this.tracer.log("Failure in configuring the TCP network link server endpoint socket to non-blocking [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        this.tracer.log("TCP Network Link Server Endpoint Configuration...", Tracer.Level.CONFIG);
        try {
            this.tracer.log("....localaddr = " + this.localIfAddr.value() + ":" + this.localPort.value() + " {actual = " + localIfAddrBound.value() + ":" + localPortBound.value() + "}", Tracer.Level.CONFIG);
            if (this.recvBufferSize.value() > 0) {
                this.ssc.socket().setReceiveBufferSize(this.recvBufferSize.value());
            }
            this.tracer.log("....socket recv buffer size = " + this.recvBufferSize.value() + " {actual = " + this.ssc.socket().getReceiveBufferSize() + "}", Tracer.Level.CONFIG);
        }
        catch (Exception e) {
            this.tracer.log("Failure in configuring a TCP network link server endpoint socket property [" + e.toString() + "]", Tracer.Level.WARNING);
            throw new EEmxException(e);
        }
        if (this.ssc.socket().getInetAddress().isAnyLocalAddress()) {
            try {
                descriptor.setConnectorDescriptor(UtlAddressDescriptor.parse((String)("tcp://" + UtlNet.getLocalHostAddress() + ":" + localPortBound.value()), null));
            }
            catch (UnknownHostException e) {
                this.tracer.log("Failure in obtaining an IP address to connect to the local host [" + e.toString() + "]. Connector descriptor cannot be prepared.", Tracer.Level.WARNING);
            }
        } else {
            descriptor.setConnectorDescriptor(UtlAddressDescriptor.parse((String)("tcp://" + localIfAddrBound.value() + ":" + localPortBound.value()), null));
        }
        this.arevent = new EmxNioNwAcceptReadyEvent(this.ssc);
        this.closed = false;
    }

    private final void onGetpropsCommand(HashMap<String, Object> props) throws SocketException {
        this.getSocketNTcpProps(this.ssc, props);
        props.put(EmxNwLnkProps.Socket.backlog.toString(), new Integer(this.backlog.value()));
    }

    private final void configureBlockingInternal(boolean blocking) throws IOException {
        this.ssc.configureBlocking(blocking);
    }

    private final boolean isBlockingInternal() {
        return this.ssc.isBlocking();
    }

    private final IEmxNwLnkPeerEndpoint acceptInternal(EmxNwLnkOpWaitCond waitCond) throws EEmxNwLnkOpFailedException {
        if (waitCond != null) {
            waitCond.reset();
            if (!this.isBlockingInternal()) {
                waitCond.add(this.arevent);
            }
        }
        if (this.tracer.fine) {
            this.tracer.log("Accepting through TCP network link server endpoint " + this.localIfAddr.value() + ":" + this.localPort.value() + "...", Tracer.Level.FINE);
        }
        try {
            SocketChannel sc = this.ssc.accept();
            if (sc != null) {
                if (this.tracer.fine) {
                    this.tracer.log("Accepted successfully completed.", Tracer.Level.FINE);
                }
                return new EmxNioTcpNwLnkPeerEndpoint(null, sc, this.descriptor);
            }
            if (this.tracer.fine) {
                this.tracer.log("Accept pending completion.", Tracer.Level.FINE);
            }
            return null;
        }
        catch (Exception e) {
            if (this.tracer.fine) {
                this.tracer.log("Accept failed [" + e.toString() + "]", Tracer.Level.FINE);
            }
            throw new EEmxNwLnkOpFailedException(e);
        }
    }

    private final void closeInternal() throws IOException {
        if (this.ssc != null) {
            this.ssc.socket().close();
        }
    }

    @Override
    public final void configureBlocking(boolean blocking) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            try {
                this.configureBlockingInternal(blocking);
            }
            catch (Exception e) {
                this.tracer.log("Failure in configuring the TCP network link server endpoint socket to " + (blocking ? "blocking" : "non-blocking") + " [" + e.toString() + "]", Tracer.Level.WARNING);
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new EEmxNwLnkOpFailedException(e);
            }
        } else {
            throw new EEmxInvalidStateException("network link client endpoint configure blocking", "closed");
        }
    }

    @Override
    public final boolean isBlocking() throws EEmxInvalidStateException {
        if (!this.closed) {
            return this.isBlockingInternal();
        }
        throw new EEmxInvalidStateException("network link server endpoint configure blocking", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint accept(EmxNwLnkOpWaitCond waitCond) throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            return this.acceptInternal(waitCond);
        }
        throw new EEmxInvalidStateException("network link server endpoint accept", "closed");
    }

    @Override
    public final IEmxNwLnkPeerEndpoint accept() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        return this.accept(null);
    }

    @Override
    public final IEmxNwAcceptReadyEvent getAcceptReadyEvent() {
        return this.arevent;
    }

    @Override
    public final void close() throws EEmxInvalidStateException, EEmxNwLnkOpFailedException {
        if (!this.closed) {
            this.tracer.log("Closing TCP network link server endpoint...", Tracer.Level.FINE);
            try {
                this.closeInternal();
            }
            catch (IOException e) {
                this.tracer.log("Failure in closing server socket during close of TCP network link server endpoint [" + e.toString() + "].", Tracer.Level.WARNING);
            }
            finally {
                this.closed = true;
            }
        }
    }

    public final Object procCommand(String command, Object data) throws ECommandException {
        try {
            switch (Command.valueOf((String)command)) {
                case getprops: {
                    try {
                        HashMap props = (HashMap)data;
                        if (props != null) {
                            this.onGetpropsCommand(props);
                            return props;
                        }
                        throw new ECommandInvalidDataTypeException(command, "java.util.HashMap<String, Object>", "null");
                    }
                    catch (ClassCastException e) {
                        throw new ECommandInvalidDataTypeException(command, "java.util.HashMap<String, Object>", data.getClass().getName());
                    }
                }
            }
            throw new ECommandNotSupportedException(command.toString());
        }
        catch (Exception e) {
            throw new ECommandException((Throwable)e);
        }
    }
}

