/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.equinix;

import com.neeve.cloud.equinix.EquinixRequestType;
import com.neeve.cloud.equinix.messages.MessageFactory;
import com.neeve.trace.Tracer;
import java.io.IOException;

class EquinixResponseDtoFactory {
    EquinixResponseDtoFactory() {
    }

    static final <T> T toSuccessResponseDto(EquinixRequestType requestType, String responseJson, Tracer tracer) throws IOException {
        if (tracer != null && tracer.debug) {
            tracer.log("<-- ResponseDTO [" + (Object)((Object)requestType) + "] (" + responseJson + ")", Tracer.Level.DEBUG);
        }
        responseJson = responseJson == null || responseJson.length() == 0 ? "{}" : responseJson;
        switch (requestType) {
            case GetNetworks: {
                return (T)MessageFactory.createGetNetworksResponseMessageFromJson(responseJson);
            }
            case CreateNetwork: {
                return (T)MessageFactory.createCreateNetworkResponseMessageFromJson(responseJson);
            }
            case DeleteNetwork: {
                return (T)MessageFactory.createDeleteNetworkResponseMessageFromJson(responseJson);
            }
        }
        throw new IllegalArgumentException("Unsupported request type '" + (Object)((Object)requestType) + "'");
    }
}

