/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.equinix;

import com.neeve.cloud.equinix.EquinixHttpClient;
import com.neeve.cloud.equinix.EquinixRequestType;
import com.neeve.cloud.equinix.messages.CreateNetworkRequestMessage;
import com.neeve.cloud.equinix.messages.CreateNetworkResponseMessage;
import com.neeve.cloud.equinix.messages.DeleteNetworkResponseMessage;
import com.neeve.cloud.equinix.messages.GetNetworksRequestMessage;
import com.neeve.cloud.equinix.messages.GetNetworksResponseMessage;
import com.neeve.cloud.util.HttpClient;
import com.neeve.trace.Tracer;

final class EquinixClient
extends EquinixHttpClient {
    private final String GET_NETWORKS_URL;
    private final String CREATE_NETWORK_URL;
    private final String DELETE_NETWORK_URL;

    EquinixClient() {
        this.GET_NETWORKS_URL = this.EQUINIX_BASE_URL + "/projects/%s/virtual-networks";
        this.CREATE_NETWORK_URL = this.EQUINIX_BASE_URL + "/projects/%s/virtual-networks";
        this.DELETE_NETWORK_URL = this.EQUINIX_BASE_URL + "/virtual-networks/%s";
    }

    final GetNetworksResponseMessage getNetworks(String apiKey, String projectId, GetNetworksRequestMessage request, Tracer tracer) {
        return (GetNetworksResponseMessage)this.executeRequest(String.format(this.GET_NETWORKS_URL, projectId), EquinixRequestType.GetNetworks, HttpClient.HttpMethod.GET, request, apiKey, tracer);
    }

    final CreateNetworkResponseMessage createNetwork(String apiKey, String projectId, CreateNetworkRequestMessage request, Tracer tracer) {
        return (CreateNetworkResponseMessage)this.executeRequest(String.format(this.CREATE_NETWORK_URL, projectId), EquinixRequestType.CreateNetwork, HttpClient.HttpMethod.POST, request, apiKey, tracer);
    }

    final DeleteNetworkResponseMessage deleteNetwork(String apiKey, String id, Tracer tracer) {
        return (DeleteNetworkResponseMessage)this.executeRequest(String.format(this.DELETE_NETWORK_URL, id), EquinixRequestType.DeleteNetwork, HttpClient.HttpMethod.DELETE, null, apiKey, tracer);
    }
}

