/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.civo;

import com.neeve.cloud.civo.CivoException;
import com.neeve.cloud.civo.CivoRequestException;
import com.neeve.cloud.civo.CivoRequestParameterFactory;
import com.neeve.cloud.civo.CivoRequestType;
import com.neeve.cloud.civo.CivoResponseDtoFactory;
import com.neeve.cloud.util.HttpClient;
import com.neeve.trace.Tracer;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.Response;

class CivoHttpClient
extends HttpClient {
    final String CIVO_BASE_URL;

    CivoHttpClient() {
        this.CIVO_BASE_URL = "https://api.civo.com/v2";
    }

    private final HttpUrl.Builder buildUrl(String url, Map<String, String> queryParams) {
        HttpUrl.Builder urlBuilder = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        queryParams.forEach((arg_0, arg_1) -> ((HttpUrl.Builder)urlBuilder).addQueryParameter(arg_0, arg_1));
        return urlBuilder;
    }

    private final Map<String, String> buildHeaders(Map<String, String> additionalHeaders, String apiKey, Tracer tracer) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/json");
        headers.put("Authorization", "bearer " + apiKey);
        headers.putAll(additionalHeaders);
        return headers;
    }

    private final <R> RequestBody createRequestBody(CivoRequestType requestType, R requestBody, Tracer tracer) throws IOException {
        if (requestBody instanceof Map) {
            Map requestBodyAsMap = (Map)requestBody;
            StringBuilder urlEncodedBodyBuilder = new StringBuilder();
            Iterator iterator = requestBodyAsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                urlEncodedBodyBuilder.append((String)entry.getKey()).append("=").append(URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.toString()));
                if (!iterator.hasNext()) continue;
                urlEncodedBodyBuilder.append("&");
            }
            String urlEncodedBody = urlEncodedBodyBuilder.toString();
            if (tracer.debug) {
                tracer.log("--> RequestDTO [" + (Object)((Object)requestType) + "] (" + urlEncodedBody + ")", Tracer.Level.DEBUG);
            }
            return RequestBody.create((String)urlEncodedBody, (MediaType)MEDIATYPE_URLENCODED);
        }
        String jsonEncodedBody = this.mapper.writeValueAsString(requestBody);
        if (tracer.debug) {
            tracer.log("--> RequestDTO [" + (Object)((Object)requestType) + "] " + jsonEncodedBody, Tracer.Level.DEBUG);
        }
        return RequestBody.create((String)jsonEncodedBody, (MediaType)MEDIATYPE_JSON);
    }

    private final <R> Response executeHttpRequest(HttpUrl.Builder urlBuilder, Map<String, String> headers, HttpClient.HttpMethod method, CivoRequestType requestType, R requestBody, Tracer tracer) throws IOException {
        switch (method) {
            case GET: {
                return this.get(urlBuilder.build().toString(), headers, tracer);
            }
            case PUT: {
                return this.put(urlBuilder.build().toString(), headers, tracer);
            }
            case POST: {
                return this.post(urlBuilder.build().toString(), headers, this.createRequestBody(requestType, requestBody, tracer), tracer);
            }
            case DELETE: {
                return this.delete(urlBuilder.build().toString(), headers, tracer);
            }
        }
        throw new IllegalArgumentException("Unsupported HTTP method: " + (Object)((Object)method));
    }

    final <T, R> T executeRequest(String url, CivoRequestType requestType, HttpClient.HttpMethod method, R requestBody, String apiKey, Tracer tracer) throws CivoException {
        try {
            HttpUrl.Builder urlBuilder = this.buildUrl(url, CivoRequestParameterFactory.createQueryParams(requestType, requestBody));
            Map<String, String> headers = this.buildHeaders(CivoRequestParameterFactory.createHeaders(requestType, requestBody), apiKey, tracer);
            Response response = this.executeHttpRequest(urlBuilder, headers, method, requestType, requestBody, tracer);
            String responseBody = response.body().string();
            if (response.isSuccessful()) {
                return CivoResponseDtoFactory.toSuccessResponseDto(requestType, responseBody, tracer);
            }
            throw new CivoRequestException(requestType, response.code(), responseBody);
        }
        catch (Exception e) {
            throw new CivoException(e);
        }
    }
}

