/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.io.IOBuffer;
import com.neeve.lang.XString;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.sma.CopyableMessageView;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelKeyResolver;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewImpl;
import com.neeve.sma.SmaException;
import com.neeve.util.UtlPool;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class PacketMessage
extends MessageViewImpl
implements UtlPool.Item<PacketMessage>,
CopyableMessageView<PacketMessage> {
    private static final UtlPool<PacketMessage> POOL = UtlPool.create((String)"sma_pktmessage", (String)"default", (UtlPool.Factory)new Factory(), (UtlPool.Params)UtlPool.Params.create().setThreaded(true));
    private String messageBus;
    private String messageChannel;
    private XString messageKeyBuffer;
    private int messageSender;
    private int messageFlow;
    private long messageSno;
    private String requestorId;
    private long requestId;
    private boolean isPossibleDuplicate;
    private long originTs;
    private long createTs;
    private long appSendBeginTs = 0L;
    private long appSendDoneTs = 0L;
    private long sendTs;
    private long sendStartTs;
    private long outTs;
    private long preSerializeTs;
    private long postSerializeTs;
    private long preWireTs;
    private long postWireSendTs;
    private long postWireTs;
    private long preDeserializeTs;
    private long postDeserializeTs;
    private long enqueueTs;
    private long receiveTs;
    private long preProcessingTs;
    private long postProcessingTs;
    private UtlPool<PacketMessage> pool;
    private MessageTransportHeaders transportHeaders;

    private PacketMessage() {
        super((short)1, (short)0);
    }

    public static final PacketMessage create() {
        PacketMessage view = (PacketMessage)POOL.get(null);
        view.undispose();
        return view;
    }

    private final void checkAndDisposeExistingPacket() {
        PktPacket packet = (PktPacket)this.getMessage();
        if (packet != null) {
            packet.dispose();
            this.setMessage(1, null);
        }
    }

    final XString messageKeyBuffer(short initialLength) {
        if (this.messageKeyBuffer == null) {
            this.messageKeyBuffer = XString.create((short)initialLength);
        } else {
            this.messageKeyBuffer.ensureCapacity(initialLength);
        }
        return this.messageKeyBuffer;
    }

    @Override
    protected final void undispose() {
        super.undispose();
        this.setMessage(1, null);
    }

    @Override
    public final MessageView setMessageBus(String name) {
        this.messageBus = name;
        return this;
    }

    @Override
    public final String getMessageBus() {
        return this.messageBus;
    }

    @Override
    public final MessageView setMessageBusAsRaw(XString bus) {
        this.messageBus = bus != null ? bus.getValue() : null;
        return this;
    }

    @Override
    public final XString getMessageBusAsRaw() {
        if (this.messageBus == null) {
            return null;
        }
        return XString.create((String)this.messageBus);
    }

    @Override
    public final MessageView setMessageChannel(String name) {
        this.messageChannel = name;
        return this;
    }

    @Override
    public final String getMessageChannel() {
        return this.messageChannel;
    }

    @Override
    public final MessageView setMessageChannelAsRaw(XString channel) {
        this.messageChannel = channel != null ? channel.getValue() : null;
        return this;
    }

    @Override
    public final XString getMessageChannelAsRaw() {
        if (this.messageChannel == null) {
            return null;
        }
        return XString.create((String)this.messageChannel);
    }

    @Override
    public final MessageView setMessageKey(String key) {
        this.messageKeyBuffer((short)(key.length() + 1)).setValue(key);
        return this;
    }

    @Override
    public final String getMessageKey() {
        return this.messageKeyBuffer != null && this.messageKeyBuffer.hasValue() ? this.messageKeyBuffer.getValue() : null;
    }

    @Override
    public final MessageView setMessageKeyAsRaw(XString key) {
        if (key == null || key.isNull()) {
            if (this.messageKeyBuffer != null) {
                this.messageKeyBuffer.clear(false);
            }
        } else {
            short requiredCapacity = (short)(key.length() + 1);
            if (key == this.messageKeyBuffer) {
                key.ensureCapacity(requiredCapacity);
            } else {
                this.messageKeyBuffer(requiredCapacity).setValue(key);
            }
        }
        return this;
    }

    @Override
    public final XString getMessageKeyAsRaw() {
        return this.messageKeyBuffer;
    }

    @Override
    public final void resolveMessageKeyWith(MessageChannelKeyResolver channelKeyResolver, MessageChannel.RawKeyResolutionTable rawKeyResolutionTable) throws SmaException {
        XString keyBuffer = this.messageKeyBuffer((short)64);
        if (rawKeyResolutionTable != null || channelKeyResolver.getKeyResolutionTable() == null) {
            keyBuffer.clear(false);
            channelKeyResolver.resolveMessageKey(keyBuffer, this, rawKeyResolutionTable);
        } else {
            String strKey = channelKeyResolver.resolveMessageKey(this, null);
            if (strKey != null) {
                keyBuffer.setValue(strKey);
            }
        }
        this.setMessageKeyAsRaw(keyBuffer);
    }

    @Override
    public final void resolveMessageKeyWith(MessageChannelKeyResolver channelKeyResolver, Properties keyResolutionTable) throws SmaException {
        XString keyBuffer = this.messageKeyBuffer((short)64);
        if (keyResolutionTable == null && channelKeyResolver.getKeyResolutionTable() == null) {
            channelKeyResolver.resolveMessageKey(keyBuffer, this, null);
        } else {
            String strKey = channelKeyResolver.resolveMessageKey(this, keyResolutionTable);
            if (strKey != null) {
                keyBuffer.setValue(strKey);
            }
        }
        this.setMessageKeyAsRaw(keyBuffer);
    }

    @Override
    public final MessageView setMessageSender(int sender) {
        this.messageSender = sender;
        return this;
    }

    @Override
    public final int getMessageSender() {
        return this.messageSender;
    }

    @Override
    public final MessageView setMessageFlow(int flow) {
        this.messageFlow = flow;
        return this;
    }

    @Override
    public final int getMessageFlow() {
        return this.messageFlow;
    }

    @Override
    public final MessageView setMessageSequenceNumber(long sno) {
        this.messageSno = sno;
        return this;
    }

    @Override
    public final long getMessageSequenceNumber() {
        return this.messageSno;
    }

    @Override
    public final MessageView setRequestorId(String val) {
        this.requestorId = val;
        return this;
    }

    @Override
    public final String getRequestorId() {
        return this.requestorId;
    }

    @Override
    public final MessageView setRequestorIdAsRaw(XString val) {
        this.requestorId = val != null ? val.getValue() : null;
        return this;
    }

    @Override
    public final XString getRequestorIdAsRaw() {
        if (this.requestorId == null) {
            return null;
        }
        return XString.create((String)this.requestorId);
    }

    @Override
    public final MessageView setRequestId(long val) {
        this.requestId = val;
        return this;
    }

    @Override
    public final long getRequestId() {
        return this.requestId;
    }

    @Override
    public final MessageView setPossibleDuplicate() {
        this.isPossibleDuplicate = true;
        return this;
    }

    @Override
    public final boolean isPossibleDuplicate() {
        return this.isPossibleDuplicate;
    }

    @Override
    public final MessageTransportHeaders activateMessageTransportHeaders() {
        return this.transportHeaders;
    }

    @Override
    public final MessageTransportHeaders getMessageTransportHeaders() {
        return this.transportHeaders;
    }

    @Override
    public final MessageView setMessageTransportHeaders(MessageTransportHeaders val) {
        if (val != this.transportHeaders) {
            if (this.transportHeaders != null) {
                this.transportHeaders.dispose();
            }
            this.transportHeaders = val.copy();
        }
        return this;
    }

    @Override
    public final MessageView setOriginTs(long ts) {
        this.originTs = ts;
        return this;
    }

    @Override
    public final long getOriginTs() {
        return this.originTs;
    }

    @Override
    public final MessageView setCreateTs(long ts) {
        this.createTs = ts;
        return this;
    }

    @Override
    public final long getCreateTs() {
        return this.createTs;
    }

    @Override
    public final MessageView setAppSendBeginTs(long ts) {
        this.appSendBeginTs = ts;
        return this;
    }

    @Override
    public final long getAppSendBeginTs() {
        return this.appSendBeginTs;
    }

    @Override
    public final MessageView setAppSendDoneTs(long ts) {
        this.appSendDoneTs = ts;
        return this;
    }

    @Override
    public final long getAppSendDoneTs() {
        return this.appSendDoneTs;
    }

    @Override
    public final MessageView setSendTs(long ts) {
        this.sendTs = ts;
        return this;
    }

    @Override
    public final long getSendTs() {
        return this.sendTs;
    }

    @Override
    public final MessageView setSendStartTs(long ts) {
        this.sendStartTs = ts;
        return this;
    }

    @Override
    public final long getSendStartTs() {
        return this.sendStartTs;
    }

    @Override
    @Deprecated
    public final MessageView setOutTs(long ts) {
        this.outTs = ts * 1000L;
        return this;
    }

    @Override
    public final long getOutTs() {
        return this.outTs / 1000L;
    }

    @Override
    public final MessageView setOutTsMicros(long ts) {
        this.outTs = ts;
        return this;
    }

    @Override
    public final long getOutTsMicros() {
        return this.outTs;
    }

    @Override
    public final MessageView setPreSerializeTs(long ts) {
        this.preSerializeTs = ts;
        return this;
    }

    @Override
    public final long getPreSerializeTs() {
        return this.preSerializeTs;
    }

    @Override
    public final MessageView setPostSerializeTs(long ts) {
        this.postSerializeTs = ts;
        return this;
    }

    @Override
    public final long getPostSerializeTs() {
        return this.postSerializeTs;
    }

    @Override
    public final MessageView setPreWireTs(long ts) {
        this.preWireTs = ts;
        return this;
    }

    @Override
    public final long getPreWireTs() {
        return this.preWireTs;
    }

    @Override
    public final PacketMessage setPostWireSendTs(long ts) {
        this.postWireSendTs = ts;
        return this;
    }

    @Override
    public final long getPostWireSendTs() {
        return this.postWireSendTs;
    }

    @Override
    public final MessageView setPostWireTs(long ts) {
        this.postWireTs = ts;
        return this;
    }

    @Override
    public final long getPostWireTs() {
        return this.postWireTs;
    }

    @Override
    public final MessageView setPreDeserializeTs(long ts) {
        this.preDeserializeTs = ts;
        return this;
    }

    @Override
    public final long getPreDeserializeTs() {
        return this.preDeserializeTs;
    }

    @Override
    public final MessageView setPostDeserializeTs(long ts) {
        this.postDeserializeTs = ts;
        return this;
    }

    @Override
    public final long getPostDeserializeTs() {
        return this.postDeserializeTs;
    }

    @Override
    public long getEnqueueTs() {
        return this.enqueueTs / 1000L;
    }

    @Override
    public MessageView setEnqueueTsMicros(long ts) {
        this.enqueueTs = ts;
        return this;
    }

    @Override
    public long getEnqueueTsMicros() {
        return this.enqueueTs;
    }

    @Override
    public final MessageView setReceiveTs(long ts) {
        this.receiveTs = ts;
        return this;
    }

    @Override
    public final long getReceiveTs() {
        return this.receiveTs;
    }

    @Override
    @Deprecated
    public final MessageView setPreProcessingTs(long ts) {
        this.preProcessingTs = ts * 1000L;
        return this;
    }

    @Override
    public final long getPreProcessingTs() {
        return this.preProcessingTs / 1000L;
    }

    @Override
    public final MessageView setPreProcessingTsMicros(long ts) {
        this.preProcessingTs = ts;
        return this;
    }

    @Override
    public final long getPreProcessingTsMicros() {
        return this.preProcessingTs;
    }

    @Override
    @Deprecated
    public final MessageView setPostProcessingTs(long ts) {
        this.postProcessingTs = ts * 1000L;
        return this;
    }

    @Override
    @Deprecated
    public final long getPostProcessingTs() {
        return this.postProcessingTs / 1000L;
    }

    @Override
    public final MessageView setPostProcessingTsMicros(long ts) {
        this.postProcessingTs = ts;
        return this;
    }

    @Override
    public final long getPostProcessingTsMicros() {
        return this.postProcessingTs;
    }

    @Override
    public final void sync() {
        if (this.getMessage() == null) {
            this.setMessage(1, PktFactory.getInstance().createPacket(256));
        }
    }

    @Override
    public final byte[] serializeToByteArray() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        byte[] bytes = new byte[packet.getSerializedLength()];
        packet.serialize(bytes, 0);
        return bytes;
    }

    @Override
    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        ByteBuffer buffer = IOBuffer.allocateByteBuffer((int)packet.getSerializedLength(), (boolean)true);
        packet.serialize(buffer);
        return buffer;
    }

    @Override
    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        IOBuffer ioBuffer = IOBuffer.create((int)packet.getSerializedLength());
        packet.serialize(ioBuffer, 0);
        return ioBuffer;
    }

    @Override
    public final PacketMessage copy() {
        IOBuffer buffer = this.serializeToIOBuffer(true);
        PacketMessage copy = PacketMessage.create();
        copy.deserializeFrom(buffer, 0, ((PktPacket)this.getMessage()).getSerializedLength());
        buffer.dispose();
        this.copyCopyableFieldsToCopy(copy);
        return copy;
    }

    @Override
    public final PktPacket serializeToPacket() {
        this.sync();
        PktPacket packet = (PktPacket)this.getMessage();
        packet.acquire();
        return packet;
    }

    @Override
    public final String serializeToJson() {
        return "{}";
    }

    @Override
    public final PacketMessage deserializeFromByteArray(byte[] array) {
        return this.deserializeFromByteBuffer(IOBuffer.wrapByteBuffer((byte[])array));
    }

    @Override
    public final PacketMessage deserializeFromByteBuffer(ByteBuffer buffer) {
        try {
            this.checkAndDisposeExistingPacket();
            this.setMessage(1, PktFactory.getInstance().createPacket(buffer, buffer.position(), buffer.remaining()));
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final PacketMessage deserializeFrom(IOBuffer buffer, int offset, int len) {
        try {
            this.checkAndDisposeExistingPacket();
            this.setMessage(1, PktFactory.getInstance().createPacket(buffer, offset, len, false));
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final PacketMessage deserializeFrom(long addr, int offset, int len) {
        try {
            this.checkAndDisposeExistingPacket();
            this.setMessage(1, PktFactory.getInstance().createPacket(addr, offset, len));
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final PacketMessage deserializeFromPacket(PktPacket packet) {
        if (this.getMessage() == packet) {
            return this;
        }
        this.checkAndDisposeExistingPacket();
        this.setMessage(1, packet);
        return this;
    }

    @Override
    public final PacketMessage deserializeFromJson(String json) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.checkAndDisposeExistingPacket();
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }
        return count;
    }

    public final PacketMessage init() {
        this.setMessage(1, null);
        this.messageBus = null;
        this.messageChannel = null;
        if (this.messageKeyBuffer != null) {
            this.messageKeyBuffer.clear(false);
        }
        this.messageSender = 0;
        this.messageFlow = 0;
        this.messageSno = 0L;
        this.isPossibleDuplicate = false;
        this.originTs = 0L;
        this.createTs = 0L;
        this.appSendBeginTs = 0L;
        this.appSendDoneTs = 0L;
        this.sendTs = 0L;
        this.sendStartTs = 0L;
        this.outTs = 0L;
        this.preSerializeTs = 0L;
        this.postSerializeTs = 0L;
        this.preWireTs = 0L;
        this.postWireTs = 0L;
        this.preDeserializeTs = 0L;
        this.postDeserializeTs = 0L;
        this.receiveTs = 0L;
        this.preProcessingTs = 0L;
        this.enqueueTs = 0L;
        this.postProcessingTs = 0L;
        if (this.transportHeaders != null) {
            this.transportHeaders.dispose();
            this.transportHeaders = null;
        }
        return this;
    }

    public final PacketMessage setPool(UtlPool<PacketMessage> pool) {
        this.pool = pool;
        return this;
    }

    public final UtlPool<PacketMessage> getPool() {
        return this.pool;
    }

    private static final class Factory
    implements UtlPool.Factory<PacketMessage> {
        private Factory() {
        }

        public PacketMessage createItem(Object object) {
            PacketMessage view = new PacketMessage();
            view.ownershipCount.set(0);
            return view;
        }

        public PacketMessage[] createItemArray(int size) {
            return new PacketMessage[size];
        }
    }
}

