/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm.plugin;

import com.neeve.adm.plugin.AdmBuildPlugin;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class AdmBuildPluginAdapter
implements AdmBuildPlugin {
    private final HashMap<String, Method> pluginMethods = new HashMap();
    private final Object pluginDelegate;

    AdmBuildPluginAdapter(Object plugin) throws Exception {
        this.pluginDelegate = plugin;
        System.out.println("Initializing plugin adapter for " + plugin.getClass() + " methods: " + Arrays.asList(plugin.getClass().getMethods()));
        for (Method m : AdmBuildPlugin.class.getMethods()) {
            this.pluginMethods.put(m.getName(), plugin.getClass().getMethod(m.getName(), m.getParameterTypes()));
        }
    }

    private <T> T invokePluginMethod(String name, Object ... args) throws Exception {
        try {
            return (T)this.pluginMethods.get(name).invoke(this.pluginDelegate, args);
        }
        catch (InvocationTargetException e) {
            Throwable target = e.getTargetException();
            if (target instanceof Exception) {
                throw (Exception)target;
            }
            throw e;
        }
    }

    @Override
    public Set<String> getSupportedMethods() throws Exception {
        return (Set)this.invokePluginMethod("getSupportedMethods", new Object[0]);
    }

    @Override
    public Map<String, Map<String, Object>> getSupportedParameters(String name) throws Exception {
        return (Map)this.invokePluginMethod("getSupportedParameters", name);
    }

    @Override
    public Map<String, Object> invokeMethod(String name, Map<String, Object> namedArgs) throws Exception {
        return (Map)this.invokePluginMethod("invokeMethod", name, namedArgs);
    }
}

