/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.asm;

import com.neeve.adm.AdmFactory;
import com.neeve.adm.AdmGenerator;
import com.neeve.adm.AdmMessage;
import com.neeve.adm.AdmModel;
import com.neeve.asm.AsmDocumentation;
import com.neeve.asm.AsmModelElement;
import com.neeve.asm.AsmOperation;
import com.neeve.asm.EAsmException;
import com.neeve.trace.Tracer;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public final class AsmModel
extends AsmModelElement {
    private final String name;
    private final String namespace;
    private final AdmModel messagesModel;
    private final Set<AsmOperation> operations;
    private AsmDocumentation documentation;

    public AsmModel(String name, String namespace, AdmModel messagesModel) {
        if (namespace == null) {
            throw new IllegalArgumentException("model namespace cannot be null");
        }
        if (messagesModel == null) {
            throw new IllegalArgumentException("message model cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + namespace + "': Creating model (name='" + name + "', namespace='" + namespace + "'...", Tracer.Level.DEBUG);
        }
        this.name = name;
        this.namespace = namespace;
        this.messagesModel = messagesModel;
        this.operations = new LinkedHashSet<AsmOperation>();
    }

    private final String forConfigurationProperty(String str) {
        return str.replace("-", ".").replace("_", ".");
    }

    private final File resolveAbsoluteClassFile(File baseDir, String namespace, String classname) throws Exception {
        StringBuilder sb = new StringBuilder(baseDir.getCanonicalPath());
        sb.append(File.separator);
        if (namespace != null) {
            StringTokenizer tokenizer = new StringTokenizer(namespace, ".");
            while (tokenizer.hasMoreTokens()) {
                sb.append(tokenizer.nextToken());
                sb.append(File.separator);
            }
        }
        sb.append(classname);
        sb.append(".java");
        return new File(sb.toString());
    }

    private final void generateAbstractClient(PrintWriter writer) {
        writer.println("package " + this.getNamespace() + ";");
        writer.println("");
        writer.println("abstract public class AbstractClient extends com.neeve.client.AbstractClient {");
        writer.println("    // ---- Constructors");
        writer.println("    protected AbstractClient(final String serviceName, final String clientName, final String clientInstanceId) {");
        writer.println("        super(serviceName, clientName, clientInstanceId);");
        for (AdmFactory factory : this.messagesModel.getFactories()) {
            writer.println("        com.neeve.sma.MessageViewFactoryRegistry.getInstance().registerMessageViewFactory(new " + factory.getFullName() + "());");
        }
        writer.println("    }");
        writer.println("    protected AbstractClient(final String serviceName, final String clientName, final int clientInstanceId) {");
        writer.println("        super(serviceName, clientName, String.valueOf(clientInstanceId));");
        for (AdmFactory factory : this.messagesModel.getFactories()) {
            writer.println("        com.neeve.sma.MessageViewFactoryRegistry.getInstance().registerMessageViewFactory(new " + factory.getFullName() + "());");
        }
        writer.println("    }");
        writer.println("    // ---- Constructors");
        writer.println("");
        writer.println("    // ---- Interface methods");
        for (AsmOperation operation : this.operations) {
            if (!operation.getInMessage().getNamespace().equals(this.messagesModel.getNamespace())) continue;
            writer.println("    public " + operation.getOutMessage().getFullName() + " " + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(final " + operation.getInMessage().getFullName() + " request, final int timeout) {");
            writer.println("        return waitForResponse(sendRequest(request, false), timeout);");
            writer.println("    }");
            writer.println("    public " + operation.getOutMessage().getFullName() + " " + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(final " + operation.getInMessage().getFullName() + " request) {");
            writer.println("        return " + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "(request, getResponseTimeout());");
            writer.println("    }");
            writer.println("    public long " + AdmGenerator.toFirstLetterLowercase((String)operation.getName()) + "Async(final " + operation.getInMessage().getFullName() + " request) {");
            writer.println("        return sendRequest(request, true);");
            writer.println("    }");
        }
        writer.println("    // ---- Interface methods");
        writer.println("}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void generateAbstractClient(File outdir, boolean absolute) throws Exception {
        File file = this.resolveAbsoluteClassFile(outdir, absolute ? null : this.getNamespace(), "AbstractClient");
        System.out.println("...'" + file.getAbsolutePath() + "'...");
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(file);
            try {
                this.generateAbstractClient(writer);
            }
            finally {
                writer.close();
            }
        }
        catch (IOException e) {
            throw new EAsmException("Failed to create application client file '" + file.getPath() + "' [" + e.toString() + "]");
        }
    }

    public final String getName() {
        return this.name;
    }

    public final String getNamespace() {
        return this.namespace;
    }

    public void setDocumentation(AsmDocumentation doc) {
        this.documentation = doc;
    }

    public AsmDocumentation getDocumentation() {
        return this.documentation;
    }

    public final AdmModel getMessagesModel() {
        return this.messagesModel;
    }

    public final String nameFromFullName(String fullname) {
        int index = fullname.lastIndexOf(".");
        return index == -1 ? fullname : fullname.substring(index + 1, fullname.length());
    }

    public final String namespaceFromFullName(String fullname) {
        int index = fullname.lastIndexOf(".");
        return index == -1 ? null : fullname.substring(0, index);
    }

    public final void addOperation(AsmOperation operation) throws Exception {
        if (operation == null) {
            throw new IllegalArgumentException("operation cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': Adding operation '" + (Object)((Object)operation) + "'", Tracer.Level.DEBUG);
        }
        this.operations.add(operation);
    }

    public final List<AdmMessage> resolveMessage(String name) {
        AdmMessage message;
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': Resolving message '" + name + "'...", Tracer.Level.DEBUG);
        }
        ArrayList<AdmMessage> resolvedMessages = new ArrayList<AdmMessage>();
        String namespace = this.namespaceFromFullName(name);
        name = this.nameFromFullName(name);
        if (this.tracer.debug) {
            this.tracer.log("ASM Model '" + this.namespace + "': ...namespace=" + namespace + ", name=" + name, Tracer.Level.DEBUG);
        }
        if ((message = this.messagesModel.getMessage(name)) != null && (namespace == null || namespace.equals(message.getNamespace()))) {
            if (this.tracer.debug) {
                this.tracer.log("ASM Model '" + this.namespace + "': ...found in generating service's message model", Tracer.Level.DEBUG);
            }
            resolvedMessages.add(message);
        }
        return resolvedMessages;
    }

    public final void generateClasses(File resourcesdir, File classesdir, boolean absolute) throws Exception {
        if (classesdir == null) {
            throw new IllegalArgumentException("output directory for unmodifiable generated files cannot be null");
        }
        if (resourcesdir == null) {
            throw new IllegalArgumentException("unmodifiable resources directory cannot be null");
        }
        System.out.println("Generating class files to '" + classesdir.getAbsolutePath() + "' (absolute=" + absolute + ")...");
        this.generateAbstractClient(classesdir, absolute);
        System.out.println("");
    }

    public final void dump() {
        System.out.println(this.getNamespace() + " {");
        System.out.println("   Messages {");
        System.out.println("   ...model [type=" + this.messagesModel.getNamespace() + "]");
        System.out.println("   }");
        System.out.println("");
        System.out.println("   Operations {");
        for (AsmOperation operation : this.operations) {
            System.out.println("   ..." + operation.getName() + " {");
            System.out.println("   ......inMessage  [type=" + operation.getInMessage().getFullName() + "]");
            System.out.println("   ......outMessage [type=" + operation.getOutMessage().getFullName() + "]");
            System.out.println("   ...}");
        }
        System.out.println("   }");
        System.out.println("");
        System.out.println("}");
        System.out.println("");
    }
}

