#!/bin/bash

# Usage help
print_usage() {
    echo "Usage: $0 --system <system_name> --script <script_name> --param <script_param>"
    exit 1
}

# Parse input arguments
SYSTEM=""
SCRIPT=""
PARAM=""

while [[ "$1" == -* ]]; do
    case "$1" in
    --system)
        shift
        SYSTEM=$1
        shift
        ;;
    --script)
        shift
        SCRIPT=$1
        shift
        ;;
    --param)
        shift
        PARAM=$1
        shift
        ;;
    *)
        echo "Unknown option: $1" >&2
        print_usage
        ;;
    esac
done

# Validate required parameters
if [[ -z "$SYSTEM" || -z "$SCRIPT" || -z "$PARAM" ]]; then
    print_usage
fi

# Remote host
REMOTE_HOST="admin.rumi.local"

# Build the remote command
REMOTE_CMD="source /home/rumi/.bash_profile && source nvx-rumi-agent/current/setenv.sh && nvx-rumi-agent/current/controller/bin/ruc $SYSTEM $SCRIPT $PARAM"

# Execute via SSH using the ~/.ssh/rumi key
ssh -i ~/.ssh/rumi rumi@$REMOTE_HOST "bash -c '$REMOTE_CMD'"
