/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.adm;

import com.neeve.adm.AdmObject;
import com.neeve.adm.EAdmException;
import com.neeve.config.Config;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import java.util.LinkedHashSet;
import java.util.Set;

public final class AdmGeneratorDescriptor
extends AdmObject {
    private final String name;
    private final String className;

    private AdmGeneratorDescriptor(String name, String className) {
        this.name = name;
        this.className = className;
    }

    public final String getName() {
        return this.name;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void save(IConfigRepository repo) throws EAdmException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/adm/generators");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/adm/generators");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperty("Class", this.getClassName());
        }
        catch (EConfigException e) {
            throw new EAdmException(e);
        }
    }

    public final void delete(IConfigRepository repo) throws EAdmException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/adm/generators");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", '" + this.className + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("generator name cannot be null");
        }
        return repo.getSimpleEntity("/adm/generators/" + name) != null;
    }

    public static boolean exists(String name) {
        return AdmGeneratorDescriptor.exists(Config.getRepository(), name);
    }

    public static AdmGeneratorDescriptor create(String name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("generator name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("generator class name cannot be null");
        }
        return new AdmGeneratorDescriptor(name, className);
    }

    public static AdmGeneratorDescriptor load(IConfigRepository repo, String name) throws EAdmException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/adm/generators/" + name);
        if (entity != null) {
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new EAdmException("Invalid generator configuration [Missing 'Class' property]");
            }
            return AdmGeneratorDescriptor.create(name, className);
        }
        throw new EAdmException("Generator '" + name + "' not found in repository");
    }

    public static AdmGeneratorDescriptor load(String name) throws EAdmException {
        return AdmGeneratorDescriptor.load(Config.getRepository(), name);
    }

    public static Set<AdmGeneratorDescriptor> loadAll(IConfigRepository repo) throws EAdmException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<AdmGeneratorDescriptor> generators = new LinkedHashSet<AdmGeneratorDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/adm/generators");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    generators.add(AdmGeneratorDescriptor.load(repo, entity.getName()));
                }
                catch (EAdmException e) {
                    throw new EAdmException("Failure in loading descriptor for generator '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return generators;
    }

    public static Set<AdmGeneratorDescriptor> loadAll() throws EAdmException {
        return AdmGeneratorDescriptor.loadAll(Config.getRepository());
    }
}

