/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cloud.civo;

import com.neeve.cloud.civo.CivoRequestType;
import com.neeve.cloud.civo.messages.MessageFactory;
import com.neeve.trace.Tracer;
import java.io.IOException;

class CivoResponseDtoFactory {
    CivoResponseDtoFactory() {
    }

    static final <T> T toSuccessResponseDto(CivoRequestType requestType, String responseJson, Tracer tracer) throws IOException {
        if (tracer != null && tracer.debug) {
            tracer.log("<-- ResponseDTO [" + (Object)((Object)requestType) + "] " + responseJson, Tracer.Level.DEBUG);
        }
        switch (requestType) {
            case GetSSHKeys: {
                return (T)MessageFactory.createGetSSHKeysResponseMessageFromJson("{\"sshkeys\":" + responseJson + "}");
            }
            case CreateNetwork: {
                return (T)MessageFactory.createCreateNetworkResponseMessageFromJson(responseJson);
            }
            case GetNetworks: {
                return (T)MessageFactory.createGetNetworksResponseMessageFromJson("{\"networks\":" + responseJson + "}");
            }
            case DeleteNetwork: {
                return (T)MessageFactory.createDeleteNetworkResponseMessageFromJson(responseJson);
            }
            case CreateFirewall: {
                return (T)MessageFactory.createCreateFirewallResponseMessageFromJson(responseJson);
            }
            case CreateFirewallRule: {
                return (T)MessageFactory.createCreateFirewallRuleResponseMessageFromJson(responseJson);
            }
            case GetFirewallRules: {
                return (T)MessageFactory.createGetFirewallRulesResponseMessageFromJson("{\"firewall_rules\":" + responseJson + "}");
            }
            case DeleteFirewallRule: {
                return (T)MessageFactory.createDeleteFirewallRuleResponseMessageFromJson(responseJson);
            }
            case GetFirewalls: {
                return (T)MessageFactory.createGetFirewallsResponseMessageFromJson("{\"firewalls\":" + responseJson + "}");
            }
            case DeleteFirewall: {
                return (T)MessageFactory.createDeleteFirewallResponseMessageFromJson(responseJson);
            }
            case GetDiskImages: {
                return (T)MessageFactory.createGetDiskImagesResponseMessageFromJson("{\"disk_images\":" + responseJson + "}");
            }
            case GetInstanceSizes: {
                return (T)MessageFactory.createGetInstanceSizesResponseMessageFromJson("{\"instance_sizes\":" + responseJson + "}");
            }
            case CreateInstance: {
                return (T)MessageFactory.createCreateInstanceResponseMessageFromJson(responseJson);
            }
            case StartInstance: {
                return (T)MessageFactory.createStartInstanceResponseMessageFromJson(responseJson);
            }
            case StopInstance: {
                return (T)MessageFactory.createStopInstanceResponseMessageFromJson(responseJson);
            }
            case GetInstance: {
                return (T)MessageFactory.createGetInstanceResponseMessageFromJson(responseJson);
            }
            case GetInstances: {
                return (T)MessageFactory.createGetInstancesResponseMessageFromJson(responseJson);
            }
            case DeleteInstance: {
                return (T)MessageFactory.createDeleteInstanceResponseMessageFromJson(responseJson);
            }
        }
        throw new IllegalArgumentException("Unsupported request type '" + (Object)((Object)requestType) + "'");
    }
}

