/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.ResultColumnList;
import com.akiban.sql.parser.StatementNode;
import com.akiban.sql.parser.TableName;
import com.akiban.sql.parser.TriggerReferencingStruct;
import com.akiban.sql.parser.ValueNode;
import java.util.List;

public class CreateTriggerNode
extends DDLStatementNode {
    public static final int TRIGGER_EVENT_UPDATE = 1;
    public static final int TRIGGER_EVENT_DELETE = 2;
    public static final int TRIGGER_EVENT_INSERT = 4;
    private TableName triggerName;
    private TableName tableName;
    private int triggerEventMask;
    private ResultColumnList triggerCols;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private List<TriggerReferencingStruct> refClause;
    private ValueNode whenClause;
    private String whenText;
    private int whenOffset;
    private StatementNode actionNode;
    private String actionText;
    private String originalActionText;
    private int actionOffset;

    @Override
    public void init(Object triggerName, Object tableName, Object triggerEventMask, Object triggerCols, Object isBefore, Object isRow, Object isEnabled, Object refClause, Object whenClause, Object whenText, Object whenOffset, Object actionNode, Object actionText, Object actionOffset) throws StandardException {
        this.initAndCheck(triggerName);
        this.triggerName = (TableName)triggerName;
        this.tableName = (TableName)tableName;
        this.triggerEventMask = (Integer)triggerEventMask;
        this.triggerCols = (ResultColumnList)triggerCols;
        this.isBefore = (Boolean)isBefore;
        this.isRow = (Boolean)isRow;
        this.isEnabled = (Boolean)isEnabled;
        this.refClause = (List)refClause;
        this.whenClause = (ValueNode)whenClause;
        this.whenText = whenText == null ? null : ((String)whenText).trim();
        this.whenOffset = (Integer)whenOffset;
        this.actionNode = (StatementNode)actionNode;
        this.originalActionText = (String)actionText;
        this.actionText = actionText == null ? null : ((String)actionText).trim();
        this.actionOffset = (Integer)actionOffset;
        this.implicitCreateSchema = true;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        CreateTriggerNode other = (CreateTriggerNode)node;
        this.triggerName = (TableName)this.getNodeFactory().copyNode(other.triggerName, this.getParserContext());
        this.tableName = (TableName)this.getNodeFactory().copyNode(other.tableName, this.getParserContext());
        this.triggerEventMask = other.triggerEventMask;
        this.triggerCols = (ResultColumnList)this.getNodeFactory().copyNode(other.triggerCols, this.getParserContext());
        this.isBefore = other.isBefore;
        this.isRow = other.isRow;
        this.isEnabled = other.isEnabled;
        this.refClause = other.refClause;
        this.whenClause = (ValueNode)this.getNodeFactory().copyNode(other.whenClause, this.getParserContext());
        this.whenText = other.whenText;
        this.whenOffset = other.whenOffset;
        this.actionNode = (StatementNode)this.getNodeFactory().copyNode(other.actionNode, this.getParserContext());
        this.actionText = other.actionText;
        this.originalActionText = other.originalActionText;
        this.actionOffset = other.actionOffset;
    }

    @Override
    public String statementToString() {
        return "CREATE TRIGGER";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.triggerCols != null) {
            this.printLabel(depth, "triggerColumns: ");
            this.triggerCols.treePrint(depth + 1);
        }
        if (this.whenClause != null) {
            this.printLabel(depth, "whenClause: ");
            this.whenClause.treePrint(depth + 1);
        }
        if (this.actionNode != null) {
            this.printLabel(depth, "actionNode: ");
            this.actionNode.treePrint(depth + 1);
        }
    }

    @Override
    public String toString() {
        String refString = "null";
        if (this.refClause != null) {
            StringBuffer buf = new StringBuffer();
            for (TriggerReferencingStruct trn : this.refClause) {
                buf.append("\t");
                buf.append(trn.toString());
                buf.append("\n");
            }
            refString = buf.toString();
        }
        return super.toString() + "tableName: " + this.tableName + "\ntriggerEventMask: " + this.triggerEventMask + "\nisBefore: " + this.isBefore + "\nisRow: " + this.isRow + "\nisEnabled: " + this.isEnabled + "\nwhenText: " + this.whenText + "\nrefClause: " + refString + "\nactionText: " + this.actionText + "\n";
    }
}

