/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog;

import com.neeve.rog.IRogMessage;
import com.neeve.stats.IStats;
import java.io.IOException;

public interface IRogMessageLogger {
    public String getName();

    public void setErrorHandler(ErrorHandler var1);

    public ErrorHandler getErrorHandler();

    public void open() throws Exception;

    public boolean isOpen();

    public boolean wasRepaired();

    public Stats getStats();

    public boolean isReadInProgress();

    public IRogMessage readAt(long var1);

    public IRogMessage readOne();

    public void readFrom(long var1, IMessageReceiver var3);

    public void read(IMessageReceiver var1);

    public void stopRead();

    public long getPositionInLog(IRogMessage var1);

    public int getSizeInLog(IRogMessage var1);

    public void log(IRogMessage var1, boolean var2, boolean var3, boolean var4);

    public void log(IRogMessage var1, boolean var2, boolean var3);

    public void log(IRogMessage var1);

    public void flush(boolean var1);

    public void delete() throws IOException;

    public void close();

    public static interface Stats
    extends IStats {
        public long getNumMessagesLogged();

        public long getNumCommits();

        public long getNumFlushesImplicit();

        public long getNumFlushesExplicit();

        public boolean isDetached();

        public int getDisruptorCapacity();

        public int getDisruptorRemaining();

        public String getDisruptorClaimStrategy();

        public String getDisruptorWaitStrategy();

        public IStats.Latencies getOfferToPollLatencies();

        public long getFileSize();

        public long getFileSizeUsed();
    }

    public static interface ErrorHandler {
        public void onError(Throwable var1);
    }

    public static interface IMessageReceiver {
        public void handleMessage(IRogMessage var1);
    }
}

