/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl;

import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.neeve.query.QueryException;
import com.neeve.query.QueryPlan;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryPlanImpl;

public class QueryResultImpl<ID, REC>
implements QueryPlanImpl.PlanQueryResult<REC> {
    private int prefetchCount;
    private QueryIndexableRepository<ID, REC> repo;
    private String repositoryAlias;
    protected Iterable<QueryResultSet.Row<REC>> rows;
    private int estimatedSize;
    private boolean fullScan = false;
    private QueryPlanImpl<ID, REC> plan;
    private boolean closed = false;

    public QueryResultImpl(QueryIndexableRepository<ID, REC> repo, Iterable<QueryResultSet.Row<REC>> rows, int estimatedSize) {
        this.repo = repo;
        this.rows = rows;
        this.estimatedSize = estimatedSize;
    }

    private void ensureOpen() {
        if (this.closed) {
            throw new QueryException("QueryResult is closed.");
        }
    }

    @Override
    public QueryPlanImpl<ID, REC> getPlan() {
        return this.plan;
    }

    @Override
    public void setPlan(QueryPlan plan) {
        this.plan = (QueryPlanImpl)plan;
    }

    @Override
    public int size() {
        this.ensureOpen();
        int n = 0;
        for (QueryResultSet.Row<REC> row : this.rows) {
            ++n;
        }
        return n;
    }

    @Override
    public int estimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public boolean isFullScan() {
        return this.fullScan;
    }

    public void setFullScan(boolean fullScan) {
        this.fullScan = fullScan;
    }

    @Override
    public void setPrefetchCount(int prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public int getPrefetchCount() {
        return this.prefetchCount;
    }

    public QueryResultIterator iterator() {
        this.ensureOpen();
        QueryResultIterator iter = new QueryResultIterator();
        return iter;
    }

    @Override
    public QueryIndexableRepository<?, REC> getRepository() {
        return this.repo;
    }

    @Override
    public void setRepositoryAlias(String alias) {
        this.repositoryAlias = alias;
    }

    @Override
    public String getRepositoryAlias() {
        return this.repositoryAlias;
    }

    @Override
    public void close() {
        this.plan.close();
        this.closed = true;
    }

    public class QueryResultIterator
    implements PeekingIterator<QueryResultSet.Row<REC>> {
        private PeekingIterator<QueryResultSet.Row<REC>> iter;

        private QueryResultIterator() {
            this.iter = Iterators.peekingIterator(QueryResultImpl.this.rows.iterator());
        }

        public QueryPlanImpl.PlanQueryResult<REC> getQueryResult() {
            return QueryResultImpl.this;
        }

        public boolean hasNext() {
            return !QueryResultImpl.this.closed && this.iter.hasNext();
        }

        public QueryResultSet.Row<REC> peek() {
            QueryResultImpl.this.ensureOpen();
            return (QueryResultSet.Row)this.iter.peek();
        }

        public QueryResultSet.Row<REC> next() {
            QueryResultImpl.this.ensureOpen();
            return (QueryResultSet.Row)this.iter.next();
        }

        public void remove() {
            QueryResultImpl.this.ensureOpen();
            this.iter.remove();
        }
    }
}

