/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.client.link.ClientLinkManager;
import com.neeve.tools.interactive.commands.Command;
import java.util.Iterator;
import java.util.Set;

public final class Roots
extends Command {
    private final ClientLinkManager linkManager;

    public Roots(ClientLinkManager linkManager) {
        this.linkManager = linkManager;
    }

    private void processRoots() {
        Set<String> roots = this.linkManager.getRoots();
        if (roots.size() > 0) {
            System.out.println("");
            Iterator<String> iterator = roots.iterator();
            while (iterator.hasNext()) {
                System.out.println("  " + iterator.next());
            }
        } else {
            System.out.printf("<No entries>\n", new Object[0]);
        }
        System.out.printf("\n", new Object[0]);
    }

    public final void run(String[] args) {
        if (args != null && args.length != 0) {
            System.out.println("Syntax error: roots");
        } else {
            this.processRoots();
        }
    }

    public final void help() {
        System.out.println("roots");
        System.out.println("  List root links maintained by the link manager.");
    }

    public final String[] keywords() {
        return new String[]{"roots"};
    }
}

