/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.mon;

import com.eaio.uuid.UUID;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.neeve.adm.runtime.AdmRuntime;
import com.neeve.adm.runtime.annotations.AdmFactoryInfo;
import com.neeve.adm.runtime.annotations.AdmGenerated;
import com.neeve.config.Config;
import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIterator;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.types.PktBodyData;
import com.neeve.protobuf.ProtobufUtil;
import com.neeve.query.impl.index.IdxMappable;
import com.neeve.rog.IRogFieldReflector;
import com.neeve.server.mon.ISrvMonUserStats;
import com.neeve.server.mon.SrvMonHeartbeatFactory;
import com.neeve.server.mon.SrvMonUserCounterStat;
import com.neeve.server.mon.SrvMonUserGaugeStat;
import com.neeve.server.mon.SrvMonUserSeriesStat;
import com.neeve.sma.MessageReflector;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReflection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;

@AdmGenerated(encoding="xbuf", compatLevel="5.0.0", admVersion="nvx-rumi-adm v4.0 (build 590)", date="6/30/25 9:20 PM", buildInfo="nvx-rumi-server 4.0 (raven)")
@AdmFactoryInfo(factoryClass=SrvMonHeartbeatFactory.class, vfid=32, ofid=32, typeId=222)
@JsonPropertyOrder(value={"counters", "series", "gauges"})
public final class SrvMonUserStats
implements ISrvMonUserStats,
MessageReflector,
IdxMappable,
UtlPool.Item<SrvMonUserStats>,
AdmRuntime.BufferSizer {
    private static final HashMap<String, IRogFieldReflector<SrvMonUserStats, ?>> _fieldReflectors = new HashMap(0);
    private static final boolean _conserveMemory = Config.conserveMemory();
    private static final MemoryStats _memstats = MemoryStats.getInstance();
    private static final SrvMonUserStatsPoolFactory _srvMonUserStatsFactory = new SrvMonUserStatsPoolFactory();
    private static final SrvMonUserStatsPojoPoolFactory _srvMonUserStatsPojoFactory = new SrvMonUserStatsPojoPoolFactory();
    private static final SrvMonUserStatsSerializerPoolFactory _srvMonUserStatsSerializerFactory = new SrvMonUserStatsSerializerPoolFactory();
    private static final SrvMonUserStatsDeserializerPoolFactory _srvMonUserStatsDeserializerFactory = new SrvMonUserStatsDeserializerPoolFactory();
    static final UtlPool<SrvMonUserStats> _entityPool = UtlPool.create((String)"protobuf.entity", (String)"SrvMonUserStatsProtobufEntity.0.222", (UtlPool.Factory)_srvMonUserStatsFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(SrvMonUserStats.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonUserStatsPoolEvictedItemReceiver());
    static final UtlPool<Pojo> _entityPojoPool = UtlPool.create((String)"protobuf.entity.pojo", (String)"SrvMonUserStatsProtobufEntityPojo.0.222", (UtlPool.Factory)_srvMonUserStatsPojoFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Pojo.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonUserStatsPojoPoolEvictedItemReceiver());
    static final UtlPool<Serializer> _entitySerializerPool = UtlPool.create((String)"protobuf.entity.serializer", (String)"SrvMonUserStatsProtobufEntitySerializer.0.222", (UtlPool.Factory)_srvMonUserStatsSerializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Serializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonUserStatsSerializerPoolEvictedItemReceiver());
    static final UtlPool<Deserializer> _entityDeserializerPool = UtlPool.create((String)"protobuf.entity.deserializer", (String)"SrvMonUserStatsProtobufEntityDeserializer.0.222", (UtlPool.Factory)_srvMonUserStatsDeserializerFactory, (UtlPool.Params)AdmRuntime.configurePoolParams(Deserializer.class, (UtlPool.Params)UtlPool.Params.create().setThreaded(true))).setEvictedItemReceiver((UtlPool.EvictedItemReceiver)new SrvMonUserStatsDeserializerPoolEvictedItemReceiver());
    private final AtomicInteger _ownershipCount = new AtomicInteger(1);
    private UtlPool<SrvMonUserStats> _pool;
    private long _serializedBuffer;
    private int _serializedBufferLength;
    private int _serializedBufferCapacity;
    private Serializer _serializer;
    private Deserializer _deserializer;
    private Pojo _pojo;
    private boolean readOnly;
    private boolean created = true;
    public static final SrvMonUserStats[] EMPTY_ARRAY = new SrvMonUserStats[0];

    SrvMonUserStats() {
    }

    public static SrvMonUserStats create() {
        SrvMonUserStats entity = (SrvMonUserStats)_entityPool.get(null);
        _memstats.onEntityAllocated(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, !entity.created);
        return entity;
    }

    private final long serializedBuffer(int len) {
        long oldBuffer = this._serializedBuffer;
        int oldCapacity = this._serializedBufferCapacity;
        int newCapacity = Math.max(len, 4);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newCapacity, (boolean)false);
        if (newCapacity > oldCapacity) {
            if (oldBuffer != 0L) {
                _memstats.onEntityDataDisposed(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, oldCapacity, true);
            }
            _memstats.onEntityDataAllocated(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, newCapacity);
            this._serializedBufferCapacity = newCapacity;
        }
        return this._serializedBuffer;
    }

    public final boolean hasSerializedBuffer() {
        return this._serializedBuffer != 0L;
    }

    @JsonIgnore
    public final long getSerializedBuffer() {
        return this._serializedBuffer;
    }

    @JsonIgnore
    public final int getSerializedBufferCapacity() {
        return this._serializedBufferCapacity;
    }

    final void setSerializedBufferLength(int val) {
        this._serializedBufferLength = val;
    }

    @JsonIgnore
    public final int getSerializedBufferLength() {
        return this._serializedBufferLength;
    }

    @Deprecated
    @JsonIgnore
    public final int getSerializeToNativeLength() {
        return this.getSerializedBufferLength();
    }

    public final Serializer serializer(int length, boolean autoResizeTargetBuffer) {
        if (this._serializer == null) {
            this._serializer = Serializer.create();
        }
        this.serializedBuffer(length);
        if (autoResizeTargetBuffer) {
            this._serializer.setSizer(this);
        }
        return this._serializer.init(this);
    }

    public final Serializer serializer(int minimumLength) {
        return this.serializer(minimumLength, true);
    }

    public final Serializer serializer() {
        return this.serializer(1024, true);
    }

    public final long ensureCapacity(long addr, int capacity) {
        if (capacity <= this._serializedBufferCapacity) {
            return addr;
        }
        int newLength = capacity <= this._serializedBufferCapacity ? capacity : Math.max(capacity, this._serializedBufferCapacity * 2);
        this._serializedBuffer = IOBuffer.ensureMemoryBlockCapacity((long)this._serializedBuffer, (long)this._serializedBufferCapacity, (int)newLength, (boolean)false);
        this._serializedBufferCapacity = newLength;
        return this._serializedBuffer;
    }

    public final Deserializer deserializer(boolean createBuffer) {
        if (!this.hasSerializedBuffer() && createBuffer) {
            this.serializedBuffer(0);
        }
        if (!this.hasSerializedBuffer()) {
            throw new IllegalStateException("no backing serialized buffer");
        }
        if (this._deserializer == null) {
            this._deserializer = Deserializer.create();
        }
        return this._deserializer.init(this._serializedBuffer, 0, this._serializedBufferLength);
    }

    public final Deserializer deserializer() {
        return this.deserializer(false);
    }

    public final boolean hasPojo() {
        return this._pojo != null && this._pojo.isInitialized();
    }

    public final boolean hasDirtyPojo() {
        return this.hasPojo() && this._pojo.isDirty();
    }

    public final Pojo pojo(boolean onlyPojos) {
        if (this._pojo == null) {
            this._pojo = Pojo.create();
        }
        if (onlyPojos) {
            this._pojo.setOnlyPojos();
        } else {
            this._pojo.clearOnlyPojos();
        }
        if (!this._pojo.isInitialized()) {
            if (this.hasSerializedBuffer()) {
                this._pojo.deserialize(this.deserializer());
                this._pojo.clearDirty();
            } else {
                this._pojo.setInitialized();
            }
            if (this.readOnly) {
                this._pojo.setAsReadOnly();
            }
        }
        if (onlyPojos) {
            this.conserveMemory(AdmRuntime.DataStoragePolicy.OnlyPojo);
        }
        return this._pojo;
    }

    public final Pojo pojo() {
        return this.pojo(false);
    }

    public final void disposeSerializedBuffer(boolean gcDisposed) {
        if (this.hasSerializedBuffer()) {
            IOBuffer.freeMemoryBlock((long)this._serializedBuffer, (int)this._serializedBufferCapacity);
            _memstats.onEntityDataDisposed(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, this._serializedBufferCapacity, !gcDisposed);
            this._serializedBuffer = 0L;
            this._serializedBufferLength = 0;
            this._serializedBufferCapacity = 0;
        }
    }

    public final void disposeSerializedBuffer() {
        this.disposeSerializedBuffer(false);
    }

    public final void disposeSerializer() {
        if (this._serializer != null) {
            this._serializer.dispose();
            this._serializer = null;
        }
    }

    public final void disposeDeserializer() {
        if (this._deserializer != null) {
            this._deserializer.dispose();
            this._deserializer = null;
        }
    }

    public final void disposePojo(boolean sync) {
        if (sync) {
            this.sync();
        }
        if (this._pojo != null) {
            this._pojo.dispose();
            this._pojo = null;
        }
    }

    public final void disposePojo() {
        this.disposePojo(false);
    }

    private final void conserveMemory(AdmRuntime.DataStoragePolicy policy) {
        switch (policy) {
            case OnlySerialized: {
                this.sync();
                this.disposeSerializer();
                this.disposeDeserializer();
                this.disposePojo(false);
                break;
            }
            case OnlyPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) {
                    this.pojo(false);
                }
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
            case SerializedOrPojo: {
                this.disposeSerializer();
                this.disposeDeserializer();
                if (this._pojo == null || !this._pojo.isInitialized()) break;
                this.disposeSerializedBuffer();
                this._pojo.forceDirty();
                break;
            }
        }
    }

    public final void clear(boolean disposeMembers) {
        if (this._pojo != null) {
            if (disposeMembers) {
                this.disposePojo(false);
            } else {
                this._pojo.reset();
            }
        }
        if (disposeMembers) {
            this.disposeSerializedBuffer();
        } else {
            this._serializedBufferLength = 0;
        }
        this.readOnly = false;
    }

    public final void clear() {
        this.clear(false);
    }

    @Deprecated
    public final void clearContent() {
        this.clear();
    }

    public final void reset(boolean disposeMembers) {
        this.clear(disposeMembers);
        if (disposeMembers) {
            this.disposeSerializer();
            this.disposeDeserializer();
        }
    }

    public final void reset() {
        this.reset(_conserveMemory);
    }

    public final String serializeToRawJson() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            SrvMonHeartbeatFactory.mapper.writeValue((OutputStream)baos, (Object)this);
            return new String(baos.toByteArray(), "utf-8");
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public final int serializeTo(Serializer serializer) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            serializer.putFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final void sync() {
        if (this.hasDirtyPojo()) {
            this._serializedBufferLength = this._pojo.serialize(this.serializer(this._pojo.getSerializedLength(), false));
            this._pojo.clearDirty();
        } else if (!this.hasSerializedBuffer()) {
            this.serializedBuffer(0);
        }
    }

    public final byte[] serializeToByteArray() {
        this.sync();
        byte[] array = new byte[this._serializedBufferLength];
        this.serializeTo(array, 0);
        return array;
    }

    public final int serializeTo(byte[] array, int offset) {
        this.sync();
        if (this._serializedBufferLength > array.length - offset) {
            throw new IllegalArgumentException("array too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (byte[])array, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final ByteBuffer serializeToByteBuffer() {
        this.sync();
        ByteBuffer buffer = ByteBuffer.allocate(this._serializedBufferLength);
        this.serializeTo(buffer);
        return buffer;
    }

    public final int serializeTo(ByteBuffer buffer) {
        this.sync();
        if (this._serializedBufferLength > buffer.capacity() - buffer.position()) {
            throw new IllegalArgumentException("buffer too small");
        }
        buffer.limit(buffer.position() + this._serializedBufferLength);
        if (this.hasSerializedBuffer()) {
            IOBuffer.getTo((long)this._serializedBuffer, (int)0, (ByteBuffer)buffer, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final IOBuffer serializeToIOBuffer(boolean useNative) {
        this.sync();
        IOBuffer buffer = IOBuffer.create((int)this._serializedBufferLength);
        this.serializeTo(buffer, 0);
        return buffer;
    }

    public final int serializeTo(IOBuffer buffer, int offset) {
        this.sync();
        if (this._serializedBufferLength > buffer.getLength() - offset) {
            throw new IllegalArgumentException("buffer too small");
        }
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)buffer.getNativeAddress(), (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(IOElasticBuffer buffer, int offset) {
        this.sync();
        buffer.setLength(offset + this._serializedBufferLength);
        return this.serializeTo(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset);
    }

    public final PktPacket serializeToPacket() {
        PktPacket packet = PktFactory.getInstance().createPacket(1052862);
        this.serializeTo(packet);
        return packet;
    }

    public final int serializeTo(PktPacket packet) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            packet.getBody().deserialize(this._serializedBuffer, 0, this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    public final int serializeTo(long addr, int offset) {
        this.sync();
        if (this.hasSerializedBuffer()) {
            IOBuffer.copy((long)this._serializedBuffer, (int)0, (long)addr, (int)offset, (int)this._serializedBufferLength);
        }
        return this._serializedBufferLength;
    }

    @Deprecated
    public final int serializeToNative(long addr, int offset) {
        return this.serializeTo(addr, offset);
    }

    public final String serializeToJson() {
        return this.serializeToRawJson();
    }

    public final SrvMonUserStats deserializeFromRawJson(String json) {
        try {
            SrvMonHeartbeatFactory.mapper.reader().withValueToUpdate((Object)this).readValue(json);
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final SrvMonUserStats deserializeFrom(Deserializer deserializer) {
        if (!deserializer.isInitialized()) {
            throw new IllegalArgumentException("can only deserialize from an initialized deserializer");
        }
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = 0;
        if (deserializer != null) {
            this._serializedBufferLength = deserializer.getSerializedLength();
            deserializer.getTo(this.serializedBuffer(this._serializedBufferLength), 0);
        }
        return this;
    }

    public final SrvMonUserStats deserializeFrom(SrvMonUserStats val) {
        return this.deserializeFrom(val.getSerializedBuffer(), 0, val.getSerializedBufferLength());
    }

    public final SrvMonUserStats wrap(IOBuffer buffer, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this.disposeSerializedBuffer();
        this._serializedBuffer = buffer.getNativeAddress();
        this._serializedBufferLength = len;
        return this;
    }

    public final SrvMonUserStats deserializeFromByteArray(byte[] array) {
        return this.deserializeFrom(array, 0, array.length);
    }

    public final SrvMonUserStats deserializeFrom(byte[] array, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = array != null ? len : 0;
        if (array != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(len), (int)0, (byte[])array, (int)offset, (int)len);
        }
        return this;
    }

    public final SrvMonUserStats deserializeFromByteBuffer(ByteBuffer buffer) {
        return this.deserializeFrom(buffer);
    }

    public final SrvMonUserStats deserializeFrom(ByteBuffer buffer) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? buffer.remaining() : 0;
        if (buffer != null) {
            IOBuffer.putFrom((long)this.serializedBuffer(this._serializedBufferLength), (int)0, (ByteBuffer)buffer, (int)buffer.position(), (int)this._serializedBufferLength);
        }
        return this;
    }

    public final SrvMonUserStats deserializeFrom(IOBuffer buffer, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        int n = this._serializedBufferLength = buffer != null ? len : 0;
        if (buffer != null) {
            IOBuffer.copy((long)buffer.getNativeAddress(), (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        }
        return this;
    }

    public final SrvMonUserStats deserializeFrom(IOElasticBuffer buffer, int offset, int len) {
        return this.deserializeFrom(buffer.getBackingBufferUnsafe(), buffer.getOffset() + offset, len);
    }

    public final SrvMonUserStats deserializeFromPacket(PktPacket packet) {
        return this.deserializeFrom(packet);
    }

    public final SrvMonUserStats deserializeFrom(PktPacket packet) {
        try {
            IOElasticBuffer buffer = packet.getBody().getBuffer();
            SrvMonUserStats srvMonUserStats = this.deserializeFrom(buffer, 0, buffer.getLength());
            return srvMonUserStats;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            packet.dispose();
        }
    }

    public final SrvMonUserStats deserializeFrom(long addr, int offset, int len) {
        if (this._pojo != null) {
            this._pojo.reset();
        }
        this._serializedBufferLength = len;
        IOBuffer.copy((long)addr, (int)offset, (long)this.serializedBuffer(len), (int)0, (int)len);
        return this;
    }

    @Deprecated
    public final SrvMonUserStats deserializeFromNative(long addr, int offset, int len) {
        return this.deserializeFrom(addr, offset, len);
    }

    public final SrvMonUserStats deserializeFromJson(String json) {
        this.deserializeFromRawJson(json);
        return this;
    }

    public final void copyInto(SrvMonUserStats copy) {
        copy.clear();
        this.sync();
        if (this.hasSerializedBuffer()) {
            copy.deserializeFrom(this._serializedBuffer, 0, this._serializedBufferLength);
        }
    }

    public final SrvMonUserStats copy() {
        SrvMonUserStats copy = SrvMonUserStats.create();
        this.copyInto(copy);
        return copy;
    }

    public boolean needsSync() {
        return false;
    }

    public final boolean fieldExists(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return _fieldReflectors.containsKey(name) || UtlReflection.hasPath((Object)message, (String)name);
    }

    public final boolean isFieldReflectable(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        if (_fieldReflectors.containsKey(name)) {
            return true;
        }
        Class c = UtlReflection.getUnwrappedReturnType(message.getClass(), (String)name);
        if (c == null || c.isArray()) {
            return false;
        }
        if (c.isEnum() || c.isPrimitive()) {
            return true;
        }
        return c == Date.class || c == Currency.class || c == String.class || XString.class.isAssignableFrom(c);
    }

    public final String getFieldValueAsString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsString(message, name.split("\\."));
    }

    public final String getFieldValueAsString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : String.valueOf(object);
        }
        IRogFieldReflector<SrvMonUserStats, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return val.toString();
            }
            return null;
        }
        return null;
    }

    public final XString getFieldValueAsRawString(Object message, String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.getFieldValueAsRawString(message, name.split("\\."));
    }

    public final XString getFieldValueAsRawString(Object message, String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            return object == null ? null : XString.create((String)object.toString());
        }
        IRogFieldReflector<SrvMonUserStats, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            Object val = reflector.getValue((Object)this);
            if (val != null) {
                return XString.create((String)val.toString());
            }
            return null;
        }
        return null;
    }

    public final boolean appendFieldValueTo(Object message, String name, XString target) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return this.appendFieldValueTo(message, name.split("\\."), target);
    }

    public final boolean appendFieldValueTo(Object node, String[] pathComponents, XString target) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            Object object = UtlReflection.getProperty((Object)this, (int)0, (String[])pathComponents);
            if (object == null) {
                return false;
            }
            target.append((CharSequence)object.toString());
            return true;
        }
        IRogFieldReflector<SrvMonUserStats, ?> reflector = _fieldReflectors.get(pathComponents[0]);
        if (reflector != null) {
            return reflector.appendValueTo((Object)this, target);
        }
        return false;
    }

    public final void setAsReadOnly() {
        this.readOnly = true;
        if (this._pojo != null) {
            this._pojo.setAsReadOnly();
        }
    }

    public static final int getCountersFieldId() {
        return 16;
    }

    @Override
    @JsonProperty(value="counters")
    public final void setCounters(SrvMonUserCounterStat[] val) {
        this.pojo().clearCounters();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToCounters(val[i]);
            }
        }
    }

    @Override
    public final void lendCounters(SrvMonUserCounterStat[] val) {
        this.pojo().clearCounters();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToCounters(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setCountersFrom(XIterator<SrvMonUserCounterStat> val) {
        this.pojo().clearCounters();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonUserCounterStat v = (SrvMonUserCounterStat)val.next();
                if (v == null) continue;
                this.pojo().addToCounters(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendCountersFrom(XIterator<SrvMonUserCounterStat> val) {
        this.pojo().clearCounters();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonUserCounterStat v = (SrvMonUserCounterStat)val.next();
                if (v == null) continue;
                this.pojo().lendToCounters(v);
            }
        }
    }

    @Override
    @JsonProperty(value="counters")
    public final void addCounters(SrvMonUserCounterStat val) {
        this.pojo().addToCounters(val);
    }

    @Override
    @JsonProperty(value="counters")
    public final void lendCounters(SrvMonUserCounterStat val) {
        this.pojo().lendToCounters(val);
    }

    @Override
    @JsonProperty(value="counters")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final SrvMonUserCounterStat[] getCounters() {
        int count = this.pojo().getCountersCount();
        if (count > 0) {
            SrvMonUserCounterStat[] val = new SrvMonUserCounterStat[count];
            XIterator<SrvMonUserCounterStat> iterator = this.pojo().getCountersIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonUserCounterStat)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final SrvMonUserCounterStat[] getCountersEmptyIfNull() {
        SrvMonUserCounterStat[] val = this.getCounters();
        return val != null ? val : SrvMonUserCounterStat.EMPTY_ARRAY;
    }

    @Override
    public final int getCountersCount() {
        return this.pojo().getCountersCount();
    }

    @Override
    public final SrvMonUserCounterStat getCountersAt(int index) {
        return this.pojo().getCountersAt(index);
    }

    @Override
    public final XIterator<SrvMonUserCounterStat> getCountersIterator() {
        return this.pojo().getCountersIterator();
    }

    @Override
    public final SrvMonUserCounterStat[] takeCounters() {
        int count = this.pojo().getCountersCount();
        if (count > 0) {
            SrvMonUserCounterStat[] val = new SrvMonUserCounterStat[count];
            XIterator<SrvMonUserCounterStat> iterator = this.pojo().getCountersIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonUserCounterStat)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearCounters() {
        this.pojo().clearCounters();
    }

    public static final int getSeriesFieldId() {
        return 17;
    }

    @Override
    @JsonProperty(value="series")
    public final void setSeries(SrvMonUserSeriesStat[] val) {
        this.pojo().clearSeries();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToSeries(val[i]);
            }
        }
    }

    @Override
    public final void lendSeries(SrvMonUserSeriesStat[] val) {
        this.pojo().clearSeries();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToSeries(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setSeriesFrom(XIterator<SrvMonUserSeriesStat> val) {
        this.pojo().clearSeries();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonUserSeriesStat v = (SrvMonUserSeriesStat)val.next();
                if (v == null) continue;
                this.pojo().addToSeries(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendSeriesFrom(XIterator<SrvMonUserSeriesStat> val) {
        this.pojo().clearSeries();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonUserSeriesStat v = (SrvMonUserSeriesStat)val.next();
                if (v == null) continue;
                this.pojo().lendToSeries(v);
            }
        }
    }

    @Override
    @JsonProperty(value="series")
    public final void addSeries(SrvMonUserSeriesStat val) {
        this.pojo().addToSeries(val);
    }

    @Override
    @JsonProperty(value="series")
    public final void lendSeries(SrvMonUserSeriesStat val) {
        this.pojo().lendToSeries(val);
    }

    @Override
    @JsonProperty(value="series")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final SrvMonUserSeriesStat[] getSeries() {
        int count = this.pojo().getSeriesCount();
        if (count > 0) {
            SrvMonUserSeriesStat[] val = new SrvMonUserSeriesStat[count];
            XIterator<SrvMonUserSeriesStat> iterator = this.pojo().getSeriesIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonUserSeriesStat)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final SrvMonUserSeriesStat[] getSeriesEmptyIfNull() {
        SrvMonUserSeriesStat[] val = this.getSeries();
        return val != null ? val : SrvMonUserSeriesStat.EMPTY_ARRAY;
    }

    @Override
    public final int getSeriesCount() {
        return this.pojo().getSeriesCount();
    }

    @Override
    public final SrvMonUserSeriesStat getSeriesAt(int index) {
        return this.pojo().getSeriesAt(index);
    }

    @Override
    public final XIterator<SrvMonUserSeriesStat> getSeriesIterator() {
        return this.pojo().getSeriesIterator();
    }

    @Override
    public final SrvMonUserSeriesStat[] takeSeries() {
        int count = this.pojo().getSeriesCount();
        if (count > 0) {
            SrvMonUserSeriesStat[] val = new SrvMonUserSeriesStat[count];
            XIterator<SrvMonUserSeriesStat> iterator = this.pojo().getSeriesIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonUserSeriesStat)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearSeries() {
        this.pojo().clearSeries();
    }

    public static final int getGaugesFieldId() {
        return 18;
    }

    @Override
    @JsonProperty(value="gauges")
    public final void setGauges(SrvMonUserGaugeStat[] val) {
        this.pojo().clearGauges();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().addToGauges(val[i]);
            }
        }
    }

    @Override
    public final void lendGauges(SrvMonUserGaugeStat[] val) {
        this.pojo().clearGauges();
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                if (val[i] == null) continue;
                this.pojo().lendToGauges(val[i]);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void setGaugesFrom(XIterator<SrvMonUserGaugeStat> val) {
        this.pojo().clearGauges();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonUserGaugeStat v = (SrvMonUserGaugeStat)val.next();
                if (v == null) continue;
                this.pojo().addToGauges(v);
            }
        }
    }

    @Override
    @JsonIgnore
    public final void lendGaugesFrom(XIterator<SrvMonUserGaugeStat> val) {
        this.pojo().clearGauges();
        if (val != null && val.toFirst().hasNext()) {
            while (val.hasNext()) {
                SrvMonUserGaugeStat v = (SrvMonUserGaugeStat)val.next();
                if (v == null) continue;
                this.pojo().lendToGauges(v);
            }
        }
    }

    @Override
    @JsonProperty(value="gauges")
    public final void addGauges(SrvMonUserGaugeStat val) {
        this.pojo().addToGauges(val);
    }

    @Override
    @JsonProperty(value="gauges")
    public final void lendGauges(SrvMonUserGaugeStat val) {
        this.pojo().lendToGauges(val);
    }

    @Override
    @JsonProperty(value="gauges")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public final SrvMonUserGaugeStat[] getGauges() {
        int count = this.pojo().getGaugesCount();
        if (count > 0) {
            SrvMonUserGaugeStat[] val = new SrvMonUserGaugeStat[count];
            XIterator<SrvMonUserGaugeStat> iterator = this.pojo().getGaugesIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonUserGaugeStat)iterator.next();
            }
            return val;
        }
        return null;
    }

    @Override
    public final SrvMonUserGaugeStat[] getGaugesEmptyIfNull() {
        SrvMonUserGaugeStat[] val = this.getGauges();
        return val != null ? val : SrvMonUserGaugeStat.EMPTY_ARRAY;
    }

    @Override
    public final int getGaugesCount() {
        return this.pojo().getGaugesCount();
    }

    @Override
    public final SrvMonUserGaugeStat getGaugesAt(int index) {
        return this.pojo().getGaugesAt(index);
    }

    @Override
    public final XIterator<SrvMonUserGaugeStat> getGaugesIterator() {
        return this.pojo().getGaugesIterator();
    }

    @Override
    public final SrvMonUserGaugeStat[] takeGauges() {
        int count = this.pojo().getGaugesCount();
        if (count > 0) {
            SrvMonUserGaugeStat[] val = new SrvMonUserGaugeStat[count];
            XIterator<SrvMonUserGaugeStat> iterator = this.pojo().getGaugesIterator();
            for (int i = 0; i < count; ++i) {
                val[i] = (SrvMonUserGaugeStat)iterator.next();
                val[i].acquire();
            }
            return val;
        }
        return null;
    }

    @Override
    public final void clearGauges() {
        this.pojo().clearGauges();
    }

    public static final <T> IRogFieldReflector<SrvMonUserStats, T> getFieldReflector(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        return SrvMonUserStats.getFieldReflector(name.split("\\."));
    }

    public static final <T> IRogFieldReflector<SrvMonUserStats, T> getFieldReflector(String[] pathComponents) {
        if (pathComponents == null || pathComponents.length == 0) {
            throw new IllegalArgumentException("pathComponents cannot be null or 0 length");
        }
        if (pathComponents.length != 1) {
            throw new IllegalArgumentException("fetching of reflectable field accessors for nested fields is currently not supported");
        }
        return _fieldReflectors.get(pathComponents[0]);
    }

    public final Object getQueryFieldValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IRogFieldReflector<SrvMonUserStats, ?> reflector = _fieldReflectors.get(name);
        if (reflector != null) {
            return reflector.getValue((Object)this);
        }
        return null;
    }

    public final SrvMonUserStats init() {
        this.reset();
        this._ownershipCount.set(1);
        return this;
    }

    public final SrvMonUserStats setPool(UtlPool<SrvMonUserStats> pool) {
        this._pool = pool;
        return this;
    }

    public final UtlPool<SrvMonUserStats> getPool() {
        return this._pool;
    }

    public final SrvMonUserStats acquire() {
        int val = this._ownershipCount.incrementAndGet();
        if (val <= 1 && this._pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed entity");
        }
        return this;
    }

    public final int getOwnershipCount() {
        return this._ownershipCount.get();
    }

    public final void dispose() {
        int val = this._ownershipCount.decrementAndGet();
        if (val < 0 && this._pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed entity");
        }
        if (val == 0 && this._pool != null) {
            this.created = false;
            this._pool.put((UtlPool.Item)this);
            _memstats.onEntityDisposed(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
        }
    }

    public final Object clone() {
        SrvMonUserStats clonee = SrvMonUserStats.create();
        SrvMonUserCounterStat[] cloner_counters = this.getCounters();
        if (cloner_counters != null) {
            SrvMonUserCounterStat[] clonee_counters = new SrvMonUserCounterStat[cloner_counters.length];
            for (int i = 0; i < cloner_counters.length; ++i) {
                clonee_counters[i] = (SrvMonUserCounterStat)cloner_counters[i].clone();
            }
            clonee.setCounters(clonee_counters);
        } else {
            clonee.setCounters(null);
        }
        SrvMonUserSeriesStat[] cloner_series = this.getSeries();
        if (cloner_series != null) {
            SrvMonUserSeriesStat[] clonee_series = new SrvMonUserSeriesStat[cloner_series.length];
            for (int i = 0; i < cloner_series.length; ++i) {
                clonee_series[i] = (SrvMonUserSeriesStat)cloner_series[i].clone();
            }
            clonee.setSeries(clonee_series);
        } else {
            clonee.setSeries(null);
        }
        SrvMonUserGaugeStat[] cloner_gauges = this.getGauges();
        if (cloner_gauges != null) {
            SrvMonUserGaugeStat[] clonee_gauges = new SrvMonUserGaugeStat[cloner_gauges.length];
            for (int i = 0; i < cloner_gauges.length; ++i) {
                clonee_gauges[i] = (SrvMonUserGaugeStat)cloner_gauges[i].clone();
            }
            clonee.setGauges(clonee_gauges);
        } else {
            clonee.setGauges(null);
        }
        return clonee;
    }

    public final boolean isValid() {
        return true;
    }

    public final void getValidationErrors(List<XString> results, String errorPrefix) {
    }

    public final String toString() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd-HH:mm:ss.SSS");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        int c = 0;
        builder.append(0 == c++ ? "" : ",").append("Counters=").append(Arrays.toString(this.getCounters()));
        builder.append(0 == c++ ? "" : ",").append("Series=").append(Arrays.toString(this.getSeries()));
        builder.append(0 == c++ ? "" : ",").append("Gauges=").append(Arrays.toString(this.getGauges()));
        builder.append("}");
        return builder.toString();
    }

    public static final class Pojo
    implements UtlPool.Item<Pojo> {
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final byte FLG_ONLY_POJOS = 8;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final long[] _fieldBitmask = new long[1];
        private final DeserializationCallback _deserializationCallback = new DeserializationCallback();
        private UtlPool<Pojo> _pool;
        private boolean _initialized;
        private boolean _readonly;
        private boolean _dirty;
        private byte _flags;
        private final XIndexedList<SrvMonUserCounterStat> _usrCounters = new XIndexedList(256);
        private final XIndexedList<SrvMonUserSeriesStat> _usrSeries = new XIndexedList(256);
        private final XIndexedList<SrvMonUserGaugeStat> _usrGauges = new XIndexedList(256);

        Pojo() {
            this.setCreated();
        }

        public static final Pojo create(boolean pvt) {
            Pojo pojo = (Pojo)_entityPojoPool.get(null);
            if (pvt) {
                pojo.setPrivate();
            } else {
                pojo.clearPrivate();
                _memstats.onEntityPojoAllocated(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, !pojo.isCreated());
            }
            return pojo.clearPooled();
        }

        public static final Pojo create() {
            return Pojo.create(false);
        }

        public final int getCountersCount() {
            return this._usrCounters.size();
        }

        public final SrvMonUserCounterStat getCountersAt(int index) {
            if (index < 0 || index >= this.getCountersCount()) {
                throw new IllegalArgumentException("index out of range");
            }
            return (SrvMonUserCounterStat)this._usrCounters.get(index);
        }

        public final XIterator<SrvMonUserCounterStat> getCountersIterator() {
            return this._usrCounters.reusableIterator();
        }

        public final void addToCounters(SrvMonUserCounterStat val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrCounters.add((Object)val);
            this._dirty = true;
        }

        public final void addToCountersFrom(SrvMonUserCounterStat.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            SrvMonUserCounterStat val = SrvMonUserCounterStat.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrCounters.add((Object)val);
            this._dirty = true;
        }

        public final void lendToCounters(SrvMonUserCounterStat val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrCounters.add((Object)val);
            this._dirty = true;
        }

        public final void clearCounters() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int size = this._usrCounters.size();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((SrvMonUserCounterStat)this._usrCounters.get(i)).dispose();
            }
            this._usrCounters.clear();
            this._dirty = true;
        }

        public final int getSeriesCount() {
            return this._usrSeries.size();
        }

        public final SrvMonUserSeriesStat getSeriesAt(int index) {
            if (index < 0 || index >= this.getSeriesCount()) {
                throw new IllegalArgumentException("index out of range");
            }
            return (SrvMonUserSeriesStat)this._usrSeries.get(index);
        }

        public final XIterator<SrvMonUserSeriesStat> getSeriesIterator() {
            return this._usrSeries.reusableIterator();
        }

        public final void addToSeries(SrvMonUserSeriesStat val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrSeries.add((Object)val);
            this._dirty = true;
        }

        public final void addToSeriesFrom(SrvMonUserSeriesStat.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            SrvMonUserSeriesStat val = SrvMonUserSeriesStat.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrSeries.add((Object)val);
            this._dirty = true;
        }

        public final void lendToSeries(SrvMonUserSeriesStat val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrSeries.add((Object)val);
            this._dirty = true;
        }

        public final void clearSeries() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int size = this._usrSeries.size();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((SrvMonUserSeriesStat)this._usrSeries.get(i)).dispose();
            }
            this._usrSeries.clear();
            this._dirty = true;
        }

        public final int getGaugesCount() {
            return this._usrGauges.size();
        }

        public final SrvMonUserGaugeStat getGaugesAt(int index) {
            if (index < 0 || index >= this.getGaugesCount()) {
                throw new IllegalArgumentException("index out of range");
            }
            return (SrvMonUserGaugeStat)this._usrGauges.get(index);
        }

        public final XIterator<SrvMonUserGaugeStat> getGaugesIterator() {
            return this._usrGauges.reusableIterator();
        }

        public final void addToGauges(SrvMonUserGaugeStat val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrGauges.add((Object)val);
            this._dirty = true;
        }

        public final void addToGaugesFrom(SrvMonUserGaugeStat.Deserializer deserializer) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (deserializer == null) {
                return;
            }
            SrvMonUserGaugeStat val = SrvMonUserGaugeStat.create();
            if (deserializer.getSerializedLength() > 0) {
                val.deserializeFrom(deserializer);
            }
            if (this.isOnlyPojos()) {
                val.pojo(true);
            }
            this._usrGauges.add((Object)val);
            this._dirty = true;
        }

        public final void lendToGauges(SrvMonUserGaugeStat val) {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            if (val == null) {
                return;
            }
            val.acquire();
            this._usrGauges.add((Object)val);
            this._dirty = true;
        }

        public final void clearGauges() {
            if (this._readonly) {
                throw new IllegalStateException("node is read only");
            }
            int size = this._usrGauges.size();
            if (size == 0) {
                return;
            }
            for (int i = 0; i < size; ++i) {
                ((SrvMonUserGaugeStat)this._usrGauges.get(i)).dispose();
            }
            this._usrGauges.clear();
            this._dirty = true;
        }

        public final void clear() {
            this._readonly = false;
            this.clearCounters();
            this.clearSeries();
            this.clearGauges();
            this._fieldBitmask[0] = 0L;
            this._dirty = true;
        }

        private final Pojo setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Pojo clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Pojo setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Pojo clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Pojo setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Pojo clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final Pojo setOnlyPojos() {
            this._flags = (byte)(this._flags | 8);
            return this;
        }

        private final boolean isOnlyPojos() {
            return (this._flags & 8) != 0;
        }

        private final Pojo clearOnlyPojos() {
            this._flags = (byte)(this._flags & 0xFFFFFFF7);
            return this;
        }

        public final void setAsReadOnly() {
            this._readonly = true;
        }

        public final boolean isInitialized() {
            return this._initialized;
        }

        public final void setInitialized() {
            this._initialized = true;
        }

        public final void clearDirty() {
            this._dirty = false;
        }

        public final void forceDirty() {
            this._dirty = true;
        }

        public final boolean isDirty() {
            return this._dirty;
        }

        public final int getSerializedLength() {
            int len = 0;
            XIterator<SrvMonUserCounterStat> countersIterator = this.getCountersIterator();
            while (countersIterator.hasNext()) {
                SrvMonUserCounterStat val = (SrvMonUserCounterStat)countersIterator.next();
                len += val.hasDirtyPojo() ? ProtobufUtil.varlenFieldSerializedLength((int)16, (int)val.pojo().getSerializedLength()) : ProtobufUtil.varlenFieldSerializedLength((int)16, (int)val.getSerializedBufferLength());
            }
            XIterator<SrvMonUserSeriesStat> seriesIterator = this.getSeriesIterator();
            while (seriesIterator.hasNext()) {
                SrvMonUserSeriesStat val = (SrvMonUserSeriesStat)seriesIterator.next();
                len += val.hasDirtyPojo() ? ProtobufUtil.varlenFieldSerializedLength((int)17, (int)val.pojo().getSerializedLength()) : ProtobufUtil.varlenFieldSerializedLength((int)17, (int)val.getSerializedBufferLength());
            }
            XIterator<SrvMonUserGaugeStat> gaugesIterator = this.getGaugesIterator();
            while (gaugesIterator.hasNext()) {
                SrvMonUserGaugeStat val = (SrvMonUserGaugeStat)gaugesIterator.next();
                len += val.hasDirtyPojo() ? ProtobufUtil.varlenFieldSerializedLength((int)18, (int)val.pojo().getSerializedLength()) : ProtobufUtil.varlenFieldSerializedLength((int)18, (int)val.getSerializedBufferLength());
            }
            return len;
        }

        public final int serialize(Serializer serializer) {
            if (!serializer.isInitialized()) {
                throw new IllegalArgumentException("serializer not initialized");
            }
            XIterator<SrvMonUserCounterStat> countersIterator = this.getCountersIterator();
            while (countersIterator.hasNext()) {
                SrvMonUserCounterStat val = (SrvMonUserCounterStat)countersIterator.next();
                serializer.counters(val);
                if (!this.isOnlyPojos()) continue;
                val.pojo(true);
            }
            XIterator<SrvMonUserSeriesStat> seriesIterator = this.getSeriesIterator();
            while (seriesIterator.hasNext()) {
                SrvMonUserSeriesStat val = (SrvMonUserSeriesStat)seriesIterator.next();
                serializer.series(val);
                if (!this.isOnlyPojos()) continue;
                val.pojo(true);
            }
            XIterator<SrvMonUserGaugeStat> gaugesIterator = this.getGaugesIterator();
            while (gaugesIterator.hasNext()) {
                SrvMonUserGaugeStat val = (SrvMonUserGaugeStat)gaugesIterator.next();
                serializer.gauges(val);
                if (!this.isOnlyPojos()) continue;
                val.pojo(true);
            }
            return serializer.done();
        }

        public final void deserialize(Deserializer deserializer) {
            if (!deserializer.isInitialized()) {
                throw new IllegalArgumentException("deserializer not initialized");
            }
            this.clear();
            deserializer.run(this._deserializationCallback);
            this._initialized = true;
        }

        public final Pojo reset() {
            this.clear();
            this._dirty = false;
            this._initialized = false;
            return this;
        }

        public final Pojo init() {
            return this.reset();
        }

        public final Pojo setPool(UtlPool<Pojo> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Pojo> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityPojoDisposed(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        private final class DeserializationCallback
        implements Deserializer.Callback {
            private DeserializationCallback() {
            }

            @Override
            public final void handleCounters(SrvMonUserCounterStat.Deserializer val) {
                Pojo.this.addToCountersFrom(val);
            }

            @Override
            public final void handleSeries(SrvMonUserSeriesStat.Deserializer val) {
                Pojo.this.addToSeriesFrom(val);
            }

            @Override
            public final void handleGauges(SrvMonUserGaugeStat.Deserializer val) {
                Pojo.this.addToGaugesFrom(val);
            }
        }
    }

    public static final class Deserializer
    implements UtlPool.Item<Deserializer> {
        private final SrvMonUserCounterStat.Deserializer _countersDeserializer = SrvMonUserCounterStat.Deserializer.create(true);
        private final SrvMonUserSeriesStat.Deserializer _seriesDeserializer = SrvMonUserSeriesStat.Deserializer.create(true);
        private final SrvMonUserGaugeStat.Deserializer _gaugesDeserializer = SrvMonUserGaugeStat.Deserializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private final IOBuffer.VarintDeserializeLength _varintDeserializeLength = new IOBuffer.VarintDeserializeLength();
        private long _addr;
        private int _offset;
        private int _len;
        private boolean _stopped;
        private UtlPool<Deserializer> _pool;
        private byte _flags;

        Deserializer() {
            this.setCreated();
        }

        public static final Deserializer create(boolean pvt) {
            Deserializer deserializer = (Deserializer)_entityDeserializerPool.get(null);
            if (pvt) {
                deserializer.setPrivate();
            } else {
                deserializer.clearPrivate();
                _memstats.onEntityDeserializerAllocated(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, !deserializer.isCreated());
            }
            return deserializer.clearPooled();
        }

        public static final Deserializer create() {
            return Deserializer.create(false);
        }

        private final Deserializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Deserializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Deserializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Deserializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Deserializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Deserializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        public final Deserializer init(long addr, int offset, int len) {
            this._addr = addr;
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final Deserializer init(IOBuffer buffer, int offset, int len) {
            this._addr = buffer.getNativeAddress();
            this._offset = offset;
            this._len = len;
            return this;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, this._offset, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)this._offset, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void run(Callback cb) {
            int flen;
            int tlen;
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            long addr = this._addr;
            int lim = this._offset + this._len;
            this._stopped = false;
            block11: for (int pos = this._offset; !this._stopped && pos < lim; pos += tlen + flen) {
                int ftag = IOBuffer.getVarint32((long)addr, (int)pos, (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                int ftype = ftag & 7;
                switch (ftag >>> 3) {
                    case 16: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 16");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleCounters(this._countersDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block11;
                    }
                    case 17: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 17");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleSeries(this._seriesDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block11;
                    }
                    case 18: {
                        if (ftype != 2) {
                            throw new IllegalStateException("field type mismatch (exp=0x02, actual=" + ftype + ") for field 18");
                        }
                        tlen = this._varintDeserializeLength.value;
                        flen = IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                        cb.handleGauges(this._gaugesDeserializer.init(addr, pos + tlen + this._varintDeserializeLength.value, flen));
                        flen += this._varintDeserializeLength.value;
                        continue block11;
                    }
                    default: {
                        switch (ftype) {
                            case 0: {
                                tlen = this._varintDeserializeLength.value;
                                IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen = this._varintDeserializeLength.value;
                                continue block11;
                            }
                            case 1: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 8;
                                continue block11;
                            }
                            case 2: {
                                tlen = this._varintDeserializeLength.value;
                                flen = IOBuffer.getVarint32((long)addr, (int)(pos + tlen), (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength);
                                flen += this._varintDeserializeLength.value;
                                continue block11;
                            }
                            case 5: {
                                tlen = this._varintDeserializeLength.value;
                                flen = 4;
                                continue block11;
                            }
                        }
                        throw new IllegalStateException("corrupt field - #" + (IOBuffer.getVarint32((long)addr, (int)pos, (IOBuffer.VarintDeserializeLength)this._varintDeserializeLength) >>> 3));
                    }
                }
            }
        }

        public final void stop() {
            this._stopped = true;
        }

        public final Deserializer init() {
            return this;
        }

        public final Deserializer setPool(UtlPool<Deserializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Deserializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntityDeserializerDisposed(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public static abstract class AbstractCallbackImpl
        implements Callback {
            @Override
            public void handleCounters(SrvMonUserCounterStat.Deserializer val) {
            }

            @Override
            public void handleSeries(SrvMonUserSeriesStat.Deserializer val) {
            }

            @Override
            public void handleGauges(SrvMonUserGaugeStat.Deserializer val) {
            }
        }

        public static interface Callback {
            public void handleCounters(SrvMonUserCounterStat.Deserializer var1);

            public void handleSeries(SrvMonUserSeriesStat.Deserializer var1);

            public void handleGauges(SrvMonUserGaugeStat.Deserializer var1);
        }
    }

    public static final class Serializer
    implements UtlPool.Item<Serializer>,
    AdmRuntime.BufferSizer {
        private final SrvMonUserCounterStat.Serializer _countersSerializer = SrvMonUserCounterStat.Serializer.create(true);
        private final SrvMonUserSeriesStat.Serializer _seriesSerializer = SrvMonUserSeriesStat.Serializer.create(true);
        private final SrvMonUserGaugeStat.Serializer _gaugesSerializer = SrvMonUserGaugeStat.Serializer.create(true);
        private static final byte FLG_CREATED = 1;
        private static final byte FLG_POOLED = 2;
        private static final byte FLG_PRIVATE = 4;
        private static final MemoryStats _memstats = MemoryStats.getInstance();
        private SrvMonUserStats _entity;
        private int _len;
        private long _addr;
        private AdmRuntime.BufferSizer _sizer;
        private UtlPool<Serializer> _pool;
        private byte _flags;

        Serializer() {
            this.setCreated();
        }

        public static final Serializer create(boolean pvt) {
            Serializer serializer = (Serializer)_entitySerializerPool.get(null);
            if (pvt) {
                serializer.setPrivate();
            } else {
                serializer.clearPrivate();
                _memstats.onEntitySerializerAllocated(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, !serializer.isCreated());
            }
            return serializer.clearPooled();
        }

        public static final Serializer create() {
            return Serializer.create(false);
        }

        private final Serializer setCreated() {
            this._flags = (byte)(this._flags | 1);
            return this;
        }

        private final boolean isCreated() {
            return (this._flags & 1) != 0;
        }

        private final Serializer clearCreated() {
            this._flags = (byte)(this._flags & 0xFFFFFFFE);
            return this;
        }

        private final Serializer setPooled() {
            this._flags = (byte)(this._flags | 2);
            return this;
        }

        private final boolean isPooled() {
            return (this._flags & 2) != 0;
        }

        private final Serializer clearPooled() {
            this._flags = (byte)(this._flags & 0xFFFFFFFD);
            return this;
        }

        private final Serializer setPrivate() {
            this._flags = (byte)(this._flags | 4);
            return this;
        }

        private final boolean isPrivate() {
            return (this._flags & 4) != 0;
        }

        private final Serializer clearPrivate() {
            this._flags = (byte)(this._flags & 0xFFFFFFFB);
            return this;
        }

        private final void ensureCapacity(int val) {
            if (this._sizer != null) {
                this._addr = this._sizer.ensureCapacity(this._addr, val);
            }
        }

        final Serializer init(SrvMonUserStats entity) {
            this.init(entity.getSerializedBuffer(), 0);
            this._entity = entity;
            return this;
        }

        public final Serializer init(long addr, int len) {
            this._entity = null;
            this._len = len;
            this._addr = addr;
            return this;
        }

        public final Serializer init(IOBuffer buffer, int len) {
            return this.init(buffer.getNativeAddress(), len);
        }

        public final Serializer init(IOBuffer buffer) {
            return this.init(buffer.getNativeAddress(), 0);
        }

        public final Serializer setSizer(AdmRuntime.BufferSizer sizer) {
            this._sizer = sizer;
            return this;
        }

        public final boolean hasSizer() {
            return this._sizer != null;
        }

        public final boolean isInitialized() {
            return this._addr != 0L;
        }

        public final int getSerializedLength() {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            return this._len;
        }

        public final void getTo(IOBuffer buffer, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (buffer.getLength() - offset < this._len) {
                throw new IllegalArgumentException("not enough space in supplied buffer");
            }
            buffer.putFrom(offset, this._addr, 0, this._len);
        }

        public final int getTo(long addr, int offset) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            IOBuffer.copy((long)this._addr, (int)0, (long)addr, (int)offset, (int)this._len);
            return this._len;
        }

        public final void putFrom(IOBuffer buffer, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            buffer.getTo(offset, this._addr, this._len, len);
            this._len += len;
        }

        public final void putFrom(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + len);
            }
            IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            this._len += len;
        }

        public final Serializer counters(SrvMonUserCounterStat val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)16, (int)serializedEntityLength));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)130);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer counters(SrvMonUserCounterStat.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)16, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)130);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer counters(SrvMonUserCounterStat.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)16, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)130);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer counters(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)16, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)130);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer counters(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)16, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)130);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final Serializer series(SrvMonUserSeriesStat val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)17, (int)serializedEntityLength));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer series(SrvMonUserSeriesStat.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)17, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer series(SrvMonUserSeriesStat.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)17, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer series(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)17, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer series(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)17, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)138);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final Serializer gauges(SrvMonUserGaugeStat val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            val.sync();
            int serializedEntityLength = val.getSerializedBufferLength();
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)18, (int)serializedEntityLength));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)146);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)serializedEntityLength);
            val.serializeTo(this._addr, this._len);
            this._len += serializedEntityLength;
            return this;
        }

        public final Serializer gauges(SrvMonUserGaugeStat.Serializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)18, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)146);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer gauges(SrvMonUserGaugeStat.Deserializer val) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null) {
                return this;
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)18, (int)val.getSerializedLength()));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)146);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)val.getSerializedLength());
            this._len += val.getTo(this._addr, this._len);
            return this;
        }

        public final Serializer gauges(IOBuffer val, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (val == null && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)18, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)146);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (val != null) {
                val.getTo(offset, this._addr, this._len, len);
            }
            this._len += len;
            return this;
        }

        public final Serializer gauges(long addr, int offset, int len) {
            if (!this.isInitialized()) {
                throw new IllegalStateException("not initialized");
            }
            if (addr == 0L && (offset > 0 || len > 0)) {
                throw new IllegalArgumentException("null buffer can only be specified with offset=0 and len=0 (to serialize an empty entity))");
            }
            if (this.hasSizer()) {
                this.ensureCapacity(this._len + ProtobufUtil.varlenFieldSerializedLength((int)18, (int)len));
            }
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)146);
            this._len += IOBuffer.putVarint32((long)this._addr, (int)this._len, (int)len);
            if (addr != 0L) {
                IOBuffer.copy((long)addr, (int)offset, (long)this._addr, (int)this._len, (int)len);
            }
            this._len += len;
            return this;
        }

        public final int done() {
            if (this._entity != null) {
                this._entity.setSerializedBufferLength(this._len);
            }
            return this._len;
        }

        public final Serializer init() {
            return this;
        }

        public final Serializer setPool(UtlPool<Serializer> pool) {
            this._pool = pool;
            return this;
        }

        public final UtlPool<Serializer> getPool() {
            return this._pool;
        }

        final void dispose() {
            this.clearCreated();
            if (this._pool != null) {
                this.setPooled();
                this._pool.put((UtlPool.Item)this);
                if (!this.isPrivate()) {
                    _memstats.onEntitySerializerDisposed(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity, true);
                }
            }
        }

        public final long ensureCapacity(long addr, int capacity) {
            this._addr = this._sizer.ensureCapacity(addr, capacity);
            return this._addr;
        }
    }

    private static final class SrvMonUserStatsDeserializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Deserializer> {
        private SrvMonUserStatsDeserializerPoolEvictedItemReceiver() {
        }

        public final void process(Deserializer evictedItem) {
            _memstats.onEntityDeserializerLeaked(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonUserStatsDeserializerPoolFactory
    implements UtlPool.Factory<Deserializer> {
        private SrvMonUserStatsDeserializerPoolFactory() {
        }

        public final Deserializer createItem(Object object) {
            return new Deserializer();
        }

        public final Deserializer[] createItemArray(int size) {
            return new Deserializer[size];
        }
    }

    private static final class SrvMonUserStatsSerializerPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Serializer> {
        private SrvMonUserStatsSerializerPoolEvictedItemReceiver() {
        }

        public final void process(Serializer evictedItem) {
            _memstats.onEntitySerializerLeaked(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonUserStatsSerializerPoolFactory
    implements UtlPool.Factory<Serializer> {
        private SrvMonUserStatsSerializerPoolFactory() {
        }

        public final Serializer createItem(Object object) {
            return new Serializer();
        }

        public final Serializer[] createItemArray(int size) {
            return new Serializer[size];
        }
    }

    private static final class SrvMonUserStatsPojoPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<Pojo> {
        private SrvMonUserStatsPojoPoolEvictedItemReceiver() {
        }

        public final void process(Pojo evictedItem) {
            _memstats.onEntityPojoLeaked(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonUserStatsPojoPoolFactory
    implements UtlPool.Factory<Pojo> {
        private SrvMonUserStatsPojoPoolFactory() {
        }

        public final Pojo createItem(Object object) {
            return new Pojo();
        }

        public final Pojo[] createItemArray(int size) {
            return new Pojo[size];
        }
    }

    private static final class SrvMonUserStatsPoolEvictedItemReceiver
    implements UtlPool.EvictedItemReceiver<SrvMonUserStats> {
        private SrvMonUserStatsPoolEvictedItemReceiver() {
        }

        public final void process(SrvMonUserStats evictedItem) {
            _memstats.onEntityLeaked(SrvMonUserStats.class, MemoryStats.EntityType.EmbeddedEntity);
        }
    }

    private static final class SrvMonUserStatsPoolFactory
    implements UtlPool.Factory<SrvMonUserStats> {
        private SrvMonUserStatsPoolFactory() {
        }

        public final SrvMonUserStats createItem(Object object) {
            return new SrvMonUserStats();
        }

        public final SrvMonUserStats[] createItemArray(int size) {
            return new SrvMonUserStats[size];
        }
    }

    static final class SrvMonUserStatsPoolFactoryItemCreateArgument {
        UUID id;
        boolean wasCreated;

        SrvMonUserStatsPoolFactoryItemCreateArgument() {
        }

        SrvMonUserStatsPoolFactoryItemCreateArgument init(UUID id) {
            this.id = id;
            this.wasCreated = false;
            return this;
        }
    }

    public static final class PacketBody
    extends PktBodyData {
        private PacketBody(Properties props) {
            super(1052862, props);
        }

        public static PktBody create(Properties props) {
            return new PacketBody(props);
        }

        public static PktBody create() {
            return PacketBody.create(null);
        }
    }
}

