/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.build.XarPackager;
import com.neeve.config.Config;
import com.neeve.controller.ControllerError;
import com.neeve.controller.ProgressMonitor;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.TraceSniffer;
import com.neeve.controller.XVM;
import com.neeve.controller.XVMUnreachableException;
import com.neeve.deploy.Model;
import com.neeve.deploy.Server;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.server.admin.AdminSession;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlTailoring;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlUnit;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public final class Controller {
    private static final String SYSTEMS_ROOT = "systems";
    private static final String SYSTEM_ARCHIVED = ".archived";
    private static final String SYSTEM_JARDIR = "jars";
    private static final String EXT_DIR = "ext";
    private static final String TEMPSYSTEM_DIR = "temp";
    private static final FilenameFilter _xarFileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(".xar");
        }
    };
    private static final FileFilter _systemsFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory() && !file.getName().startsWith(".");
        }
    };
    private final File _confFile;
    private final String _resolvedDiscoveryDescriptor;
    private final String _home;
    private final String _javaHome;
    private final Model _model;
    private final Tracer _tracer;
    private final Tracer _troubleshootingTracer;
    private final File _deployFolder;
    private long _confFileLastModified;
    private Properties __conf;
    private TraceSniffer _traceSniffer;
    private TraceSniffer _troubleshootingTraceSniffer;
    private String _distributionPlatform;
    private int _distributionMajorVersion;
    private int _distributionMinorVersion;
    private XLinkedHashMap<String, System> _systems = new XLinkedHashMap();

    private Controller(String discoveryDescriptor) throws Exception {
        this._tracer = Tracer.get((String)"nv.controller");
        this._troubleshootingTracer = Tracer.get((String)"nv.controller.troubleshooting");
        String confFileName = Config.getValue((String)"RUMI.CONTROLLER.CONF", null);
        this._confFile = confFileName != null ? new File(confFileName) : null;
        this._home = UtlProps.getValue((Properties)this.getConfig(), (String)"RUMI.CONTROLLER.HOME", null);
        this._javaHome = UtlProps.getValue((Properties)this.getConfig(), (String)"JAVA.HOME", null);
        if (this._home != null) {
            this._deployFolder = new File(this._home, "deploy");
            if (!this._deployFolder.exists()) {
                this._deployFolder.mkdirs();
            }
        } else {
            this._deployFolder = null;
        }
        boolean discoveryProvided = discoveryDescriptor != null;
        File distribution = this.getDistribution();
        this.trace("", Tracer.Level.INFO);
        this.trace("Configuration {", Tracer.Level.INFO);
        this.trace("...HOME=" + this._home, Tracer.Level.INFO);
        this.trace("...CONF=" + (this._confFile == null ? "<env>" : this._confFile), Tracer.Level.INFO);
        this.trace("...JAVA_HOME=" + this._javaHome, Tracer.Level.INFO);
        this.trace("...SSH {", Tracer.Level.INFO);
        this.trace("......User=" + this.getSshUser(), Tracer.Level.INFO);
        this.trace("......Key=" + this.getSshKeyFile(), Tracer.Level.INFO);
        this.trace("...}", Tracer.Level.INFO);
        this.trace("...Systems Folder=" + this.getSystemsDir(), Tracer.Level.INFO);
        this.trace("...Ext Lib=" + this.getExtDir(), Tracer.Level.INFO);
        this.trace("...Local XVM Sandbox Root=" + this.getLocalXVMSandboxRoot(), Tracer.Level.INFO);
        this.trace("}", Tracer.Level.INFO);
        this.trace("", Tracer.Level.INFO);
        this.trace("X Distribution=" + distribution, Tracer.Level.INFO);
        this.trace("...platform=" + this._distributionPlatform, Tracer.Level.INFO);
        this.trace("...version=" + this._distributionMajorVersion + "." + this._distributionMinorVersion, Tracer.Level.INFO);
        if (discoveryProvided) {
            this.trace("Discovery=" + discoveryDescriptor + " (PROVIDED)", Tracer.Level.INFO);
        } else {
            String configDiscoveryDescriptor = UtlProps.getValue((Properties)this.getConfig(), (String)"nv.discovery.descriptor", null);
            String envDiscoveryDescriptor = Config.getValue((String)"nv.discovery.descriptor", null);
            if (configDiscoveryDescriptor != null && envDiscoveryDescriptor != configDiscoveryDescriptor) {
                discoveryDescriptor = configDiscoveryDescriptor;
                this.trace("Discovery=" + discoveryDescriptor + " (CONF)", Tracer.Level.INFO);
            } else if (envDiscoveryDescriptor != null) {
                discoveryDescriptor = envDiscoveryDescriptor;
                this.trace("Discovery=" + discoveryDescriptor + " (ENV)", Tracer.Level.INFO);
            } else {
                this.trace("Discovery=" + DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR + " (DEFAULT)", Tracer.Level.INFO);
            }
        }
        this.trace("", Tracer.Level.INFO);
        this.trace("Admin Transport=" + UtlProps.getValue((Properties)this.getConfig(), (String)"nv.server.admin.transports", (String)"direct"), Tracer.Level.INFO);
        this._resolvedDiscoveryDescriptor = discoveryDescriptor;
        String applicationName = UtlProps.getValue((Properties)this.getConfig(), (String)"nv.controller.app.name", (String)("RumiController-" + UUID.randomUUID().toString()));
        this.trace("Discovering hosts...", Tracer.Level.INFO);
        this._model = new Model(applicationName, this._resolvedDiscoveryDescriptor, this._tracer);
        this._model.setServerConnectionProperties(this.getConfig());
        this._model.setServerCommandTimeout(this.getXVMCommandTimeout(this.__conf));
        this._model.setServerConnectHandshakeTimeout(this.getXVMConnectHandshakeTimeout());
        this._model.setServerConnectRetryInterval(this.getXVMConnectRetryInterval());
        this._model.open();
        this.trace("Refreshing systems...", Tracer.Level.INFO);
        this.refreshSystems(true);
        this.trace("..." + this._systems.size() + " System" + (this._systems.size() != 1 ? "s loaded." : " loaded."), Tracer.Level.INFO);
    }

    public Controller() throws Exception {
        this(null);
    }

    public static Controller create(String discoveryDescriptor) throws Exception {
        return new Controller(discoveryDescriptor);
    }

    public static Controller create() throws Exception {
        return Controller.create(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseDistributionPlatformAndVersion(File distribution) {
        this._distributionPlatform = null;
        if (distribution == null) return;
        String distributionName = distribution.getName().replace("_", "-");
        if (distributionName.endsWith(".tar.gz")) {
            distributionName = distributionName.substring(0, distributionName.lastIndexOf(".tar.gz"));
        } else {
            if (!distributionName.endsWith(".zip")) throw new IllegalArgumentException("unable to parse platform from '" + distribution.getName() + "' [unknown file extension]");
            distributionName = distributionName.substring(0, distributionName.lastIndexOf(".zip"));
        }
        String[] distributionNameElements = distributionName.split("-");
        if (distributionNameElements.length < 9) throw new IllegalArgumentException("unable to parse platform from '" + distribution.getName() + "' [distribution not of the form nvx-[rumi]-<version>-<jre>-<jreversion>-<platform>-<type>]");
        this._distributionPlatform = distributionNameElements[distributionNameElements.length - 4] + "-" + distributionNameElements[distributionNameElements.length - 3] + "-" + distributionNameElements[distributionNameElements.length - 2];
        String distributionVersion = distributionNameElements[2];
        String[] distributionVersionElements = distributionVersion.split("\\.");
        if ((distributionVersionElements.length != 2 || !distributionNameElements[3].equals("SNAPSHOT")) && distributionVersionElements.length != 3) throw new IllegalArgumentException("unable to parse version from '" + distribution.getName() + "' [version is not in the form of x.y.z or x.y-SNAPSHOT]");
        try {
            this._distributionMajorVersion = Integer.parseInt(distributionVersionElements[0]);
            this._distributionMinorVersion = Integer.parseInt(distributionVersionElements[1]);
            return;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("unable to parse version from '" + distribution.getName() + "' [version is not in the form of x.y.z or x.y-SNAPSHOT]");
        }
    }

    private final int getXVMConnectHandshakeTimeout(Properties props) {
        return (int)UtlUnit.parseDuration((String)UtlProps.getValue((Properties)props, (String)"nv.controller.xvmconnecthandshaketimeout", (String)"15s"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private final int getXVMConnectRetryInterval(Properties props) {
        return (int)UtlUnit.parseDuration((String)UtlProps.getValue((Properties)props, (String)"nv.controller.xvmconnectretryinterval", (String)"1s"), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private final int getXVMCommandTimeout(Properties props) {
        return (int)UtlUnit.parseDuration((String)UtlProps.getValue((Properties)props, (String)"nv.controller.xvmcommandtimeout", (String)UtlProps.getValue((Properties)props, (String)"nv.controller.servercommandtimeout", (String)"30s")), (TimeUnit)TimeUnit.MILLISECONDS, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    private final void deleteSystem(String systemName, boolean archived) throws IOException {
        String rootFolder = archived ? this.getArchivedSystemsDir() : this.getSystemsDir();
        File systemFolder = new File(rootFolder + File.separator + systemName);
        if (systemFolder.exists() && systemFolder.isDirectory()) {
            UtlFile.deleteDirectory((File)systemFolder);
        }
    }

    private final void moveFolder(String src, String dest) throws IOException {
        File srcFile = new File(src);
        File destFile = new File(dest);
        destFile.mkdirs();
        srcFile.renameTo(destFile);
    }

    final void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    final void error(String str) {
        this.trace("ERROR: " + str, Tracer.Level.SEVERE);
        throw new ControllerError(str);
    }

    final void error(String str, Throwable thrown) {
        this.trace("ERROR: " + str, Tracer.Level.SEVERE);
        throw new ControllerError(str, thrown);
    }

    final void traceForTroubleshooting(String str, Tracer.Level level) {
        this._troubleshootingTracer.log(str, level);
        if (level.val < Tracer.Level.OFF.val && level.val > Tracer.Level.ALL.val && level.val >= this._troubleshootingTracer.getLevel().val && this._troubleshootingTraceSniffer != null) {
            this._troubleshootingTraceSniffer.log(str);
        }
    }

    final void trace(String str, Tracer.Level level) {
        this.traceForTroubleshooting(str, level);
        this._tracer.log(str, level);
        if (level.val < Tracer.Level.OFF.val && level.val > Tracer.Level.ALL.val && level.val >= this._tracer.getLevel().val && this._traceSniffer != null) {
            this._traceSniffer.log(str);
        }
    }

    final String resolveScript(String name) {
        String fullName = this._home + File.separator + "bin" + File.separator + "internal" + File.separator + name + ".sh";
        return new File(fullName).exists() ? fullName : this._home + File.separator + "bin" + File.separator + "internal" + File.separator + name + ".bat";
    }

    final synchronized Object remoteCommand(String xvmName, String appName, String command, boolean sync, boolean waitForXVMToLaunch, int numAppPingAttempts, ProgressMonitor progressMonitor) throws Exception {
        String warningMessage;
        StringBuilder sb;
        Thread.sleep(100L);
        AdminSession session = null;
        int numXVMConnectAttempts = (waitForXVMToLaunch ? this.getXVMLaunchTimeout() : 1) + 4;
        for (int j = 0; j < numXVMConnectAttempts; ++j) {
            sb = new StringBuilder();
            sb.append("......connecting to xvm '" + xvmName + "'....");
            try {
                String infoMessage;
                Server server = this._model.getServer(xvmName);
                if (server != null) {
                    switch (server.getState()) {
                        case Init: {
                            --j;
                            throw new Exception("xvm running. waiting to connect...");
                        }
                        case Connect: {
                            String lastConnectExceptionMessage = server.getLastConnectException() != null ? (server.getLastConnectException().getMessage() != null ? server.getLastConnectException().getMessage() : server.getLastConnectException().toString()) : null;
                            throw new Exception("xvm running. connecting..." + (lastConnectExceptionMessage != null ? " (lastConnectResult = '" + lastConnectExceptionMessage + "')" : ""));
                        }
                        case Inert: {
                            throw new Exception("xvm is running but given up connecting to it");
                        }
                        case Failed: {
                            throw new Exception("xvm has stopped or failed");
                        }
                        case Open: {
                            session = server.getSession();
                            break;
                        }
                        case Closed: {
                            throw new Exception("xvm is running but connection to it is closed");
                        }
                        default: {
                            throw new Exception("unknown xvm state '" + server.getState() + "'");
                        }
                    }
                }
                if (session != null) {
                    sb.append("ok");
                    infoMessage = sb.toString();
                    if (progressMonitor != null) {
                        progressMonitor.onTrace(infoMessage, Tracer.Level.INFO);
                    }
                } else {
                    throw new Exception("xvm not running");
                }
                this.trace(infoMessage, Tracer.Level.INFO);
                break;
            }
            catch (Exception e) {
                sb.append("X (" + e.getMessage() + ")");
                warningMessage = sb.toString();
                if (progressMonitor != null) {
                    progressMonitor.onTrace(warningMessage, Tracer.Level.WARNING);
                }
                this.trace(warningMessage, Tracer.Level.WARNING);
                if (j >= numXVMConnectAttempts - 1) continue;
                this.sleep(1000L);
                continue;
            }
        }
        if (session == null) {
            throw new XVMUnreachableException(xvmName);
        }
        if (appName != null) {
            int i;
            for (i = 0; i < numAppPingAttempts; ++i) {
                sb = new StringBuilder();
                sb.append("......pinging app '" + appName + "'....");
                try {
                    session.invokeCommand("server", "app_ping", new Object[]{appName});
                    sb.append("ok");
                    String infoMessage = sb.toString();
                    if (progressMonitor != null) {
                        progressMonitor.onTrace(infoMessage, Tracer.Level.INFO);
                    }
                    this.trace(infoMessage, Tracer.Level.INFO);
                    break;
                }
                catch (Exception e) {
                    sb.append("X (" + e.getMessage() + ")");
                    warningMessage = sb.toString();
                    if (progressMonitor != null) {
                        progressMonitor.onTrace(warningMessage, Tracer.Level.WARNING);
                    }
                    this.trace(warningMessage, Tracer.Level.WARNING);
                    this.sleep(5000L);
                    continue;
                }
            }
            if (i == numAppPingAttempts) {
                throw new Exception("app '" + appName + "' is unreachable.");
            }
        }
        Object response = null;
        if (command != null) {
            String infoMessage = "......sending '" + command + "' command (to " + (appName != null ? "app" : "xvm") + ")...";
            if (progressMonitor != null) {
                progressMonitor.onTrace(infoMessage, Tracer.Level.INFO);
            }
            this.trace(infoMessage, Tracer.Level.INFO);
            String target = appName;
            if (target == null) {
                target = "server";
            }
            int timeout = sync ? this.getXVMCommandTimeout() : -1;
            response = session.invokeCommandLine(timeout, target, command);
        }
        return response;
    }

    final synchronized Object remoteCommand(String xvmName, String appName, String command, boolean sync, int numAppPingAttempts, ProgressMonitor progressMonitor) throws Exception {
        return this.remoteCommand(xvmName, appName, command, sync, false, numAppPingAttempts, progressMonitor);
    }

    final Properties getConfigThrowRuntimeException() {
        try {
            return this.getConfig();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    final long lastConfigModificationTime() {
        try {
            this.getConfig();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this._confFileLastModified;
    }

    final String getLocalXVMSandboxRoot() {
        return UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.xvm.localsandboxroot", (String)UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.runroot.default", (String)this._home));
    }

    public final File resolveSystemHome(String systemName) {
        File systemDir;
        File file = systemDir = new File(systemName).isAbsolute() ? new File(systemName) : new File(this.getSystemsDir() + File.separator + systemName);
        if (!systemDir.exists()) {
            throw new IllegalArgumentException("System '" + systemDir.getAbsolutePath() + " does not exist.");
        }
        if (!systemDir.isDirectory()) {
            throw new IllegalArgumentException("Invalid system '" + systemDir.getAbsolutePath() + "' [not a directory]");
        }
        return systemDir;
    }

    public final File getConfigFile() {
        return this._confFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized Properties getConfig() throws IOException {
        boolean confFileDeleted;
        boolean confFileExists = this._confFile != null && this._confFile.exists();
        long lastModified = confFileExists ? this._confFile.lastModified() : 0L;
        boolean confFileModified = confFileExists && lastModified > this._confFileLastModified;
        boolean bl = confFileDeleted = !confFileExists && this._confFileLastModified > 0L;
        if (this.__conf == null || confFileModified || confFileDeleted) {
            this.__conf = Config.getPropertiesCopy();
            if (confFileExists) {
                try (FileInputStream fis = new FileInputStream(this._confFile);){
                    this.__conf.load(fis);
                    PropertiesPropSource substSource = new PropertiesPropSource(this.__conf);
                    for (String propName : this.__conf.stringPropertyNames()) {
                        String propValue;
                        String substPropValue = propValue = this.__conf.getProperty(propName);
                        try {
                            substPropValue = UtlTailoring.substitute((String)propValue, (UtlTailoring.PropertySource)substSource);
                        }
                        catch (Throwable e) {
                            this.traceForTroubleshooting("Failed during env variable subst in controller.conf (prop=" + propName + ") :" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                        }
                        this.__conf.setProperty(propName, substPropValue);
                    }
                }
            }
            this._confFileLastModified = lastModified;
            if (this._model != null) {
                this._model.setServerConnectionProperties(this.__conf);
                this._model.setServerCommandTimeout(this.getXVMCommandTimeout(this.__conf));
                this._model.setServerConnectHandshakeTimeout(this.getXVMConnectHandshakeTimeout(this.__conf));
                this._model.setServerConnectRetryInterval(this.getXVMConnectRetryInterval(this.__conf));
            }
        }
        return this.__conf;
    }

    public final synchronized void flushConfig() {
        this.__conf = null;
        Config.resetEnvironment();
    }

    public final String getHome() {
        return this._home;
    }

    public final String getJavaHome() {
        return this._javaHome;
    }

    public final String getResolvedDiscoveryDescriptor() {
        return this._resolvedDiscoveryDescriptor;
    }

    public final String getSshUser() {
        return UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.sshuser", null);
    }

    public final String getSshKeyFile() {
        return UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.sshkeyfile", null);
    }

    public final int getXVMConnectHandshakeTimeout() {
        return this.getXVMConnectHandshakeTimeout(this.getConfigThrowRuntimeException());
    }

    public final int getXVMConnectRetryInterval() {
        return this.getXVMConnectRetryInterval(this.getConfigThrowRuntimeException());
    }

    public final int getXVMLaunchTimeout() {
        return (int)UtlUnit.parseDuration((String)UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.xvmlaunchtimeout", (String)UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.serverlaunchtimeout", (String)"30s")), (TimeUnit)TimeUnit.SECONDS, (TimeUnit)TimeUnit.SECONDS);
    }

    public final int getXVMCommandTimeout() {
        return this.getXVMCommandTimeout(this.getConfigThrowRuntimeException());
    }

    public final boolean isTreatUnreachableXVMAsNonFatal() {
        return UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.treatunreachablexvmasnonfatal", (boolean)UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.treatunreacahbleserverasnonfatal", (boolean)false));
    }

    public final File getDistribution() {
        File[] files;
        if (this._home != null && (files = new File(this._home).listFiles(new FilenameFilter(){

            @Override
            public final boolean accept(File dir, String name) {
                return !new File(name).isDirectory() && name.startsWith("nvx-") && (name.endsWith(".tar.gz") || name.endsWith(".zip"));
            }
        })) != null && files.length > 0) {
            Arrays.sort(files, new Comparator<File>(){

                @Override
                public final int compare(File f1, File f2) {
                    if (f1.lastModified() < f2.lastModified()) {
                        return -1;
                    }
                    if (f1.lastModified() > f2.lastModified()) {
                        return 1;
                    }
                    return 0;
                }
            });
            File distribution = files[files.length - 1];
            this.parseDistributionPlatformAndVersion(distribution);
            return distribution;
        }
        return null;
    }

    public final String getDistributionPlatform() {
        return this._distributionPlatform;
    }

    public final int getDistributionMajorVersion() {
        return this._distributionMajorVersion;
    }

    public final int getDistributionMinorVersion() {
        return this._distributionMinorVersion;
    }

    public final Controller setTraceSniffer(TraceSniffer traceSniffer) {
        this._traceSniffer = traceSniffer;
        return this;
    }

    public final Controller setTroubleshootingTraceSniffer(TraceSniffer traceSniffer) {
        this._troubleshootingTraceSniffer = traceSniffer;
        return this;
    }

    public final Model getModel() {
        return this._model;
    }

    public void refreshSystems(boolean forceReload) {
        List<String> systemNames = this.getSystemNames();
        if (forceReload) {
            this._systems.clear();
        } else {
            this._systems.keySet().retainAll(systemNames);
        }
        for (String systemName : this.getSystemNames()) {
            try {
                this.getSystem(systemName);
            }
            catch (Exception e) {
                this.traceForTroubleshooting("Error refreshing system '" + systemName + ":" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
            }
        }
    }

    public System getSystem(String systemName) throws Exception {
        System system = (System)this._systems.get((Object)systemName);
        if (system == null) {
            try {
                this.traceForTroubleshooting("Loading System '" + systemName + "'", Tracer.Level.INFO);
                File systemDir = this.resolveSystemHome(systemName);
                system = new System(systemName, systemDir, this, true);
                this._systems.put((Object)systemName, (Object)system);
                this.traceForTroubleshooting("System '" + system.getName() + "' Loaded", Tracer.Level.INFO);
            }
            catch (Exception e) {
                this.traceForTroubleshooting("Error loading system '" + systemName + "':" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                throw e;
            }
        }
        if (system.isConfigStale()) {
            this.traceForTroubleshooting("System '" + systemName + " 'configuration is stale ... reconfiguring", Tracer.Level.INFO);
            try {
                system.configure(true);
            }
            catch (Exception e) {
                this.traceForTroubleshooting("Error configuring system '" + systemName + "':" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                this._systems.remove((Object)systemName);
                throw e;
            }
        }
        return system;
    }

    public final List<String> getSystemNames() {
        ArrayList<String> systemNames = new ArrayList<String>();
        File systemsHome = new File(this.getSystemsDir());
        if (systemsHome.exists()) {
            File[] systemDirs = systemsHome.listFiles(_systemsFileFilter);
            for (int i = 0; i < systemDirs.length; ++i) {
                systemNames.add(systemDirs[i].getName());
            }
        }
        return systemNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkAndDeployNewXars() {
        block14: {
            this.trace("Checking for new xars...", Tracer.Level.DEBUG);
            try {
                File[] xars;
                File[] fileArray = xars = this._deployFolder == null ? new File[]{} : this._deployFolder.listFiles(_xarFileFilter);
                if (xars.length > 0) {
                    for (File xar : xars) {
                        this.trace("Deploying new xar..." + xar.getName(), Tracer.Level.INFO);
                        String xarName = xar.getName();
                        String systemName = xarName.substring(0, xarName.lastIndexOf(".xar"));
                        File extractionDir = new File(this.getSystemsDir() + File.separator + systemName);
                        this.trace("......extracting...", Tracer.Level.INFO);
                        try {
                            if (extractionDir.exists()) {
                                if (extractionDir.isFile()) {
                                    extractionDir.delete();
                                } else {
                                    UtlFile.deleteDirectory((File)extractionDir);
                                }
                            }
                            extractionDir.mkdirs();
                            XarPackager.extract(xar, extractionDir, this._tracer.debug);
                            xar.delete();
                        }
                        catch (IOException e) {
                            this.trace("Failed to extract " + xar + ": " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                            this.trace("", Tracer.Level.DEBUG);
                            return;
                        }
                        if (this._home == null) continue;
                        File extDir = new File(this.getExtDir());
                        File systemJarsDir = new File(this.getSystemsDir() + File.separator + systemName + File.separator + SYSTEM_JARDIR);
                        this.trace("......copying jars from '" + extDir + "' to '" + systemJarsDir + "'...", Tracer.Level.VERBOSE);
                        try {
                            UtlFile.copyDirectory((File)extDir, (File)systemJarsDir);
                        }
                        catch (IOException e) {
                            this.trace("Failed to copy jars from ext directory ('" + extDir + "') to system jars directory ('" + systemJarsDir + "') :" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.SEVERE);
                            this.trace("", Tracer.Level.DEBUG);
                            return;
                        }
                    }
                    break block14;
                }
                this.trace("...<no new xars>", Tracer.Level.DEBUG);
            }
            finally {
                this.trace("", Tracer.Level.DEBUG);
            }
        }
    }

    public final Script createScript(System system) throws Exception {
        return this.createScript(system, null);
    }

    public final Script createScript(System system, ProgressMonitor progressMonitor) throws Exception {
        if (this._home == null) {
            this.error("RUMI_CONTROLLER_HOME needs to be specified for scripting");
        }
        if (this._javaHome == null) {
            this.error("JAVA_HOME needs to be specified for scripting");
        }
        if (this.getDistribution() == null) {
            this.error("Failed to resolve a distribution to use as the X runtime. Specify via 'nv.controller.xdistribution' or copy distribution into RUMI_CONTROLLER_HOME");
        }
        return new Script(this, system, progressMonitor);
    }

    public final void close() {
        if (this._model != null) {
            this._model.close();
        }
    }

    public final String getSystemsDir() {
        return UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.systemsroot", (String)(this._home != null ? this._home : ".")) + File.separator + SYSTEMS_ROOT;
    }

    public final String getArchivedSystemsDir() {
        return this.getSystemsDir() + File.separator + SYSTEM_ARCHIVED;
    }

    public final String getExtDir() {
        return UtlProps.getValue((Properties)this.getConfigThrowRuntimeException(), (String)"nv.controller.extroot", (String)(this._home != null ? this._home : ".")) + File.separator + EXT_DIR;
    }

    public List<String> getArchivedSystemNames() {
        ArrayList<String> archivedSystemNames = new ArrayList<String>();
        File archivedSystemsHome = new File(this.getArchivedSystemsDir());
        if (archivedSystemsHome.exists()) {
            File[] systemDirs = archivedSystemsHome.listFiles(_systemsFileFilter);
            for (int i = 0; i < systemDirs.length; ++i) {
                archivedSystemNames.add(systemDirs[i].getName());
            }
        }
        return archivedSystemNames;
    }

    public void deleteSystem(String systemName) throws IOException {
        this.deleteSystem(systemName, false);
    }

    public void deleteArchivedSystem(String systemName) throws IOException {
        this.deleteSystem(systemName, true);
    }

    public void archiveSystem(String systemName) throws Exception {
        String archiveFolderPath = this.getArchivedSystemsDir() + File.separator + systemName;
        File archiveFolder = new File(archiveFolderPath);
        if (archiveFolder.exists()) {
            throw new IllegalArgumentException("System '" + systemName + " archive already exists.");
        }
        String systemFolderPath = this.getSystemsDir() + File.separator + systemName;
        File systemFolder = new File(systemFolderPath);
        if (!systemFolder.exists()) {
            return;
        }
        this.moveFolder(systemFolderPath, archiveFolderPath);
    }

    public void restoreSystem(String systemName) throws Exception {
        String systemFolderPath = this.getSystemsDir() + File.separator + systemName;
        File systemFoder = new File(systemFolderPath);
        if (systemFoder.exists()) {
            throw new IllegalArgumentException("System '" + systemName + "' already exists.");
        }
        String archiveFolderPath = this.getArchivedSystemsDir() + File.separator + systemName;
        File archiveFolder = new File(archiveFolderPath);
        if (!archiveFolder.exists()) {
            throw new IllegalArgumentException("Archive '" + systemName + "' does not exist.");
        }
        this.moveFolder(archiveFolderPath, systemFolderPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String writeSingleCommandScript(File systemDir, String command) throws Exception {
        File scriptDir = new File(systemDir + File.separator + "scripts");
        scriptDir.mkdirs();
        String scriptFilename = UUID.randomUUID().toString();
        try (PrintWriter writer = new PrintWriter(scriptDir + File.separator + scriptFilename);){
            writer.println(command);
        }
        return scriptFilename;
    }

    private static final String prepareForSingleCommand(String command) throws Exception {
        File systemDir;
        String home = java.lang.System.getenv("RUMI_CONTROLLER_HOME");
        if (home == null) {
            java.lang.System.err.println("RUMI_CONTROLLER_HOME needs to be specified");
            java.lang.System.exit(1);
        }
        if ((systemDir = new File(home + File.separator + TEMPSYSTEM_DIR)).exists()) {
            UtlFile.deleteDirectory((File)systemDir);
        }
        systemDir.mkdirs();
        return Controller.writeSingleCommandScript(systemDir, command);
    }

    private static final void printUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage Controller [{-s, --system} specifies the system to use (required parameter)]").append("\n");
        sb.append("                 [{-c, --script} specifies the script to run (required parameter must be present under <system>/scripts)]").append("\n");
        sb.append("                 [{-p, --params} a comma delimited set of key value pairs that provide script parameter values (not required parameter]").append("\n");
        sb.append("                 [{-i, --single} specifies a single command to run").append("\n");
        sb.append("                 [{-h, --help} print this help string]").append("\n");
        java.lang.System.out.println(sb.toString());
        java.lang.System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block27: {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option singleOption = parser.addBooleanOption('i', "single");
            CmdLineParser.Option systemNameOption = parser.addStringOption('s', "system");
            CmdLineParser.Option scriptNameOption = parser.addStringOption('c', "script");
            CmdLineParser.Option scriptParamsOption = parser.addStringOption('p', "params");
            CmdLineParser.Option helpOption = parser.addBooleanOption('h', "help");
            try {
                parser.parse(args);
                if (!((Boolean)parser.getOptionValue(helpOption, (Object)false)).booleanValue()) {
                    boolean single = (Boolean)parser.getOptionValue(singleOption, (Object)false);
                    String systemName = (String)parser.getOptionValue(systemNameOption, null);
                    String scriptName = (String)parser.getOptionValue(scriptNameOption, null);
                    String scriptParams = (String)parser.getOptionValue(scriptParamsOption, null);
                    try {
                        block26: {
                            if (single) {
                                if (scriptName != null || systemName != null | scriptParams != null) {
                                    java.lang.System.err.println("ERROR: System, script or script parameters cannot be specified for single command runs");
                                    Controller.printUsage();
                                }
                                if (args.length < 2) {
                                    Controller.printUsage();
                                }
                                StringBuilder command = new StringBuilder();
                                for (int i = 1; i < args.length; ++i) {
                                    command.append(args[i]);
                                    if (i >= args.length - 1) continue;
                                    command.append(" ");
                                }
                                systemName = TEMPSYSTEM_DIR;
                                scriptName = Controller.prepareForSingleCommand(command.toString());
                            }
                            try (Controller controller = new Controller();){
                                controller.checkAndDeployNewXars();
                                System system = controller.getSystem(systemName);
                                if (system != null) {
                                    controller.trace("XVM Locations", Tracer.Level.INFO);
                                    Collection<XVM> xvms = system.getXVMs();
                                    if (xvms.size() > 0) {
                                        for (XVM xvm : xvms) {
                                            controller.trace("..." + xvm.name() + "=" + xvm.toString(), Tracer.Level.INFO);
                                        }
                                    } else {
                                        controller.trace("...<no XVMs>", Tracer.Level.INFO);
                                    }
                                    controller.trace("", Tracer.Level.INFO);
                                    StringTokenizer tokenizer = new StringTokenizer(scriptName, ",");
                                    while (tokenizer.hasMoreTokens()) {
                                        controller.createScript(system).parseFromFile(tokenizer.nextToken(), scriptParams).run();
                                    }
                                    break block26;
                                }
                                throw new IllegalArgumentException("System '" + systemName + "' not found.");
                            }
                        }
                        java.lang.System.exit(0);
                    }
                    catch (Exception e) {
                        if (e.getMessage() != null) {
                            java.lang.System.err.println("ERROR: " + UtlThrowable.prepareStackTrace((Throwable)e));
                        } else {
                            e.printStackTrace();
                        }
                        java.lang.System.exit(1);
                    }
                    break block27;
                }
                Controller.printUsage();
            }
            catch (CmdLineParser.OptionException e) {
                java.lang.System.err.println("ERROR: " + e.getMessage());
                Controller.printUsage();
            }
        }
    }

    private static final class PropertiesPropSource
    implements UtlTailoring.PropertySource {
        Properties props;

        PropertiesPropSource(Properties props) {
            this.props = props;
        }

        public String getValue(String key, String defaultValue) {
            return this.props.getProperty(key, defaultValue);
        }
    }
}

