/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkOpCancelledException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkObject;
import com.neeve.link.LnkRegistry;
import com.neeve.link.LnkSTRContainer;
import com.neeve.pkt.PktPacket;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;

public abstract class LnkHandshaker
extends LnkObject {
    private final RootConfig.ObjectConfig config;
    private final ILnkPeerEndpoint pep;
    private final IEmxAlarmEvent alarmEvent;
    private final int timeout;
    private final short ltp;
    private final CompletionData completionData;
    private LnkContainer pepContainer;
    private LnkSTRContainer handshakeContainer;
    private boolean flgOriginalReadStopped;
    private boolean flgJoined;
    private boolean flgMigrated;
    private boolean flgHandshakeReadStarted;
    private State state;

    protected LnkHandshaker(RootConfig.ObjectConfig config, ILnkPeerEndpoint pep, int timeout, short ltp, State state) {
        super(config);
        this.config = config;
        if (state != State.ACCEPTED && state != State.CONNECTED) {
            throw new IllegalArgumentException("Invalid initial state '" + (Object)((Object)state) + "'");
        }
        this.pep = pep;
        this.timeout = timeout * 1000;
        this.ltp = ltp;
        this.state = state;
        this.alarmEvent = this.timeout > 0 ? EmxFactory.getInstance().createAlarmEvent(EmxFactory.EmxImpl.DEFAULT, new TimeoutEventHandler(), this.timeout) : null;
        this.completionData = new CompletionData(this.state);
    }

    private final void sendRequest() throws Exception {
        PktPacket request;
        this.completionData.request = request = this.prepareRequest();
        try {
            this.pep.enque(this.ltp, request, null, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void processRequest(PktPacket request) throws Exception {
        PktPacket reply;
        this.completionData.request = request;
        this.validateRequest(request);
        this.completionData.reply = reply = this.prepareReply(request);
        try {
            this.pep.enque(this.ltp, reply, null, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void processReply(PktPacket reply) throws Exception {
        this.completionData.reply = reply;
        this.validateReply(reply);
    }

    private final void executePrologue() throws Exception {
        this.flgOriginalReadStopped = false;
        this.flgJoined = false;
        this.flgMigrated = false;
        this.flgHandshakeReadStarted = false;
        if (this.tracer.debug) {
            this.tracer.log("Stopping link tree's read using link's container...", Tracer.Level.DEBUG);
        }
        if (this.pep.isReadOperational()) {
            if (this.pepContainer == null) {
                throw new ELnkException("A link with an operational read must be in a container");
            }
            this.pepContainer.stopRead(this.pep);
            this.flgOriginalReadStopped = true;
        }
        if (this.tracer.debug) {
            this.tracer.log("Joining link (ltp=" + this.ltp + ")...", Tracer.Level.DEBUG);
        }
        this.pep.join(this.ltp, new PacketHandler());
        this.flgJoined = true;
        if (this.pepContainer != null) {
            if (this.tracer.debug) {
                this.tracer.log("Migrating link tree to handshake container [pepContainer=" + (Object)((Object)this.pepContainer) + " handshakeContainer=" + (Object)((Object)this.handshakeContainer) + "]", Tracer.Level.DEBUG);
            }
            this.pep.setContainer(this.handshakeContainer);
            this.flgMigrated = true;
        } else if (this.tracer.debug) {
            this.tracer.log("Link is private. Not migrating.", Tracer.Level.DEBUG);
        }
        if (this.tracer.debug) {
            this.tracer.log("Starting link tree's read machinery using handshake container...", Tracer.Level.DEBUG);
        }
        this.handshakeContainer.startRead(this.pep);
        this.flgHandshakeReadStarted = true;
    }

    private final void executeEpilogue(Exception completionStatus) throws Exception {
        try {
            if (this.flgHandshakeReadStarted) {
                if (this.tracer.debug) {
                    this.tracer.log("Stopping link tree's handshake read...", Tracer.Level.DEBUG);
                }
                this.handshakeContainer.stopRead(this.pep);
            } else if (this.tracer.debug) {
                this.tracer.log("Not stopping link tree's handshake read. Was never started.", Tracer.Level.DEBUG);
            }
            if (this.flgMigrated) {
                if (this.tracer.debug) {
                    this.tracer.log("Migrating link tree back to original container [pepContainer=" + (Object)((Object)this.pepContainer) + " handshakeContainer=" + (Object)((Object)this.handshakeContainer) + "]", Tracer.Level.DEBUG);
                }
                this.pep.setContainer(this.pepContainer);
            } else if (this.tracer.debug) {
                this.tracer.log("Not migrating back. Link is private or never migrated originally", Tracer.Level.DEBUG);
            }
            if (this.flgJoined) {
                if (this.tracer.debug) {
                    this.tracer.log("Leaving link (ltp=" + this.ltp + ")...", Tracer.Level.DEBUG);
                }
                this.pep.leave(this.ltp, 3);
            } else if (this.tracer.debug) {
                this.tracer.log("Not leaving link. Neve joined.", Tracer.Level.DEBUG);
            }
            if (this.flgOriginalReadStopped) {
                if (completionStatus != null) {
                    if (this.tracer.debug) {
                        this.tracer.log("Restarting read on link using original container...", Tracer.Level.DEBUG);
                    }
                    this.pepContainer.startRead(this.pep);
                } else if (this.tracer.debug) {
                    this.tracer.log("Not restarting link read. Was stopped but handshake is successful.", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log("Not restarting link read. Never stopped.", Tracer.Level.DEBUG);
            }
        }
        finally {
            if (this.tracer.debug) {
                this.tracer.log("Removing temporary container '" + this.handshakeContainer.getName() + "' from registry.", Tracer.Level.DEBUG);
            }
            if (LnkRegistry.getInstance().removeContainer(this.handshakeContainer.getName()) == null) {
                this.tracer.log("Could not find temporary container '" + this.handshakeContainer.getName() + "' removing from registry.", Tracer.Level.DIAGNOSE);
            }
        }
    }

    private final void handshake(Event event, Object eventData) {
        try {
            if (this.tracer.debug) {
                this.tracer.log("Handshake state machine [" + (Object)((Object)this.state) + ", " + (Object)((Object)event) + "]", Tracer.Level.DEBUG);
            }
            block3 : switch (this.state) {
                case ACCEPTED: {
                    switch (event) {
                        case ON_START: {
                            this.executePrologue();
                            if (this.alarmEvent != null) {
                                if (this.tracer.debug) {
                                    this.tracer.log("Scheduling alarm event..", Tracer.Level.DEBUG);
                                }
                                this.handshakeContainer.getReader().schedAlarmEv(this.alarmEvent);
                            } else if (this.tracer.debug) {
                                this.tracer.log("Not scheduling alarm event (infinite timeout specified).", Tracer.Level.DEBUG);
                            }
                            this.state = State.WAIT_FOR_REQUEST;
                            break block3;
                        }
                    }
                    throw new IllegalArgumentException("Invalid event [" + (Object)((Object)event) + "] for state [" + (Object)((Object)this.state) + "]");
                }
                case CONNECTED: {
                    switch (event) {
                        case ON_START: {
                            this.executePrologue();
                            this.sendRequest();
                            if (this.alarmEvent != null) {
                                if (this.tracer.debug) {
                                    this.tracer.log("Scheduling alarm event..", Tracer.Level.DEBUG);
                                }
                                this.handshakeContainer.getReader().schedAlarmEv(this.alarmEvent);
                            } else if (this.tracer.debug) {
                                this.tracer.log("Not scheduling alarm event (infinite timeout specified).", Tracer.Level.DEBUG);
                            }
                            this.state = State.WAIT_FOR_REPLY;
                            break block3;
                        }
                    }
                    throw new IllegalArgumentException("Invalid event [" + (Object)((Object)event) + "] for state [" + (Object)((Object)this.state) + "]");
                }
                case WAIT_FOR_REQUEST: {
                    switch (event) {
                        case ON_PACKET: {
                            this.processRequest((PktPacket)((Object)eventData));
                            this.state = State.DONE;
                            this.handshake(Event.ON_NOTIFY, null);
                            break block3;
                        }
                        case ON_TIMEOUT: {
                            throw new IllegalArgumentException("Timed out in waiting for request");
                        }
                        case ON_LINK_DOWN: {
                            throw (Exception)eventData;
                        }
                        case ON_CANCEL: {
                            this.state = State.CANCELLING;
                            IEmxUserEvent userEvent = (IEmxUserEvent)EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, new CancelEventHandler()).setPriority(31);
                            this.handshakeContainer.getReader().schedUserEv(userEvent);
                            break block3;
                        }
                    }
                    throw new IllegalArgumentException("Invalid event [" + (Object)((Object)event) + "] for state [" + (Object)((Object)this.state) + "]");
                }
                case WAIT_FOR_REPLY: {
                    switch (event) {
                        case ON_PACKET: {
                            this.processReply((PktPacket)((Object)eventData));
                            this.state = State.DONE;
                            this.handshake(Event.ON_NOTIFY, null);
                            break block3;
                        }
                        case ON_TIMEOUT: {
                            throw new IllegalArgumentException("Timed out in waiting for reply");
                        }
                        case ON_LINK_DOWN: {
                            throw (Exception)eventData;
                        }
                        case ON_CANCEL: {
                            this.state = State.CANCELLING;
                            IEmxUserEvent userEvent = (IEmxUserEvent)EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, new CancelEventHandler()).setPriority(31);
                            this.handshakeContainer.getReader().schedUserEv(userEvent);
                            break block3;
                        }
                    }
                    throw new IllegalArgumentException("Invalid event [" + (Object)((Object)event) + "] for state [" + (Object)((Object)this.state) + "]");
                }
                case CANCELLING: {
                    switch (event) {
                        case ON_PACKET: 
                        case ON_TIMEOUT: 
                        case ON_LINK_DOWN: {
                            break block3;
                        }
                        case ON_NOTIFY: {
                            this.state = State.DONE;
                            this.handshake(Event.ON_NOTIFY, eventData);
                            break block3;
                        }
                    }
                    throw new IllegalArgumentException("Invalid event [" + (Object)((Object)event) + "] for state [" + (Object)((Object)this.state) + "]");
                }
                case DONE: {
                    switch (event) {
                        case ON_NOTIFY: {
                            try {
                                if (this.alarmEvent != null && this.alarmEvent.getDispatcher() != null) {
                                    this.handshakeContainer.getReader().unschedAlarmEv(this.alarmEvent);
                                }
                                this.executeEpilogue((Exception)eventData);
                            }
                            catch (Exception e) {
                                throw new InternalError("Handshake epilogue failed! [" + e.toString() + "]. Handshake completion status was [" + eventData == null ? "success" : eventData.toString() + "]");
                            }
                            this.completionData.status = (Exception)eventData;
                            this.completionData.flgReadOperationalOnStart = this.flgOriginalReadStopped;
                            try {
                                this.onComplete(this.completionData);
                            }
                            catch (Exception e) {}
                            break block3;
                        }
                    }
                    throw new IllegalArgumentException("Invalid event [" + (Object)((Object)event) + "] for state [" + (Object)((Object)this.state) + "]");
                }
                default: {
                    throw new IllegalArgumentException("Invalid state [" + (Object)((Object)this.state) + "]");
                }
            }
        }
        catch (Exception e) {
            if (this.tracer.debug) {
                this.tracer.log("Handshake error [" + this.pep + ", " + e.getMessage() + "]", Tracer.Level.DEBUG);
            }
            this.state = State.DONE;
            this.handshake(Event.ON_NOTIFY, e);
        }
    }

    public final void start(IEmxDispatcher dispatcher) {
        if (Thread.currentThread() != dispatcher.getOwner()) {
            throw new ELnkNotOwnerException();
        }
        this.handshakeContainer = LnkSTRContainer.createTemporary(this.config, dispatcher);
        if (this.tracer.debug) {
            this.tracer.log("Created temporary container '" + this.handshakeContainer.getName() + "' to handshake on link " + this.pep, Tracer.Level.DEBUG);
        }
        this.pepContainer = this.pep.getContainer();
        this.handshake(Event.ON_START, null);
    }

    protected abstract PktPacket prepareRequest() throws Exception;

    protected abstract void validateRequest(PktPacket var1) throws Exception;

    protected abstract PktPacket prepareReply(PktPacket var1) throws Exception;

    protected abstract void validateReply(PktPacket var1) throws Exception;

    protected abstract void onComplete(CompletionData var1);

    public final void stop() {
        if (this.handshakeContainer != null && Thread.currentThread() != this.handshakeContainer.getReader().getOwner()) {
            throw new ELnkNotOwnerException();
        }
        this.handshake(Event.ON_CANCEL, null);
    }

    public final class CompletionData {
        public final State initialState;
        public final UtlList overflowPacketList;
        public PktPacket request;
        public PktPacket reply;
        public Exception status;
        public boolean flgReadOperationalOnStart;

        private CompletionData(State initialState) {
            this.initialState = initialState;
            this.overflowPacketList = UtlList.create();
        }
    }

    public static enum State {
        ACCEPTED,
        CONNECTED,
        WAIT_FOR_REQUEST,
        WAIT_FOR_REPLY,
        CANCELLING,
        DONE;

    }

    private static enum Event {
        ON_START,
        ON_PACKET,
        ON_LINK_DOWN,
        ON_TIMEOUT,
        ON_CANCEL,
        ON_NOTIFY;

    }

    private final class CancelEventHandler
    implements IEmxEventHandler {
        private CancelEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            LnkHandshaker.this.handshake(Event.ON_NOTIFY, (Object)new ELnkOpCancelledException());
            return false;
        }
    }

    private final class TimeoutEventHandler
    implements IEmxEventHandler {
        private TimeoutEventHandler() {
        }

        @Override
        public final boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            LnkHandshaker.this.handshake(Event.ON_TIMEOUT, null);
            return false;
        }
    }

    private final class PacketHandler
    implements ILnkEventHandler {
        private PacketHandler() {
        }

        private final void dispatchPacketsToStateMachine() {
            UtlListElement element;
            if (((LnkHandshaker)LnkHandshaker.this).tracer.debug) {
                LnkHandshaker.this.tracer.log("Start of packet dispatch to handshaker " + (Object)((Object)LnkHandshaker.this) + " state machine [numPackets=" + ((LnkHandshaker)LnkHandshaker.this).completionData.overflowPacketList.count() + "]", Tracer.Level.DEBUG);
            }
            UtlList overflowList = ((LnkHandshaker)LnkHandshaker.this).completionData.overflowPacketList;
            while (LnkHandshaker.this.state != State.DONE && (element = overflowList.first()) != null) {
                element.unlink();
                LnkHandshaker.this.handshake(Event.ON_PACKET, element);
            }
            if (((LnkHandshaker)LnkHandshaker.this).tracer.debug) {
                LnkHandshaker.this.tracer.log("End of packet dispatch to handshaker " + (Object)((Object)LnkHandshaker.this) + " state machine [remainingPackets=" + ((LnkHandshaker)LnkHandshaker.this).completionData.overflowPacketList.count() + " state=" + (Object)((Object)LnkHandshaker.this.state) + "]", Tracer.Level.DEBUG);
            }
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            switch (type) {
                case 5: {
                    if (((LnkHandshaker)LnkHandshaker.this).tracer.debug) {
                        LnkHandshaker.this.tracer.log("Handshaker [" + (Object)((Object)LnkHandshaker.this) + "] received single packet.", Tracer.Level.DEBUG);
                    }
                    ((LnkHandshaker)LnkHandshaker.this).completionData.overflowPacketList.append((UtlListElement)((PktPacket)((Object)data)));
                    this.dispatchPacketsToStateMachine();
                    break;
                }
                case 8: {
                    LnkHandshaker.this.handshake(Event.ON_LINK_DOWN, data);
                    break;
                }
                default: {
                    throw new InternalError("Received invalid event type [type=" + type + "]");
                }
            }
        }
    }
}

