/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.tools.AbstractCommand;
import com.neeve.tools.AwsCommand;
import com.neeve.tools.CivoCommand;
import com.neeve.tools.EquinixCommand;
import com.neeve.tools.LocalCommand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CloudCommand
extends AbstractCommand {
    private static final Set<String> topLevelCommands = Stream.of("aws", "civo", "equinix", "local").collect(Collectors.toCollection(HashSet::new));

    CloudCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi 'cloud' Commands:");
        System.out.println("");
        System.out.println("         aws        Commands that provision Rumi applications in AWS            (https://aws.amazon.com)");
        System.out.println("         civo       Commands that provision Rumi applications in Civo           (https://www.civo.com)");
        System.out.println("         equinix    Commands that provision Rumi applications in Equinix Metal  (https://deploy.equinix.com/)");
        System.out.println("         local      Commands that provision Rumi applications on local machine  (Docker-based)");
        System.out.println("");
        System.out.println("      Run 'rumi help cloud <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("aws")) {
            return new AwsCommand();
        }
        if (command.equals("civo")) {
            return new CivoCommand();
        }
        if (command.equals("equinix")) {
            return new EquinixCommand();
        }
        if (command.equals("local")) {
            return new LocalCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    @Override
    final void help(String[] args) {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (topLevelCommands.contains(command)) {
                CloudCommand.commandHandler(command).help(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (topLevelCommands.contains(command)) {
                CloudCommand.commandHandler(command).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }
}

