/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sto;

import com.neeve.sto.StoCompoundField;
import com.neeve.sto.StoField;
import com.neeve.sto.StoFieldContainer;
import com.neeve.sto.StoShortField;
import com.neeve.sto.StoTypeFactory;
import com.neeve.sto.StoTypeFactoryRegistry;
import com.neeve.sto.StoVariableLengthField;
import java.nio.ByteBuffer;
import java.util.Arrays;

public final class StoCompoundArrayField
extends StoVariableLengthField<StoFieldContainer[]> {
    private StoCompoundArrayField(String name) {
        super(StoField.Type.COMPOUND_ARRAY, name);
    }

    private StoCompoundArrayField(ByteBuffer buffer, int bufferOffset) {
        super(buffer, bufferOffset);
    }

    private static final StoTypeFactory getTypeFactory(short tfid) {
        StoTypeFactory factory = null;
        if (tfid != 0 && (factory = StoTypeFactoryRegistry.getInstance().getTypeFactory(tfid)) == null) {
            System.err.println("WARNING: STO type factory '" + tfid + "' could not be found. Unable to instantiate correct user types");
        }
        return factory;
    }

    private static final StoFieldContainer[] createContainerArray(StoTypeFactory factory, short tid, int len) {
        return factory != null ? factory.createCompoundArrayType(tid, len) : new StoFieldContainer[len];
    }

    @Override
    protected final int serializedLength(ByteBuffer buffer, int offset) {
        return StoCompoundArrayField.getSerializedLength(buffer, offset);
    }

    @Override
    protected final int serializedLength(StoFieldContainer[] val) {
        return StoCompoundArrayField.getSerializedLength(val);
    }

    @Override
    protected final void serialize(ByteBuffer buffer, int offset, StoFieldContainer[] val) {
        StoCompoundArrayField.put(buffer, offset, val);
    }

    @Override
    protected final StoFieldContainer[] deserialize(ByteBuffer buffer, int offset) {
        return StoCompoundArrayField.get(buffer, offset);
    }

    @Override
    protected final boolean compare(StoFieldContainer[] val1, StoFieldContainer[] val2) {
        int i;
        for (i = 0; i < val1.length && val1[i].contentsEquals(val2[i]); ++i) {
        }
        return i == val1.length;
    }

    @Override
    protected final StoFieldContainer[] clone(StoFieldContainer[] val) {
        if (val.length > 0) {
            StoFieldContainer[] clone = StoCompoundArrayField.createContainerArray(StoCompoundArrayField.getTypeFactory(val[0].getTypeFactoryId()), val[0].getTypeId(), val.length);
            for (int i = 0; i < val.length; ++i) {
                clone[i] = (StoFieldContainer)val[i].clone();
            }
            return clone;
        }
        return new StoFieldContainer[0];
    }

    @Override
    protected final String toString(StoFieldContainer[] val) {
        return Arrays.toString(val);
    }

    public static StoCompoundArrayField create(String name) {
        return new StoCompoundArrayField(name);
    }

    public static StoCompoundArrayField create(ByteBuffer buffer, int bufferOffset) {
        return new StoCompoundArrayField(buffer, bufferOffset);
    }

    public static int getSerializedLength(ByteBuffer buffer, int offset) {
        int numElements = StoShortField.get(buffer, offset);
        int len = 2 + (numElements > 0 ? 4 : 0);
        for (int i = 0; i < numElements; ++i) {
            len += StoCompoundField.getBodySerializedLength(buffer, offset + len);
        }
        return len;
    }

    public static int getSerializedLength(StoFieldContainer[] val) {
        int len = 2 + (val != null && val.length > 0 ? 4 : 0);
        if (val != null) {
            for (int i = 0; i < val.length; ++i) {
                len += StoCompoundField.getBodySerializedLength(val[i]);
            }
        }
        return len;
    }

    public static int put(ByteBuffer buffer, int offset, StoFieldContainer[] val) {
        StoShortField.put(buffer, offset, (short)(val == null ? 0 : (val.length == 0 ? -1 : val.length)));
        int len = 2;
        if (val != null && val.length > 0) {
            len += StoCompoundField.putHeader(buffer, offset + len, val[0]);
            for (int i = 0; i < val.length; ++i) {
                len += StoCompoundField.putBody(buffer, offset + len, val[i]);
            }
        }
        return len;
    }

    public static StoFieldContainer[] get(ByteBuffer buffer, int offset) {
        short len = StoShortField.get(buffer, offset);
        if (len > 0) {
            int proclen = 2;
            short tfid = StoCompoundField.getTypeFactoryId(buffer, offset + proclen);
            short tid = StoCompoundField.getTypeId(buffer, offset + proclen);
            StoTypeFactory factory = StoCompoundArrayField.getTypeFactory(tfid);
            StoFieldContainer[] val = StoCompoundArrayField.createContainerArray(factory, tid, len);
            proclen += 4;
            for (int i = 0; i < val.length; ++i) {
                val[i] = StoCompoundField.getBody(buffer, offset + proclen, factory, tid);
                proclen += StoCompoundField.getBodySerializedLength(buffer, offset + proclen);
            }
            return val;
        }
        if (len < 0) {
            return new StoFieldContainer[0];
        }
        return null;
    }
}

