/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class Scp {
    private static final String[] trimFromToFiles(String[] args) {
        String[] ret = new String[args.length - 2];
        for (int i = 0; i < args.length - 2; ++i) {
            ret[i] = args[i];
        }
        return ret;
    }

    private static final int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            if (b == 1) {
                System.out.print(sb.toString());
            }
            if (b == 2) {
                System.out.print(sb.toString());
            }
        }
        return b;
    }

    private static final void printUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append("Usage Scp -i <keyFile> -P <port> <localFile> <user>@host:<remoteFile>").append("\n");
        System.out.println(sb.toString());
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block27: {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option keyFilenameOption = parser.addStringOption('i', "keyfile");
            CmdLineParser.Option portOption = parser.addIntegerOption('P', "port");
            if (args.length >= 2) {
                try {
                    parser.parse(Scp.trimFromToFiles(args));
                    String keyFilename = (String)parser.getOptionValue(keyFilenameOption, null);
                    int port = (Integer)parser.getOptionValue(portOption, (Object)22);
                    if (keyFilename != null) {
                        try {
                            File keyFile = new File(keyFilename);
                            if (keyFile.exists()) {
                                String lfile = args[args.length - 2];
                                String user = args[args.length - 1].substring(0, args[args.length - 1].indexOf(64));
                                args[args.length - 1] = args[args.length - 1].substring(args[args.length - 1].indexOf(64) + 1);
                                String host = args[args.length - 1].substring(0, args[args.length - 1].indexOf(58));
                                String rfile = args[args.length - 1].substring(args[args.length - 1].indexOf(58) + 1);
                                System.out.println("host=" + host);
                                System.out.println("port=" + port);
                                System.out.println("user=" + user);
                                System.out.println("keyfile=" + keyFile.getAbsolutePath());
                                JSch jsch = new JSch();
                                jsch.addIdentity(keyFile.getAbsolutePath());
                                Session session = jsch.getSession(user, host, port);
                                Properties config = new Properties();
                                config.put("StrictHostKeyChecking", "no");
                                session.setConfig(config);
                                session.connect();
                                try {
                                    String command = "scp -p -t " + rfile;
                                    Channel channel = session.openChannel("exec");
                                    ((ChannelExec)channel).setCommand(command);
                                    try (OutputStream out = channel.getOutputStream();){
                                        InputStream in = channel.getInputStream();
                                        channel.connect();
                                        try {
                                            if (Scp.checkAck(in) != 0) {
                                                System.exit(1);
                                            }
                                            File _lfile = new File(lfile);
                                            command = "T " + _lfile.lastModified() / 1000L + " 0";
                                            command = command + " " + _lfile.lastModified() / 1000L + " 0\n";
                                            out.write(command.getBytes());
                                            out.flush();
                                            if (Scp.checkAck(in) != 0) {
                                                System.exit(1);
                                            }
                                            long filesize = _lfile.length();
                                            command = "C0644 " + filesize + " ";
                                            command = lfile.lastIndexOf(47) > 0 ? command + lfile.substring(lfile.lastIndexOf(47) + 1) : command + lfile;
                                            command = command + "\n";
                                            out.write(command.getBytes());
                                            out.flush();
                                            if (Scp.checkAck(in) != 0) {
                                                System.exit(1);
                                            }
                                            byte[] buf = new byte[1024];
                                            try (FileInputStream fis = new FileInputStream(lfile);){
                                                int len;
                                                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                                                    out.write(buf, 0, len);
                                                }
                                            }
                                            buf[0] = 0;
                                            out.write(buf, 0, 1);
                                            out.flush();
                                            if (Scp.checkAck(in) != 0) {
                                                System.exit(1);
                                            }
                                            break block27;
                                        }
                                        finally {
                                            channel.disconnect();
                                        }
                                    }
                                }
                                finally {
                                    session.disconnect();
                                }
                            }
                            System.err.println("ERROR: Key file '" + keyFile.getAbsolutePath() + "' does not exist");
                            System.exit(1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block27;
                    }
                    Scp.printUsage();
                }
                catch (CmdLineParser.OptionException e) {
                    System.err.println("ERROR: " + e.getMessage());
                    Scp.printUsage();
                }
            } else {
                Scp.printUsage();
            }
        }
    }
}

