/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl;

import cern.colt.map.OpenIntIntHashMap;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.config.Config;
import com.neeve.event.Event;
import com.neeve.event.IEventAcknowledger;
import com.neeve.event.IEventHandler;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageMetadata;
import com.neeve.sma.MessageMetadataFactory;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.MessageViewFactoryRegistry;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.MessagingProvider;
import com.neeve.sma.MessagingProviderRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.event.BusCongestedEvent;
import com.neeve.sma.event.MessageBusBindingFailedEvent;
import com.neeve.sma.event.MessageEvent;
import com.neeve.sma.event.NonXMessageEvent;
import com.neeve.sma.event.UnhandledMessageEvent;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThrowable;
import com.neeve.util.UtlTime;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class MessageBusBindingBase
extends SmaObject
implements MessageBusBinding {
    protected final int id;
    protected final String userName;
    protected final MessageBusDescriptor descriptor;
    protected final MessageLatencyManager latencyManager;
    protected final IEventHandler eventHandler;
    protected final String tracePrefix;
    protected static final List<String> knownProperties = Arrays.asList("Provider", "Address", "sma_metadata_version", "set_flow_on_receipt", "set_sno_on_receipt", "set_bus_and_channel_on_receipt", "set_key_on_receipt", "enable_inbound_transport_headers", "enable_concurrent_sends", "topic_starts_with_channel", "auto_add_catchall_channel", "raw_mode", "additional_properties_file", "initWaitTime");
    protected final int metadataVersion;
    protected final boolean setFlowOnReceipt;
    protected final boolean setBusAndChannelOnReceipt;
    protected final boolean setKeyOnReceipt;
    protected final boolean setSnoOnReceipt;
    protected final boolean enableInboundTransportHeaders;
    protected final boolean topicStartsWithChannel;
    protected final boolean enableConcurrentSends;
    protected final boolean rawMode;
    protected final MessagingProvider provider;
    protected MessageBusBinding.State state;
    private final MessageViewFactoryRegistry viewFactoryRegistry;
    private final XLinkedHashMap<String, MessageChannel> channelsByName;
    private final XLinkedHashMap<XString, MessageChannel> channelsByXString;
    private final OpenIntObjectHashMap channelsById;
    private final OpenIntIntHashMap blacklistedChannelIds;
    private final ReentrantReadWriteLock channelTablesLock;
    private final Lock channelTablesReadLock;
    private final Lock channelTablesWriteLock;
    private final Lock sendLock;
    private final AtomicReference<Thread> currentSendThread;
    private final MessageBusBinding.SequenceNumberGenerator defaultSnoGenerator;
    private final XString name;
    private final XString type;
    private MessageBusBinding.SequenceNumberGenerator snoGenerator;
    private MessageBusBinding.PostMessagePrepProcessor postMessagePrepProcessor;
    private Object attachment;
    private MessageBusBinding.StatsListener statsListener;

    protected MessageBusBindingBase(RootConfig.ObjectConfig config, String userName, MessageBusDescriptor descriptor, IEventHandler eventHandler) throws SmaException {
        super(config);
        String providerName;
        Properties providerConfig = descriptor.getProviderConfig();
        String string = providerName = providerConfig == null ? null : providerConfig.getProperty("Provider");
        if (providerName == null) {
            throw new SmaPermanentException("a provider has not been configured for the bus");
        }
        this.provider = MessagingProviderRegistry.getInstance().getProvider(providerName);
        this.userName = userName;
        this.descriptor = descriptor;
        this.eventHandler = eventHandler;
        this.name = XString.create((String)descriptor.getName());
        this.type = XString.create((String)descriptor.getProviderConfig().getProperty("Provider"));
        this.id = (this.getUserName() + "@" + this.getName()).hashCode();
        this.latencyManager = new MessageLatencyManager(this, this.userName + "@" + descriptor.getName());
        this.viewFactoryRegistry = MessageViewFactoryRegistry.getInstance();
        this.channelsByXString = new XLinkedHashMap();
        this.channelsByName = new XLinkedHashMap();
        this.channelsById = new OpenIntObjectHashMap();
        this.blacklistedChannelIds = new OpenIntIntHashMap();
        this.channelTablesLock = new ReentrantReadWriteLock();
        this.channelTablesReadLock = this.channelTablesLock.readLock();
        this.channelTablesWriteLock = this.channelTablesLock.writeLock();
        this.snoGenerator = this.defaultSnoGenerator = new DefaultSequenceNumberGenerator();
        this.tracePrefix = "[MsgBusBinding<" + this.getUserName() + "." + this.getName() + ">] ";
        Properties additionalProperties = descriptor.loadAdditionalPropertiesFile();
        if (additionalProperties != null && !additionalProperties.isEmpty() && this.tracer.isEnabled(Tracer.Level.CONFIG)) {
            this.tracer.log(this.tracePrefix + "Loaded additonal descriptor properties: " + additionalProperties.keySet(), Tracer.Level.CONFIG);
        }
        this.metadataVersion = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"sma_metadata_version", (int)2);
        if (this.metadataVersion > 3 || this.metadataVersion < 1) {
            throw new SmaPermanentException("invalid metadata version '" + this.metadataVersion + "'.");
        }
        this.setFlowOnReceipt = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"set_flow_on_receipt", (boolean)false);
        this.setSnoOnReceipt = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"set_sno_on_receipt", (boolean)true);
        this.setBusAndChannelOnReceipt = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"set_bus_and_channel_on_receipt", (boolean)false);
        this.setKeyOnReceipt = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"set_key_on_receipt", (boolean)false);
        this.enableInboundTransportHeaders = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"enable_inbound_transport_headers", (boolean)false);
        this.enableConcurrentSends = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"enable_concurrent_sends", (boolean)false);
        this.topicStartsWithChannel = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"topic_starts_with_channel", (boolean)true);
        this.rawMode = UtlProps.getValue((Properties)descriptor.getProviderConfig(), (String)"raw_mode", (boolean)false);
        if (this.rawMode) {
            this.tracer.log(this.tracePrefix + "Operating in raw mode", Tracer.Level.INFO);
        }
        descriptor.createAutoCreatedChannels();
        this.sendLock = this.isEnableConcurrentSends() ? new ReentrantLock(true) : null;
        this.currentSendThread = this.sendLock != null ? null : new AtomicReference();
        this.state = MessageBusBinding.State.Closed;
        this.open();
    }

    private final SmaException prepareStateValidationErrorException() {
        switch (this.state) {
            case Open: {
                return new SmaException("binding is open");
            }
            case Failed: {
                return new SmaException("binding has failed");
            }
            case Closing: {
                return new SmaException("binding is closing");
            }
            case Closed: {
                return new SmaException("binding is closed");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    private final MessageChannel.Qos channelQosFromProperty(String property) {
        MessageChannel.Qos qos = null;
        String qosStr = Config.getValue((String)property, null);
        if (qosStr != null) {
            try {
                qos = MessageChannel.Qos.valueOf(qosStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return qos;
    }

    private final MessageView createMessageView(int encodingType, Object message, short vfid, short vtype) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Creating message view for message (encodingType=" + encodingType + ", vfid=" + vfid + ", vtype=" + vtype + ")", Tracer.Level.DEBUG);
        }
        try {
            MessageViewFactory factory = this.viewFactoryRegistry.getMessageViewFactory(vfid);
            if (factory != null) {
                return factory.wrap(vtype, encodingType, message);
            }
            throw new RuntimeException("View factory '" + vfid + "' could not be found");
        }
        catch (RuntimeException e) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.tracePrefix).append("Failed to deserialize message\n").append("...encoding=").append(encodingType).append("\n").append("...vfid=").append(vfid).append("\n").append("...vtype=").append(vtype).append("\n").append(UtlThrowable.prepareStackTrace((Throwable)e));
            this.tracer.log(sb.toString(), Tracer.Level.SEVERE);
            throw e;
        }
    }

    final void onChannelClose(MessageChannel channel) {
        if (this.state != MessageBusBinding.State.Closing && this.state != MessageBusBinding.State.Failed) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Removing channel '" + channel.getName() + "' from binding channel table.", Tracer.Level.DEBUG);
            }
            this.channelTablesWriteLock.lock();
            try {
                this.channelsByXString.remove((Object)channel.getNameAsRaw());
                this.channelsByName.remove((Object)channel.getName());
                if (MessageChannelBase.hasValidId(channel)) {
                    this.channelsById.removeKey((int)channel.getId());
                }
            }
            finally {
                this.channelTablesWriteLock.unlock();
            }
        }
    }

    final void acquireSendLock() {
        if (this.sendLock != null) {
            this.sendLock.lock();
        } else {
            Thread currentThread = this.currentSendThread.getAndSet(Thread.currentThread());
            if (currentThread != null) {
                String str = "concurrent sends attempted with the binding not configured for concurrent send [thread1=" + currentThread.getName() + ", thread2=" + Thread.currentThread().getName() + "] (to fix this issue, configure the binding with " + "enable_concurrent_sends" + "=true)";
                this.tracer.log(this.tracePrefix + str, Tracer.Level.SEVERE);
                throw new IllegalStateException(str);
            }
        }
    }

    final void releaseSendLock() {
        if (this.sendLock != null) {
            this.sendLock.unlock();
        } else {
            this.currentSendThread.set(null);
        }
    }

    final long getNextSno(MessageView view) {
        return this.snoGenerator.nextSno(view);
    }

    final void invokePostMessagePrepProcessor(MessageView view) {
        if (this.postMessagePrepProcessor != null) {
            this.postMessagePrepProcessor.onSendPrepComplete(view);
        }
    }

    protected abstract void doOpen() throws SmaException;

    protected abstract void doStart() throws SmaException;

    protected abstract MessageChannel doGetMessageChannel(MessageChannelDescriptor var1) throws SmaException;

    protected abstract void doFlush() throws SmaException;

    protected abstract boolean doCanFail();

    protected abstract boolean doAcksRequireFlush();

    protected abstract void doClose() throws SmaException;

    protected final MessageView setInboundMetadata(MessageView view, int sender, int flow, long sno, long requestId, XString requestorId, XString key, MessageTransportHeaders headers, long originTs, long preWireTs, long postWireTs, long preDeserializeTs) {
        if (this.setFlowOnReceipt) {
            view.setMessageFlow(flow);
        }
        if (this.setSnoOnReceipt) {
            view.setMessageSender(sender);
            view.setMessageSequenceNumber(sno);
        }
        if (this.setKeyOnReceipt) {
            view.setMessageKeyAsRaw(key);
        }
        if (this.enableInboundTransportHeaders) {
            view.setMessageTransportHeaders(headers);
        }
        view.setRequestId(requestId);
        if (requestorId != null) {
            view.setRequestorIdAsRaw(requestorId);
        }
        view.setOriginTs(originTs);
        view.setPreWireTs(preWireTs);
        view.setPostWireTs(postWireTs);
        view.setPreDeserializeTs(preDeserializeTs);
        return view;
    }

    protected final MessageView wrap(Object message, short vfid, short vtype, int encodingType, int sender, int flow, long sno, long requestId, XString requestorId, XString key, MessageTransportHeaders headers, long originTs, long preWireTs, long postWireTs, long preDeserializeTs) {
        return this.setInboundMetadata(this.createMessageView(encodingType, message, vfid, vtype), sender, flow, sno, requestId, requestorId, key, headers, originTs, preWireTs, postWireTs, preDeserializeTs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void onEvent(Event event, boolean trapException) {
        try {
            if (this.eventHandler != null) {
                this.eventHandler.onEvent(event);
            }
        }
        catch (Throwable e) {
            if (e instanceof Error) {
                throw (Error)e;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("SMA event handler [" + this.eventHandler + "] faulted with error [" + e.toString() + "] on event {" + event + "} with the following stack trace:\n");
            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
            this.tracer.log(this.tracePrefix + sb.toString(), Tracer.Level.SEVERE);
            if (!trapException) {
                throw (RuntimeException)e;
            }
        }
        finally {
            event.dispose();
        }
    }

    protected final void onEvent(Event event) {
        this.onEvent(event, true);
    }

    protected final MessageEvent prepareMessageEvent(MessageChannel channel, MessageView view, IEventAcknowledger acknowledger) {
        MessageEvent event = MessageEvent.create(this, channel, view, acknowledger);
        view.setTag(0, event);
        view.setTag(3, this.latencyManager);
        return event;
    }

    protected final void onMessage(MessageChannel channel, MessageView view, IEventAcknowledger acknowledger) {
        if (this.setBusAndChannelOnReceipt) {
            view.setMessageChannelAsRaw(channel.getNameAsRaw());
            view.setMessageBusAsRaw(channel.getMessageBusBinding().getNameAsRaw());
        }
        if (MessageLatencyManager.recordMsgLegWaypoints) {
            view.setPostDeserializeTs(UtlTime.now());
        }
        MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.d2, MessageWaypointListener.MessagingDirection.Inbound, view);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Deserialize complete...", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...origin=" + view.getOriginTs(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...preWire=" + view.getPreWireTs(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...postWire=" + view.getPostWireTs(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...preDeserialize=" + view.getPreDeserializeTs(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...postDeserialize=" + view.getPostDeserializeTs(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
        }
        this.onEvent(this.prepareMessageEvent(channel, view, acknowledger), false);
    }

    protected final void onCongestion() {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received congestion notification.", Tracer.Level.DEBUG);
        }
        this.onEvent(BusCongestedEvent.create(this), true);
    }

    protected void onNonXMessage(Object transportMessageId, String messageKey, Object unwrappedMessage, byte[] serializedMessage, Acknowledger<?> acknowledger) {
        try {
            if (this.state == MessageBusBinding.State.Open) {
                this.onEvent(NonXMessageEvent.create(this, messageKey, transportMessageId != null ? transportMessageId.toString() : null, unwrappedMessage, serializedMessage, acknowledger));
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Non X message received in state '" + (Object)((Object)this.state) + "'", Tracer.Level.DEBUG);
            }
        }
        catch (Throwable th) {
            this.tracer.log(this.tracePrefix + "Error preparing NonXMessageEvent " + UtlThrowable.prepareStackTrace((Throwable)th), Tracer.Level.SEVERE);
        }
    }

    protected void onInboundMessageHandlingFault(Object transportMessageId, String messageKey, MessageMetadata metadata, Object unwrappedMessage, byte[] serializedMetadata, byte[] serializedMessage, Acknowledger<?> acknowledger, Throwable fault) {
        try {
            MessageChannel channel;
            if (metadata == null) {
                if (serializedMetadata != null) {
                    try {
                        metadata = MessageMetadataFactory.getInstance().createMessageMetadata();
                        metadata.deserialize(ByteBuffer.wrap(serializedMetadata));
                    }
                    catch (SmaException smaEx) {
                        this.tracer.log(this.tracePrefix + "Failed to wrap metadata (corrupt?) for inbound message handling fault: " + smaEx.getMessage(), Tracer.Level.VERBOSE);
                    }
                } else {
                    this.tracer.log(this.tracePrefix + "Missing metadata for inbound message handling fault.", Tracer.Level.VERBOSE);
                }
            } else {
                metadata.acquire();
            }
            try {
                channel = this.findMessageChannelForInboundMessageDispatch(metadata.getMessageChannelNameAsRaw(), metadata.getMessageChannelId());
            }
            catch (Throwable thrown) {
                channel = null;
            }
            if (this.state == MessageBusBinding.State.Open) {
                this.tracer.log(this.tracePrefix + "Inbound message handling fault, dispatching UnhandledMessageEvent: " + UtlThrowable.prepareStackTrace((Throwable)fault), Tracer.Level.VERBOSE);
                UnhandledMessageEvent ume = UnhandledMessageEvent.create(this, channel, metadata, messageKey, transportMessageId != null ? transportMessageId.toString() : null, unwrappedMessage, serializedMetadata, serializedMessage, acknowledger, fault);
                this.onEvent(ume);
            } else {
                this.tracer.log(this.tracePrefix + "Inbound message handling fault in state '" + (Object)((Object)this.state) + "': " + UtlThrowable.prepareStackTrace((Throwable)fault), Tracer.Level.VERBOSE);
            }
        }
        catch (Throwable th) {
            this.tracer.log(this.tracePrefix + "Error preparing UnhandledMessageEvent on inbound message fault '" + fault.getMessage() + "' " + UtlThrowable.prepareStackTrace((Throwable)th) + " Original Fault was: " + UtlThrowable.prepareStackTrace((Throwable)fault), Tracer.Level.SEVERE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFail(Exception e, boolean dispatchFailureEvent) {
        this.state = MessageBusBinding.State.Failed;
        this.channelTablesReadLock.lock();
        try {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Failing channels (count=" + this.channelsByXString.size() + ").", Tracer.Level.DEBUG);
            }
            XIterator iterator = this.channelsByXString.reuseableValueIterator();
            while (iterator.hasNext()) {
                ((MessageChannelBase)iterator.next()).onFail(e);
            }
        }
        finally {
            this.channelTablesReadLock.unlock();
        }
        if (dispatchFailureEvent) {
            this.onEvent(MessageBusBindingFailedEvent.create(this, e));
        }
    }

    protected void onFail(Exception e) {
        this.onFail(e, true);
    }

    protected final MessageChannel getCatchAllChannel() throws SmaException {
        MessageChannel channel = this.findMessageChannelForInboundMessageDispatch(null, (short)Short.MAX_VALUE);
        if (channel == null) {
            channel = this.getMessageChannel("_CATCHALL_");
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final MessageChannel findMessageChannelForInboundMessageDispatch(XString channelName, short channelId) {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Finding message channel using <channelName=" + channelName + ", channelId=" + channelId + ">...", Tracer.Level.DEBUG);
        }
        boolean validId = MessageChannelBase.isValidId(channelId);
        this.channelTablesReadLock.lock();
        try {
            boolean hasChannelName;
            MessageChannel channel = null;
            boolean bl = hasChannelName = channelName != null && channelName.hasValue() && channelName.length() > 0;
            if (hasChannelName && validId) {
                channel = (MessageChannel)this.channelsByXString.get((Object)channelName);
                if (channel != null) {
                    if (channelId == channel.getId()) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Found message channel with supplied name and id.", Tracer.Level.DEBUG);
                        }
                    } else {
                        this.tracer.log(this.tracePrefix + "Received channel <name, id> combination does not match local one [channel='" + channelName + "' <receivedId=" + channelId + ", localId=" + channel.getId() + ">]. Blackilisting channelId=" + channelId + "...", Tracer.Level.WARNING);
                        this.blacklistedChannelIds.put((int)channelId, (int)channelId);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "No local message channel with name=" + channelName + ".", Tracer.Level.DEBUG);
                }
            } else if (hasChannelName && !validId) {
                channel = (MessageChannel)this.channelsByXString.get((Object)channelName);
                if (channel != null) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Found message channel with supplied name.", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "No local message channel with name=" + channelName + ".", Tracer.Level.DEBUG);
                }
            } else if (!hasChannelName && validId) {
                if (!this.blacklistedChannelIds.containsKey((int)channelId)) {
                    channel = (MessageChannel)this.channelsById.get((int)channelId);
                    if (channel != null) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + "Found message channel with supplied id.", Tracer.Level.DEBUG);
                        }
                    } else if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "No local message channel with id=" + channelId + ".", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Received channel id is blacklisted!", Tracer.Level.DEBUG);
                }
            }
            if (channel == null || !channel.isJoined()) {
                if (channel != null && this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Found message channel is not joined.", Tracer.Level.DEBUG);
                }
                if ((channel = (MessageChannel)this.channelsById.get(Short.MAX_VALUE)) != null) {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Found catchall message channel.", Tracer.Level.DEBUG);
                    }
                } else if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "No catchall message channel.", Tracer.Level.DEBUG);
                }
            }
            MessageChannel messageChannel = channel;
            return messageChannel;
        }
        finally {
            this.channelTablesReadLock.unlock();
        }
    }

    private final void open() throws SmaException {
        if (this.state == MessageBusBinding.State.Closed) {
            this.doOpen();
            this.state = MessageBusBinding.State.Open;
            if (this.latencyManager != null) {
                try {
                    this.latencyManager.start();
                }
                catch (Throwable e) {
                    this.close();
                    throw new SmaException(e);
                }
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    @Override
    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public final void setStatsListener(MessageBusBinding.StatsListener statsListener) {
        this.statsListener = statsListener;
    }

    @Override
    public final void setSequenceNumberGenerator(MessageBusBinding.SequenceNumberGenerator generator) {
        if (generator == null) {
            throw new IllegalArgumentException("generator cannot be null");
        }
        if (this.state != MessageBusBinding.State.Open) {
            throw new IllegalStateException("sequence number generator can only installed in Open state");
        }
        this.snoGenerator = generator;
    }

    @Override
    public final void setPostMessagePrepProcessor(MessageBusBinding.PostMessagePrepProcessor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null");
        }
        if (this.state != MessageBusBinding.State.Open) {
            throw new IllegalStateException("post message prep processor can only installed in Open state");
        }
        this.postMessagePrepProcessor = processor;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public final String getType() {
        return this.type.getValue();
    }

    @Override
    public final XString getTypeAsRaw() {
        return this.type;
    }

    public final String getName() {
        return this.name.getValue();
    }

    @Override
    public final XString getNameAsRaw() {
        return this.name;
    }

    @Override
    public final int getId() {
        return this.id;
    }

    @Override
    public final String getUserName() {
        return this.userName;
    }

    @Override
    public final MessageBusDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public void getStats(StringBuilder sb) {
        sb.append("<No Stats Available>");
    }

    @Override
    public final MessageLatencyManager getLatencyManager() {
        return this.latencyManager;
    }

    @Override
    public IEventHandler getEventHandler() {
        return this.eventHandler;
    }

    @Override
    public MessageBusBinding.State getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MessageChannel getMessageChannel(String channelName) throws SmaException {
        if (channelName == null) {
            throw new IllegalArgumentException("channel name cannot be null");
        }
        if (this.state == MessageBusBinding.State.Open) {
            MessageChannel channel;
            block11: {
                channel = (MessageChannel)this.channelsByName.get((Object)channelName);
                if (channel == null) {
                    try {
                        this.channelTablesWriteLock.lock();
                        MessageChannelDescriptor channelDescriptor = this.descriptor.getChannel(channelName);
                        if (channelDescriptor != null) {
                            MessageChannel.Qos qosOverride = this.channelQosFromProperty("nv.sma." + this.getName() + "." + channelName + ".qosoverride");
                            if (qosOverride == null) {
                                qosOverride = this.channelQosFromProperty("nv.sma." + this.getName() + ".qosoverride");
                            }
                            if (qosOverride == null) {
                                qosOverride = this.channelQosFromProperty("nv.sma.qosoverride");
                            }
                            if (qosOverride != null && channelDescriptor.getChannelQos() != qosOverride) {
                                this.tracer.log(this.tracePrefix + "Overriding QOS of channel '" + channelName + "' in bus '" + this.getName() + "' (configured=" + (Object)((Object)channelDescriptor.getChannelQos()) + ", override=" + (Object)((Object)qosOverride) + ")", Tracer.Level.WARNING);
                                channelDescriptor.setChannelQos(qosOverride);
                            }
                            channel = this.doGetMessageChannel(channelDescriptor);
                            this.channelsByName.put((Object)channelName, (Object)channel);
                            this.channelsByXString.put((Object)channel.getNameAsRaw(), (Object)channel);
                            if (MessageChannelBase.hasValidId(channel)) {
                                this.channelsById.put((int)channel.getId(), (Object)channel);
                            }
                            break block11;
                        }
                        throw new SmaException("channel '" + channelName + "' not configured in bus '" + this.getName() + "'");
                    }
                    finally {
                        this.channelTablesWriteLock.unlock();
                    }
                }
            }
            return channel;
        }
        throw this.prepareStateValidationErrorException();
    }

    @Override
    public final void start() throws SmaException {
        if (this.state != MessageBusBinding.State.Open) {
            throw this.prepareStateValidationErrorException();
        }
        this.doStart();
    }

    @Override
    public final void flush() throws SmaException {
        if (this.state == MessageBusBinding.State.Open) {
            this.acquireSendLock();
            try {
                this.doFlush();
            }
            finally {
                this.releaseSendLock();
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    @Override
    public final boolean canFail() {
        return this.doCanFail();
    }

    public final int getMetadataVersion() {
        return this.metadataVersion;
    }

    public final boolean isSetFlowOnReceipt() {
        return this.setFlowOnReceipt;
    }

    public final boolean isSetBusAndChannelOnReceipt() {
        return this.setBusAndChannelOnReceipt;
    }

    public final boolean isSetKeyOnReceipt() {
        return this.setKeyOnReceipt;
    }

    public final boolean isSetSnoOnReceipt() {
        return this.setSnoOnReceipt;
    }

    public final boolean isEnableInboundTransportHeaders() {
        return this.enableInboundTransportHeaders;
    }

    public final boolean topicStartsWithChannel() {
        return this.topicStartsWithChannel;
    }

    public final boolean isEnableConcurrentSends() {
        return this.enableConcurrentSends;
    }

    public final boolean rawMode() {
        return this.rawMode;
    }

    @Override
    public final boolean acksRequireFlush() {
        return this.doAcksRequireFlush();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void fail(Exception e, boolean dispatchFailureEvent) throws SmaException {
        if (this.state != MessageBusBinding.State.Open && this.state != MessageBusBinding.State.Closing) throw this.prepareStateValidationErrorException();
        if (!this.doCanFail()) throw new IllegalStateException("binding does not support failed state.");
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Failing binding...", Tracer.Level.DEBUG);
        }
        this.doClose();
        this.onFail(e, dispatchFailureEvent);
    }

    @Override
    public final void close() throws SmaException {
        this.close(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close(int flags) throws SmaException {
        if (this.state != MessageBusBinding.State.Closed && this.state != MessageBusBinding.State.Closing) {
            if (this.state != MessageBusBinding.State.Failed) {
                this.state = MessageBusBinding.State.Closing;
            }
            try {
                if (this.latencyManager != null) {
                    this.latencyManager.shutdown();
                }
                boolean preserveChannelJoins = (flags & 1) != 0;
                this.channelTablesWriteLock.lock();
                ArrayList<Object> channelsToClose = new ArrayList<Object>(this.channelsByXString.size());
                try {
                    if (this.tracer.debug) {
                        this.tracer.log(this.tracePrefix + "Closing channels (count=" + this.channelsByXString.size() + ", preserveChannelJoins=" + preserveChannelJoins + ").", Tracer.Level.DEBUG);
                    }
                    XIterator iterator = this.channelsByXString.reuseableValueIterator();
                    while (iterator.hasNext()) {
                        channelsToClose.add(iterator.next());
                    }
                }
                finally {
                    this.channelTablesWriteLock.unlock();
                }
                for (int i = 0; i < channelsToClose.size(); ++i) {
                    MessageChannel channel = (MessageChannel)channelsToClose.get(i);
                    boolean preserveThisChannelJoin = preserveChannelJoins;
                    switch (channel.getDescriptor().getPreserveJoinsOnClose()) {
                        case Default: {
                            break;
                        }
                        case Leave: {
                            preserveThisChannelJoin = false;
                            break;
                        }
                        case Preserve: {
                            preserveThisChannelJoin = true;
                        }
                    }
                    channel.close(preserveThisChannelJoin ? 64 : 0);
                }
                this.doClose();
                this.channelTablesWriteLock.lock();
                try {
                    this.channelsByXString.clear();
                    this.channelsByName.clear();
                    this.channelsById.clear();
                    this.blacklistedChannelIds.clear();
                }
                finally {
                    this.channelTablesWriteLock.unlock();
                }
                this.state = MessageBusBinding.State.Closed;
            }
            catch (Throwable thrown) {
                if (this.state == MessageBusBinding.State.Closing) {
                    if (this.canFail()) {
                        this.onFail(new SmaException(this.tracePrefix + "Exception during binding close: " + thrown.getMessage(), thrown), false);
                    } else {
                        this.state = MessageBusBinding.State.Closed;
                    }
                }
                if (thrown instanceof SmaException) {
                    throw (SmaException)thrown;
                }
                throw new SmaException(this.tracePrefix + "Exception during binding close: " + thrown.getMessage(), thrown);
            }
        }
    }

    protected final void finalize() {
        try {
            this.close();
        }
        catch (SmaException smaException) {
            // empty catch block
        }
    }

    protected abstract class Acknowledger<T extends Acknowledger<T>>
    implements IEventAcknowledger,
    UtlPool.Item<T> {
        private UtlPool<T> pool;

        protected Acknowledger() {
        }

        protected abstract void doAck();

        protected abstract void doReset();

        public final void ack() {
            this.doAck();
            if (MessageBusBindingBase.this.statsListener != null) {
                MessageBusBindingBase.this.statsListener.onAck();
            }
        }

        public final void dispose() {
            if (this.pool != null) {
                try {
                    this.pool.put((UtlPool.Item)this);
                }
                catch (IllegalStateException re) {
                    switch (MessageBusBindingBase.this.getState()) {
                        case Closed: 
                        case Closing: 
                        case Failed: {
                            if (!((MessageBusBindingBase)MessageBusBindingBase.this).tracer.debug) break;
                            MessageBusBindingBase.this.tracer.log(MessageBusBindingBase.this.tracePrefix + "Ignoring pool error for closed binding [" + re.getMessage() + "]", Tracer.Level.DEBUG);
                            break;
                        }
                        default: {
                            throw re;
                        }
                    }
                }
            }
        }

        public final T init() {
            this.doReset();
            return (T)this;
        }

        public final T setPool(UtlPool<T> pool) {
            this.pool = pool;
            return (T)this;
        }

        public final UtlPool<T> getPool() {
            return this.pool;
        }
    }

    private final class DefaultSequenceNumberGenerator
    implements MessageBusBinding.SequenceNumberGenerator {
        private long sno;

        private DefaultSequenceNumberGenerator() {
        }

        @Override
        public final long nextSno(MessageView view) {
            return ++this.sno;
        }
    }
}

