/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util.collect;

import com.neeve.query.impl.util.collect.UtlRangeBase;
import java.util.Iterator;

public abstract class UtlIterableRange<T extends Comparable<T>, I>
extends UtlRangeBase<T>
implements Iterable<T> {
    protected I increment;

    public UtlIterableRange(T start, T end) {
        super(start, end);
    }

    public void setIncrement(I increment) {
        this.increment = increment;
    }

    public abstract T addIncrement(T var1);

    @Override
    public Iterator<T> iterator() {
        if (this.increment == null) {
            throw new IllegalStateException("increment is not yet set or was set to null.");
        }
        return new Iterator<T>(){
            private T next;
            {
                this.next = UtlIterableRange.this.getStart();
                if (!UtlIterableRange.this.includeStart()) {
                    this.next = UtlIterableRange.this.addIncrement(this.next);
                }
            }

            @Override
            public boolean hasNext() {
                int comparison = this.next.compareTo(UtlIterableRange.this.getEnd());
                return comparison < 0 || UtlIterableRange.this.includeEnd() && comparison == 0;
            }

            @Override
            public T next() {
                Object result = this.next;
                this.next = UtlIterableRange.this.addIncrement(this.next);
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

