/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ods.impl;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreField;
import com.neeve.ods.IStoreObject;
import com.neeve.ods.IStoreQueryRepository;
import com.neeve.ods.OdsConfig;
import com.neeve.ods.impl.StoreBindingImpl;
import com.neeve.query.QueryException;
import com.neeve.query.QueryIndexer;
import com.neeve.query.impl.QueryIndexableRepository;
import com.neeve.query.impl.QueryRepositoryBase;
import java.util.Iterator;

class StoreQueryRepositoryImpl
extends QueryRepositoryBase<UUID, IStoreObject>
implements IStoreQueryRepository,
QueryIndexableRepository<UUID, IStoreObject> {
    private final StoreBindingImpl store;
    private boolean started = false;

    StoreQueryRepositoryImpl(StoreBindingImpl store) {
        super(null, store.getStoreName(), OdsConfig.getConfig());
        this.store = store;
    }

    final void onPut(IStoreObject object) {
        this.indexer.put(object);
    }

    @Override
    protected final void onIndexerOpened(QueryIndexer<UUID, IStoreObject> indexer) {
    }

    @Override
    public final void flushIndexing() throws QueryException {
        if (!this.started) {
            throw new QueryException("flushIndexing can't be called on a closed log");
        }
    }

    final void onUpdate(IStoreObject before, IStoreObject after) {
        this.indexer.update(before, after);
    }

    public <T> void onFieldUpdated(IStoreObject object, IStoreField<T> field, T oldVal, T newVal) {
        this.indexer.updateField(object, field, oldVal, newVal);
    }

    public void onRemove(IStoreObject toRemove) {
        if (toRemove == null) {
            throw new QueryException("Cannot remove null object from repository");
        }
        this.indexer.remove(toRemove);
    }

    public void commit() {
        this.indexer.commit(0L);
    }

    public void rollback() {
        this.indexer.rollback();
    }

    @Override
    public long getCommitSequence(IStoreObject record) {
        return record.getTransactionId();
    }

    @Override
    public UUID getRecordId(IStoreObject record) {
        return record.getOid();
    }

    @Override
    public IStoreObject retrieve(UUID key) throws QueryException {
        if (!this.started) {
            throw new IllegalStateException("closed");
        }
        try {
            return this.store.get(key);
        }
        catch (Exception e) {
            throw new QueryException("Error fetching store object [" + key + "]: " + e.getMessage(), e);
        }
    }

    @Override
    public final Iterable<IStoreObject> retrieve(long startSeqNo, long endSeqNo) throws QueryException {
        try {
            return new IStoreObjectFetcher();
        }
        catch (Exception e) {
            throw new QueryException("Error fetching log entries: " + e.getMessage(), e);
        }
    }

    @Override
    public synchronized void open() throws Exception {
        if (!this.started) {
            try {
                this.started = true;
                super.open();
            }
            catch (Exception e) {
                super.close();
            }
        }
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.started) {
            this.flushIndexing();
            this.started = false;
        }
    }

    @Override
    protected void stopIndexing() throws InterruptedException {
    }

    @Override
    protected final synchronized void startIndexing(long fromPos) throws QueryException {
        for (IStoreObject object : this.retrieveAll()) {
            this.onPut(object);
        }
    }

    @Override
    public final boolean isLiveIndexingUpToDate() {
        return true;
    }

    @Override
    protected boolean isOrderedRepository() {
        return false;
    }

    @Override
    protected boolean isIndexerEarlyCreated() {
        return true;
    }

    private class IStoreObjectFetcher
    implements Iterable<IStoreObject> {
        IStoreObjectFetcher() throws Exception {
        }

        @Override
        public Iterator<IStoreObject> iterator() {
            return new Iterator<IStoreObject>(){
                final Iterator<IStoreObject> entries;
                {
                    this.entries = StoreQueryRepositoryImpl.this.store.entries();
                }

                @Override
                public boolean hasNext() {
                    return this.entries.hasNext();
                }

                @Override
                public IStoreObject next() {
                    return this.entries.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported in store query iterator");
                }
            };
        }
    }
}

