/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.client.link.ClientLinkManager;
import com.neeve.client.link.EClientLinkException;
import com.neeve.client.link.EClientLinkNotManagedException;
import com.neeve.tools.interactive.commands.Command;
import com.neeve.tools.interactive.commands.Links;

public final class Open
extends Command {
    private final ClientLinkManager linkManager;
    private final Links links;

    public Open(ClientLinkManager linkManager, Links links) {
        this.linkManager = linkManager;
        this.links = links;
    }

    private void processOpen(String name, int timeout, boolean async) {
        try {
            this.linkManager.open(name.compareToIgnoreCase("all") == 0 ? null : name, timeout, async ? 1 : 0);
            this.links.run(new String[0]);
        }
        catch (EClientLinkNotManagedException e) {
            System.out.println("Invalid link ['" + name + "'].");
        }
        catch (EClientLinkException e) {
            System.out.println("Failure ['" + e.toString() + "'].");
        }
    }

    public final void run(String[] args) {
        if (args.length != 3) {
            System.out.println("Syntax error: Open <name> <timeout> <aysnc>");
        } else {
            this.processOpen(args[0], Integer.parseInt(args[1]), Boolean.parseBoolean(args[2]));
        }
    }

    public final void help() {
        System.out.println("open <name>");
        System.out.println("  Opens a link maintained by the link manager [Specify name='all' to open all managed links].");
    }

    public final String[] keywords() {
        return new String[]{"open"};
    }
}

