/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import cern.colt.function.IntObjectProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.aep.AepBusConnection;
import com.neeve.aep.AepBusConnectionStats;
import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepBusConnectionStats;
import com.neeve.aep.IAepEngineStats;
import com.neeve.event.IEventMultiplexerStats;
import com.neeve.lang.XCollectionIterator;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIntMap;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingStats;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.ods.IStoreSender;
import com.neeve.ods.IStoreSenderStats;
import com.neeve.rog.IRogMessageLogger;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvController;
import com.neeve.server.controller.SrvControllerAdminApp;
import com.neeve.server.controller.SrvControllerDirectHeartbeatGenerator;
import com.neeve.server.controller.SrvControllerFileSystemAccessor;
import com.neeve.server.controller.SrvControllerHeartbeatGenerator;
import com.neeve.server.mon.SrvMonAdminClientStats;
import com.neeve.server.mon.SrvMonAppBusBindingStats;
import com.neeve.server.mon.SrvMonAppEngineStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerFeederQueueStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerStats;
import com.neeve.server.mon.SrvMonAppMessageLoggerStats;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonAppStoreBindingICRSenderStats;
import com.neeve.server.mon.SrvMonAppStoreBindingPersisterStats;
import com.neeve.server.mon.SrvMonAppStoreBindingRole;
import com.neeve.server.mon.SrvMonAppStoreBindingState;
import com.neeve.server.mon.SrvMonAppStoreBindingStats;
import com.neeve.server.mon.SrvMonAppStoreICRRole;
import com.neeve.server.mon.SrvMonDisruptorClaimStrategy;
import com.neeve.server.mon.SrvMonDisruptorStats;
import com.neeve.server.mon.SrvMonDisruptorWaitStrategy;
import com.neeve.server.mon.SrvMonIntSeries;
import com.neeve.server.mon.SrvMonLongSeries;
import com.neeve.server.mon.SrvMonMsgTypeStats;
import com.neeve.server.mon.SrvMonPoolStats;
import com.neeve.server.mon.SrvMonSeriesType;
import com.neeve.server.mon.SrvMonSysDiskStats;
import com.neeve.server.mon.SrvMonSysGCCollectorStats;
import com.neeve.server.mon.SrvMonSysGCStats;
import com.neeve.server.mon.SrvMonSysIndividualThreadStats;
import com.neeve.server.mon.SrvMonSysJITStats;
import com.neeve.server.mon.SrvMonSysMemoryEntityTypeCounters;
import com.neeve.server.mon.SrvMonSysMemoryIOBufCounters;
import com.neeve.server.mon.SrvMonSysMemoryNativeCounters;
import com.neeve.server.mon.SrvMonSysMemoryOffHeapUsage;
import com.neeve.server.mon.SrvMonSysMemoryStats;
import com.neeve.server.mon.SrvMonSysMemoryUsage;
import com.neeve.server.mon.SrvMonSysStats;
import com.neeve.server.mon.SrvMonSysThreadStats;
import com.neeve.server.mon.SrvMonUserCounterStat;
import com.neeve.server.mon.SrvMonUserGaugeStat;
import com.neeve.server.mon.SrvMonUserSeriesStat;
import com.neeve.server.mon.SrvMonUserStats;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.stats.IStats;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

final class SrvControllerIndirectHeartbeatGenerator
extends SrvControllerHeartbeatGenerator {
    private final SrvController controller;
    private final Sys sys;
    private final Pools pools;
    private final AdminClients adminClients;
    private final Apps apps;
    private final long statsInterval;
    private final WeakHashMap<Thread, XString> threadNameCache = new WeakHashMap();
    private final boolean seriesCollectionEnabled;
    private final SrvController.IntHistogramComputer intervalIntSeriesComputer;
    private final SrvController.LongHistogramComputer intervalLongSeriesComputer;
    private final DoubleArrayList tempSeriesCollectorArray = new DoubleArrayList();
    private final XLinkedHashMap<IStats.Series, SrvController.IntSeriesCollector> intSeriesCollectors = new XLinkedHashMap();
    private final XLinkedHashMap<IStats.Series, SrvController.LongSeriesCollector> longSeriesCollectors = new XLinkedHashMap();
    private final Object processingCriticalSection = new Object();
    private final SrvConfigDescriptor.Heartbeats config;
    private long lastThreadNameCacheCleanup = -1L;
    private boolean done;

    SrvControllerIndirectHeartbeatGenerator(SrvController controller) {
        this.config = controller.configDescriptor.getHeartbeats();
        this.setName("X-Server-" + controller.getConfigDescriptor().getName() + "-SrvControllerIndirectHeartbeatGenerator");
        this.controller = controller;
        this.sys = new Sys(this);
        this.pools = new Pools(this.config.isCollectPoolStats(), this.config.isCollectAllPoolStats(), controller.configDescriptor.getHeartbeats().getPoolDepletionThreshold());
        this.adminClients = new AdminClients();
        this.apps = new Apps(this);
        this.statsInterval = this.config.getInterval() * 1000L;
        this.seriesCollectionEnabled = this.config.isCollectSeriesStats();
        this.intervalIntSeriesComputer = new SrvController.IntHistogramComputer();
        this.intervalLongSeriesComputer = new SrvController.LongHistogramComputer();
    }

    private final XString lookupThreadName(Thread thread) {
        XString name = this.threadNameCache.get(thread);
        if (name == null) {
            name = XString.create((String)thread.getName());
            this.threadNameCache.put(thread, name);
        }
        if (this.lastThreadNameCacheCleanup == -1L) {
            this.lastThreadNameCacheCleanup = System.currentTimeMillis();
        }
        if (this.threadNameCache.size() > 100 && this.lastThreadNameCacheCleanup - System.currentTimeMillis() > 60000L) {
            Iterator<Thread> cachedThreads = this.threadNameCache.keySet().iterator();
            while (cachedThreads.hasNext()) {
                Thread candidate = cachedThreads.next();
                if (candidate == null || candidate.isAlive()) continue;
                cachedThreads.remove();
            }
        }
        return name;
    }

    private final SrvMonIntSeries collectIntSeriesStats(IStats.Series series) {
        if (this.seriesCollectionEnabled && series != null) {
            SrvController.IntSeriesCollector collector = (SrvController.IntSeriesCollector)this.intSeriesCollectors.get((Object)series);
            if (collector == null) {
                collector = new SrvController.IntSeriesCollector(series, this.tempSeriesCollectorArray, this.controller.configDescriptor.getHeartbeats().isCollectSeriesDatapoints());
                this.intSeriesCollectors.put((Object)series, (Object)collector);
            }
            try {
                return collector.collect(this.intervalIntSeriesComputer);
            }
            catch (Throwable e) {
                this.controller.tracer().log("Exception encountered while collecting series (int) stats: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                return null;
            }
        }
        return null;
    }

    private final SrvMonLongSeries collectLongSeriesStats(IStats.Series series) {
        if (this.seriesCollectionEnabled && series != null) {
            SrvController.LongSeriesCollector collector = (SrvController.LongSeriesCollector)this.longSeriesCollectors.get((Object)series);
            if (collector == null) {
                collector = new SrvController.LongSeriesCollector(series, this.tempSeriesCollectorArray, this.controller.configDescriptor.getHeartbeats().isCollectSeriesDatapoints());
                this.longSeriesCollectors.put((Object)series, (Object)collector);
            }
            try {
                return collector.collect(this.intervalLongSeriesComputer);
            }
            catch (Throwable e) {
                this.controller.tracer().log("Exception encountered while collecting series (long) stats: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                return null;
            }
        }
        return null;
    }

    private final SrvMonAppMessageLoggerStats populateMessageLoggerStats(IRogMessageLogger.Stats loggerStats) {
        if (loggerStats != null) {
            SrvMonAppMessageLoggerStats monLoggerStats = SrvMonAppMessageLoggerStats.create();
            monLoggerStats.setNumMessagesRecorded(loggerStats.getNumMessagesLogged());
            monLoggerStats.setNumCommits(loggerStats.getNumCommits());
            monLoggerStats.setNumExplicitFlushes(loggerStats.getNumFlushesExplicit());
            monLoggerStats.setNumImplicitFlushes(loggerStats.getNumFlushesImplicit());
            monLoggerStats.setNumForks(0L);
            monLoggerStats.setDetachedPersist(loggerStats.isDetached());
            if (monLoggerStats.getDetachedPersist()) {
                SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                disruptorStats.setCapacity(loggerStats.getDisruptorCapacity());
                disruptorStats.setRemaining(loggerStats.getDisruptorRemaining());
                disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(loggerStats.getDisruptorClaimStrategy()));
                disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(loggerStats.getDisruptorWaitStrategy()));
                disruptorStats.setOfferToPollLatencies(this.collectIntSeriesStats((IStats.Series)loggerStats.getOfferToPollLatencies()));
                monLoggerStats.setDisruptorStats(disruptorStats);
            }
            monLoggerStats.setFileSize(loggerStats.getFileSize());
            monLoggerStats.setFileSizeUsed(loggerStats.getFileSizeUsed());
            return monLoggerStats;
        }
        return null;
    }

    private final SrvMonDisruptorClaimStrategy toDisruptorClaimStrategy(String claimStrategyStr) {
        try {
            return SrvMonDisruptorClaimStrategy.valueOf(claimStrategyStr);
        }
        catch (Throwable e) {
            return SrvMonDisruptorClaimStrategy.Unknown;
        }
    }

    private final SrvMonDisruptorWaitStrategy toDisruptorWaitStrategy(String waitStrategyStr) {
        try {
            return SrvMonDisruptorWaitStrategy.valueOf(waitStrategyStr);
        }
        catch (Throwable e) {
            return SrvMonDisruptorWaitStrategy.Unknown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void shutdown() {
        Object object = this.processingCriticalSection;
        synchronized (object) {
            this.done = true;
            this.interrupt();
        }
        while (true) {
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    @Override
    final void onPoolAdded(UtlPool<?> pool) {
        this.pools.onPoolAdded(pool);
    }

    @Override
    final void onPoolRemoved(UtlPool<?> pool) {
        this.pools.onPoolRemoved(pool);
    }

    @Override
    final void onAppInitialized(SrvAppLoader appLoader) {
        this.apps.onAppInitialized(appLoader);
    }

    @Override
    final void onAppUnloaded(String appName) {
        this.apps.onAppUnloaded(appName);
    }

    @Override
    final void onAdminClientConnected(SrvControllerAdminApp.AdminClientContext client) {
        this.adminClients.onAdminClientConnected(client);
    }

    @Override
    final void onAdminClientDisconnected(SrvControllerAdminApp.AdminClientContext client) {
        this.adminClients.onAdminClientDisconnected(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void run() {
        UtlThread.setDefaultCPUAffinityMask();
        XIndexedList poolStats = new XIndexedList();
        XIndexedList adminClientStats = new XIndexedList();
        XIndexedList appStats = new XIndexedList();
        long nextHeartbeat = System.currentTimeMillis() + this.statsInterval;
        UtlThread.ThreadStats threadStats = UtlThread.registerOrGetThreadStats((Thread)Thread.currentThread());
        try {
            while (!this.done) {
                try {
                    threadStats.preWait();
                    Thread.sleep(Math.max(0L, nextHeartbeat - System.currentTimeMillis()));
                    threadStats.postWait();
                    nextHeartbeat = System.currentTimeMillis() + this.statsInterval;
                    Object object = this.processingCriticalSection;
                    synchronized (object) {
                        if (!this.done) {
                            try {
                                long wallTime = System.currentTimeMillis();
                                long ts1 = System.nanoTime();
                                SrvMonSysStats sysStats = this.sys.createForHeartbeat();
                                this.pools.createForHeartbeat((XIndexedList<SrvMonPoolStats>)poolStats);
                                this.apps.createForHeartbeat((XIndexedList<SrvMonAppStats>)appStats);
                                this.adminClients.createForHeartbeat((XIndexedList<SrvMonAdminClientStats>)adminClientStats);
                                SrvMonAppMessageLoggerStats heartbeatLoggerStats = null;
                                if (this.controller.isHeartbeatLogOpen()) {
                                    heartbeatLoggerStats = this.populateMessageLoggerStats(this.controller.getHeartbeatLogStats());
                                }
                                this.controller.processHeartbeat(this.controller.prepareHeartbeat(wallTime, ts1, System.nanoTime(), sysStats, (XIndexedList<SrvMonPoolStats>)poolStats, (XIndexedList<SrvMonAdminClientStats>)adminClientStats, (XIndexedList<SrvMonAppStats>)appStats, heartbeatLoggerStats));
                            }
                            catch (Throwable e) {
                                this.controller.tracer().log("Error preparing/processing heartbeat" + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                            }
                        }
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                finally {
                    poolStats.clear();
                    adminClientStats.clear();
                    appStats.clear();
                }
            }
            return;
        }
        finally {
            UtlThread.deregister((Thread)Thread.currentThread());
        }
    }

    static final class Apps {
        private final XLinkedHashMap<String, AppStats> appsStats = new XLinkedHashMap();
        private final XIndexedList<IEventMultiplexerStats.IFeederQueueStats> feederQueueStatsCollector = new XIndexedList();
        private final XIndexedList<IAepBusConnectionStats> busConnectionStatsCollector = new XIndexedList();
        private final MsgTypeStatsCollector msgTypeStatsCollector = new MsgTypeStatsCollector();
        private final int inactiveMessageTypeStatsInclusionFrequency;
        private final SrvControllerIndirectHeartbeatGenerator heartbeatGenerator;
        private int inactiveMessageTypeStatsInclusionCountdown = 1;

        public Apps(SrvControllerIndirectHeartbeatGenerator heartbeatGenerator) {
            this.heartbeatGenerator = heartbeatGenerator;
            this.inactiveMessageTypeStatsInclusionFrequency = heartbeatGenerator != null ? heartbeatGenerator.config.getInactiveMessageTypeStatsInclusionFrequency() : 1;
            this.inactiveMessageTypeStatsInclusionCountdown = this.inactiveMessageTypeStatsInclusionFrequency;
        }

        private final SrvMonDisruptorClaimStrategy toDisruptorClaimStrategy(String claimStrategyStr) {
            try {
                return SrvMonDisruptorClaimStrategy.valueOf(claimStrategyStr);
            }
            catch (Throwable e) {
                return SrvMonDisruptorClaimStrategy.Unknown;
            }
        }

        private final SrvMonDisruptorWaitStrategy toDisruptorWaitStrategy(String waitStrategyStr) {
            try {
                return SrvMonDisruptorWaitStrategy.valueOf(waitStrategyStr);
            }
            catch (Throwable e) {
                return SrvMonDisruptorWaitStrategy.Unknown;
            }
        }

        private final void populateEngineStats(IAepEngineStats engineStats, SrvMonAppStats appStats) {
            SrvMonAppEngineStats monEngineStats = SrvMonAppEngineStats.create();
            monEngineStats.setNumFlows(engineStats.getNumFlows());
            monEngineStats.setNumMsgsRcvdBestEffort(engineStats.getNumMsgsRcvdBestEffort());
            monEngineStats.setNumMsgsRcvdGuaranteed(engineStats.getNumMsgsRcvdGuaranteed());
            monEngineStats.setNumMsgsFiltered(engineStats.getNumMsgsFiltered());
            monEngineStats.setNumMsgsSourced(engineStats.getNumMsgsSourced());
            monEngineStats.setNumDupMsgsRcvd(engineStats.getNumDupMsgsRcvd());
            monEngineStats.setNumMsgsSentBestEffort(engineStats.getNumMsgsSentBestEffort());
            monEngineStats.setNumMsgsSentGuaranteed(engineStats.getNumMsgsSentGuaranteed());
            monEngineStats.setNumMsgsResent(engineStats.getNumMsgsResent());
            monEngineStats.setNumEventsRcvd(engineStats.getNumEventsRcvd());
            monEngineStats.setNumEventsProcessed(engineStats.getNumEventsProcessed());
            monEngineStats.setNumFlowEventsRcvd(engineStats.getNumFlowEventsRcvd());
            monEngineStats.setNumFlowEventsProcSuccess(engineStats.getNumFlowEventsProcSuccess());
            monEngineStats.setNumFlowEventsProcFail(engineStats.getNumFlowEventsProcFail());
            monEngineStats.setNumFlowEventsProcComplete(engineStats.getNumFlowEventsProcComplete());
            monEngineStats.setNumTransactions(engineStats.getNumTransactions());
            monEngineStats.setNumCommitsStarted(engineStats.getNumCommitsStarted());
            monEngineStats.setNumCommitsCompleted(engineStats.getNumCommitsCompleted());
            monEngineStats.setNumSendCommitsStarted(engineStats.getNumSendCommitsStarted());
            monEngineStats.setNumSendCommitsCompleted(engineStats.getNumSendCommitsCompleted());
            monEngineStats.setSendCommitCompletionQueueSize(engineStats.getSendCommitCompletionQueueSize());
            monEngineStats.setNumStoreCommitsStarted(engineStats.getNumStoreCommitsStarted());
            monEngineStats.setNumStoreCommitsCompleted(engineStats.getNumStoreCommitsCompleted());
            monEngineStats.setStoreCommitCompletionQueueSize(engineStats.getStoreCommitCompletionQueueSize());
            monEngineStats.setNumRollbacks(engineStats.getNumRollbacks());
            monEngineStats.setNumPartialRollbacks(engineStats.getNumPartialRollbacks());
            monEngineStats.setBackupOutboundQueueSize(engineStats.getBackupOutboundQueueSize());
            monEngineStats.setBackupOutboundLogQueueSize(engineStats.getBackupOutboundLogQueueSize());
            monEngineStats.setOutboundSno(engineStats.getOutboundSequenceNumber());
            monEngineStats.setOutboundStableSno(engineStats.getOutboundStableSequenceNumber());
            monEngineStats.setCommitEpilogueLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitEpilogueLatencies()));
            monEngineStats.setCommitFullLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitFullLatencies()));
            monEngineStats.setCommitPrologueLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitPrologueLatencies()));
            monEngineStats.setCommitSendLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitSendLatencies()));
            monEngineStats.setCommitStartLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitStartLatencies()));
            monEngineStats.setCommitStoreLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitStoreLatencies()));
            monEngineStats.setCommitTransitionLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getCommitTransitionLatencies()));
            monEngineStats.setInAckLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getInAckLatencies()));
            monEngineStats.setInOutLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getInOutLatencies()));
            monEngineStats.setMsgPreProcLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgPreProcessingLatencies()));
            monEngineStats.setMsgProcessingLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgProcessingLatencies()));
            monEngineStats.setMsgFilteringLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgFilteringLatencies()));
            monEngineStats.setMsgSendCoreLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgSendCoreLatencies()));
            monEngineStats.setMsgSendLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getMsgSendLatencies()));
            monEngineStats.setTransactionLeg1ProcessingTimes(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg1ProcessingTimes()));
            monEngineStats.setTransactionLeg2ProcessingTimes(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg2ProcessingTimes()));
            monEngineStats.setTransactionLeg3ProcessingTimes(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg3ProcessingTimes()));
            if (this.heartbeatGenerator.config.isIncludeMessageTypeStats()) {
                this.msgTypeStatsCollector.collect(engineStats.getMessageTypeStatsTable(), monEngineStats);
            }
            this.populateUserStats(engineStats, appStats);
            SrvMonAppEventMultiplexerStats monEventMultiplexerStats = SrvMonAppEventMultiplexerStats.create();
            IEventMultiplexerStats eventMultiplexerStats = engineStats.getEventMultiplexerStats();
            if (eventMultiplexerStats != null) {
                monEventMultiplexerStats.setLastDecongested(eventMultiplexerStats.getLastDecongested());
                monEventMultiplexerStats.setMaxConcurrency(eventMultiplexerStats.getMaxConcurrency());
                monEventMultiplexerStats.setScheduleQueueSize(eventMultiplexerStats.getScheduleQueueSize());
                SrvMonDisruptorStats monDisruptorStats = SrvMonDisruptorStats.create();
                monDisruptorStats.setCapacity(eventMultiplexerStats.getCapacity());
                monDisruptorStats.setRemaining(eventMultiplexerStats.getCapacityRemaining());
                monDisruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(eventMultiplexerStats.getClaimStrategy()));
                monDisruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(eventMultiplexerStats.getWaitStrategy()));
                monDisruptorStats.setOfferToPollLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)eventMultiplexerStats.getOfferToPollLatencies()));
                monEventMultiplexerStats.setDisruptorStats(monDisruptorStats);
                this.feederQueueStatsCollector.clear();
                eventMultiplexerStats.getFeederQueueStats(this.feederQueueStatsCollector);
                for (int i = 0; i < this.feederQueueStatsCollector.size(); ++i) {
                    SrvMonAppEventMultiplexerFeederQueueStats stat = SrvMonAppEventMultiplexerFeederQueueStats.create();
                    Thread owner = ((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getOwner();
                    if (owner != null) {
                        if (this.heartbeatGenerator != null) {
                            stat.lendOwner(this.heartbeatGenerator.lookupThreadName(owner));
                        } else {
                            stat.setOwner(owner.getName());
                        }
                        stat.setSize(((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getSize());
                        stat.setDecongestCount(((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getDecongestCount());
                        stat.setOfferToPollLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getOfferToPollLatencies()));
                    }
                    monEventMultiplexerStats.addFeederQueueStats(stat);
                }
            }
            appStats.setEventMultiplexerStats(monEventMultiplexerStats);
            this.populateInboundMessageLoggerStats(engineStats, monEngineStats);
            this.populateOutboundMessageLoggerStats(engineStats, monEngineStats);
            this.populatePerTransactionStatsLoggerStats(engineStats, monEngineStats);
            appStats.setEngineStats(monEngineStats);
        }

        private final SrvMonAppStoreBindingRole toStoreBindingRole(IStoreBinding.Role role) {
            if (role != null) {
                switch (role) {
                    case Primary: {
                        return SrvMonAppStoreBindingRole.Primary;
                    }
                    case Backup: {
                        return SrvMonAppStoreBindingRole.Backup;
                    }
                }
                return SrvMonAppStoreBindingRole.Unknown;
            }
            return null;
        }

        private final SrvMonAppStoreICRRole toStoreICRRole(IStoreBinding.InterClusterReplicationRole interClusterReplicationRole) {
            if (interClusterReplicationRole == null) {
                return SrvMonAppStoreICRRole.None;
            }
            switch (interClusterReplicationRole) {
                case Sender: {
                    return SrvMonAppStoreICRRole.Sender;
                }
                case StandaloneReceiver: {
                    return SrvMonAppStoreICRRole.StandaloneReceiver;
                }
            }
            return SrvMonAppStoreICRRole.None;
        }

        private final SrvMonAppStoreBindingState toStoreBindingState(IStoreBinding.State state) {
            if (state != null) {
                switch (state) {
                    case Opening: {
                        return SrvMonAppStoreBindingState.Opening;
                    }
                    case Open: {
                        return SrvMonAppStoreBindingState.Open;
                    }
                    case Failed: {
                        return SrvMonAppStoreBindingState.Failed;
                    }
                    case Closed: {
                        return SrvMonAppStoreBindingState.Closed;
                    }
                }
                return SrvMonAppStoreBindingState.Unknown;
            }
            return null;
        }

        private final void populateStoreBindingPersisterStats(IStoreBindingStats storeBindingStats, SrvMonAppStoreBindingStats stats) {
            IStorePersisterStats persisterStats = storeBindingStats.getPersisterStats();
            if (persisterStats != null) {
                SrvMonAppStoreBindingPersisterStats monPersisterStats = SrvMonAppStoreBindingPersisterStats.create();
                monPersisterStats.setNumPutsRecorded(persisterStats.getNumPutsRecorded());
                monPersisterStats.setNumUpdatesRecorded(persisterStats.getNumUpdatesRecorded());
                monPersisterStats.setNumRemovesRecorded(persisterStats.getNumRemovesRecorded());
                monPersisterStats.setNumSendsRecorded(persisterStats.getNumSendsRecorded());
                monPersisterStats.setNumCommits(persisterStats.getNumCommits());
                monPersisterStats.setNumForks(persisterStats.getNumForks());
                monPersisterStats.setDetachedPersist(persisterStats.isDetached());
                if (monPersisterStats.getDetachedPersist()) {
                    SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                    disruptorStats.setCapacity(persisterStats.getDisruptorCapacity());
                    disruptorStats.setRemaining(persisterStats.getDisruptorRemaining());
                    disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(persisterStats.getDisruptorClaimStrategy()));
                    disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(persisterStats.getDisruptorWaitStrategy()));
                    disruptorStats.setOfferToPollLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)persisterStats.getOfferToPollLatencies()));
                    monPersisterStats.setDisruptorStats(disruptorStats);
                }
                monPersisterStats.setFileSize(persisterStats.getFileSize());
                monPersisterStats.setFileSizeUsed(persisterStats.getFileSizeUsed());
                stats.setPersisterStats(monPersisterStats);
            }
        }

        private final void populateStoreBindingICRSenderStats(IStoreBindingStats storeBindingStats, SrvMonAppStoreBindingStats stats) {
            IStoreSenderStats senderStats = storeBindingStats.getICRSenderStats();
            if (senderStats != null) {
                SrvMonAppStoreBindingICRSenderStats monSenderStats = SrvMonAppStoreBindingICRSenderStats.create();
                monSenderStats.setNumPutsRecorded(senderStats.getNumPutsRecorded());
                monSenderStats.setNumUpdatesRecorded(senderStats.getNumUpdatesRecorded());
                monSenderStats.setNumRemovesRecorded(senderStats.getNumRemovesRecorded());
                monSenderStats.setNumSendsRecorded(senderStats.getNumSendsRecorded());
                monSenderStats.setNumCommits(senderStats.getNumCommits());
                monSenderStats.setNumForks(senderStats.getNumForks());
                monSenderStats.setDetachedSend(senderStats.isDetached());
                if (monSenderStats.getDetachedSend()) {
                    SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                    disruptorStats.setCapacity(senderStats.getDisruptorCapacity());
                    disruptorStats.setRemaining(senderStats.getDisruptorRemaining());
                    disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(senderStats.getDisruptorClaimStrategy()));
                    disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(senderStats.getDisruptorWaitStrategy()));
                    disruptorStats.setOfferToPollLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)senderStats.getOfferToPollLatencies()));
                    monSenderStats.setDisruptorStats(disruptorStats);
                }
                stats.setICRSenderStats(monSenderStats);
            }
        }

        private final void populateInboundMessageLoggerStats(IAepEngineStats engineStats, SrvMonAppEngineStats stats) {
            SrvMonAppMessageLoggerStats monLoggerStats = this.heartbeatGenerator.populateMessageLoggerStats(engineStats.getInboundMessageLoggerStats());
            stats.setInboundMessageLoggerStats(monLoggerStats);
        }

        private final void populateOutboundMessageLoggerStats(IAepEngineStats engineStats, SrvMonAppEngineStats stats) {
            SrvMonAppMessageLoggerStats monLoggerStats = this.heartbeatGenerator.populateMessageLoggerStats(engineStats.getOutboundMessageLoggerStats());
            stats.setOutboundMessageLoggerStats(monLoggerStats);
        }

        private final void populatePerTransactionStatsLoggerStats(IAepEngineStats engineStats, SrvMonAppEngineStats stats) {
            SrvMonAppMessageLoggerStats monLoggerStats = this.heartbeatGenerator.populateMessageLoggerStats(engineStats.getPerTransactionStatsLoggerStats());
            stats.setPerTransactionStatsLoggerStats(monLoggerStats);
        }

        private final void populateStoreBindingStats(IStoreBindingStats storeBindingStats, SrvMonAppStats appStats) {
            if (storeBindingStats != null) {
                SrvMonAppStoreBindingStats monStoreBindingStats = SrvMonAppStoreBindingStats.create();
                monStoreBindingStats.setRole(this.toStoreBindingRole(storeBindingStats.getRole()));
                monStoreBindingStats.setICRRole(this.toStoreICRRole(storeBindingStats.getBinding().getInterClusterReplicationRole()));
                monStoreBindingStats.setState(this.toStoreBindingState(storeBindingStats.getState()));
                monStoreBindingStats.setSize(storeBindingStats.getBinding().sizeUnprotected());
                monStoreBindingStats.setDataSize(storeBindingStats.getDataSize());
                monStoreBindingStats.setNumCommitsSent(storeBindingStats.getNumCommitsSent());
                monStoreBindingStats.setNumCommitEntriesSent(storeBindingStats.getNumCommitEntriesSent());
                monStoreBindingStats.setNumCommitsReceived(storeBindingStats.getNumCommitsReceived());
                monStoreBindingStats.setNumCommitEntriesReceived(storeBindingStats.getNumCommitEntriesReceived());
                monStoreBindingStats.setNumCommitCompletionsSent(storeBindingStats.getNumCommitCompletionsSent());
                monStoreBindingStats.setNumCommitCompletionsReceived(storeBindingStats.getNumCommitCompletionsReceived());
                monStoreBindingStats.setCommitLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getCommitLatencies()));
                monStoreBindingStats.setCommitQueueSize(this.heartbeatGenerator.collectIntSeriesStats(storeBindingStats.getCommitQueueSizes()));
                monStoreBindingStats.setDeserializeLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getDeserializeLatencies()));
                monStoreBindingStats.setIcrSendLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getIcrSendLatencies()));
                monStoreBindingStats.setIndexLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getIndexLatencies()));
                monStoreBindingStats.setPersistLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getPersisterLatencies()));
                monStoreBindingStats.setSerializeLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeLatencies()));
                monStoreBindingStats.setSerializeToPersistLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeToPersistLatencies()));
                monStoreBindingStats.setSerializeToWireLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeToWireLatencies()));
                monStoreBindingStats.setWireLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getWireLatencies()));
                monStoreBindingStats.setWireToDeserializeLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)storeBindingStats.getWireToDeserializeLatencies()));
                this.populateStoreBindingPersisterStats(storeBindingStats, monStoreBindingStats);
                this.populateStoreBindingICRSenderStats(storeBindingStats, monStoreBindingStats);
                appStats.setStoreBindingStats(monStoreBindingStats);
            }
        }

        private final void populateBusConnectionStats(List<IAepBusConnectionStats> busConnectionsStats, SrvMonAppStats appStats) {
            for (int i = 0; i < busConnectionsStats.size(); ++i) {
                IAepBusConnectionStats busConnectionStats = busConnectionsStats.get(i);
                SrvMonAppBusBindingStats stats = SrvMonAppBusBindingStats.create();
                stats.setBusBindingName(busConnectionStats.getBusConnection().getBusDescriptor().getName());
                stats.setInternal(busConnectionStats.getBusConnection().isInternal());
                stats.setNumMsgsRcvd(busConnectionStats.getNumMsgsRcvd());
                stats.setNumMsgsInBatchesRcvd(busConnectionStats.getNumMsgsInBatchesRcvd());
                stats.setNumMsgBatchesRcvd(busConnectionStats.getNumMsgBatchesRcvd());
                stats.setNumAcksSent(busConnectionStats.getNumAcksSent());
                stats.setNumMsgsEnqueued(busConnectionStats.getNumMsgsEnqueued());
                stats.setNumMsgsSent(busConnectionStats.getNumMsgsSent());
                stats.setNumStabilityRcvd(busConnectionStats.getNumStabilityRcvd());
                stats.setNumStabilityInBatchesRcvd(busConnectionStats.getNumStabilityInBatchesRcvd());
                stats.setNumStabilityBatchesRcvd(busConnectionStats.getNumStabilityBatchesRcvd());
                stats.setNumPacketsRcvd(busConnectionStats.getNumPacketsRcvd());
                stats.setNumCommits(busConnectionStats.getNumCommits());
                stats.setNumRollbacks(busConnectionStats.getNumRollbacks());
                stats.setNumPartialRollbacks(busConnectionStats.getNumPartialRollbacks());
                stats.setNumClients(busConnectionStats.getNumClients());
                stats.setNumChannelsUp(busConnectionStats.getNumChannelsUp());
                stats.setNumBindingFailures(busConnectionStats.getNumBindingFailures());
                stats.setDetachedCommit(busConnectionStats.isDetachedCommit());
                MessageLatencyManager lm = busConnectionStats.getLatencyManager();
                if (lm != null) {
                    stats.setCreateToSendLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getCreateToSendLatencies()));
                    stats.setDeserializeLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getDeserializeLatencies()));
                    stats.setDeserializeToReceiveLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getDeserializeToReceiveLatencies()));
                    stats.setOriginToReceiveLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getOriginToReceiveLatencies()));
                    stats.setSendToPollLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSendToPollLatencies()));
                    stats.setSendToSerializeLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSendToSerializeLatencies()));
                    stats.setSerializeLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSerializeLatencies()));
                    stats.setSerializeToWireLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getSerializeToWireLatencies()));
                    stats.setWireSendLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireSendLatencies()));
                    stats.setWireLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireLatencies()));
                    stats.setWireToDeserializeLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireToDeserializeLatencies()));
                    stats.setWireToWireLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)lm.getWireToWireLatencies()));
                }
                if (stats.getDetachedCommit()) {
                    SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                    disruptorStats.setCapacity(busConnectionStats.getDisruptorCapacity());
                    disruptorStats.setRemaining(busConnectionStats.getDisruptorRemaining());
                    disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(busConnectionStats.getDisruptorClaimStrategy()));
                    disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(busConnectionStats.getDisruptorWaitStrategy()));
                    disruptorStats.setOfferToPollLatencies(this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)busConnectionStats.getDisruptorOfferToPollLatencies()));
                    stats.setDisruptorStats(disruptorStats);
                }
                appStats.addBusBindingStats(stats);
            }
        }

        private final void populateUserStats(IAepEngineStats engineStats, SrvMonAppStats stats) {
            List userGauges;
            List userCounters;
            SrvMonUserStats userStats = null;
            List userLatencies = engineStats.getUserSeriesStats();
            if (!userLatencies.isEmpty() && this.heartbeatGenerator.seriesCollectionEnabled) {
                if (userStats == null) {
                    userStats = SrvMonUserStats.create();
                }
                for (int i = 0; i < userLatencies.size(); ++i) {
                    IStats.Series recorded = (IStats.Series)userLatencies.get(i);
                    SrvMonUserSeriesStat stat = SrvMonUserSeriesStat.create();
                    stat.lendName(recorded.getNameAsRaw());
                    stat.setSeriesType(SrvMonSeriesType.LONG);
                    stat.setLongSeries(this.heartbeatGenerator.collectLongSeriesStats(recorded));
                    userStats.addSeries(stat);
                }
            }
            if (!(userCounters = engineStats.getUserCounterStats()).isEmpty()) {
                if (userStats == null) {
                    userStats = SrvMonUserStats.create();
                }
                for (int i = 0; i < userCounters.size(); ++i) {
                    IStats.Counter recorded = (IStats.Counter)userCounters.get(i);
                    SrvMonUserCounterStat stat = SrvMonUserCounterStat.create();
                    stat.lendName(recorded.getNameAsRaw());
                    stat.setCount(recorded.getCount());
                    userStats.addCounters(stat);
                }
            }
            if (!(userGauges = engineStats.getUserGaugeStats()).isEmpty()) {
                if (userStats == null) {
                    userStats = SrvMonUserStats.create();
                }
                for (int i = 0; i < userGauges.size(); ++i) {
                    IStats.Gauge recorded = (IStats.Gauge)userGauges.get(i);
                    SrvMonUserGaugeStat stat = SrvMonUserGaugeStat.create();
                    stat.lendName(recorded.getNameAsRaw());
                    SrvMonUtil.addGaugeValue(stat, recorded);
                    userStats.addGauges(stat);
                }
            }
            stats.setUserStats(userStats);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final AppStats getAppStats(SrvMonAppStats stats, long collectionTime) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                AppStats appStats = (AppStats)this.appsStats.get((Object)stats.getAppName());
                if (appStats == null) {
                    appStats = new AppStats(stats, collectionTime);
                    this.appsStats.put((Object)stats.getAppName(), (Object)appStats);
                }
                return appStats;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void createForHeartbeat(XIndexedList<SrvMonAppStats> statsList) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                XIterator appsStatsIt = this.appsStats.reuseableValueIterator();
                --this.inactiveMessageTypeStatsInclusionCountdown;
                while (appsStatsIt.hasNext()) {
                    AppStats appStats = (AppStats)appsStatsIt.next();
                    SrvMonAppStats stats = SrvMonAppStats.create();
                    stats.setAppName(appStats.appLoader.getAppName());
                    IAepEngineStats engineStats = appStats.appLoader.getAppEngine().getStats();
                    this.populateEngineStats(engineStats, stats);
                    this.populateStoreBindingStats(engineStats.getStoreBindingStats(), stats);
                    this.busConnectionStatsCollector.clear();
                    engineStats.getBusConnectionStats(this.busConnectionStatsCollector);
                    this.populateBusConnectionStats((List<IAepBusConnectionStats>)this.busConnectionStatsCollector, stats);
                    statsList.add((Object)stats);
                }
                if (this.inactiveMessageTypeStatsInclusionCountdown <= 0) {
                    this.inactiveMessageTypeStatsInclusionCountdown = this.inactiveMessageTypeStatsInclusionFrequency;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAppInitialized(SrvAppLoader appLoader) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                this.appsStats.put((Object)appLoader.getAppName(), (Object)new AppStats(appLoader));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAppUnloaded(String appName) {
            XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
            synchronized (xLinkedHashMap) {
                this.appsStats.remove((Object)appName);
            }
        }

        private final class AppStats {
            private final SrvAppLoader appLoader;
            private final NumberFormat format;
            private EngineStats engineStats;
            private StoreBindingStats storeBindingStats;
            private Map<String, BusBindingStats> busBindingsStats = new HashMap<String, BusBindingStats>();
            private long startTime;
            private long stampTime;

            AppStats(SrvAppLoader appLoader) {
                this.format = NumberFormat.getInstance();
                this.format.setMaximumFractionDigits(2);
                this.appLoader = appLoader;
                this.stampTime = this.startTime = System.currentTimeMillis();
                this.init(appLoader);
            }

            AppStats(SrvMonAppStats stats, long collectionTime) {
                this.format = NumberFormat.getInstance();
                this.format.setMaximumFractionDigits(2);
                this.appLoader = null;
                this.stampTime = this.startTime = collectionTime;
                this.refresh(stats);
            }

            private final void init(SrvAppLoader appLoader) {
                AepEngine engine = appLoader.getAppEngine();
                this.engineStats = new EngineStats(engine);
                if (engine.getStore() != null) {
                    this.storeBindingStats = new StoreBindingStats(engine.getStore());
                }
                for (AepBusConnection busConnection : engine.getBusConnections()) {
                    this.busBindingsStats.put(busConnection.getBusDescriptor().getName(), new BusBindingStats(busConnection));
                }
            }

            private final void refresh(SrvMonAppStats stats) {
            }

            private final void stamp(SrvMonAppStats stats) {
                SrvMonAppBusBindingStats[] monBusBindingsStats;
                if (stats.getEngineStats() != null) {
                    if (this.engineStats == null) {
                        this.engineStats = new EngineStats(stats.getEngineStats());
                    }
                    this.engineStats.stamp(stats.getEngineStats());
                }
                if (stats.getStoreBindingStats() != null) {
                    if (this.storeBindingStats == null) {
                        this.storeBindingStats = new StoreBindingStats(stats.getStoreBindingStats());
                    }
                    this.storeBindingStats.stamp(stats.getStoreBindingStats());
                }
                if ((monBusBindingsStats = stats.getBusBindingStats()) != null) {
                    for (SrvMonAppBusBindingStats monBusBindingStats : monBusBindingsStats) {
                        BusBindingStats busBindingStats = this.busBindingsStats.get(monBusBindingStats.getBusBindingName());
                        if (busBindingStats == null) {
                            busBindingStats = new BusBindingStats(monBusBindingStats);
                            this.busBindingsStats.put(monBusBindingStats.getBusBindingName(), busBindingStats);
                        }
                        busBindingStats.stamp(monBusBindingStats);
                    }
                }
                this.refresh(stats);
            }

            private final class BusBindingStats {
                private long numMsgsRcvdLast;
                private long numMsgsInBatchesRcvdLast;
                private long numMsgBatchesRcvdLast;
                private long numMsgsEnqueuedLast;
                private long numMsgsSentLast;
                private long numFlushesSyncLast;
                private long numMsgsFlushedSyncLast;
                private long numFlushesAsyncLast;
                private long numMsgsFlushedAsyncLast;
                private long numStabilityRcvdLast;
                private long numStabilityInBatchesRcvdLast;
                private long numStabilityBatchesRcvdLast;
                private long numPacketsRcvdLast;
                private long numCommitsLast;
                private long numMsgsRcvdCurrent;
                private long numMsgsInBatchesRcvdCurrent;
                private long numMsgBatchesRcvdCurrent;
                private long numMsgsEnqueuedCurrent;
                private long numMsgsSentCurrent;
                private long numFlushesSyncCurrent;
                private long numMsgsFlushedSyncCurrent;
                private long numFlushesAsyncCurrent;
                private long numMsgsFlushedAsyncCurrent;
                private long numStabilityRcvdCurrent;
                private long numStabilityInBatchesRcvdCurrent;
                private long numStabilityBatchesRcvdCurrent;
                private long numPacketsRcvdCurrent;
                private long numCommitsCurrent;
                private long numRollbacksCurrent;
                private int numClientsCurrent;
                private int numChannelsUpCurrent;
                private int numBindingFailuresCurrent;

                BusBindingStats(AepBusConnection busConnection) {
                    this.init(busConnection);
                }

                BusBindingStats(SrvMonAppBusBindingStats stats) {
                    this.refresh(stats);
                }

                private final void init(AepBusConnection busConnection) {
                    AepBusConnectionStats stats = busConnection.getStats();
                    this.numMsgsRcvdCurrent = stats.getNumMsgsRcvd();
                    this.numMsgsInBatchesRcvdCurrent = stats.getNumMsgsInBatchesRcvd();
                    this.numMsgBatchesRcvdCurrent = stats.getNumMsgBatchesRcvd();
                    this.numMsgsEnqueuedCurrent = stats.getNumMsgsEnqueued();
                    this.numMsgsSentCurrent = stats.getNumMsgsSent();
                    this.numStabilityRcvdCurrent = stats.getNumStabilityRcvd();
                    this.numStabilityInBatchesRcvdCurrent = stats.getNumStabilityInBatchesRcvd();
                    this.numStabilityBatchesRcvdCurrent = stats.getNumStabilityBatchesRcvd();
                    this.numPacketsRcvdCurrent = stats.getNumPacketsRcvd();
                    this.numCommitsCurrent = stats.getNumCommits();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                    this.numClientsCurrent = stats.getNumClients();
                    this.numChannelsUpCurrent = stats.getNumChannelsUp();
                    this.numBindingFailuresCurrent = stats.getNumBindingFailures();
                }

                private final void refresh(SrvMonAppBusBindingStats stats) {
                    this.numMsgsRcvdCurrent = stats.getNumMsgsRcvd();
                    this.numMsgsInBatchesRcvdCurrent = stats.getNumMsgsInBatchesRcvd();
                    this.numMsgBatchesRcvdCurrent = stats.getNumMsgBatchesRcvd();
                    this.numMsgsEnqueuedCurrent = stats.getNumMsgsEnqueued();
                    this.numMsgsSentCurrent = stats.getNumMsgsSent();
                    this.numStabilityRcvdCurrent = stats.getNumStabilityRcvd();
                    this.numStabilityInBatchesRcvdCurrent = stats.getNumStabilityInBatchesRcvd();
                    this.numStabilityBatchesRcvdCurrent = stats.getNumStabilityBatchesRcvd();
                    this.numPacketsRcvdCurrent = stats.getNumPacketsRcvd();
                    this.numCommitsCurrent = stats.getNumCommits();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                    this.numClientsCurrent = stats.getNumClients();
                    this.numChannelsUpCurrent = stats.getNumChannelsUp();
                    this.numBindingFailuresCurrent = stats.getNumBindingFailures();
                }

                final void stamp(SrvMonAppBusBindingStats stats) {
                    this.numMsgsRcvdLast = this.numMsgsRcvdCurrent;
                    this.numMsgsInBatchesRcvdLast = this.numMsgsInBatchesRcvdCurrent;
                    this.numMsgBatchesRcvdLast = this.numMsgBatchesRcvdCurrent;
                    this.numMsgsEnqueuedLast = this.numMsgsEnqueuedCurrent;
                    this.numMsgsSentLast = this.numMsgsSentCurrent;
                    this.numStabilityRcvdLast = this.numStabilityRcvdCurrent;
                    this.numStabilityInBatchesRcvdLast = this.numStabilityInBatchesRcvdCurrent;
                    this.numStabilityBatchesRcvdLast = this.numStabilityBatchesRcvdCurrent;
                    this.numPacketsRcvdLast = this.numPacketsRcvdCurrent;
                    this.numCommitsLast = this.numCommitsCurrent;
                    this.refresh(stats);
                }
            }

            private final class StoreBindingStats {
                private long numCommitsSentLast;
                private long numCommitEntriesSentLast;
                private long numCommitsReceivedLast;
                private long numCommitEntriesReceivedLast;
                private long numCommitCompletionsSentLast;
                private long numCommitCompletionsReceivedLast;
                private int sizeCurrent;
                private long numCommitsSentCurrent;
                private long numCommitEntriesSentCurrent;
                private long numCommitsReceivedCurrent;
                private long numCommitEntriesReceivedCurrent;
                private long numCommitCompletionsSentCurrent;
                private long numCommitCompletionsReceivedCurrent;
                private PersisterStats persisterStats;
                private ICRSenderStats icrSenderStats;

                StoreBindingStats(IStoreBinding binding) {
                    this.init(binding);
                }

                StoreBindingStats(SrvMonAppStoreBindingStats stats) {
                    this.refresh(stats);
                }

                private final void init(IStoreBinding storeBinding) {
                    IStoreBindingStats stats = storeBinding.getStats();
                    this.sizeCurrent = storeBinding.size();
                    this.numCommitsSentCurrent = stats.getNumCommitsSent();
                    this.numCommitEntriesSentCurrent = stats.getNumCommitEntriesSent();
                    this.numCommitsReceivedCurrent = stats.getNumCommitsReceived();
                    this.numCommitEntriesReceivedCurrent = stats.getNumCommitEntriesReceived();
                    this.numCommitCompletionsSentCurrent = stats.getNumCommitCompletionsSent();
                    this.numCommitCompletionsReceivedCurrent = stats.getNumCommitCompletionsReceived();
                    this.persisterStats = storeBinding.getPersister() != null ? new PersisterStats(storeBinding.getPersister()) : null;
                    this.icrSenderStats = storeBinding.getICRSender() != null ? new ICRSenderStats(storeBinding.getICRSender()) : null;
                }

                private final void refresh(SrvMonAppStoreBindingStats stats) {
                    this.sizeCurrent = stats.getSize();
                    this.numCommitsSentCurrent = stats.getNumCommitsSent();
                    this.numCommitEntriesSentCurrent = stats.getNumCommitEntriesSent();
                    this.numCommitsReceivedCurrent = stats.getNumCommitsReceived();
                    this.numCommitEntriesReceivedCurrent = stats.getNumCommitEntriesReceived();
                    this.numCommitCompletionsSentCurrent = stats.getNumCommitCompletionsSent();
                    this.numCommitCompletionsReceivedCurrent = stats.getNumCommitCompletionsReceived();
                }

                final void stamp(SrvMonAppStoreBindingStats stats) {
                    this.numCommitsSentLast = this.numCommitsSentCurrent;
                    this.numCommitEntriesSentLast = this.numCommitEntriesSentCurrent;
                    this.numCommitsReceivedLast = this.numCommitsReceivedCurrent;
                    this.numCommitEntriesReceivedLast = this.numCommitEntriesReceivedCurrent;
                    this.numCommitCompletionsSentLast = this.numCommitCompletionsSentCurrent;
                    this.numCommitCompletionsReceivedLast = this.numCommitCompletionsReceivedCurrent;
                    this.refresh(stats);
                    if (stats.getPersisterStats() != null) {
                        if (this.persisterStats == null) {
                            this.persisterStats = new PersisterStats(stats.getPersisterStats());
                        }
                        this.persisterStats.stamp(stats.getPersisterStats());
                    }
                    if (stats.getICRSenderStats() != null) {
                        if (this.icrSenderStats == null) {
                            this.icrSenderStats = new ICRSenderStats(stats.getICRSenderStats());
                        }
                        this.icrSenderStats.stamp(stats.getICRSenderStats());
                    }
                }

                private final class ICRSenderStats {
                    private long numPutsRecordedLast;
                    private long numUpdatesRecordedLast;
                    private long numRemovesRecordedLast;
                    private long numSendsRecordedLast;
                    private long numCommitsLast;
                    private long numPutsRecordedCurrent;
                    private long numUpdatesRecordedCurrent;
                    private long numRemovesRecordedCurrent;
                    private long numSendsRecordedCurrent;
                    private long numCommitsCurrent;

                    ICRSenderStats(IStoreSender sender) {
                        this.init(sender);
                    }

                    ICRSenderStats(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.refresh(stats);
                    }

                    private final void init(IStoreSender sender) {
                        IStoreSenderStats stats = sender.getStats();
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    private final void refresh(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    final void stamp(SrvMonAppStoreBindingICRSenderStats stats) {
                        this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                        this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                        this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                        this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                        this.numCommitsLast = this.numCommitsCurrent;
                        this.refresh(stats);
                    }
                }

                private final class PersisterStats {
                    private long numPutsRecordedLast;
                    private long numUpdatesRecordedLast;
                    private long numRemovesRecordedLast;
                    private long numSendsRecordedLast;
                    private long numCommitsLast;
                    private long numPutsRecordedCurrent;
                    private long numUpdatesRecordedCurrent;
                    private long numRemovesRecordedCurrent;
                    private long numSendsRecordedCurrent;
                    private long numCommitsCurrent;

                    PersisterStats(IStorePersister persister) {
                        this.init(persister);
                    }

                    PersisterStats(SrvMonAppStoreBindingPersisterStats stats) {
                        this.refresh(stats);
                    }

                    private final void init(IStorePersister persister) {
                        IStorePersisterStats stats = persister.getStats();
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    private final void refresh(SrvMonAppStoreBindingPersisterStats stats) {
                        this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                        this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                        this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                        this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                        this.numCommitsCurrent = stats.getNumCommits();
                    }

                    final void stamp(SrvMonAppStoreBindingPersisterStats stats) {
                        this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                        this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                        this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                        this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                        this.numCommitsLast = this.numCommitsCurrent;
                        this.refresh(stats);
                    }
                }
            }

            private final class EngineStats {
                private long numMsgsRcvdBestEffortLast;
                private long numMsgsRcvdGuaranteedLast;
                private long numMsgsSentBestEffortLast;
                private long numMsgsSentGuaranteedLast;
                private long numEventsRcvdLast;
                private long numFlowEventsRcvdLast;
                private long numTransactionsLast;
                private long numMsgsRcvdBestEffortCurrent;
                private long numMsgsRcvdGuaranteedCurrent;
                private long numMsgsSentBestEffortCurrent;
                private long numMsgsSentGuaranteedCurrent;
                private long numEventsRcvdCurrent;
                private long numFlowEventsRcvdCurrent;
                private long numFlowEventsProcSuccessCurrent;
                private long numTransactionsCurrent;
                private long numCommitsStartedCurrent;
                private long numRollbacksCurrent;

                EngineStats(AepEngine engine) {
                    this.init(engine);
                }

                EngineStats(SrvMonAppEngineStats stats) {
                    this.refresh(stats);
                }

                private final void init(AepEngine engine) {
                    IAepEngineStats engineStats = engine.getStats();
                    this.numMsgsRcvdBestEffortCurrent = engineStats.getNumMsgsRcvdBestEffort();
                    this.numMsgsRcvdGuaranteedCurrent = engineStats.getNumMsgsRcvdGuaranteed();
                    this.numMsgsSentBestEffortCurrent = engineStats.getNumMsgsSentBestEffort();
                    this.numMsgsSentGuaranteedCurrent = engineStats.getNumMsgsSentGuaranteed();
                    this.numEventsRcvdCurrent = engineStats.getNumEventsRcvd();
                    this.numFlowEventsRcvdCurrent = engineStats.getNumFlowEventsRcvd();
                    this.numFlowEventsProcSuccessCurrent = engineStats.getNumFlowEventsProcSuccess();
                    this.numTransactionsCurrent = engineStats.getNumTransactions();
                    this.numCommitsStartedCurrent = engineStats.getNumCommitsStarted();
                    this.numRollbacksCurrent = engineStats.getNumRollbacks();
                }

                private final void refresh(SrvMonAppEngineStats stats) {
                    this.numMsgsRcvdBestEffortCurrent = stats.getNumMsgsRcvdBestEffort();
                    this.numMsgsRcvdGuaranteedCurrent = stats.getNumMsgsRcvdGuaranteed();
                    this.numMsgsSentBestEffortCurrent = stats.getNumMsgsSentBestEffort();
                    this.numMsgsSentGuaranteedCurrent = stats.getNumMsgsSentGuaranteed();
                    this.numEventsRcvdCurrent = stats.getNumEventsRcvd();
                    this.numFlowEventsRcvdCurrent = stats.getNumFlowEventsRcvd();
                    this.numFlowEventsProcSuccessCurrent = stats.getNumFlowEventsProcSuccess();
                    this.numTransactionsCurrent = stats.getNumTransactions();
                    this.numCommitsStartedCurrent = stats.getNumCommitsStarted();
                    this.numRollbacksCurrent = stats.getNumRollbacks();
                }

                final void stamp(SrvMonAppEngineStats stats) {
                    this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                    this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                    this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                    this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                    this.numEventsRcvdLast = this.numEventsRcvdCurrent;
                    this.numFlowEventsRcvdLast = this.numFlowEventsRcvdCurrent;
                    this.numTransactionsLast = this.numTransactionsCurrent;
                    this.refresh(stats);
                }
            }
        }

        private final class MsgTypeStatsCollector {
            private XIntLinkedHashMap<MsgTypeStats> msgTypeStats = new XIntLinkedHashMap();
            private XIntLinkedHashMap<IAepEngineStats.IMessageTypeStats> copiedEngineMsgTypeStatsTable = new XIntLinkedHashMap();
            private final IntObjectProcedure msgTypeStatsCopier = new IntObjectProcedure(){

                public final boolean apply(int key, Object stats) {
                    MsgTypeStatsCollector.this.copiedEngineMsgTypeStatsTable.put(key, (Object)((IAepEngineStats.IMessageTypeStats)stats));
                    return true;
                }
            };

            private MsgTypeStatsCollector() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void collect(OpenIntObjectHashMap engineMessageTypeStats, SrvMonAppEngineStats monAppStats) {
                if (engineMessageTypeStats == null) {
                    return;
                }
                this.copiedEngineMsgTypeStatsTable.clear();
                OpenIntObjectHashMap openIntObjectHashMap = engineMessageTypeStats;
                synchronized (openIntObjectHashMap) {
                    engineMessageTypeStats.forEachPair(this.msgTypeStatsCopier);
                }
                XCollectionIterator it = this.copiedEngineMsgTypeStatsTable.reuseableEntryIterator();
                while (it.hasNext()) {
                    XIntMap.Entry entry = (XIntMap.Entry)it.next();
                    MsgTypeStats stats = (MsgTypeStats)this.msgTypeStats.get(entry.getKey());
                    if (stats == null) {
                        stats = new MsgTypeStats((IAepEngineStats.IMessageTypeStats)entry.getValue());
                        this.msgTypeStats.put(entry.getKey(), (Object)stats);
                    }
                    stats.collectCurrentValues((IAepEngineStats.IMessageTypeStats)entry.getValue());
                }
                XIterator statsIt = this.msgTypeStats.reuseableValueIterator();
                while (statsIt.hasNext()) {
                    MsgTypeStats typeStats = (MsgTypeStats)statsIt.next();
                    typeStats.computeAndInclude(monAppStats, Apps.this.inactiveMessageTypeStatsInclusionCountdown == 0);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void collect(SrvMonAppEngineStats.Serializer monEngineStatsSerializer, OpenIntObjectHashMap engineMessageTypeStats) {
                if (engineMessageTypeStats == null) {
                    return;
                }
                this.copiedEngineMsgTypeStatsTable.clear();
                OpenIntObjectHashMap openIntObjectHashMap = engineMessageTypeStats;
                synchronized (openIntObjectHashMap) {
                    engineMessageTypeStats.forEachPair(this.msgTypeStatsCopier);
                }
                XCollectionIterator it = this.copiedEngineMsgTypeStatsTable.reuseableEntryIterator();
                while (it.hasNext()) {
                    XIntMap.Entry entry = (XIntMap.Entry)it.next();
                    MsgTypeStats stats = (MsgTypeStats)this.msgTypeStats.get(entry.getKey());
                    if (stats == null) {
                        stats = new MsgTypeStats((IAepEngineStats.IMessageTypeStats)entry.getValue());
                        this.msgTypeStats.put(entry.getKey(), (Object)stats);
                    }
                    stats.collectCurrentValues((IAepEngineStats.IMessageTypeStats)entry.getValue());
                }
                XIterator statsIt = this.msgTypeStats.reuseableValueIterator();
                while (statsIt.hasNext()) {
                    MsgTypeStats typeStats = (MsgTypeStats)statsIt.next();
                    typeStats.computeAndInclude(monEngineStatsSerializer, Apps.this.inactiveMessageTypeStatsInclusionCountdown == 0);
                }
            }
        }

        private final class MsgTypeStats {
            final XString name;
            final short factoryid;
            final short typeid;
            private long numMsgsRcvdBestEffortLast;
            private long numMsgsRcvdGuaranteedLast;
            private long numMsgsSourcedLast;
            private long numMsgsSentBestEffortLast;
            private long numMsgsSentGuaranteedLast;
            private long numMsgsFilteredLast;
            private long numDupMsgsRcvdLast;
            private long numMsgsResentLast;
            private long numMsgsRcvdBestEffortCurrent;
            private long numMsgsRcvdGuaranteedCurrent;
            private long numMsgsSourcedCurrent;
            private long numMsgsSentBestEffortCurrent;
            private long numMsgsSentGuaranteedCurrent;
            private long numMsgsFilteredCurrent;
            private long numDupMsgsRcvdCurrent;
            private long numMsgsResentCurrent;
            private SrvMonIntSeries messageCreateToOfferLatencies;
            private SrvMonIntSeries messageOfferToPollLatencies;
            private SrvMonIntSeries messageFilteringLatencies;
            private SrvMonIntSeries messagePreProcessingLatencies;
            private SrvMonIntSeries messageProcessingLatencies;

            MsgTypeStats(IAepEngineStats.IMessageTypeStats engineMsgTypeStats) {
                this.name = XString.create((String)engineMsgTypeStats.getMessageTypeName());
                this.typeid = engineMsgTypeStats.getMessageTypeId();
                this.factoryid = engineMsgTypeStats.getMessageFactoryId();
            }

            final void collectCurrentValues(IAepEngineStats.IMessageTypeStats engineMsgTypeStats) {
                this.numDupMsgsRcvdCurrent = engineMsgTypeStats.getNumDupMsgsRcvd();
                this.numMsgsFilteredCurrent = engineMsgTypeStats.getNumMsgsFiltered();
                this.numMsgsRcvdBestEffortCurrent = engineMsgTypeStats.getNumMsgsRcvdBestEffort();
                this.numMsgsRcvdGuaranteedCurrent = engineMsgTypeStats.getNumMsgsRcvdGuaranteed();
                this.numMsgsResentCurrent = engineMsgTypeStats.getNumMsgsResent();
                this.numMsgsSentBestEffortCurrent = engineMsgTypeStats.getNumMsgsSentBestEffort();
                this.numMsgsSentGuaranteedCurrent = engineMsgTypeStats.getNumMsgsSentGuaranteed();
                this.numMsgsSourcedCurrent = engineMsgTypeStats.getNumMsgsSourced();
                this.messageCreateToOfferLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgCreateToOfferLatencies());
                this.messageOfferToPollLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgOfferToPollLatencies());
                this.messageFilteringLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgFilteringLatencies());
                this.messagePreProcessingLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgPreProcessingLatencies());
                this.messageProcessingLatencies = Apps.this.heartbeatGenerator.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgProcessingLatencies());
            }

            public void computeAndInclude(SrvMonAppEngineStats monAppStats, boolean includeInactive) {
                if (!includeInactive && this.numMsgsRcvdBestEffortLast == this.numMsgsRcvdBestEffortCurrent && this.numMsgsRcvdGuaranteedLast == this.numMsgsRcvdGuaranteedCurrent && this.numMsgsSourcedLast == this.numMsgsSourcedCurrent && this.numMsgsSentBestEffortLast == this.numMsgsSentBestEffortCurrent && this.numMsgsSentGuaranteedLast == this.numMsgsSentGuaranteedCurrent && this.numMsgsFilteredLast == this.numMsgsFilteredCurrent && this.numDupMsgsRcvdLast == this.numDupMsgsRcvdCurrent && this.numMsgsResentLast == this.numMsgsResentCurrent) {
                    if (this.messageCreateToOfferLatencies != null) {
                        this.messageCreateToOfferLatencies.dispose();
                        this.messageCreateToOfferLatencies = null;
                    }
                    if (this.messageOfferToPollLatencies != null) {
                        this.messageOfferToPollLatencies.dispose();
                        this.messageOfferToPollLatencies = null;
                    }
                    if (this.messagePreProcessingLatencies != null) {
                        this.messagePreProcessingLatencies.dispose();
                        this.messagePreProcessingLatencies = null;
                    }
                    if (this.messageFilteringLatencies != null) {
                        this.messageFilteringLatencies.dispose();
                        this.messageFilteringLatencies = null;
                    }
                    if (this.messageFilteringLatencies != null) {
                        this.messageFilteringLatencies.dispose();
                        this.messageFilteringLatencies = null;
                    }
                    return;
                }
                SrvMonMsgTypeStats monStats = SrvMonMsgTypeStats.create();
                monStats.lendMessageTypeName(this.name);
                monStats.setMessageFactoryId(this.factoryid);
                monStats.setMessageTypeId(this.typeid);
                monStats.setNumDupMsgsRcvd(this.numDupMsgsRcvdCurrent);
                monStats.setNumMsgsFiltered(this.numMsgsFilteredCurrent);
                monStats.setNumMsgsRcvdBestEffort(this.numMsgsRcvdBestEffortCurrent);
                monStats.setNumMsgsRcvdGuaranteed(this.numMsgsRcvdGuaranteedCurrent);
                monStats.setNumMsgsResent(this.numMsgsResentCurrent);
                monStats.setNumMsgsSentBestEffort(this.numMsgsSentBestEffortCurrent);
                monStats.setNumMsgsSentGuaranteed(this.numMsgsSentGuaranteedCurrent);
                monStats.setNumMsgsSourced(this.numMsgsSourcedCurrent);
                monStats.setMsgCreateToOfferLatencies(this.messageCreateToOfferLatencies);
                monStats.setMsgOfferToPollLatencies(this.messageOfferToPollLatencies);
                monStats.setMsgFilteringLatencies(this.messageFilteringLatencies);
                monStats.setMsgPreProcessingLatencies(this.messagePreProcessingLatencies);
                monStats.setMsgProcessingLatencies(this.messageProcessingLatencies);
                monAppStats.addMsgTypeStats(monStats);
                this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                this.numMsgsSourcedLast = this.numMsgsSourcedCurrent;
                this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                this.numMsgsFilteredLast = this.numMsgsFilteredCurrent;
                this.numDupMsgsRcvdLast = this.numDupMsgsRcvdCurrent;
                this.numMsgsResentLast = this.numMsgsResentCurrent;
                this.messageCreateToOfferLatencies = null;
                this.messageOfferToPollLatencies = null;
                this.messageFilteringLatencies = null;
                this.messagePreProcessingLatencies = null;
                this.messageProcessingLatencies = null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void computeAndInclude(SrvMonAppEngineStats.Serializer monEngineStatsSerializer, boolean includeInactive) {
                if (!includeInactive && this.numMsgsRcvdBestEffortLast == this.numMsgsRcvdBestEffortCurrent && this.numMsgsRcvdGuaranteedLast == this.numMsgsRcvdGuaranteedCurrent && this.numMsgsSourcedLast == this.numMsgsSourcedCurrent && this.numMsgsSentBestEffortLast == this.numMsgsSentBestEffortCurrent && this.numMsgsSentGuaranteedLast == this.numMsgsSentGuaranteedCurrent && this.numMsgsFilteredLast == this.numMsgsFilteredCurrent && this.numDupMsgsRcvdLast == this.numDupMsgsRcvdCurrent && this.numMsgsResentLast == this.numMsgsResentCurrent) {
                    if (this.messageCreateToOfferLatencies != null) {
                        this.messageCreateToOfferLatencies.dispose();
                        this.messageCreateToOfferLatencies = null;
                    }
                    if (this.messageOfferToPollLatencies != null) {
                        this.messageOfferToPollLatencies.dispose();
                        this.messageOfferToPollLatencies = null;
                    }
                    if (this.messagePreProcessingLatencies != null) {
                        this.messagePreProcessingLatencies.dispose();
                        this.messagePreProcessingLatencies = null;
                    }
                    if (this.messageFilteringLatencies != null) {
                        this.messageFilteringLatencies.dispose();
                        this.messageFilteringLatencies = null;
                    }
                    if (this.messageFilteringLatencies != null) {
                        this.messageFilteringLatencies.dispose();
                        this.messageFilteringLatencies = null;
                    }
                    return;
                }
                SrvMonMsgTypeStats monMsgTypeStats = SrvMonMsgTypeStats.create();
                try {
                    SrvMonMsgTypeStats.Serializer monMsgTypeStatsSerializer = monMsgTypeStats.serializer();
                    monMsgTypeStatsSerializer.messageTypeName(this.name).messageFactoryId(this.factoryid).messageTypeId(this.typeid).numDupMsgsRcvd(this.numDupMsgsRcvdCurrent).numMsgsFiltered(this.numMsgsFilteredCurrent).numMsgsRcvdBestEffort(this.numMsgsRcvdBestEffortCurrent).numMsgsRcvdGuaranteed(this.numMsgsRcvdGuaranteedCurrent).numMsgsResent(this.numMsgsResentCurrent).numMsgsSentBestEffort(this.numMsgsSentBestEffortCurrent).numMsgsSentGuaranteed(this.numMsgsSentGuaranteedCurrent).numMsgsSourced(this.numMsgsSourcedCurrent).msgCreateToOfferLatencies(this.messageCreateToOfferLatencies).msgOfferToPollLatencies(this.messageOfferToPollLatencies).msgFilteringLatencies(this.messageFilteringLatencies).msgPreProcessingLatencies(this.messagePreProcessingLatencies).msgProcessingLatencies(this.messageProcessingLatencies).done();
                    monEngineStatsSerializer.msgTypeStats(monMsgTypeStatsSerializer);
                }
                finally {
                    monMsgTypeStats.dispose();
                }
                this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                this.numMsgsSourcedLast = this.numMsgsSourcedCurrent;
                this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                this.numMsgsFilteredLast = this.numMsgsFilteredCurrent;
                this.numDupMsgsRcvdLast = this.numDupMsgsRcvdCurrent;
                this.numMsgsResentLast = this.numMsgsResentCurrent;
                if (this.messageCreateToOfferLatencies != null) {
                    this.messageCreateToOfferLatencies.dispose();
                    this.messageCreateToOfferLatencies = null;
                }
                if (this.messageOfferToPollLatencies != null) {
                    this.messageOfferToPollLatencies.dispose();
                    this.messageOfferToPollLatencies = null;
                }
                if (this.messageFilteringLatencies != null) {
                    this.messageFilteringLatencies.dispose();
                    this.messageFilteringLatencies = null;
                }
                if (this.messagePreProcessingLatencies != null) {
                    this.messagePreProcessingLatencies.dispose();
                    this.messagePreProcessingLatencies = null;
                }
                if (this.messageProcessingLatencies != null) {
                    this.messageProcessingLatencies.dispose();
                    this.messageProcessingLatencies = null;
                }
            }
        }

        public static enum EntityType {
            Engine,
            UserStat,
            EventMultiplexer,
            StoreBinding,
            StoreBindingPersister,
            StoreBindingICRSender,
            BusBinding;

        }
    }

    static final class AdminClients {
        private final XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> adminClientsStats = new XLinkedHashMap();
        private final Tracer tracer = Tracer.get((String)"nv.server.stats.adminclient");

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAdminClientConnected(SrvControllerAdminApp.AdminClientContext client) {
            XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
            synchronized (xLinkedHashMap) {
                this.adminClientsStats.put((Object)client.getName(), (Object)client.getStats());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onAdminClientDisconnected(SrvControllerAdminApp.AdminClientContext client) {
            XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
            synchronized (xLinkedHashMap) {
                this.adminClientsStats.remove((Object)client.getName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void createForHeartbeat(XIndexedList<SrvMonAdminClientStats> statsList) {
            XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
            synchronized (xLinkedHashMap) {
                XIterator adminClientStatsIt = this.adminClientsStats.reuseableValueIterator();
                while (adminClientStatsIt.hasNext()) {
                    SrvControllerAdminApp.AdminClientContext.Stats adminClientStats = (SrvControllerAdminApp.AdminClientContext.Stats)adminClientStatsIt.next();
                    if (adminClientStats == null && this.tracer.debug) {
                        this.tracer.log("NULL ADMIN STAT DETECTED IN ADMINCLIENTSTATS MAP", Tracer.Level.DEBUG);
                        continue;
                    }
                    SrvMonAdminClientStats stats = SrvMonAdminClientStats.create();
                    stats.setName(adminClientStats.getClient().getName());
                    stats.setLifecyclesSent(adminClientStats.getEventsSent());
                    stats.setTracesSent(adminClientStats.getTracesSent());
                    stats.setTracesDropped(adminClientStats.getTracesDropped());
                    stats.setHeartbeatsSent(adminClientStats.getHeartbeatsSent());
                    stats.setHeartbeatsDropped(adminClientStats.getHeartbeatsDropped());
                    stats.setFlushesScheduled(adminClientStats.getFlushesScheduled());
                    stats.setFlushesExecuted(adminClientStats.getFlushesExecuted());
                    stats.setOutboundQueueCapacity(adminClientStats.getOutboundQueueCapacity());
                    stats.setOutboundQueueSize(adminClientStats.getOutboundQueueSize());
                    stats.setOutboundQueueCount(adminClientStats.getOutboundQueueCount());
                    stats.setOutboundQueueFlushSize(adminClientStats.getOutboundQueueFlushSize());
                    stats.setOutboundQueueFlushCount(adminClientStats.getOutboundQueueFlushCount());
                    statsList.add((Object)stats);
                }
            }
        }
    }

    static final class Pools {
        private final XLinkedHashMap<String, PoolStats> poolsStats = new XLinkedHashMap();
        private final ObjectArrayList poolStatsHolder = new ObjectArrayList(4096);
        private final Tracer tracer;
        private final boolean enabled;
        private final boolean collectAll;
        private final float depletionThreshold;

        public Pools(boolean enabled, boolean collectAll, float poolDepletionThreshold) {
            this.enabled = enabled;
            this.tracer = Tracer.get((String)"nv.server.stats.pool");
            float value = poolDepletionThreshold;
            if (value <= 0.0f) {
                value = 101.0f;
            }
            this.collectAll = collectAll;
            this.depletionThreshold = value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void copyPoolStatsToHolder() {
            this.poolStatsHolder.clear();
            XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
            synchronized (xLinkedHashMap) {
                XIterator poolStatsIt = this.poolsStats.reuseableValueIterator();
                while (poolStatsIt.hasNext()) {
                    PoolStats poolStats = (PoolStats)poolStatsIt.next();
                    if (poolStats == null && this.tracer.debug) {
                        this.tracer.log("NULL POOL STAT DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                        continue;
                    }
                    if (poolStats.pool == null && this.tracer.debug) {
                        this.tracer.log("NULL POOL IN POOLS STATS DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                        continue;
                    }
                    this.poolStatsHolder.add((Object)poolStats);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onPoolAdded(UtlPool<?> pool) {
            if (!this.enabled) {
                return;
            }
            XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
            synchronized (xLinkedHashMap) {
                this.poolsStats.put((Object)pool.key(), (Object)new PoolStats(pool));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void onPoolRemoved(UtlPool<?> pool) {
            if (!this.enabled) {
                return;
            }
            XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
            synchronized (xLinkedHashMap) {
                this.poolsStats.remove((Object)pool.key());
            }
        }

        final void createForHeartbeat(XIndexedList<SrvMonPoolStats> statsList) {
            if (!this.enabled) {
                return;
            }
            this.copyPoolStatsToHolder();
            for (int i = 0; i < this.poolStatsHolder.size(); ++i) {
                PoolStats poolStats = (PoolStats)this.poolStatsHolder.get(i);
                if (poolStats.pool == null && this.tracer.debug) {
                    this.tracer.log("NULL POOL IN POOLS STATS DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                    continue;
                }
                try {
                    UtlPool.Stats corePoolStats = poolStats.pool.stats();
                    long putsCurrent = corePoolStats.puts();
                    long getsCurrent = corePoolStats.gets();
                    long hitsCurrent = corePoolStats.hits();
                    long missesCurrent = corePoolStats.misses();
                    long growthsCurrent = corePoolStats.growths();
                    long evictsCurrent = corePoolStats.evicts();
                    long dwashesCurrent = corePoolStats.detachedWashes();
                    int size = poolStats.pool.size();
                    int capacity = poolStats.pool.capacity();
                    int preallocated = corePoolStats.preallocated();
                    int maxCapacity = poolStats.pool.params().getMaxCapacity();
                    if (this.collectAll || poolStats.isAtOrBelowDepletionThreshold(size) || missesCurrent - poolStats.missesLast > 0L || size > poolStats.sizeHighaterMark || evictsCurrent - poolStats.evictsLast > 0L) {
                        SrvMonPoolStats stats = SrvMonPoolStats.create();
                        stats.setPuts(putsCurrent);
                        stats.setGets(getsCurrent);
                        stats.setHits(hitsCurrent);
                        stats.setMisses(missesCurrent);
                        stats.setGrowths(growthsCurrent);
                        stats.setEvicts(evictsCurrent);
                        stats.setDetachedWashes(dwashesCurrent);
                        stats.setPreallocated(preallocated);
                        stats.setSize(size);
                        stats.setCapacity(capacity);
                        stats.setMaxCapacity(maxCapacity);
                        stats.setKey(poolStats.pool.key());
                        statsList.add((Object)stats);
                    }
                    poolStats.stamp(putsCurrent, getsCurrent, hitsCurrent, missesCurrent, growthsCurrent, evictsCurrent, dwashesCurrent, size);
                    continue;
                }
                catch (IllegalStateException e) {
                    if (poolStats.pool == null || poolStats.pool.isClosed()) continue;
                    throw e;
                }
            }
        }

        private final class PoolStats {
            private final UtlPool<?> pool;
            final int depletionThresholdDecrement;
            private long putsLast;
            private long getsLast;
            private long hitsLast;
            private long missesLast;
            private long growthsLast;
            private long evictsLast;
            private long dwashesLast;
            private int nextDepletionThreshold = -1;
            private int sizeHighaterMark = -1;

            PoolStats(UtlPool<?> pool) {
                this.pool = pool;
                UtlPool.Stats stats = this.pool.stats();
                this.stamp(stats.puts(), stats.gets(), stats.hits(), stats.misses(), stats.growths(), stats.evicts(), stats.detachedWashes(), pool.size());
                if (stats.preallocated() > 0 && pool.size() > 0 && Pools.this.depletionThreshold <= 100.0f) {
                    this.depletionThresholdDecrement = (int)((float)stats.preallocated() * Pools.this.depletionThreshold / 100.0f);
                    this.nextDepletionThreshold = Math.max(0, stats.preallocated() - this.depletionThresholdDecrement);
                } else {
                    this.depletionThresholdDecrement = 0;
                    this.nextDepletionThreshold = -1;
                }
            }

            PoolStats(SrvMonPoolStats stats) {
                this.pool = null;
                this.stamp(stats.getPuts(), stats.getGets(), stats.getHits(), stats.getMisses(), stats.getGrowths(), stats.getEvicts(), stats.getDetachedWashes(), stats.getSize());
                if (stats.getPreallocated() > 0 && stats.getSize() > 0 && Pools.this.depletionThreshold <= 100.0f) {
                    this.depletionThresholdDecrement = (int)((float)stats.getPreallocated() * Pools.this.depletionThreshold / 100.0f);
                    this.nextDepletionThreshold = Math.max(0, stats.getPreallocated() - this.depletionThresholdDecrement);
                } else {
                    this.depletionThresholdDecrement = 0;
                    this.nextDepletionThreshold = -1;
                }
            }

            final void stamp(long puts, long gets, long hits, long misses, long growths, long evicts, long dwashes, int size) {
                this.putsLast = puts;
                this.getsLast = gets;
                this.hitsLast = hits;
                this.missesLast = misses;
                this.growthsLast = growths;
                this.evictsLast = evicts;
                this.dwashesLast = dwashes;
                if (this.isAtOrBelowDepletionThreshold(size)) {
                    while (this.nextDepletionThreshold >= size) {
                        this.nextDepletionThreshold -= this.depletionThresholdDecrement;
                    }
                }
                this.sizeHighaterMark = Math.max(size, this.sizeHighaterMark);
            }

            final boolean isAtOrBelowDepletionThreshold(int size) {
                if (this.depletionThresholdDecrement > 0) {
                    return size <= this.nextDepletionThreshold;
                }
                return false;
            }
        }
    }

    static final class Sys {
        private final SrvControllerIndirectHeartbeatGenerator heartbeatGenerator;
        private final Tracer tracer;
        private final XIntLinkedHashMap<Thread.State> threadStates = new XIntLinkedHashMap();
        private final MemoryMXBean memoryBean;
        private final OperatingSystemMXBean osBean;
        private final SrvControllerDirectHeartbeatGenerator.Sys.SunOperatingSystemMXBean sunOsBean;
        private final ThreadMXBean threadBean;
        private final CompilationMXBean jitBean;
        private final Method zgThreadAccessor;
        private final Field zgThreadStateField;
        private final Field zgCharArrayThreadNameField;
        private final Field zgStringThreadNameField;
        private final SrvControllerFileSystemAccessor.FileRoot[] fileRoots;
        private final boolean collectIndividualThreadStats;
        private final boolean collectNonZGStats;
        private Throwable lastZgThreadNameAccessorException;

        Sys(SrvControllerIndirectHeartbeatGenerator heartbeatGenerator) {
            this.heartbeatGenerator = heartbeatGenerator;
            this.tracer = Tracer.get((String)"nv.server.stats.sys");
            this.memoryBean = ManagementFactory.getMemoryMXBean();
            this.osBean = ManagementFactory.getOperatingSystemMXBean();
            this.sunOsBean = this.getSunOsMBean();
            this.threadBean = ManagementFactory.getThreadMXBean();
            this.jitBean = ManagementFactory.getCompilationMXBean();
            this.zgThreadAccessor = this.getThreadAccessor();
            this.zgThreadStateField = this.getThreadStateField();
            this.zgCharArrayThreadNameField = this.getCharArrayThreadNameField();
            this.zgStringThreadNameField = this.zgCharArrayThreadNameField == null ? this.getStringThreadNameField() : null;
            if (this.zgCharArrayThreadNameField == null && this.zgStringThreadNameField == null) {
                this.tracer.log("Couldn't load zero garbage thread name accessor: " + this.lastZgThreadNameAccessorException.getMessage() + " ... Server stats may not register updated thread names.", Tracer.Level.WARNING);
            }
            boolean zgThreadStats = this.zgThreadAccessor != null && this.zgThreadStateField != null;
            this.collectNonZGStats = heartbeatGenerator.config.isCollectNonZGStats();
            this.collectIndividualThreadStats = heartbeatGenerator.config.isCollectIndividualThreadStats();
            this.fileRoots = this.collectNonZGStats ? SrvControllerFileSystemAccessor.getEnhancedFileRootsIfAvailable() : SrvControllerFileSystemAccessor.getStandardFileRoots();
            this.tracer.log("ZERO GARBAGE THREAD STATS ARE....." + (zgThreadStats ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("SYSTEM DISK STATS ARE............." + (SrvControllerFileSystemAccessor.areEnhandedFileSystemRootsAvailable() ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("SYSTEM MEM STATS ARE.............." + (this.sunOsBean != null ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("ENHANCED CPU STATS ARE............" + (this.sunOsBean != null && this.sunOsBean.enhancedProcessorLoadStatsAvailable() ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
            this.tracer.log("NON ZERO GARBAGE STATS ARE........" + (this.collectNonZGStats ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
        }

        private final SrvControllerDirectHeartbeatGenerator.Sys.SunOperatingSystemMXBean getSunOsMBean() {
            SrvControllerDirectHeartbeatGenerator.Sys.SunOperatingSystemMXBean sunOsMbean = null;
            try {
                sunOsMbean = (SrvControllerDirectHeartbeatGenerator.Sys.SunOperatingSystemMXBean)Class.forName("com.neeve.server.controller.SrvControllerSunOsMbeanAccessor").newInstance();
            }
            catch (Throwable thrown) {
                this.tracer.log("Sun os mbean not available (" + thrown.getMessage() + ") some processor and memory system stats will not be available.", Tracer.Level.WARNING);
            }
            return sunOsMbean;
        }

        private final Method getThreadAccessor() {
            Method zgThreadAccessorCandidate = null;
            try {
                try {
                    zgThreadAccessorCandidate = this.threadBean.getClass().getDeclaredMethod("getThreads", new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    zgThreadAccessorCandidate = this.threadBean.getClass().getSuperclass().getDeclaredMethod("getThreads", new Class[0]);
                }
                if (!zgThreadAccessorCandidate.getReturnType().equals(Thread[].class)) {
                    throw new Exception("Unexpected return type on native ThreadMX bean accessor '" + zgThreadAccessorCandidate + "'");
                }
                zgThreadAccessorCandidate.setAccessible(true);
                ((Thread[])zgThreadAccessorCandidate.invoke((Object)this.threadBean, new Object[0])).hashCode();
            }
            catch (Throwable thrown) {
                zgThreadAccessorCandidate = null;
                this.tracer.log("Couldn't load zero garbage ThreadMXBean accessor: " + thrown.toString() + " ... Server stats will produce garbage!", Tracer.Level.WARNING);
            }
            return zgThreadAccessorCandidate;
        }

        private final Field getThreadStateField() {
            Field zgThreadStateFieldCandidate = null;
            try {
                zgThreadStateFieldCandidate = Thread.class.getDeclaredField("threadStatus");
                if (zgThreadStateFieldCandidate.getType() != Integer.TYPE) {
                    throw new Exception("Unexpected field type for '" + zgThreadStateFieldCandidate + "'");
                }
                zgThreadStateFieldCandidate.setAccessible(true);
                zgThreadStateFieldCandidate.getInt(Thread.currentThread());
            }
            catch (Throwable thrown) {
                zgThreadStateFieldCandidate = null;
                this.tracer.log("Couldn't load zero garbage thread state accessor: " + thrown.getMessage() + " ... Server stats will produce garbage!", Tracer.Level.WARNING);
            }
            return zgThreadStateFieldCandidate;
        }

        private final Field getCharArrayThreadNameField() {
            Field zgThreadNameFieldCandidate;
            block4: {
                zgThreadNameFieldCandidate = null;
                try {
                    zgThreadNameFieldCandidate = Thread.class.getDeclaredField("name");
                    if (zgThreadNameFieldCandidate.getType() == char[].class) {
                        zgThreadNameFieldCandidate.setAccessible(true);
                        char[] testGet = (char[])zgThreadNameFieldCandidate.get(Thread.currentThread());
                        if (testGet == null) {
                            throw new Exception("Failed to get thread name via reflection (null)");
                        }
                        break block4;
                    }
                    throw new Exception("Unexpected field type for '" + zgThreadNameFieldCandidate + "'");
                }
                catch (Throwable thrown) {
                    zgThreadNameFieldCandidate = null;
                    this.lastZgThreadNameAccessorException = thrown;
                }
            }
            return zgThreadNameFieldCandidate;
        }

        private final Field getStringThreadNameField() {
            Field zgThreadNameFieldCandidate;
            block4: {
                zgThreadNameFieldCandidate = null;
                try {
                    zgThreadNameFieldCandidate = Thread.class.getDeclaredField("name");
                    if (zgThreadNameFieldCandidate.getType() == String.class) {
                        zgThreadNameFieldCandidate.setAccessible(true);
                        String testGet = (String)zgThreadNameFieldCandidate.get(Thread.currentThread());
                        if (testGet == null) {
                            throw new Exception("Failed to get thread name via reflection (null)");
                        }
                        break block4;
                    }
                    throw new Exception("Unexpected field type for '" + zgThreadNameFieldCandidate + "'");
                }
                catch (Throwable thrown) {
                    zgThreadNameFieldCandidate = null;
                    this.lastZgThreadNameAccessorException = thrown;
                }
            }
            return zgThreadNameFieldCandidate;
        }

        private final void populateSystemInfo(SrvMonSysStats stats) {
            stats.setAvailableProcessors(this.osBean.getAvailableProcessors());
            stats.setSystemLoadAverage(this.osBean.getSystemLoadAverage());
            if (this.sunOsBean != null && this.collectNonZGStats && this.sunOsBean.enhancedProcessorLoadStatsAvailable()) {
                stats.setProcessCpuLoad(this.sunOsBean.getProcessCpuLoad());
                stats.setSystemCpuLoad(this.sunOsBean.getSystemCpuLoad());
            }
        }

        private final SrvMonSysMemoryNativeCounters populateNativeMemoryCounters(MemoryStats.NativeMemoryStats memoryStats, SrvMonSysMemoryNativeCounters counters) {
            counters.setAllocCount(memoryStats.getAllocCount());
            counters.setAllocBytes(memoryStats.getAllocBytes());
            counters.setReallocCount(memoryStats.getReallocCount());
            counters.setReallocBytes(memoryStats.getReallocBytes());
            counters.setFreeCount(memoryStats.getFreeCount());
            counters.setFreeBytes(memoryStats.getFreeBytes());
            return counters;
        }

        private final SrvMonSysMemoryIOBufCounters populateIOBufMemoryCounters(MemoryStats.IOBufferStats bufferStats, SrvMonSysMemoryIOBufCounters counters) {
            counters.setBufferAllocCount(bufferStats.getBufferAllocCount());
            counters.setBufferAllocBytes(bufferStats.getBufferAllocBytes());
            counters.setBufferPoolAllocCount(bufferStats.getBufferPoolAllocCount());
            counters.setBufferPoolAllocBytes(bufferStats.getBufferPoolAllocBytes());
            counters.setBufferReallocCount(bufferStats.getBufferReallocCount());
            counters.setBufferReallocBytes(bufferStats.getBufferReallocBytes());
            counters.setBufferForkCount(bufferStats.getBufferForkCount());
            counters.setBufferForkBytes(bufferStats.getBufferForkBytes());
            counters.setBufferGCDisposeCount(bufferStats.getBufferGCDisposeCount());
            counters.setBufferGCDisposeBytes(bufferStats.getBufferGCDisposeBytes());
            counters.setBufferPoolDisposeCount(bufferStats.getBufferPoolDisposeCount());
            counters.setBufferPoolDisposeBytes(bufferStats.getBufferPoolDisposeBytes());
            counters.setBufferPoolLeakCount(bufferStats.getBufferPoolLeakCount());
            counters.setBufferPoolLeakBytes(bufferStats.getBufferPoolLeakBytes());
            return counters;
        }

        private final SrvMonSysMemoryEntityTypeCounters populateEntityMemoryStatsCounters(MemoryStats.EntityTypeStats memoryStats, SrvMonSysMemoryEntityTypeCounters counters) {
            counters.setLiveCount(memoryStats.getLiveCount());
            counters.setPooledCount(memoryStats.getPooledCount());
            counters.setCreateAllocCount(memoryStats.getCreateAllocCount());
            counters.setPoolAllocCount(memoryStats.getPoolAllocCount());
            counters.setGCDisposeCount(memoryStats.getGCDisposeCount());
            counters.setPoolDisposeCount(memoryStats.getPoolDisposeCount());
            counters.setPoolLeakCount(memoryStats.getPoolLeakCount());
            counters.setPojoLiveCount(memoryStats.getPojoLiveCount());
            counters.setPojoPooledCount(memoryStats.getPojoPooledCount());
            counters.setPojoCreateAllocCount(memoryStats.getPojoCreateAllocCount());
            counters.setPojoPoolAllocCount(memoryStats.getPojoPoolAllocCount());
            counters.setPojoGCDisposeCount(memoryStats.getPojoGCDisposeCount());
            counters.setPojoPoolDisposeCount(memoryStats.getPojoPoolDisposeCount());
            counters.setPojoPoolLeakCount(memoryStats.getPojoPoolLeakCount());
            counters.setSerializerLiveCount(memoryStats.getSerializerLiveCount());
            counters.setSerializerPooledCount(memoryStats.getSerializerPooledCount());
            counters.setSerializerCreateAllocCount(memoryStats.getSerializerCreateAllocCount());
            counters.setSerializerPoolAllocCount(memoryStats.getSerializerPoolAllocCount());
            counters.setSerializerGCDisposeCount(memoryStats.getSerializerGCDisposeCount());
            counters.setSerializerPoolDisposeCount(memoryStats.getSerializerPoolDisposeCount());
            counters.setSerializerPoolLeakCount(memoryStats.getSerializerPoolLeakCount());
            counters.setDeserializerLiveCount(memoryStats.getDeserializerLiveCount());
            counters.setDeserializerPooledCount(memoryStats.getDeserializerPooledCount());
            counters.setDeserializerCreateAllocCount(memoryStats.getDeserializerCreateAllocCount());
            counters.setDeserializerPoolAllocCount(memoryStats.getDeserializerPoolAllocCount());
            counters.setDeserializerGCDisposeCount(memoryStats.getDeserializerGCDisposeCount());
            counters.setDeserializerPoolDisposeCount(memoryStats.getDeserializerPoolDisposeCount());
            counters.setDeserializerPoolLeakCount(memoryStats.getDeserializerPoolLeakCount());
            counters.setMetadataLiveCount(memoryStats.getMetadataLiveCount());
            counters.setMetadataLiveBytes(memoryStats.getMetadataLiveBytes());
            counters.setMetadataAllocCount(memoryStats.getMetadataAllocCount());
            counters.setMetadataAllocBytes(memoryStats.getMetadataAllocBytes());
            counters.setMetadataGCDisposeCount(memoryStats.getMetadataGCDisposeCount());
            counters.setMetadataGCDisposeBytes(memoryStats.getMetadataGCDisposeBytes());
            counters.setMetadataPoolDisposeCount(memoryStats.getMetadataPoolDisposeCount());
            counters.setMetadataPoolDisposeBytes(memoryStats.getMetadataPoolDisposeBytes());
            counters.setDataLiveCount(memoryStats.getDataLiveCount());
            counters.setDataLiveBytes(memoryStats.getDataLiveBytes());
            counters.setDataAllocCount(memoryStats.getDataAllocCount());
            counters.setDataAllocBytes(memoryStats.getDataAllocBytes());
            counters.setDataGCDisposeCount(memoryStats.getDataGCDisposeCount());
            counters.setDataGCDisposeBytes(memoryStats.getDataGCDisposeBytes());
            counters.setDataPoolDisposeCount(memoryStats.getDataPoolDisposeCount());
            counters.setDataPoolDisposeBytes(memoryStats.getDataPoolDisposeBytes());
            return counters;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void populateMemoryInfo(SrvMonSysStats stats) {
            Map collectionCountersByType;
            Map messageCountersByType;
            Map entityCountersByType;
            Map embeddedEntityCountersByType;
            SrvMonSysMemoryStats sysMemoryStats = SrvMonSysMemoryStats.create();
            MemoryStats memoryStats = MemoryStats.getInstance();
            SrvMonSysMemoryUsage heapUsage = SrvMonSysMemoryUsage.create();
            MemoryUsage beanHeapUsage = this.memoryBean.getHeapMemoryUsage();
            heapUsage.setInit(beanHeapUsage.getInit());
            heapUsage.setUsed(beanHeapUsage.getUsed());
            heapUsage.setCommitted(beanHeapUsage.getCommitted());
            heapUsage.setMax(beanHeapUsage.getMax());
            sysMemoryStats.setHeapUsage(heapUsage);
            SrvMonSysMemoryUsage nonHeapUsage = SrvMonSysMemoryUsage.create();
            MemoryUsage beanNonHeapUsage = this.memoryBean.getNonHeapMemoryUsage();
            nonHeapUsage.setInit(beanNonHeapUsage.getInit());
            nonHeapUsage.setUsed(beanNonHeapUsage.getUsed());
            nonHeapUsage.setCommitted(beanNonHeapUsage.getCommitted());
            nonHeapUsage.setMax(beanNonHeapUsage.getMax());
            sysMemoryStats.setNonHeapUsage(nonHeapUsage);
            SrvMonSysMemoryOffHeapUsage offHeapUsage = SrvMonSysMemoryOffHeapUsage.create();
            offHeapUsage.setUsedLive(memoryStats.getOffHeapMemoryUsedLive());
            offHeapUsage.setUsedPooled(memoryStats.getOffHeapMemoryUsedPooled());
            sysMemoryStats.setOffHeapUsage(offHeapUsage);
            SrvMonSysMemoryNativeCounters nativeCounters = SrvMonSysMemoryNativeCounters.create();
            sysMemoryStats.setNativeCounters(this.populateNativeMemoryCounters(memoryStats.getNativeStatsCounters(), nativeCounters));
            SrvMonSysMemoryIOBufCounters iobufCounters = SrvMonSysMemoryIOBufCounters.create();
            sysMemoryStats.setIobufCounters(this.populateIOBufMemoryCounters(memoryStats.getIOBufferStatsCounters(), iobufCounters));
            SrvMonSysMemoryEntityTypeCounters embeddedEntityCounters = SrvMonSysMemoryEntityTypeCounters.create();
            sysMemoryStats.setEmbeddedEntityCounters(this.populateEntityMemoryStatsCounters(memoryStats.getEmbeddedEntityStatsCounters(), embeddedEntityCounters));
            Map map = embeddedEntityCountersByType = memoryStats.getEmbeddedEntityTypeStatsCounters();
            synchronized (map) {
                for (Map.Entry entry : embeddedEntityCountersByType.entrySet()) {
                    Class embeddedEntityClass = (Class)entry.getKey();
                    SrvMonSysMemoryEntityTypeCounters srvMonSysMemoryEntityTypeCounters = SrvMonSysMemoryEntityTypeCounters.create();
                    srvMonSysMemoryEntityTypeCounters.setEntityName(embeddedEntityClass.getName());
                    srvMonSysMemoryEntityTypeCounters.setEntityShortName(embeddedEntityClass.getSimpleName());
                    sysMemoryStats.addEmbeddedEntityCountersByType(this.populateEntityMemoryStatsCounters((MemoryStats.EntityTypeStats)entry.getValue(), srvMonSysMemoryEntityTypeCounters));
                }
            }
            SrvMonSysMemoryEntityTypeCounters entityCounters = SrvMonSysMemoryEntityTypeCounters.create();
            sysMemoryStats.setEntityCounters(this.populateEntityMemoryStatsCounters(memoryStats.getEntityStatsCounters(), entityCounters));
            Map map2 = entityCountersByType = memoryStats.getEntityTypeStatsCounters();
            synchronized (map2) {
                for (Map.Entry entry : entityCountersByType.entrySet()) {
                    Class entityClass = (Class)entry.getKey();
                    SrvMonSysMemoryEntityTypeCounters srvMonSysMemoryEntityTypeCounters = SrvMonSysMemoryEntityTypeCounters.create();
                    srvMonSysMemoryEntityTypeCounters.setEntityName(entityClass.getName());
                    srvMonSysMemoryEntityTypeCounters.setEntityShortName(entityClass.getSimpleName());
                    sysMemoryStats.addEntityCountersByType(this.populateEntityMemoryStatsCounters((MemoryStats.EntityTypeStats)entry.getValue(), srvMonSysMemoryEntityTypeCounters));
                }
            }
            SrvMonSysMemoryEntityTypeCounters srvMonSysMemoryEntityTypeCounters = SrvMonSysMemoryEntityTypeCounters.create();
            sysMemoryStats.setMessageCounters(this.populateEntityMemoryStatsCounters(memoryStats.getMessageStatsCounters(), srvMonSysMemoryEntityTypeCounters));
            Map map3 = messageCountersByType = memoryStats.getMessageTypeStatsCounters();
            synchronized (map3) {
                for (Map.Entry entry : messageCountersByType.entrySet()) {
                    Class messageClass = (Class)entry.getKey();
                    SrvMonSysMemoryEntityTypeCounters typeSpecificMessageCounters = SrvMonSysMemoryEntityTypeCounters.create();
                    typeSpecificMessageCounters.setEntityName(messageClass.getName());
                    typeSpecificMessageCounters.setEntityShortName(messageClass.getSimpleName());
                    sysMemoryStats.addMessageCountersByType(this.populateEntityMemoryStatsCounters((MemoryStats.EntityTypeStats)entry.getValue(), typeSpecificMessageCounters));
                }
            }
            SrvMonSysMemoryEntityTypeCounters srvMonSysMemoryEntityTypeCounters2 = SrvMonSysMemoryEntityTypeCounters.create();
            sysMemoryStats.setCollectionCounters(this.populateEntityMemoryStatsCounters(memoryStats.getCollectionStatsCounters(), srvMonSysMemoryEntityTypeCounters2));
            Map map4 = collectionCountersByType = memoryStats.getCollectionTypeStatsCounters();
            synchronized (map4) {
                for (Map.Entry entry5 : collectionCountersByType.entrySet()) {
                    Class collectionClass = (Class)entry5.getKey();
                    SrvMonSysMemoryEntityTypeCounters typeSpecificCollectionCounters = SrvMonSysMemoryEntityTypeCounters.create();
                    typeSpecificCollectionCounters.setEntityName(collectionClass.getName());
                    typeSpecificCollectionCounters.setEntityShortName(collectionClass.getSimpleName());
                    sysMemoryStats.addCollectionCountersByType(this.populateEntityMemoryStatsCounters((MemoryStats.EntityTypeStats)entry5.getValue(), typeSpecificCollectionCounters));
                }
            }
            if (this.sunOsBean != null) {
                sysMemoryStats.setCommittedVirtualMemorySize(this.sunOsBean.getCommittedVirtualMemorySize());
                sysMemoryStats.setFreePhysicalMemorySize(this.sunOsBean.getFreePhysicalMemorySize());
                sysMemoryStats.setFreeSwapSpaceSize(this.sunOsBean.getFreeSwapSpaceSize());
                sysMemoryStats.setTotalPhysicalMemorySize(this.sunOsBean.getTotalPhysicalMemorySize());
                sysMemoryStats.setTotalSwapSpaceSize(this.sunOsBean.getTotalSwapSpaceSize());
            }
            stats.setMemoryStats(sysMemoryStats);
        }

        private final void populateGCInfo(SrvMonSysStats sysStats) {
            SrvMonSysGCStats gcStats = SrvMonSysGCStats.create();
            List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
            for (int i = 0; i < gcBeans.size(); ++i) {
                GarbageCollectorMXBean gcBean = gcBeans.get(i);
                SrvMonSysGCCollectorStats stats = SrvMonSysGCCollectorStats.create();
                stats.setCollectorName(gcBean.getName());
                stats.setCollectionCount(gcBean.getCollectionCount());
                stats.setCollectionTime(gcBean.getCollectionTime());
                gcStats.addCollectorsStats(stats);
            }
            sysStats.setGcStats(gcStats);
        }

        private final void populateJITInfo(SrvMonSysStats stats) {
            SrvMonSysJITStats jitStats = SrvMonSysJITStats.create();
            jitStats.setName(this.jitBean.getName());
            jitStats.setTotalCompilationTime(this.jitBean.isCompilationTimeMonitoringSupported() ? this.jitBean.getTotalCompilationTime() : -1L);
            stats.setJitStats(jitStats);
        }

        private final void populateThreadInfo(SrvMonSysStats sysStats) {
            SrvMonSysThreadStats threadStats = SrvMonSysThreadStats.create();
            threadStats.setThreadCount(this.threadBean.getThreadCount());
            threadStats.setDaemonThreadCount(this.threadBean.getDaemonThreadCount());
            threadStats.setPeakThreadCount(this.threadBean.getPeakThreadCount());
            if (this.collectIndividualThreadStats) {
                Thread[] threads = null;
                try {
                    threads = (Thread[])this.zgThreadAccessor.invoke((Object)this.threadBean, (Object[])null);
                }
                catch (Throwable thrown) {
                    this.tracer.log("Error getting MX Bean threads: " + thrown.getMessage(), Tracer.Level.WARNING);
                }
                if (threads != null) {
                    for (int i = 0; i < threads.length; ++i) {
                        Enum state;
                        SrvMonSysIndividualThreadStats individualThreadStats;
                        block29: {
                            String stringName;
                            char[] charArrayName;
                            block28: {
                                individualThreadStats = SrvMonSysIndividualThreadStats.create();
                                individualThreadStats.setId(threads[i].getId());
                                charArrayName = null;
                                stringName = null;
                                if (this.zgCharArrayThreadNameField != null) {
                                    try {
                                        charArrayName = (char[])this.zgCharArrayThreadNameField.get(threads[i]);
                                    }
                                    catch (Throwable thrown) {
                                        if (this.tracer.debug) {
                                            this.tracer.log("Error getting thread name" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                                        }
                                        break block28;
                                    }
                                }
                                if (this.zgStringThreadNameField != null) {
                                    try {
                                        stringName = (String)this.zgStringThreadNameField.get(threads[i]);
                                    }
                                    catch (Throwable thrown) {
                                        if (!this.tracer.debug) break block28;
                                        this.tracer.log("Error getting thread name" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                                    }
                                }
                            }
                            XString tName = this.heartbeatGenerator.lookupThreadName(threads[i]);
                            if (charArrayName != null && tName.length() != charArrayName.length || stringName != null && tName.length() != stringName.length()) {
                                this.heartbeatGenerator.threadNameCache.remove(threads[i]);
                                tName = this.heartbeatGenerator.lookupThreadName(threads[i]);
                            }
                            individualThreadStats.setNameFrom(tName);
                            state = null;
                            if (this.zgThreadStateField != null) {
                                try {
                                    int status = this.zgThreadStateField.getInt(threads[i]);
                                    state = (Thread.State)((Object)this.threadStates.get(status));
                                    if (state == null) {
                                        state = threads[i].getState();
                                        this.threadStates.put(status, (Object)state);
                                    }
                                }
                                catch (Throwable thrown) {
                                    if (!this.tracer.debug) break block29;
                                    this.tracer.log("Error getting thread state" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                                }
                            }
                        }
                        if (state == null) {
                            state = threads[i].getState();
                        }
                        individualThreadStats.setState(state.toString());
                        if (threads[i].isAlive() && state != Thread.State.NEW) {
                            long cpuTime = this.threadBean.getThreadCpuTime(threads[i].getId());
                            long userTime = this.threadBean.getThreadUserTime(threads[i].getId());
                            long collectTime = System.nanoTime();
                            if (cpuTime > 0L) {
                                individualThreadStats.setCpuTime(cpuTime);
                            }
                            if (userTime > 0L) {
                                individualThreadStats.setUsrTime(userTime);
                            }
                            individualThreadStats.setCollectTime(collectTime);
                        } else {
                            individualThreadStats.setCollectTime(System.nanoTime());
                        }
                        UtlThread.ThreadStats stats = UtlThread.getThreadStats((Thread)threads[i]);
                        if (stats != null) {
                            individualThreadStats.setAffinity(stats.getAffinityString());
                            long waitCount = stats.getWaitCount();
                            if (waitCount > 0L) {
                                individualThreadStats.setWaitTime(stats.getWaitTime());
                                individualThreadStats.setWaitCount(waitCount);
                            }
                        }
                        threadStats.addIndividualThreadStats(individualThreadStats);
                    }
                } else {
                    long[] ids = this.threadBean.getAllThreadIds();
                    for (int i = 0; i < ids.length; ++i) {
                        SrvMonSysIndividualThreadStats individualThreadStats = SrvMonSysIndividualThreadStats.create();
                        individualThreadStats.setId(ids[i]);
                        ThreadInfo tinfo = this.threadBean.getThreadInfo(ids[i]);
                        individualThreadStats.setName(tinfo != null ? tinfo.getThreadName() : "<defunct>");
                        individualThreadStats.setState(tinfo != null ? tinfo.getThreadState().toString() : "<unavailable>");
                        long cpuTime = this.threadBean.getThreadCpuTime(ids[i]);
                        long userTime = this.threadBean.getThreadUserTime(ids[i]);
                        long collectTime = System.nanoTime();
                        if (cpuTime > 0L) {
                            individualThreadStats.setCpuTime(cpuTime);
                        }
                        if (userTime > 0L) {
                            individualThreadStats.setUsrTime(userTime);
                        }
                        individualThreadStats.setCollectTime(collectTime);
                        threadStats.addIndividualThreadStats(individualThreadStats);
                    }
                }
            }
            sysStats.setThreadStats(threadStats);
        }

        private final void populateDiskInfo(SrvMonSysStats sysStats) {
            for (int i = 0; i < this.fileRoots.length; ++i) {
                SrvMonSysDiskStats diskStats = SrvMonSysDiskStats.create();
                diskStats.setRootPath(this.fileRoots[i].getPath());
                diskStats.setTotalSpace(this.fileRoots[i].getTotalSpace());
                diskStats.setUsableSpace(this.fileRoots[i].getUsableSpace());
                diskStats.setFreeSpace(this.fileRoots[i].getFreeSpace());
                sysStats.addDiskStats(diskStats);
            }
        }

        final SrvMonSysStats createForHeartbeat() {
            SrvMonSysStats stats = SrvMonSysStats.create();
            this.populateSystemInfo(stats);
            this.populateMemoryInfo(stats);
            this.populateGCInfo(stats);
            this.populateJITInfo(stats);
            this.populateThreadInfo(stats);
            return stats;
        }
    }
}

