/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.daemon.thread;

import com.neeve.daemon.thread.DmnThread;
import com.neeve.daemon.thread.DmnThreadObject;
import com.neeve.daemon.thread.DmnThreadPool;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;

public class DmnThreadManager
extends DmnThreadObject {
    private final String name;
    private final RootConfig.ObjectConfig config;
    private int roundRobinAssignmentIndex;
    protected final DmnThreadPool pool;

    protected DmnThreadManager(String name, RootConfig.ObjectConfig config) {
        super(config);
        this.name = name;
        this.config = config;
        this.pool = new DmnThreadPool(name, config);
        this.roundRobinAssignmentIndex = 0;
    }

    protected final DmnThread getIOThreadByAffinity(int affinity) {
        DmnThread thread;
        int resolvedAffinity = affinity;
        if (affinity < -1) {
            this.tracer.log("Invalid requested affinity [" + affinity + "]. Using affinity=-1 (dynamic).", Tracer.Level.WARNING);
            resolvedAffinity = -1;
        }
        if (affinity > this.pool.getIOThreadCount()) {
            this.tracer.log("Invalid requested thread affinity [" + affinity + "]. Using affinity=" + this.pool.getIOThreadCount() + " (last).", Tracer.Level.WARNING);
            resolvedAffinity = this.pool.getIOThreadCount();
        }
        if (resolvedAffinity < 0) {
            thread = this.pool.getIOThread(this.roundRobinAssignmentIndex++);
            this.roundRobinAssignmentIndex = this.roundRobinAssignmentIndex == this.pool.getIOThreadCount() ? 0 : this.roundRobinAssignmentIndex;
        } else {
            thread = this.pool.getIOThread(resolvedAffinity);
        }
        return thread;
    }

    public final void init(int numIOThreads, long[] ioThreadCpuAffinityMasks, int maxOnDemandThreads) throws Exception {
        if (numIOThreads < 1) {
            throw new InternalError("Invalid number of threads specified (" + numIOThreads + ")");
        }
        if (numIOThreads > 1 && !this.getThreaded()) {
            throw new InternalError("Thread pool started with numIOThreads > 1 but threaded mode is false!");
        }
        if (ioThreadCpuAffinityMasks == null) {
            throw new InternalError("IO thread CPU affinity array musg be non-null");
        }
        if (numIOThreads != ioThreadCpuAffinityMasks.length) {
            throw new InternalError("number of IO threads does not match the length of the CPU affinity array");
        }
        this.pool.init(numIOThreads, ioThreadCpuAffinityMasks, maxOnDemandThreads);
    }

    public final void start() {
        if (Thread.currentThread() != this.pool.getMainThread().getDispatcher().getOwner()) {
            throw new InternalError("Start must be invoked by the main thread");
        }
        this.pool.start();
    }

    public final DmnThreadPool getThreadPool() {
        return this.pool;
    }

    public final void stop() {
        if (this.pool.getMainThread() != null) {
            if (Thread.currentThread() != this.pool.getMainThread().getDispatcher().getOwner()) {
                throw new InternalError("Stop must be invoked by the main thread");
            }
            this.pool.stop();
        }
    }
}

