/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.cloud.local.LocalProvisioner;
import com.neeve.tools.AbstractCommand;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class LocalCommand
extends AbstractCommand {
    private static final Set<String> commands = Stream.of("launch-admin", "run-admin-script", "start-admin", "stop-admin", "terminate-admin", "launch-monitor", "start-monitor", "stop-monitor", "terminate-monitor", "launch-solace", "start-solace", "stop-solace", "terminate-solace", "launch-kafka", "start-kafka", "stop-kafka", "terminate-kafka", "launch-amq", "start-amq", "stop-amq", "terminate-amq", "launch-platform", "start-platform", "stop-platform", "terminate-platform", "launch-instance", "run-command", "start-instance", "stop-instance", "terminate-instance", "list-instances", "provision", "deploy", "configure", "start", "stop", "deprovision").collect(Collectors.toCollection(HashSet::new));

    LocalCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi 'cloud local' commands:");
        System.out.println("");
        System.out.println("         launch-admin           Provision and start the Rumi admin module");
        System.out.println("         run-admin-script       Run a Rumi admin script");
        System.out.println("         start-admin            Start the Rumi admin module");
        System.out.println("         stop-admin             Stop the Rumi admin module");
        System.out.println("         terminate-admin        Terminate the Rumi admin module");
        System.out.println("         launch-monitor         Provision and start the Rumi monitor module");
        System.out.println("         start-monitor          Start the Rumi monitor module");
        System.out.println("         stop-monitor           Stop the Rumi monitor module");
        System.out.println("         terminate-monitor      Terminate the Rumi monitor module");
        System.out.println("         launch-solace          Provision and start the Solace broker");
        System.out.println("         start-solace           Start the Solace broker");
        System.out.println("         stop-solace            Stop the Solace broker");
        System.out.println("         terminate-solace       Terminate the Solace broker");
        System.out.println("         launch-kafka           Provision and start the Kafka broker");
        System.out.println("         start-kafka            Start the Kafka broker");
        System.out.println("         stop-kafka             Stop the Kafka broker");
        System.out.println("         terminate-kafka        Terminate the Kafka broker");
        System.out.println("         launch-amq             Provision and start the ActiveMQ broker");
        System.out.println("         start-amq              Start the ActiveMQ broker");
        System.out.println("         stop-amq               Stop the ActiveMQ broker");
        System.out.println("         terminate-amq          Terminate the ActiveMQ broker");
        System.out.println("         launch-platform        Provision and start the Rumi platform modules");
        System.out.println("         start-platform         Start the Rumi platform modules");
        System.out.println("         stop-platform          Stop the Rumi platform modules");
        System.out.println("         terminate-platform     Terminate the Rumi platform modules");
        System.out.println("         launch-instance        Provision and start a Rumi service instance");
        System.out.println("         run-command            Run a command on a Rumi service instance");
        System.out.println("         start-instance         Start a Rumi service instance");
        System.out.println("         stop-instance          Stop a Rumi service instance");
        System.out.println("         terminate-instance     Terminate a Rumi service instance");
        System.out.println("         list-instances         List instances provisioned by Rumi");
        System.out.println("         provision              Provision a local Rumi private cloud");
        System.out.println("         deploy                 Deploy a Rumi system to the local private cloud");
        System.out.println("         configure              Update a configuration property in the local private cloud");
        System.out.println("         start                  Start all services in the local private cloud");
        System.out.println("         stop                   Stop all services in the local private cloud");
        System.out.println("         deprovision            Deprovision the local Rumi private cloud");
        System.out.println("");
        System.out.println("      Run 'rumi help cloud local <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("launch-admin")) {
            return new LaunchAdminCommand();
        }
        if (command.equals("run-admin-script")) {
            return new RunAdminScriptCommand();
        }
        if (command.equals("start-admin")) {
            return new StartAdminCommand();
        }
        if (command.equals("stop-admin")) {
            return new StopAdminCommand();
        }
        if (command.equals("terminate-admin")) {
            return new TerminateAdminCommand();
        }
        if (command.equals("launch-monitor")) {
            return new LaunchMonitorCommand();
        }
        if (command.equals("start-monitor")) {
            return new StartMonitorCommand();
        }
        if (command.equals("stop-monitor")) {
            return new StopMonitorCommand();
        }
        if (command.equals("terminate-monitor")) {
            return new TerminateMonitorCommand();
        }
        if (command.equals("launch-solace")) {
            return new LaunchSolaceCommand();
        }
        if (command.equals("start-solace")) {
            return new StartSolaceCommand();
        }
        if (command.equals("stop-solace")) {
            return new StopSolaceCommand();
        }
        if (command.equals("terminate-solace")) {
            return new TerminateSolaceCommand();
        }
        if (command.equals("launch-kafka")) {
            return new LaunchKafkaCommand();
        }
        if (command.equals("start-kafka")) {
            return new StartKafkaCommand();
        }
        if (command.equals("stop-kafka")) {
            return new StopKafkaCommand();
        }
        if (command.equals("terminate-kafka")) {
            return new TerminateKafkaCommand();
        }
        if (command.equals("launch-amq")) {
            return new LaunchActiveMQCommand();
        }
        if (command.equals("start-amq")) {
            return new StartActiveMQCommand();
        }
        if (command.equals("stop-amq")) {
            return new StopActiveMQCommand();
        }
        if (command.equals("terminate-amq")) {
            return new TerminateActiveMQCommand();
        }
        if (command.equals("launch-platform")) {
            return new LaunchPlatformCommand();
        }
        if (command.equals("start-platform")) {
            return new StartPlatformCommand();
        }
        if (command.equals("stop-platform")) {
            return new StopPlatformCommand();
        }
        if (command.equals("terminate-platform")) {
            return new TerminatePlatformCommand();
        }
        if (command.equals("launch-instance")) {
            return new LaunchServiceInstanceCommand();
        }
        if (command.equals("run-command")) {
            return new RunCommandOnServiceInstanceCommand();
        }
        if (command.equals("start-instance")) {
            return new StartServiceInstanceCommand();
        }
        if (command.equals("stop-instance")) {
            return new StopServiceInstanceCommand();
        }
        if (command.equals("terminate-instance")) {
            return new TerminateServiceInstanceCommand();
        }
        if (command.equals("list-instances")) {
            return new ListInstancesCommand();
        }
        if (command.equals("provision")) {
            return new ProvisionCloudCommand();
        }
        if (command.equals("deploy")) {
            return new DeploySystemCommand();
        }
        if (command.equals("configure")) {
            return new UpdateCloudConfigCommand();
        }
        if (command.equals("start")) {
            return new StartCloudCommand();
        }
        if (command.equals("stop")) {
            return new StopCloudCommand();
        }
        if (command.equals("deprovision")) {
            return new DeprovisionCloudCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    @Override
    final void help(String[] args) {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                LocalCommand.commandHandler(command).help(null);
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                LocalCommand.commandHandler(command).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    private static final class DeprovisionCloudCommand
    extends AbstractCommand {
        private DeprovisionCloudCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local deprovision' - deprovisions the local private cloud");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeprovisionCloudCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().deprovisionEnvironment();
        }
    }

    private static final class StopCloudCommand
    extends AbstractCommand {
        private StopCloudCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop' - stops all services in the local private cloud");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopCloudCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopEnvironment();
        }
    }

    private static final class StartCloudCommand
    extends AbstractCommand {
        private StartCloudCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start' - starts all services in the local private cloud");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartCloudCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startEnvironment();
        }
    }

    private static final class UpdateCloudConfigCommand
    extends AbstractCommand {
        private UpdateCloudConfigCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local configure <args>' where args are:");
            System.out.println("          [{-s, --section the configuration section] (required)");
            System.out.println("          [{-k, --key the property key] (required)");
            System.out.println("          [{-v, --value the property value (use 'null' to remove)] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            UpdateCloudConfigCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option sectionOption = parser.addStringOption('s', "section");
            CmdLineParser.Option keyOption = parser.addStringOption('k', "key");
            CmdLineParser.Option valueOption = parser.addStringOption('v', "value");
            parser.parse(args);
            String section = (String)parser.getOptionValue(sectionOption, null);
            String key = (String)parser.getOptionValue(keyOption, null);
            String value = (String)parser.getOptionValue(valueOption, null);
            if (section != null && key != null && value != null) {
                LocalProvisioner.create().updateConfig(section, key, value);
            } else {
                UpdateCloudConfigCommand.printUsage();
            }
        }
    }

    private static final class DeploySystemCommand
    extends AbstractCommand {
        private DeploySystemCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local deploy <args>' where args are:");
            System.out.println("          [{-x, --xar the xar file to deploy] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeploySystemCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option xarOption = parser.addStringOption('x', "xar");
            parser.parse(args);
            String xarPath = (String)parser.getOptionValue(xarOption, null);
            if (xarPath != null) {
                LocalProvisioner.create().deploySystem(new File(xarPath));
            } else {
                DeploySystemCommand.printUsage();
            }
        }
    }

    private static final class ProvisionCloudCommand
    extends AbstractCommand {
        private ProvisionCloudCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local provision <args>' where args are:");
            System.out.println("          [{-b, --message-broker the messaging broker to provision] (default=<no broker>)");
            System.out.println("                                 valid values: solace, kafka, activemq");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ProvisionCloudCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option messageBrokerOption = parser.addStringOption('b', "message-broker");
            parser.parse(args);
            String messageBroker = (String)parser.getOptionValue(messageBrokerOption, null);
            if (messageBroker != null) {
                LocalProvisioner.create().provisionEnvironmentWithMessageBroker(messageBroker);
            } else {
                LocalProvisioner.create().provisionEnvironment();
            }
        }
    }

    private static final class RunCommandOnServiceInstanceCommand
    extends AbstractCommand {
        private RunCommandOnServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local run-command <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service container] (required)");
            System.out.println("          [{-c, --command the command to run] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            RunCommandOnServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option commandOption = parser.addStringOption('c', "command");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            String command = (String)parser.getOptionValue(commandOption, null);
            if (name != null && command != null) {
                LocalProvisioner.create().runCommandOnServiceInstance(name, command);
            } else {
                RunCommandOnServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class ListInstancesCommand
    extends AbstractCommand {
        private ListInstancesCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local list-instances' - lists all running containers in the local environment");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListInstancesCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().listInstances();
        }
    }

    private static final class TerminateServiceInstanceCommand
    extends AbstractCommand {
        private TerminateServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-instance <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service instance] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            if (name != null) {
                LocalProvisioner.create().terminateServiceInstance(name);
            } else {
                TerminateServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class StopServiceInstanceCommand
    extends AbstractCommand {
        private StopServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-instance <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service instance] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            if (name != null) {
                LocalProvisioner.create().stopServiceInstance(name);
            } else {
                StopServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class StartServiceInstanceCommand
    extends AbstractCommand {
        private StartServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-instance <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service instance] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            if (name != null) {
                LocalProvisioner.create().startServiceInstance(name);
            } else {
                StartServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class LaunchServiceInstanceCommand
    extends AbstractCommand {
        private LaunchServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-instance <args>' where args are:");
            System.out.println("          [{-n, --name the name of the service instance] (required)");
            System.out.println("          [{-h, --hostname the hostname for the service] (required)");
            System.out.println("          [{-p, --ports the comma separated set of service ports to expose] (default=null)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option hostnameOption = parser.addStringOption('h', "hostname");
            CmdLineParser.Option portsOption = parser.addStringOption('p', "ports");
            parser.parse(args);
            String name = (String)parser.getOptionValue(nameOption, null);
            String hostname = (String)parser.getOptionValue(hostnameOption, null);
            String commaSeparatedPorts = (String)parser.getOptionValue(portsOption, null);
            if (name != null && hostname != null) {
                if (commaSeparatedPorts != null && !commaSeparatedPorts.trim().isEmpty()) {
                    int[] ports = Arrays.stream(commaSeparatedPorts.split(",")).map(String::trim).mapToInt(Integer::parseInt).toArray();
                    LocalProvisioner.create().launchServiceInstance(name, hostname, ports);
                } else {
                    LocalProvisioner.create().launchServiceInstance(name, hostname);
                }
            } else {
                LaunchServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class TerminatePlatformCommand
    extends AbstractCommand {
        private TerminatePlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-platform' - terminates the Rumi platform modules");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminatePlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminatePlatform();
        }
    }

    private static final class StopPlatformCommand
    extends AbstractCommand {
        private StopPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-platform' - stops the Rumi platform modules");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopPlatform();
        }
    }

    private static final class StartPlatformCommand
    extends AbstractCommand {
        private StartPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-platform' - starts the Rumi platform modules");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startPlatform();
        }
    }

    private static final class LaunchPlatformCommand
    extends AbstractCommand {
        private LaunchPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-platform' - provisions and starts the Rumi platform modules");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchPlatform();
        }
    }

    private static final class TerminateActiveMQCommand
    extends AbstractCommand {
        private TerminateActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-amq' - terminates the ActiveMQ broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateActiveMQBroker();
        }
    }

    private static final class StopActiveMQCommand
    extends AbstractCommand {
        private StopActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-amq' - stops the ActiveMQ broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopActiveMQBroker();
        }
    }

    private static final class StartActiveMQCommand
    extends AbstractCommand {
        private StartActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-amq' - starts the ActiveMQ broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startActiveMQBroker();
        }
    }

    private static final class LaunchActiveMQCommand
    extends AbstractCommand {
        private LaunchActiveMQCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-amq' - provisions and starts the ActiveMQ broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchActiveMQCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchActiveMQBroker();
        }
    }

    private static final class TerminateKafkaCommand
    extends AbstractCommand {
        private TerminateKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-kafka' - terminates the Kafka broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateKafkaBroker();
        }
    }

    private static final class StopKafkaCommand
    extends AbstractCommand {
        private StopKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-kafka' - stops the Kafka broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopKafkaBroker();
        }
    }

    private static final class StartKafkaCommand
    extends AbstractCommand {
        private StartKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-kafka' - starts the Kafka broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startKafkaBroker();
        }
    }

    private static final class LaunchKafkaCommand
    extends AbstractCommand {
        private LaunchKafkaCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-kafka' - provisions and starts the Kafka broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchKafkaCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchKafkaBroker();
        }
    }

    private static final class TerminateSolaceCommand
    extends AbstractCommand {
        private TerminateSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-solace' - terminates the Solace broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateSolaceBroker();
        }
    }

    private static final class StopSolaceCommand
    extends AbstractCommand {
        private StopSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-solace' - stops the Solace broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopSolaceBroker();
        }
    }

    private static final class StartSolaceCommand
    extends AbstractCommand {
        private StartSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-solace' - starts the Solace broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startSolaceBroker();
        }
    }

    private static final class LaunchSolaceCommand
    extends AbstractCommand {
        private LaunchSolaceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-solace' - provisions and starts the Solace broker");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchSolaceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchSolaceBroker();
        }
    }

    private static final class TerminateMonitorCommand
    extends AbstractCommand {
        private TerminateMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-monitor' - terminates the Rumi monitor module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateMonitor();
        }
    }

    private static final class StopMonitorCommand
    extends AbstractCommand {
        private StopMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-monitor' - stops the Rumi monitor module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopMonitor();
        }
    }

    private static final class StartMonitorCommand
    extends AbstractCommand {
        private StartMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-monitor' - starts the Rumi monitor module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startMonitor();
        }
    }

    private static final class LaunchMonitorCommand
    extends AbstractCommand {
        private LaunchMonitorCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-monitor' - provisions and starts the Rumi monitor module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchMonitorCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchMonitor();
        }
    }

    private static final class TerminateAdminCommand
    extends AbstractCommand {
        private TerminateAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local terminate-admin' - terminates the Rumi admin module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().terminateAdmin();
        }
    }

    private static final class StopAdminCommand
    extends AbstractCommand {
        private StopAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local stop-admin' - stops the Rumi admin module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().stopAdmin();
        }
    }

    private static final class StartAdminCommand
    extends AbstractCommand {
        private StartAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local start-admin' - starts the Rumi admin module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().startAdmin();
        }
    }

    private static final class RunAdminScriptCommand
    extends AbstractCommand {
        private RunAdminScriptCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local run-admin-script <args>' where args are:");
            System.out.println("          [{-s, --system the name of the system whose script to run] (required)");
            System.out.println("          [{-i, --script the script to run] (required)");
            System.out.println("          [{-a, --params the script params in key1=val1,key2=val2,...,keyN=valN format] (default=null)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            RunAdminScriptCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option systemOption = parser.addStringOption('s', "system");
            CmdLineParser.Option scriptOption = parser.addStringOption('i', "script");
            CmdLineParser.Option paramsOption = parser.addStringOption('a', "params");
            parser.parse(args);
            String system = (String)parser.getOptionValue(systemOption, null);
            String script = (String)parser.getOptionValue(scriptOption, null);
            String params = (String)parser.getOptionValue(paramsOption, null);
            if (system != null && script != null) {
                LocalProvisioner.create().runAdminScript(system, script, params);
            } else {
                RunAdminScriptCommand.printUsage();
            }
        }
    }

    private static final class LaunchAdminCommand
    extends AbstractCommand {
        private LaunchAdminCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud local launch-admin' - provisions and starts the Rumi admin module");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchAdminCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            LocalProvisioner.create().launchAdmin();
        }
    }
}

