/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools;

import com.neeve.cloud.civo.CivoProvisioner;
import com.neeve.tools.AbstractCommand;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class CivoCommand
extends AbstractCommand {
    private static final Set<String> commands = Stream.of("list-sshkeys", "list-diskimages", "list-images", "list-instance-sizes", "list-instance-types", "create-network", "launch-jump", "start-jump", "stop-jump", "terminate-jump", "launch-admin", "start-admin", "stop-admin", "terminate-admin", "launch-monitor", "start-monitor", "stop-monitor", "terminate-monitor", "launch-solace", "start-solace", "stop-solace", "terminate-solace", "launch-platform", "start-platform", "stop-platform", "terminate-platform", "launch-instance", "terminate-instance", "list-instances", "list-networks", "delete-network", "provision", "deploy", "configure", "start", "stop", "deprovision").collect(Collectors.toCollection(HashSet::new));

    CivoCommand() {
    }

    private final void printTopLevelUsage() {
        System.out.println("");
        System.out.println("      Rumi 'cloud civo' commands:");
        System.out.println("");
        System.out.println("         list-sshkeys                              List the available SSH key pairs");
        System.out.println("         list-diskimages, list-images              List the available disk images (OS images)");
        System.out.println("         list-instance-sizes, list-instance-types  List the available instance sizes");
        System.out.println("         create-network                            Create a new Rumi network");
        System.out.println("         launch-jump                               Provision and start the Rumi Jump Server");
        System.out.println("         start-jump                                Start the Rumi Jump Server");
        System.out.println("         stop-jump                                 Stop the Rumi Jump Server");
        System.out.println("         terminate-jump                            Terminate the Rumi Jump Server");
        System.out.println("         launch-admin                              Provision and start the Rumi Admin Server");
        System.out.println("         start-admin                               Start the Rumi Admin Server");
        System.out.println("         stop-admin                                Stop the Rumi Admin Server");
        System.out.println("         terminate-admin                           Terminate the Rumi Admin Server");
        System.out.println("         launch-monitor                            Provision and start the Rumi Monitor Server");
        System.out.println("         start-monitor                             Start the Rumi Monitor Server");
        System.out.println("         stop-monitor                              Stop the Rumi Monitor Server");
        System.out.println("         terminate-monitor                         Terminate the Rumi Monitor Server");
        System.out.println("         launch-solace                             Provision and start the Rumi Solace Broker");
        System.out.println("         start-solace                              Start the Rumi Solace Broker");
        System.out.println("         stop-solace                               Stop the Rumi Solace Broker");
        System.out.println("         terminate-solace                          Terminate the Rumi Solace Broker");
        System.out.println("         launch-platform                           Provision and start  the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         start-platform                            Start the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         stop-platform                             Stop the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         terminate-platform                        Terminate the Rumi platform components (Jump, Admin, Monitor, Messaging)");
        System.out.println("         launch-instance                           Provision and start a Rumi service instance");
        System.out.println("         terminate-instance                        Terminate the Rumi service instance");
        System.out.println("         list-instances                            List instances provisioned by Rumi");
        System.out.println("         list-networks                             List networks provisioned by Rumi");
        System.out.println("         delete-network                            Delete an existing Rumi network");
        System.out.println("         provision                                 Provision a Rumi environment in the Civo cloud");
        System.out.println("         deploy                                    Deploy a Rumi system to a Rumi environment provisioned in the Civo cloud");
        System.out.println("         configure                                 Update a configuration property of a Rumi environment provisioned in the Civo cloud");
        System.out.println("         start                                     Start all provisioned instances in a Rumi environment in the Civo Cloud");
        System.out.println("         stop                                      Stop all provisioned instances in a Rumi environment in the Civo Cloud");
        System.out.println("         deprovision                               Deprovision an existing Rumi environment in the Civo Cloud");
        System.out.println("");
        System.out.println("      Run 'rumi help cloud civo <command>' for help on a specific command");
        System.out.println("");
    }

    private static final AbstractCommand commandHandler(String command) {
        if (command.equals("list-sshkeys")) {
            return new ListSSHKeysCommand();
        }
        if (command.equals("list-diskimages") || command.equals("list-images")) {
            return new ListDiskImagesCommand();
        }
        if (command.equals("list-instance-sizes") || command.equals("list-instance-types")) {
            return new ListInstanceSizesCommand();
        }
        if (command.equals("create-network")) {
            return new CreateNetworkCommand();
        }
        if (command.equals("launch-jump")) {
            return new LaunchJumpServerCommand();
        }
        if (command.equals("start-jump")) {
            return new StartJumpServerCommand();
        }
        if (command.equals("stop-jump")) {
            return new StopJumpServerCommand();
        }
        if (command.equals("terminate-jump")) {
            return new TerminateJumpServerCommand();
        }
        if (command.equals("launch-admin")) {
            return new LaunchAdminServerCommand();
        }
        if (command.equals("start-admin")) {
            return new StartAdminServerCommand();
        }
        if (command.equals("stop-admin")) {
            return new StopAdminServerCommand();
        }
        if (command.equals("terminate-admin")) {
            return new TerminateAdminServerCommand();
        }
        if (command.equals("launch-monitor")) {
            return new LaunchMonitorServerCommand();
        }
        if (command.equals("start-monitor")) {
            return new StartMonitorServerCommand();
        }
        if (command.equals("stop-monitor")) {
            return new StopMonitorServerCommand();
        }
        if (command.equals("terminate-monitor")) {
            return new TerminateMonitorServerCommand();
        }
        if (command.equals("launch-solace")) {
            return new LaunchSolaceBrokerCommand();
        }
        if (command.equals("start-solace")) {
            return new StartSolaceBrokerCommand();
        }
        if (command.equals("stop-solace")) {
            return new StopSolaceBrokerCommand();
        }
        if (command.equals("terminate-solace")) {
            return new TerminateSolaceBrokerCommand();
        }
        if (command.equals("launch-platform")) {
            return new LaunchPlatformCommand();
        }
        if (command.equals("start-platform")) {
            return new StartPlatformCommand();
        }
        if (command.equals("stop-platform")) {
            return new StopPlatformCommand();
        }
        if (command.equals("terminate-platform")) {
            return new TerminatePlatformCommand();
        }
        if (command.equals("launch-instance")) {
            return new LaunchServiceInstanceCommand();
        }
        if (command.equals("start-instance")) {
            return new StartServiceInstanceCommand();
        }
        if (command.equals("stop-instance")) {
            return new StopServiceInstanceCommand();
        }
        if (command.equals("terminate-instance")) {
            return new TerminateServiceInstanceCommand();
        }
        if (command.equals("list-instances")) {
            return new ListInstancesCommand();
        }
        if (command.equals("list-networks")) {
            return new ListNetworksCommand();
        }
        if (command.equals("delete-network")) {
            return new DeleteNetworkCommand();
        }
        if (command.equals("provision")) {
            return new ProvisionEnvironmentCommand();
        }
        if (command.equals("deploy")) {
            return new DeploySystemCommand();
        }
        if (command.equals("configure")) {
            return new UpdateEnvironmentConfigCommand();
        }
        if (command.equals("start")) {
            return new StartEnvironmentCommand();
        }
        if (command.equals("stop")) {
            return new StopEnvironmentCommand();
        }
        if (command.equals("deprovision")) {
            return new DeprovisionEnvironmentCommand();
        }
        throw new IllegalArgumentException("unknown command '" + command + "'");
    }

    @Override
    final void help(String[] args) {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                CivoCommand.commandHandler(command).help(null);
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    @Override
    final void execute(String[] args) throws Exception {
        if (args.length > 0) {
            String command = args[0].toLowerCase();
            if (commands.contains(command)) {
                CivoCommand.commandHandler(command).execute(args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{});
            } else {
                this.printTopLevelUsage();
            }
        } else {
            this.printTopLevelUsage();
        }
    }

    private static final class DeprovisionEnvironmentCommand
    extends AbstractCommand {
        private DeprovisionEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo deprovision <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to delete the network] (required)");
            System.out.println("          [{-n, --name the name of the provisioned Rumi environment to delete] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeprovisionEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && name != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).deprovisionEnvironment(name, keyPair);
            } else {
                DeprovisionEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class StopEnvironmentCommand
    extends AbstractCommand {
        private StopEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo configure <args>' where args are:");
            System.out.println("          [{-p, --profile the Civo profile to use] (required)");
            System.out.println("          [{-r, --region the Civo region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment to stop] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && name != null) {
                CivoProvisioner.create((String)profile, (String)region).stopEnvironment(name, !nowait);
            } else {
                StopEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class StartEnvironmentCommand
    extends AbstractCommand {
        private StartEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo configure <args>' where args are:");
            System.out.println("          [{-p, --profile the Civo profile to use] (required)");
            System.out.println("          [{-r, --region the Civo region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment to start] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option profileOption = parser.addStringOption('p', "profile");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String profile = (String)parser.getOptionValue(profileOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (profile != null && name != null) {
                CivoProvisioner.create((String)profile, (String)region).startEnvironment(name, !nowait);
            } else {
                StartEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class UpdateEnvironmentConfigCommand
    extends AbstractCommand {
        private UpdateEnvironmentConfigCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud aws configure <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the AWS region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment whose config is to be updated] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-s, --section the configuration property section] (required)");
            System.out.println("          [{-e, --key the configuration property key] (required)");
            System.out.println("          [{-v, --value the configuration property value] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            UpdateEnvironmentConfigCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option sectionOption = parser.addStringOption('s', "section");
            CmdLineParser.Option keyOption = parser.addStringOption('e', "key");
            CmdLineParser.Option valueOption = parser.addStringOption('v', "value");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String section = (String)parser.getOptionValue(sectionOption, null);
            String key = (String)parser.getOptionValue(keyOption, null);
            String value = (String)parser.getOptionValue(valueOption, null);
            if (apiKey != null && keyPair != null && name != null && section != null & key != null && value != null) {
                CivoProvisioner.create((String)apiKey, (String)region).updateConfig(name, keyPair, section, key, value.equalsIgnoreCase("null") ? null : value);
            } else {
                UpdateEnvironmentConfigCommand.printUsage();
            }
        }
    }

    private static final class DeploySystemCommand
    extends AbstractCommand {
        private DeploySystemCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo deploy <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region to use] (default=us-east-1)");
            System.out.println("          [{-n, --name the name of the environment to deploy the system to] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-x, --xar the xar file] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeploySystemCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option xarOption = parser.addStringOption('x', "xar");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, (Object)"us-east-1");
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String xar = (String)parser.getOptionValue(xarOption, null);
            if (apiKey != null && keyPair != null && name != null && xar != null) {
                CivoProvisioner.create((String)apiKey, (String)region).deploySystem(name, keyPair, new File(xar));
            } else {
                DeploySystemCommand.printUsage();
            }
        }
    }

    private static final class ProvisionEnvironmentCommand
    extends AbstractCommand {
        private ProvisionEnvironmentCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo provision <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to delete the network] (required)");
            System.out.println("          [{-n, --name the name of the network (VPC)] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ProvisionEnvironmentCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && name != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).provisionEnvironment(name, keyPair);
            } else {
                ProvisionEnvironmentCommand.printUsage();
            }
        }
    }

    private static final class DeleteNetworkCommand
    extends AbstractCommand {
        private DeleteNetworkCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo delete-network <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to delete the network] (required)");
            System.out.println("          [{-n, --name the name of the network to delete] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            DeleteNetworkCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && name != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).deleteNetwork(name, keyPair);
            } else {
                DeleteNetworkCommand.printUsage();
            }
        }
    }

    private static final class ListNetworksCommand
    extends AbstractCommand {
        private ListNetworksCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo list-networks <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use]");
            System.out.println("          [{-r, --region the Civo region in which to list the networks] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListNetworksCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            if (apiKey != null && region != null) {
                List networks = CivoProvisioner.create((String)apiKey, (String)region).getNetworks();
                System.out.println("");
                System.out.println("Provisioned Networks");
                System.out.println("--------------------");
                if (networks.size() > 0) {
                    Iterator iterator = networks.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListNetworksCommand.printUsage();
            }
        }
    }

    private static final class ListInstancesCommand
    extends AbstractCommand {
        private ListInstancesCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo list-instances <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use]");
            System.out.println("          [{-r, --region the Civo region in which to list the instances] (required)");
            System.out.println("          [{-n, --network the name of the network in which to list the instances] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListInstancesCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            if (apiKey != null && region != null && network != null) {
                Iterator iterator;
                CivoProvisioner provisioner = CivoProvisioner.create((String)apiKey, (String)region);
                List instances = provisioner.getPlatformInstances(network);
                System.out.println("");
                System.out.println("Platform Instances");
                System.out.println("------------------");
                if (instances.size() > 0) {
                    iterator = instances.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                instances = provisioner.getServiceInstances(network);
                System.out.println("");
                System.out.println("Service Instances");
                System.out.println("-----------------");
                if (instances.size() > 0) {
                    iterator = instances.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListInstancesCommand.printUsage();
            }
        }
    }

    private static final class TerminateServiceInstanceCommand
    extends AbstractCommand {
        private TerminateServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo terminate-instance <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to delete the instance] (required)");
            System.out.println("          [{-n, --network the name of the network in which to delete the instances] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-i, --name the name of the instance to delete] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option nameOption = parser.addStringOption('i', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && keyPair != null && name != null) {
                CivoProvisioner.create((String)apiKey, (String)region).terminateServiceInstance(network, keyPair, name, !nowait);
            } else {
                TerminateServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class StopServiceInstanceCommand
    extends AbstractCommand {
        private StopServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo stop-instance <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to delete the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-a, --name the name of the service instance to stop] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nameOption = parser.addStringOption('a', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && name != null) {
                CivoProvisioner.create((String)apiKey, (String)region).stopServiceInstance(network, name, !nowait);
            } else {
                StopServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class StartServiceInstanceCommand
    extends AbstractCommand {
        private StartServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo start-instance <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to delete the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-a, --name the name of the service instance to start] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nameOption = parser.addStringOption('a', "name");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && name != null) {
                CivoProvisioner.create((String)apiKey, (String)region).startServiceInstance(network, name, !nowait);
            } else {
                StartServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class LaunchServiceInstanceCommand
    extends AbstractCommand {
        private LaunchServiceInstanceCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo launch-instance <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network in which to create the new instance] (required)");
            System.out.println("          [{-k, --keyPair the name of the ssh key to associate with the new instance] (default=rumi)");
            System.out.println("          [{-s, --size the size of the service instance to launch (e.g. g4s.xsmall)] (required)");
            System.out.println("          [{-i, --publicIP whether to assign a public IP to the instance] (default=false)");
            System.out.println("          [{-z, --zone the hosted zone to add this instance's DNS entry to] (default=rumi.local)");
            System.out.println("          [{-a, --name the name of the service instance to launch] (required)");
            System.out.println("          [{-o, --nameInZone the zone name of the service instance to launch] (default=null in which case the instance name is used as the name in the zone)");
            System.out.println("          [{-l, --additionalNamesInZone the additional names to add the zone for this service instance] (default=null in which case no additional names are added to the zone for this instance)");
            System.out.println("          [{-v, --vsize the size, in GiB, of the additional (non-boot) volume on the instance] (default=0)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchServiceInstanceCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option sizeOption = parser.addStringOption('s', "size");
            CmdLineParser.Option publicIPOption = parser.addBooleanOption('i', "publicIP");
            CmdLineParser.Option zoneOption = parser.addStringOption('z', "zone");
            CmdLineParser.Option nameOption = parser.addStringOption('a', "name");
            CmdLineParser.Option nameInZoneOption = parser.addStringOption('b', "nameInZone");
            CmdLineParser.Option additionalNamesInZoneOption = parser.addStringOption('l', "additionalNamesInZone");
            CmdLineParser.Option vsizeOption = parser.addIntegerOption('v', "vsize");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            String size = (String)parser.getOptionValue(sizeOption, null);
            boolean publicIP = (Boolean)parser.getOptionValue(publicIPOption, (Object)false);
            String zone = (String)parser.getOptionValue(zoneOption, (Object)"rumi.local");
            String name = (String)parser.getOptionValue(nameOption, null);
            String nameInZone = (String)parser.getOptionValue(nameInZoneOption, null);
            String additionalNamesInZone = (String)parser.getOptionValue(additionalNamesInZoneOption, null);
            int vsize = (Integer)parser.getOptionValue(vsizeOption, (Object)32);
            if (apiKey != null && region != null && network != null && keyPair != null && name != null && size != null) {
                CivoProvisioner.create((String)apiKey, (String)region).launchServiceInstance(network, keyPair, size, publicIP, zone, name, nameInZone, additionalNamesInZone != null ? additionalNamesInZone.split(",") : null, vsize);
            } else {
                LaunchServiceInstanceCommand.printUsage();
            }
        }
    }

    private static final class TerminatePlatformCommand
    extends AbstractCommand {
        private TerminatePlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo terminate-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminatePlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).terminatePlatform(network, keyPair, !nowait);
            } else {
                TerminatePlatformCommand.printUsage();
            }
        }
    }

    private static final class StopPlatformCommand
    extends AbstractCommand {
        private StopPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo stop-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).stopPlatform(network, !nowait);
            } else {
                StopPlatformCommand.printUsage();
            }
        }
    }

    private static final class StartPlatformCommand
    extends AbstractCommand {
        private StartPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo start-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).startPlatform(network, !nowait);
            } else {
                StartPlatformCommand.printUsage();
            }
        }
    }

    private static final class LaunchPlatformCommand
    extends AbstractCommand {
        private LaunchPlatformCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo launch-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchPlatformCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).launchPlatform(network, keyPair);
            } else {
                LaunchPlatformCommand.printUsage();
            }
        }
    }

    private static final class TerminateSolaceBrokerCommand
    extends AbstractCommand {
        private TerminateSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo terminate-solace <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).terminateSolaceBroker(network, keyPair, !nowait);
            } else {
                TerminateSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class StopSolaceBrokerCommand
    extends AbstractCommand {
        private StopSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo stop-solace <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).stopSolaceBroker(network, !nowait);
            } else {
                StopSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class StartSolaceBrokerCommand
    extends AbstractCommand {
        private StartSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo start-solace <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).startSolaceBroker(network, !nowait);
            } else {
                StartSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class LaunchSolaceBrokerCommand
    extends AbstractCommand {
        private LaunchSolaceBrokerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo launch-solace <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchSolaceBrokerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).launchSolaceBroker(network, keyPair);
            } else {
                LaunchSolaceBrokerCommand.printUsage();
            }
        }
    }

    private static final class TerminateMonitorServerCommand
    extends AbstractCommand {
        private TerminateMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo terminate-monitor <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).terminateMonitorServer(network, keyPair, !nowait);
            } else {
                TerminateMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class StopMonitorServerCommand
    extends AbstractCommand {
        private StopMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo stop-monitor <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).stopMonitorServer(network, !nowait);
            } else {
                StopMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class StartMonitorServerCommand
    extends AbstractCommand {
        private StartMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo start-monitor <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).startMonitorServer(network, !nowait);
            } else {
                StartMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class LaunchMonitorServerCommand
    extends AbstractCommand {
        private LaunchMonitorServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo launch-monitor <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchMonitorServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).launchMonitorServer(network, keyPair);
            } else {
                LaunchMonitorServerCommand.printUsage();
            }
        }
    }

    private static final class TerminateAdminServerCommand
    extends AbstractCommand {
        private TerminateAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo terminate-admin <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).terminateAdminServer(network, keyPair, !nowait);
            } else {
                TerminateAdminServerCommand.printUsage();
            }
        }
    }

    private static final class StopAdminServerCommand
    extends AbstractCommand {
        private StopAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo stop-admin <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).stopAdminServer(network, !nowait);
            } else {
                StopAdminServerCommand.printUsage();
            }
        }
    }

    private static final class StartAdminServerCommand
    extends AbstractCommand {
        private StartAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo start-admin <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).startAdminServer(network, !nowait);
            } else {
                StartAdminServerCommand.printUsage();
            }
        }
    }

    private static final class LaunchAdminServerCommand
    extends AbstractCommand {
        private LaunchAdminServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo launch-admin <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchAdminServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).launchAdminServer(network, keyPair);
            } else {
                LaunchAdminServerCommand.printUsage();
            }
        }
    }

    private static final class TerminateJumpServerCommand
    extends AbstractCommand {
        private TerminateJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo terminate-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to terminate it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            TerminateJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).terminateJumpServer(network, keyPair, !nowait);
            } else {
                TerminateJumpServerCommand.printUsage();
            }
        }
    }

    private static final class StopJumpServerCommand
    extends AbstractCommand {
        private StopJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo stop-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to stop it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StopJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).stopJumpServer(network, !nowait);
            } else {
                StopJumpServerCommand.printUsage();
            }
        }
    }

    private static final class StartJumpServerCommand
    extends AbstractCommand {
        private StartJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo start-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to start it into] (required)");
            System.out.println("          [{-o, --nowait whether to not wait for the instance to fully start] (default=false)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            StartJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option nowaitOption = parser.addBooleanOption('o', "nowait");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            boolean nowait = (Boolean)parser.getOptionValue(nowaitOption, (Object)false);
            if (apiKey != null && region != null && network != null) {
                CivoProvisioner.create((String)apiKey, (String)region).startJumpServer(network, !nowait);
            } else {
                StartJumpServerCommand.printUsage();
            }
        }
    }

    private static final class LaunchJumpServerCommand
    extends AbstractCommand {
        private LaunchJumpServerCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo launch-jump <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the instance] (required)");
            System.out.println("          [{-n, --network the name of the network to launch it into] (required)");
            System.out.println("          [{-k, --keyPair the network key pair] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            LaunchJumpServerCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option networkOption = parser.addStringOption('n', "network");
            CmdLineParser.Option keyPairOption = parser.addStringOption('k', "keyPair");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String network = (String)parser.getOptionValue(networkOption, null);
            String keyPair = (String)parser.getOptionValue(keyPairOption, null);
            if (apiKey != null && region != null && network != null && keyPair != null) {
                CivoProvisioner.create((String)apiKey, (String)region).launchJumpServer(network, keyPair);
            } else {
                LaunchJumpServerCommand.printUsage();
            }
        }
    }

    private static final class CreateNetworkCommand
    extends AbstractCommand {
        private CreateNetworkCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo create-network <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use] (required)");
            System.out.println("          [{-r, --region the Civo region in which to create the network] (required)");
            System.out.println("          [{-n, --name the name to give the new network] (required)");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            CreateNetworkCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            CmdLineParser.Option regionOption = parser.addStringOption('r', "region");
            CmdLineParser.Option nameOption = parser.addStringOption('n', "name");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            String region = (String)parser.getOptionValue(regionOption, null);
            String name = (String)parser.getOptionValue(nameOption, null);
            if (apiKey != null && region != null && name != null) {
                CivoProvisioner.create((String)apiKey, (String)region).createNetwork(name);
            } else {
                CreateNetworkCommand.printUsage();
            }
        }
    }

    private static final class ListInstanceSizesCommand
    extends AbstractCommand {
        private ListInstanceSizesCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo list-instance-sizes <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use]");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListInstanceSizesCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            if (apiKey != null) {
                List sizes = CivoProvisioner.create((String)apiKey).getInstanceSizes();
                System.out.println("");
                System.out.println("Available Sizes");
                System.out.println("---------------");
                if (sizes.size() > 0) {
                    Iterator iterator = sizes.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListInstanceSizesCommand.printUsage();
            }
        }
    }

    private static final class ListDiskImagesCommand
    extends AbstractCommand {
        private ListDiskImagesCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo list-diskimages <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use]");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListDiskImagesCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            if (apiKey != null) {
                List images = CivoProvisioner.create((String)apiKey).getDiskImages();
                System.out.println("");
                System.out.println("Available Images");
                System.out.println("----------------");
                if (images.size() > 0) {
                    Iterator iterator = images.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListDiskImagesCommand.printUsage();
            }
        }
    }

    private static final class ListSSHKeysCommand
    extends AbstractCommand {
        private ListSSHKeysCommand() {
        }

        private static final void printUsage() {
            System.out.println("");
            System.out.println("      'rumi cloud civo list-sshkeys <args>' where args are:");
            System.out.println("          [{-y, --api-key the user API key to use]");
            System.out.println("");
        }

        @Override
        final void help(String[] args) {
            ListSSHKeysCommand.printUsage();
        }

        @Override
        final void execute(String[] args) throws Exception {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option apiKeyOption = parser.addStringOption('k', "api-key");
            parser.parse(args);
            String apiKey = (String)parser.getOptionValue(apiKeyOption, null);
            if (apiKey != null) {
                List keys = CivoProvisioner.create((String)apiKey).getSSHKeys();
                System.out.println("");
                System.out.println("Provisioned Key Pairs");
                System.out.println("---------------------");
                if (keys.size() > 0) {
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        System.out.println("  " + (String)iterator.next());
                    }
                } else {
                    System.out.println("  <none>");
                }
                System.out.println("");
            } else {
                ListSSHKeysCommand.printUsage();
            }
        }
    }
}

