/*
 * Decompiled with CFR 0.152.
 */
package com.akiban.sql.parser;

import com.akiban.sql.StandardException;
import com.akiban.sql.parser.DDLStatementNode;
import com.akiban.sql.parser.QueryTreeNode;
import com.akiban.sql.parser.TableName;

public class RenameNode
extends DDLStatementNode {
    protected TableName newTableName;
    protected String oldObjectName;
    protected String newObjectName;
    protected boolean usedAlterTable;
    protected RenameType renamingWhat;

    @Override
    public void init(Object tableName, Object oldObjectName, Object newName, Object usedAlterTable, Object renamingWhat) throws StandardException {
        this.usedAlterTable = (Boolean)usedAlterTable;
        this.renamingWhat = (RenameType)((Object)renamingWhat);
        switch (this.renamingWhat) {
            case TABLE: {
                this.initAndCheck((TableName)tableName);
                this.newTableName = (TableName)newName;
                this.oldObjectName = null;
                this.newObjectName = this.newTableName.getTableName();
                break;
            }
            case INDEX: {
                this.initAndCheck((TableName)tableName);
                this.oldObjectName = (String)oldObjectName;
                this.newObjectName = (String)newName;
                break;
            }
            case COLUMN: {
                TableName actingObjectName = tableName instanceof TableName ? (TableName)tableName : this.makeTableName(null, (String)tableName);
                this.initAndCheck(actingObjectName);
                this.oldObjectName = (String)oldObjectName;
                this.newObjectName = (String)newName;
                break;
            }
            default: {
                assert (false) : "Unexpected rename action in RenameNode";
                break;
            }
        }
    }

    public RenameType getRenameType() {
        return this.renamingWhat;
    }

    public TableName getNewTableName() {
        return this.newTableName;
    }

    public boolean isAlterTable() {
        return this.usedAlterTable;
    }

    public String getOldObjectName() {
        return this.oldObjectName;
    }

    public String getNewObjectName() {
        return this.newObjectName;
    }

    @Override
    public void copyFrom(QueryTreeNode node) throws StandardException {
        super.copyFrom(node);
        RenameNode other = (RenameNode)node;
        this.newTableName = (TableName)this.getNodeFactory().copyNode(other.newTableName, this.getParserContext());
        this.oldObjectName = other.oldObjectName;
        this.newObjectName = other.newObjectName;
        this.usedAlterTable = other.usedAlterTable;
        this.renamingWhat = other.renamingWhat;
    }

    @Override
    public String toString() {
        switch (this.renamingWhat) {
            case TABLE: {
                return super.toString() + "oldTableName: " + "\n" + this.getRelativeName() + "\n" + "newTableName: " + "\n" + this.newTableName + "\n";
            }
            case COLUMN: {
                return super.toString() + "oldTableName.oldColumnName:" + "\n" + this.getRelativeName() + "." + this.oldObjectName + "\n" + "newColumnName: " + "\n" + this.newObjectName + "\n";
            }
            case INDEX: {
                return super.toString() + "oldIndexName:" + "\n" + this.oldObjectName + "\n" + "newIndexName: " + "\n" + this.newObjectName + "\n";
            }
        }
        assert (false) : "Unexpected rename action in RenameNode";
        return "UNKNOWN";
    }

    @Override
    public String statementToString() {
        if (this.usedAlterTable) {
            switch (this.renamingWhat) {
                case TABLE: {
                    return "ALTER TABLE";
                }
            }
            assert (false) : "Unexpected rename action in RenameNode";
            return "UNKNOWN";
        }
        switch (this.renamingWhat) {
            case TABLE: {
                return "RENAME TABLE";
            }
            case COLUMN: {
                return "RENAME COLUMN";
            }
            case INDEX: {
                return "RENAME INDEX";
            }
        }
        assert (false) : "Unexpected rename action in RenameNode";
        return "UNKNOWN";
    }

    public static enum RenameType {
        TABLE,
        COLUMN,
        INDEX;

    }
}

