/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.cli;

import com.neeve.cli.CliException;
import com.neeve.cli.FieldValueApplier;
import com.neeve.cli.annotations.Configured;
import com.neeve.config.Config;
import com.neeve.util.UtlDataTypes;
import com.neeve.util.UtlReflection;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;

public class ConfigInjector {
    private final Object configuredObj;

    private ConfigInjector(Object obj) throws CliException {
        this.configuredObj = obj;
    }

    public static ConfigInjector createInjector(Object targetObject) throws CliException {
        return new ConfigInjector(targetObject);
    }

    public final void populate() throws CliException {
        try {
            Class<?> clazz = this.configuredObj.getClass();
            Collection<Field> fieldList = UtlReflection.collectAllFields(clazz);
            for (Field field : fieldList) {
                Configured cfgAnn = field.getAnnotation(Configured.class);
                if (cfgAnn == null) continue;
                if ((field.getModifiers() & 0x10) == 16) {
                    this.throwException("Configured field must not be final", cfgAnn, clazz, field.getName());
                }
                if ((field.getModifiers() & 8) == 8) {
                    this.throwException("Configured field must not be static", cfgAnn, clazz, field.getName());
                }
                Object cfgVal = this.getCfgValue(cfgAnn, clazz, field, null);
                boolean wasAccessible = field.isAccessible();
                field.setAccessible(true);
                new FieldValueApplier(this.configuredObj, field).applyParsedValue(cfgVal);
                field.setAccessible(wasAccessible);
            }
            Collection<Method> methodList = UtlReflection.collectAllMethods(clazz);
            for (Method method : methodList) {
                Configured cfgAnn = method.getAnnotation(Configured.class);
                if (cfgAnn == null) continue;
                if (method.getReturnType() != Void.TYPE) {
                    this.throwException("Configured setter must return void", cfgAnn, clazz, method.getName());
                }
                if (method.getParameterTypes().length != 1) {
                    this.throwException("Configured setter must have exactly one argument", cfgAnn, clazz, method.getName());
                }
                Object cfgVal = this.getCfgValue(cfgAnn, clazz, null, method);
                cfgVal = UtlDataTypes.convert(method.getParameterTypes()[0], cfgVal);
                boolean wasAccessible = method.isAccessible();
                method.setAccessible(true);
                method.invoke(this.configuredObj, cfgVal);
                method.setAccessible(wasAccessible);
            }
        }
        catch (CliException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new CliException(t);
        }
    }

    private Object getCfgValue(Configured cfgAnn, Class<?> clazz, Field field, Method method) throws CliException {
        String cfgVal = Config.getValue((String)cfgAnn.property());
        if (cfgVal == null) {
            cfgVal = cfgAnn.defaultValue();
            if (cfgAnn.required() && "<null>".equals(cfgVal)) {
                String pName = null;
                if (field != null) {
                    pName = field.getName();
                }
                if (method != null) {
                    pName = method.getName();
                }
                this.throwException("Configured property required but no value found", cfgAnn, clazz, pName);
            }
        }
        return cfgVal;
    }

    private void throwException(String msg, Configured cfgAnn, Class<?> clazz, String pName) throws CliException {
        throw new CliException(msg + " (" + cfgAnn.property() + "): " + clazz.getName() + "." + pName);
    }
}

