/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.controller;

import com.neeve.controller.Command;
import com.neeve.controller.Controller;
import com.neeve.controller.ProgressMonitorHelper;
import com.neeve.controller.Script;
import com.neeve.controller.System;
import com.neeve.controller.XVM;
import com.neeve.controller.XVMUnreachableException;

final class Stop
extends Command {
    String _appName;
    private XVM _xvm;

    Stop(Controller controller, ProgressMonitorHelper progressMonitorHelper, System system, Script script, int lineNum, String line) {
        super(controller, progressMonitorHelper, system, script, lineNum, line);
    }

    private final void syntaxError(int lineNum) {
        this.error("Line " + lineNum + ": Syntax error: stop the <appName> app in the <xvmName> xvm");
    }

    @Override
    final String name() {
        return "stop";
    }

    @Override
    final boolean parse(Command.Args tokenizer) {
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        this._appName = tokenizer.nextToken();
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("app")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("in")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("the")) {
            this.syntaxError(this.lineNum());
        }
        if (!tokenizer.hasMoreTokens()) {
            this.syntaxError(this.lineNum());
        }
        String token = tokenizer.nextToken();
        this._xvm = this.system().getXVM(token);
        if (this._xvm == null) {
            this.error("Line " + this.lineNum() + ": XVM '" + token + "' is not configured in the '" + this.system().getHome().getName() + "' system");
        }
        if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equalsIgnoreCase("xvm")) {
            this.syntaxError(this.lineNum());
        }
        return true;
    }

    @Override
    final void execute() {
        if (!this.mock()) {
            try {
                this.remoteCommand(this._xvm.name(), null, "app_stop " + this._appName, true, 5);
            }
            catch (Exception e) {
                if (e instanceof XVMUnreachableException && this.isTreatUnreachableXVMAsNonFatal()) {
                    this.info("......xvm '" + this._xvm.name() + "' is unreachable. configured to ignore...");
                }
                this.error("Line " + this.lineNum() + ": Failed to execute command [" + e.toString() + "].", e);
            }
        }
    }

    @Override
    final void cleanup() {
    }
}

