/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.util.collect;

import com.google.common.base.Objects;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MinMaxPriorityQueue;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;

public class UtlSorted {
    public static <T> Iterable<T> unique(final Iterable<T> iterable) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private PeekingIterator<T> peekingIterator;
                    {
                        this.peekingIterator = Iterators.peekingIterator(iterable.iterator());
                    }

                    protected T computeNext() {
                        if (!this.peekingIterator.hasNext()) {
                            return this.endOfData();
                        }
                        Object element = this.peekingIterator.next();
                        while (this.peekingIterator.hasNext() && Objects.equal((Object)element, (Object)this.peekingIterator.peek())) {
                            this.peekingIterator.next();
                        }
                        return element;
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> merge(Iterable<Iterable<T>> iterables, Comparator<T> sorter) {
        return Iterables.mergeSorted(iterables, sorter);
    }

    public static <T> Iterable<T> mergeEach(Comparator<T> comparator, Iterable<T> ... iterables) {
        ArrayList iterablesList = Lists.newArrayList((Object[])iterables);
        return UtlSorted.merge(iterablesList, comparator);
    }

    public static <T extends Comparable<T>> Iterable<T> mergeEach(Iterable<T> ... iterables) {
        ArrayList iterablesList = Lists.newArrayList((Object[])iterables);
        Ordering comparator = Ordering.natural();
        return UtlSorted.merge(iterablesList, comparator);
    }

    public static <T> Iterable<T> mergeUnique(Iterable<? extends Iterable<T>> iterables, Comparator<T> sorter) {
        Iterable merged = Iterables.mergeSorted(iterables, sorter);
        return UtlSorted.unique(merged);
    }

    public static <T> Iterable<T> intersect(Iterable<? extends Iterable<T>> iterables, Comparator<T> sorter) {
        final ArrayList peekingIterators = Lists.newArrayList();
        for (Iterable<T> iterable : iterables) {
            Iterator<T> iterator = iterable.iterator();
            PeekingIterator peeking = Iterators.peekingIterator(iterator);
            peekingIterators.add(peeking);
        }
        int numberOfIterators = peekingIterators.size();
        if (numberOfIterators == 0) {
            return Collections.emptyList();
        }
        if (numberOfIterators == 1) {
            return iterables.iterator().next();
        }
        final InterleaveComparator<T> iteratorSorter = new InterleaveComparator<T>(sorter);
        iteratorSorter.sortEmptyFirst();
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new AbstractIterator<T>(){
                    private MinMaxPriorityQueue<PeekingIterator<T>> sortedIterators;
                    {
                        this.sortedIterators = MinMaxPriorityQueue.orderedBy((Comparator)iteratorSorter).create();
                    }

                    protected T computeNext() {
                        for (PeekingIterator iter : peekingIterators) {
                            if (iter.hasNext()) {
                                this.sortedIterators.add((Object)iter);
                                continue;
                            }
                            return this.endOfData();
                        }
                        while (iteratorSorter.compare((PeekingIterator)this.sortedIterators.peekFirst(), (PeekingIterator)this.sortedIterators.peekLast()) < 0) {
                            PeekingIterator firstIter = (PeekingIterator)this.sortedIterators.poll();
                            PeekingIterator lastIter = (PeekingIterator)this.sortedIterators.peekLast();
                            while (firstIter.hasNext() && iteratorSorter.compare(firstIter, lastIter) < 0) {
                                firstIter.next();
                            }
                            if (!firstIter.hasNext()) {
                                return this.endOfData();
                            }
                            this.sortedIterators.add((Object)firstIter);
                        }
                        Object element = null;
                        while (!this.sortedIterators.isEmpty()) {
                            PeekingIterator iterator = (PeekingIterator)this.sortedIterators.poll();
                            element = iterator.next();
                        }
                        return element;
                    }
                };
            }
        };
    }

    public static <T extends Comparable<T>> Iterable<T> intersect(Iterable<? extends Iterable<T>> iterables) {
        Ordering comparator = Ordering.natural();
        return UtlSorted.intersect(iterables, comparator);
    }

    public static class InterleaveComparator<T>
    implements Comparator<PeekingIterator<T>> {
        private Comparator<T> elementComparator;
        private boolean emptyLast = true;

        public static <S> InterleaveComparator<S> create(Comparator<S> elementComparator) {
            return new InterleaveComparator<S>(elementComparator);
        }

        public InterleaveComparator(Comparator<T> elementComparator) {
            this.elementComparator = elementComparator;
        }

        public void sortEmptyFirst() {
            this.emptyLast = false;
        }

        public void sortEmptyLast() {
            this.emptyLast = true;
        }

        @Override
        public int compare(PeekingIterator<T> iter1, PeekingIterator<T> iter2) {
            if (iter1.hasNext()) {
                if (iter2.hasNext()) {
                    return this.elementComparator.compare(iter1.peek(), iter2.peek());
                }
                return this.emptyLast ? -1 : 1;
            }
            if (iter2.hasNext()) {
                return this.emptyLast ? 1 : -1;
            }
            return 0;
        }
    }
}

