/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlPool;

public class UtlPlist<T> {
    private final UtlPool<Element<T>> pool;
    private final UtlList list = UtlList.create();

    protected UtlPlist() {
        this.pool = UtlPool.create(null, null, new ElementFactory(), null);
    }

    public static <T> UtlPlist<T> create() {
        return new UtlPlist<T>();
    }

    public final Element<T> prepend(T object) {
        Element<T> element = this.pool.get(null);
        element.setObject(object);
        this.list.prepend(element);
        return element;
    }

    public final Element<T> append(T object) {
        Element<T> element = this.pool.get(null);
        element.setObject(object);
        this.list.append(element);
        return element;
    }

    public final Element<T> append(Element<T> element) {
        this.list.append(element);
        return element;
    }

    public final Element<T> first() {
        return (Element)this.list.next();
    }

    public final Element<T> last() {
        return (Element)this.list.previous();
    }

    public final void remove(Element<T> element) {
        element.unlink();
        this.pool.put(element);
    }

    public final int count() {
        return this.list.count();
    }

    public final void clear() {
        Element<T> element;
        while ((element = this.first()) != null) {
            this.remove(element);
        }
    }

    public String toString() {
        return "plist" + this.hashCode() + "<count=" + this.count() + ">";
    }

    public static class Element<T>
    extends UtlListElement
    implements UtlPool.Item<Element<T>> {
        private T object;
        private UtlPool<Element<T>> pool;

        Element() {
        }

        public final Element<T> setObject(T object) {
            this.object = object;
            return this;
        }

        public final T getObject() {
            return this.object;
        }

        @Override
        public final Element<T> setPool(UtlPool<Element<T>> pool) {
            this.pool = pool;
            return this;
        }

        @Override
        public final UtlPool<Element<T>> getPool() {
            return this.pool;
        }

        @Override
        public final Element<T> init() {
            this.unlink();
            this.object = null;
            return this;
        }
    }

    public static final class ElementFactory<T>
    implements UtlPool.Factory<Element<T>> {
        @Override
        public final Element<T> createItem(Object object) {
            return new Element();
        }

        public final Element<T>[] createItemArray(int size) {
            return new Element[size];
        }
    }
}

