/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XLongCollection;
import com.neeve.lang.XLongCollectionBase;
import com.neeve.lang.XLongIterator;
import com.neeve.lang.XLongList;
import com.neeve.lang.XLongListIterator;
import java.util.NoSuchElementException;

public class XLongLinkedList
extends XLongCollectionBase
implements XLongList {
    private transient LongNode _head = this.newNode();
    private transient LongNode _tail = this.newNode();
    private transient int _size;

    public XLongLinkedList() {
        this(4);
    }

    public XLongLinkedList(int capacity) {
        this._head._next = this._tail;
        this._tail._previous = this._head;
        LongNode previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            LongNode newNode = this.newNode();
            newNode._previous = previous;
            previous._next = newNode;
            previous = newNode;
        }
    }

    public XLongLinkedList(XLongCollection values) {
        this(values.size());
        this.addAll(values);
    }

    public static XLongLinkedList newInstance() {
        return new XLongLinkedList();
    }

    @Override
    public final boolean add(long value) {
        this.addLast(value);
        return true;
    }

    @Override
    public final long get(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return this.nodeAt(index)._value;
    }

    @Override
    public final long set(int index, long value) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        LongNode node = this.nodeAt(index);
        long previousValue = node._value;
        node._value = value;
        return previousValue;
    }

    @Override
    public final void add(int index, long value) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        this.addBefore(this.nodeAt(index), value);
    }

    @Override
    public final boolean addAll(int index, XLongCollection values) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        LongNode indexNode = this.nodeAt(index);
        XLongIterator i = values.iterator();
        while (i.hasNext()) {
            this.addBefore(indexNode, i.next());
        }
        return values.size() != 0;
    }

    @Override
    public final long remove(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        LongNode node = this.nodeAt(index);
        long previousValue = node._value;
        this.delete(node);
        return previousValue;
    }

    @Override
    public final int indexOf(long value) {
        int index = 0;
        LongNode n = this._head;
        LongNode end = this._tail;
        while ((n = n._next) != end) {
            if (value == n._value) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Override
    public final int lastIndexOf(long value) {
        int index = this.size() - 1;
        LongNode n = this._tail;
        LongNode end = this._head;
        while ((n = n._previous) != end) {
            if (value == n._value) {
                return index;
            }
            --index;
        }
        return -1;
    }

    @Override
    public XLongIterator iterator() {
        return this.listIterator();
    }

    @Override
    public XLongListIterator listIterator() {
        return XLongLinkedListIterator.valueOf(this, this._head._next, 0, this._size);
    }

    @Override
    public XLongListIterator listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        return XLongLinkedListIterator.valueOf(this, this.nodeAt(index), index, this._size);
    }

    @Override
    public final XLongList subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
        }
        return SubList.valueOf(this, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
    }

    public final long getFirst() {
        LongNode node = this._head._next;
        if (node == this._tail) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final long getLast() {
        LongNode node = this._tail._previous;
        if (node == this._head) {
            throw new NoSuchElementException();
        }
        return node._value;
    }

    public final void addFirst(long value) {
        this.addBefore(this._head._next, value);
    }

    public void addLast(long value) {
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        this._tail._value = value;
        this._tail = this._tail._next;
        ++this._size;
    }

    public final long removeFirst() {
        LongNode first = this._head._next;
        if (first == this._tail) {
            throw new NoSuchElementException();
        }
        long previousValue = first._value;
        this.delete(first);
        return previousValue;
    }

    public final long removeLast() {
        if (this._size == 0) {
            throw new NoSuchElementException();
        }
        --this._size;
        LongNode last = this._tail._previous;
        long previousValue = last._value;
        this._tail = last;
        last._value = -1L;
        return previousValue;
    }

    public final void addBefore(LongNode next, long value) {
        LongNode newNode;
        LongNode tailNext;
        if (this._tail._next == null) {
            this.increaseCapacity();
        }
        if ((tailNext = (this._tail._next = (newNode = this._tail._next)._next)) != null) {
            tailNext._previous = this._tail;
        }
        LongNode previous = next._previous;
        previous._next = newNode;
        next._previous = newNode;
        newNode._next = next;
        newNode._previous = previous;
        newNode._value = value;
        ++this._size;
    }

    private final LongNode nodeAt(int index) {
        LongNode node = this._head;
        int i = index;
        while (i-- >= 0) {
            node = node._next;
        }
        return node;
    }

    @Override
    public final LongNode head() {
        return this._head;
    }

    @Override
    public final LongNode tail() {
        return this._tail;
    }

    @Override
    public final long valueOf(XCollection.Record record) {
        return ((LongNode)record)._value;
    }

    @Override
    public final void delete(XCollection.Record record) {
        LongNode node = (LongNode)record;
        --this._size;
        node._value = -1L;
        node._previous._next = node._next;
        node._next._previous = node._previous;
        LongNode next = this._tail._next;
        node._previous = this._tail;
        node._next = next;
        this._tail._next = node;
        if (next != null) {
            next._previous = node;
        }
    }

    @Override
    public final boolean contains(long value) {
        return this.indexOf(value) >= 0;
    }

    @Override
    public final int size() {
        return this._size;
    }

    @Override
    public final void clear() {
        this._size = 0;
        this._tail = this._head._next;
    }

    @Override
    public XLongList unmodifiable() {
        return (XLongList)super.unmodifiable();
    }

    protected LongNode newNode() {
        return new LongNode();
    }

    private void increaseCapacity() {
        LongNode newNode0 = this.newNode();
        this._tail._next = newNode0;
        newNode0._previous = this._tail;
        LongNode newNode1 = this.newNode();
        newNode0._next = newNode1;
        newNode1._previous = newNode0;
        LongNode newNode2 = this.newNode();
        newNode1._next = newNode2;
        newNode2._previous = newNode1;
        LongNode newNode3 = this.newNode();
        newNode2._next = newNode3;
        newNode3._previous = newNode2;
    }

    public void reset() {
        this.clear();
    }

    private static final class XLongLinkedListIterator
    implements XLongListIterator {
        private XLongLinkedList _list;
        private LongNode _nextNode;
        private LongNode _currentNode;
        private int _length;
        private int _nextIndex;

        private XLongLinkedListIterator() {
        }

        public static XLongLinkedListIterator valueOf(XLongLinkedList list, LongNode nextNode, int nextIndex, int size) {
            XLongLinkedListIterator itr = new XLongLinkedListIterator();
            itr._list = list;
            itr._nextNode = nextNode;
            itr._nextIndex = nextIndex;
            itr._length = size;
            return itr;
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex != this._length;
        }

        @Override
        public long next() {
            if (this._nextIndex == this._length) {
                throw new NoSuchElementException();
            }
            ++this._nextIndex;
            this._currentNode = this._nextNode;
            this._nextNode = this._nextNode._next;
            return this._currentNode._value;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public long previous() {
            if (this._nextIndex == 0) {
                throw new NoSuchElementException();
            }
            --this._nextIndex;
            this._currentNode = this._nextNode = this._nextNode._previous;
            return this._currentNode._value;
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public void add(long o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            this._list.addBefore(this._nextNode, o);
            this._currentNode = null;
            ++this._length;
            ++this._nextIndex;
        }

        @Override
        public void set(long o) {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            this._currentNode._value = o;
        }

        @Override
        public void remove() {
            if (!this._list.supportsIteratorModifications()) {
                throw new UnsupportedOperationException("not supported");
            }
            if (this._currentNode == null) {
                throw new IllegalStateException();
            }
            if (this._nextNode == this._currentNode) {
                this._nextNode = this._nextNode._next;
            } else {
                --this._nextIndex;
            }
            this._list.delete(this._currentNode);
            this._currentNode = null;
            --this._length;
        }

        @Override
        public final XLongLinkedListIterator toFirst() {
            this._nextNode = this._list._head._next;
            this._nextIndex = 0;
            this._length = this._list._size;
            return this;
        }
    }

    private static final class SubList
    extends XLongCollectionBase
    implements XLongList {
        private XLongLinkedList _list;
        private LongNode _head;
        private LongNode _tail;
        private int _size;

        private SubList() {
        }

        public static SubList valueOf(XLongLinkedList list, LongNode head, LongNode tail, int size) {
            SubList subList = new SubList();
            subList._list = list;
            subList._head = head;
            subList._tail = tail;
            subList._size = size;
            return subList;
        }

        @Override
        public int size() {
            return this._size;
        }

        @Override
        public XCollection.Record head() {
            return this._head;
        }

        @Override
        public XCollection.Record tail() {
            return this._tail;
        }

        @Override
        public long valueOf(XCollection.Record record) {
            return this._list.valueOf(record);
        }

        @Override
        public void delete(XCollection.Record record) {
            this._list.delete(record);
            if (record == this._head) {
                this._head = this._head.getNext();
            } else if (record == this._tail) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
        }

        @Override
        public boolean addAll(XLongCollection values) {
            return this.addAll(this._size, values);
        }

        @Override
        public boolean addAll(int index, XLongCollection values) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            LongNode indexNode = this.nodeAt(index);
            XLongIterator i = values.iterator();
            while (i.hasNext()) {
                this._list.addBefore(indexNode, i.next());
            }
            if (values.size() > 0) {
                if (index == 0) {
                    this._head = this._head.getPrevious();
                } else if (index == this._size) {
                    this._tail = indexNode.getPrevious();
                }
            }
            this._size += values.size();
            return values.size() != 0;
        }

        @Override
        public long get(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            return this.nodeAt(index)._value;
        }

        @Override
        public long set(int index, long value) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            LongNode node = this.nodeAt(index);
            long previousValue = node._value;
            node._value = value;
            return previousValue;
        }

        @Override
        public boolean add(long element) {
            this.add(this._size, element);
            return true;
        }

        @Override
        public void add(int index, long element) {
            if (index < 0 || index > this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            this._list.addBefore(this.nodeAt(index), element);
            if (index == 0) {
                this._head = this._head.getPrevious();
            } else if (index == this._size) {
                this._tail = this._tail.getNext();
            }
            ++this._size;
        }

        @Override
        public long remove(int index) {
            if (index < 0 || index >= this._size) {
                throw new IndexOutOfBoundsException("index: " + index);
            }
            LongNode node = this.nodeAt(index);
            long previousValue = node._value;
            this._list.delete(node);
            if (index == 0) {
                this._head = this._head.getNext();
            } else if (index == this._size) {
                this._tail = this._tail.getPrevious();
            }
            --this._size;
            return previousValue;
        }

        @Override
        public int indexOf(long value) {
            int index = 0;
            LongNode n = this._head;
            LongNode end = this._tail;
            while ((n = n._next) != end) {
                if (value == n._value) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(long value) {
            int index = this.size() - 1;
            LongNode n = this._tail;
            LongNode end = this._head;
            while ((n = n._previous) != end) {
                if (value == n._value) {
                    return index;
                }
                --index;
            }
            return -1;
        }

        @Override
        public XLongListIterator listIterator() {
            return this.listIterator(0);
        }

        @Override
        public XLongListIterator listIterator(int index) {
            if (index >= 0 && index <= this._size) {
                return XLongLinkedListIterator.valueOf(this._list, this.nodeAt(index), index, this._size);
            }
            throw new IndexOutOfBoundsException("index: " + index + " for list of size: " + this._size);
        }

        @Override
        public XLongList subList(int fromIndex, int toIndex) {
            if (fromIndex < 0 || toIndex > this._size || fromIndex > toIndex) {
                throw new IndexOutOfBoundsException("fromIndex: " + fromIndex + ", toIndex: " + toIndex + " for list of size: " + this._size);
            }
            SubList subList = SubList.valueOf(this._list, this.nodeAt(fromIndex)._previous, this.nodeAt(toIndex), toIndex - fromIndex);
            return subList;
        }

        private final LongNode nodeAt(int index) {
            if (index <= this._size >> 1) {
                LongNode node = this._head;
                int i = index;
                while (i-- >= 0) {
                    node = node._next;
                }
                return node;
            }
            LongNode node = this._tail;
            int i = this._size - index;
            while (i-- > 0) {
                node = node._previous;
            }
            return node;
        }

        @Override
        public void clear() {
            while (this._size > 0) {
                this.remove(0);
            }
        }
    }

    public static class LongNode
    implements XCollection.Record {
        private LongNode _next;
        private LongNode _previous;
        private long _value;

        protected LongNode() {
        }

        public final long getValue() {
            return this._value;
        }

        @Override
        public final LongNode getNext() {
            return this._next;
        }

        @Override
        public final LongNode getPrevious() {
            return this._previous;
        }
    }
}

